/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.environment;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.CharOverlayData;
import mindustry.gen.Unit;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.OverlayFloor;

public class RuneOverlay
extends OverlayFloor {
    public static final int characters = 109;
    public static final int unicodeOffset = 5163;
    public TextureRegion[] letterRegions;
    public Color color = Color.white;

    public RuneOverlay(String name) {
        super(name);
        this.saveData = true;
        this.variants = 0;
        this.saveConfig = true;
        this.editorConfigurable = true;
    }

    public static String bytesToString(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (byte b : data) {
            result.append((char)((b & 0xFF) + 5163));
        }
        return result.toString();
    }

    public static byte[] stringToBytes(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            bytes[i] = (byte)(s.charAt(i) - 5163);
        }
        return bytes;
    }

    @Override
    public void drawBase(Tile tile) {
        Draw.color(this.color);
        if ((tile.overlayData & 0xFF) < 109) {
            Draw.rect(this.letterRegions[tile.overlayData & 0xFF], tile.worldx(), tile.worldy());
        }
        Draw.color();
    }

    @Override
    public Object getConfig(Tile tile) {
        return (int)tile.overlayData;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int letterChar;
        int data = 0;
        Object object = plan.config;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            data = i.byteValue();
        }
        if ((letterChar = data & 0xFF) < 109) {
            TextureRegion reg = this.letterRegions[letterChar];
            Draw.tint(this.color);
            Draw.rect(reg, plan.drawx(), plan.drawy());
            Draw.tint(Color.white);
        }
    }

    @Override
    public void onPicked(Tile tile) {
        Vars.control.input.rotation = CharOverlayData.rotation(tile.overlayData);
    }

    @Override
    public void buildEditorConfig(Table table) {
        int n;
        Object object = this.lastConfig;
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            n = i;
        } else {
            n = 0;
        }
        int value = n;
        table.field(value + "", val -> {
            this.lastConfig = Strings.parseInt(val);
        }).valid(t -> Strings.canParsePositiveInt(t) && Strings.parseInt(t, 999) < 109);
    }

    @Override
    public void placeEnded(Tile tile, @Nullable Unit builder, int rotation, @Nullable Object config) {
        if (config instanceof Integer) {
            Integer i = (Integer)config;
            tile.overlayData = i.byteValue();
        }
    }

    @Override
    public void editorPicked(Tile tile) {
        this.lastConfig = tile.overlayData;
    }
}

