/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ai.UnitStance;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class SetUnitStanceCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public int[] unitIds;
    public UnitStance stance;
    public boolean enable;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server()) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeInts(WRITE, this.unitIds);
        TypeIO.writeStance(WRITE, this.stance);
        WRITE.bool(this.enable);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.unitIds = TypeIO.readInts(READ);
        this.stance = TypeIO.readStance(READ);
        this.enable = READ.bool();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.setUnitStance(player, this.unitIds, this.stance, this.enable);
        Call.setUnitStance__forward(con, player, this.unitIds, this.stance, this.enable);
    }

    @Override
    public void handleClient() {
        InputHandler.setUnitStance(this.player, this.unitIds, this.stance, this.enable);
    }
}

