/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.FloatSeq;
import arc.struct.ObjectSet;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.game.SpawnGroup;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class WaveGraph
extends Table {
    public Seq<SpawnGroup> groups = new Seq();
    private Mode mode = Mode.counts;
    private int[][] values;
    private OrderedSet<UnitType> used = new OrderedSet();
    private int max;
    private int maxTotal;
    private float maxHealth;
    private Table colors;
    private ObjectSet<UnitType> hidden = new ObjectSet();
    private StringBuilder countStr = new StringBuilder();
    private float pan;
    private float zoom = 1.0f;
    private int from = 0;
    private int to = 20;
    private int lastFrom = -1;
    private int lastTo = -1;
    private float lastZoom = -1.0f;
    private float defaultSpace = Scl.scl(40.0f);
    private FloatSeq points = new FloatSeq(40);

    public WaveGraph() {
        this.background(Tex.pane);
        this.scrolled(scroll -> {
            this.zoom -= scroll * 2.0f / 10.0f * this.zoom;
            this.clampZoom();
        });
        this.touchable = Touchable.enabled;
        this.addListener(new InputListener(){

            @Override
            public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
                WaveGraph.this.requestScroll();
            }
        });
        this.addListener(new ElementGestureListener(){

            @Override
            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                WaveGraph.this.pan -= deltaX / WaveGraph.this.zoom;
            }

            @Override
            public void zoom(InputEvent event, float initialDistance, float distance) {
                if (WaveGraph.this.lastZoom < 0.0f) {
                    WaveGraph.this.lastZoom = WaveGraph.this.zoom;
                }
                WaveGraph.this.zoom = distance / initialDistance * WaveGraph.this.lastZoom;
                WaveGraph.this.clampZoom();
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                WaveGraph.this.lastZoom = WaveGraph.this.zoom;
            }
        });
        this.rect((x, y, width, height) -> {
            float cx;
            int selcol;
            int n;
            Lines.stroke(Scl.scl(3.0f));
            this.countStr.setLength(0);
            Vec2 mouse = this.stageToLocalCoordinates(Core.input.mouse());
            GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
            Font font = Fonts.outline;
            switch (this.mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case counts: {
                    n = this.nextStep(this.max);
                    break;
                }
                case health: {
                    n = this.nextStep((int)this.maxHealth);
                    break;
                }
                case totals: {
                    n = this.nextStep(this.maxTotal);
                }
            }
            int maxY = n;
            lay.setText(font, "1");
            float spacing = this.zoom * this.defaultSpace;
            this.pan = Math.max(this.pan, width / 2.0f / this.zoom - this.defaultSpace);
            float fh = lay.height;
            float offsetX = 0.0f;
            float offsetY = Scl.scl(22.0f) + fh + Scl.scl(5.0f);
            float graphX = x + offsetX - this.pan * this.zoom + width / 2.0f;
            float graphY = y + offsetY;
            float graphW = width - offsetX;
            float graphH = height - offsetY;
            float left = (x - graphX) / spacing;
            float right = (x + width - graphX) / spacing;
            this.from = (int)left - 1;
            this.to = (int)right + 1;
            if (this.lastFrom != this.from || this.lastTo != this.to) {
                this.rebuild();
            }
            this.lastFrom = this.from;
            this.lastTo = this.to;
            if (!this.clipBegin(x + offsetX, y + offsetY, graphW, graphH)) {
                return;
            }
            int n2 = selcol = Rect.contains(x, y, width, height, mouse.x, mouse.y) ? Mathf.round((mouse.x - graphX - (float)this.from * spacing) / spacing) : -1;
            if (selcol + this.from <= -1) {
                selcol = -1;
            }
            if (this.mode == Mode.counts) {
                for (UnitType type : this.used.orderedItems()) {
                    Draw.color(this.color(type));
                    Draw.alpha(this.parentAlpha);
                    this.beginLine();
                    for (int i = 0; i < this.values.length; ++i) {
                        int val = this.values[i][type.id];
                        cx = graphX + (float)(i + this.from) * spacing;
                        float cy = graphY + (float)val * graphH / (float)maxY;
                        this.linePoint(cx, cy);
                    }
                    this.endLine();
                }
            } else if (this.mode == Mode.totals) {
                this.beginLine();
                Draw.color(Pal.accent);
                for (int i = 0; i < this.values.length; ++i) {
                    int sum = 0;
                    for (UnitType type : this.used.orderedItems()) {
                        sum += this.values[i][type.id];
                    }
                    float cx2 = graphX + (float)(i + this.from) * spacing;
                    float cy = graphY + (float)sum * graphH / (float)maxY;
                    this.linePoint(cx2, cy);
                }
                this.endLine();
            } else if (this.mode == Mode.health) {
                this.beginLine();
                Draw.color(Pal.health);
                for (int i = 0; i < this.values.length; ++i) {
                    float sum = 0.0f;
                    for (UnitType type : this.used.orderedItems()) {
                        sum += type.health * (float)this.values[i][type.id];
                    }
                    float cx3 = graphX + (float)(i + this.from) * spacing;
                    float cy = graphY + sum * graphH / (float)maxY;
                    this.linePoint(cx3, cy);
                }
                this.endLine();
            }
            if (selcol >= 0 && selcol < this.values.length) {
                Draw.color(1.0f, 0.0f, 0.0f, 0.2f);
                Fill.crect((float)(selcol + this.from) * spacing + graphX - spacing / 2.0f, graphY, spacing, graphH);
                Draw.color();
                font.getData().setScale(1.5f);
                for (UnitType type : this.used.orderedItems()) {
                    int amount = this.values[Mathf.clamp(selcol, 0, this.values.length - 1)][type.id];
                    if (amount <= 0) continue;
                    this.countStr.append(type.emoji()).append(" ").append(amount).append("\n");
                }
                float pad = Scl.scl(5.0f);
                font.draw(this.countStr, (float)(selcol + this.from) * spacing + graphX - spacing / 2.0f + pad, graphY + graphH - pad);
                font.getData().setScale(1.0f);
            }
            this.clipEnd();
            float totalMarks = Mathf.clamp(maxY, 1, 10);
            int markSpace = Math.max(1, Mathf.ceil((float)maxY / totalMarks));
            Draw.color(Color.lightGray);
            Draw.alpha(0.1f);
            for (int i = 0; i < maxY; i += markSpace) {
                float cy = graphY + (float)i * graphH / (float)maxY;
                cx = x;
                Lines.line(cx, cy, cx + graphW, cy);
                lay.setText(font, "" + i);
                font.draw("" + i, cx, cy + lay.height / 2.0f, 8);
            }
            Draw.alpha(1.0f);
            float len = Scl.scl(4.0f);
            font.setColor(Color.lightGray);
            for (int i = 0; i < this.values.length; ++i) {
                float cy = y + fh;
                float cx4 = graphX + spacing * (float)(i + this.from);
                if (cx4 >= x + offsetX && cx4 <= x + offsetX + graphW) {
                    Lines.line(cx4, cy, cx4, cy + len);
                }
                if (i != selcol) continue;
                font.draw("" + (i + this.from + 1), cx4, cy - Scl.scl(2.0f), 1);
            }
            font.setColor(Color.white);
            Pools.free(lay);
            Draw.reset();
        }).pad(4.0f).padBottom(10.0f).grow();
        this.row();
        this.table((Table t) -> {
            this.colors = t;
        }).growX();
        this.row();
        this.table((Table t) -> {
            t.left();
            ButtonGroup group = new ButtonGroup();
            for (Mode m : Mode.all) {
                t.button("@wavemode." + m.name(), Styles.fullTogglet, () -> {
                    this.mode = m;
                }).group(group).height(35.0f).update((T b) -> b.setChecked(m == this.mode)).width(130.0f);
            }
        }).growX();
    }

    private void clampZoom() {
        this.zoom = Mathf.clamp(this.zoom, 0.5f / Scl.scl(1.0f), 40.0f / Scl.scl(1.0f));
    }

    private void linePoint(float x, float y) {
        this.points.add(x, y);
    }

    private void beginLine() {
        this.points.clear();
    }

    private void endLine() {
        float[] items = this.points.items;
        for (int i = 0; i < this.points.size - 2; i += 2) {
            Lines.line(items[i], items[i + 1], items[i + 2], items[i + 3], false);
            Fill.circle(items[i], items[i + 1], Lines.getStroke() / 2.0f);
        }
        Fill.circle(items[this.points.size - 2], items[this.points.size - 1], Lines.getStroke());
        this.points.clear();
    }

    public void rebuild() {
        this.values = new int[this.to - this.from + 1][Vars.content.units().size];
        this.used.clear();
        this.maxTotal = 1;
        this.max = 1;
        this.maxHealth = 1.0f;
        for (int i = this.from; i <= this.to; ++i) {
            int index = i - this.from;
            float healthsum = 0.0f;
            int sum = 0;
            for (SpawnGroup spawn : this.groups) {
                int spawned = spawn.getSpawned(i);
                int[] nArray = this.values[index];
                short s = spawn.type.id;
                nArray[s] = nArray[s] + spawned;
                if (spawned > 0) {
                    this.used.add(spawn.type);
                }
                this.max = Math.max(this.max, this.values[index][spawn.type.id]);
                healthsum += (float)spawned * spawn.type.health;
                sum += spawned;
            }
            this.maxTotal = Math.max(this.maxTotal, sum);
            this.maxHealth = Math.max(this.maxHealth, healthsum);
        }
        this.used.orderedItems().sort();
        ObjectSet usedCopy = new ObjectSet(this.used);
        this.colors.clear();
        this.colors.left();
        this.colors.button("@waves.units.hide", Styles.flatt, () -> {
            if (this.hidden.size == usedCopy.size) {
                this.hidden.clear();
            } else {
                this.hidden.addAll(usedCopy);
            }
            this.used.clear();
            this.used.addAll(usedCopy);
            for (UnitType o : this.hidden) {
                this.used.remove(o);
            }
        }).update((T b) -> b.setText(this.hidden.size == usedCopy.size ? "@waves.units.show" : "@waves.units.hide")).height(32.0f).width(130.0f);
        this.colors.pane((Table t) -> {
            t.left();
            for (UnitType type : this.used) {
                t.button((Button b) -> {
                    Color tcolor = this.color(type).cpy();
                    b.image().size(32.0f).update((T i) -> i.setColor(b.isChecked() ? Tmp.c1.set(tcolor).mul(0.5f) : tcolor)).get().act(1.0f);
                    b.image(type.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(20.0f).update((T i) -> i.setColor(b.isChecked() ? Color.gray : Color.white)).get().act(1.0f);
                    b.margin(0.0f);
                }, (Button.ButtonStyle)Styles.fullTogglet, () -> {
                    if (!this.hidden.add(type)) {
                        this.hidden.remove(type);
                    }
                    this.used.clear();
                    this.used.addAll(usedCopy);
                    for (UnitType o : this.hidden) {
                        this.used.remove(o);
                    }
                }).update((T b) -> b.setChecked(this.hidden.contains(type)));
            }
        }).scrollY(false);
        this.colors.act(1.0E-6f);
        for (UnitType type : this.hidden) {
            this.used.remove(type);
        }
    }

    Color color(UnitType type) {
        return Tmp.c1.fromHsv((float)type.id / (float)Vars.content.units().size * 360.0f, 0.7f, 1.0f);
    }

    int nextStep(float value) {
        int order = 1;
        while ((float)order < value) {
            if ((float)(order * 2) > value) {
                return order * 2;
            }
            if ((float)(order * 5) > value) {
                return order * 5;
            }
            if ((float)(order * 10) > value) {
                return order * 10;
            }
            order *= 10;
        }
        return order;
    }

    static enum Mode {
        counts,
        totals,
        health;

        static Mode[] all;

        static {
            all = Mode.values();
        }
    }
}

