/*
 * Decompiled with CFR 0.152.
 */
package arc.util;

import arc.func.Cons;
import arc.func.ConsT;
import arc.struct.IntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Threads;
import arc.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class Http {
    protected static ExecutorService exec = Threads.unboundedExecutor("HTTP", 1);

    public static HttpRequest request(HttpMethod method, String url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null.");
        }
        return new HttpRequest(method).url(url);
    }

    public static HttpRequest get(String url) {
        if (url == null) {
            throw new NullPointerException("url cannot be null.");
        }
        return new HttpRequest(HttpMethod.GET).url(url);
    }

    public static void get(String url, ConsT<HttpResponse, Exception> callback) {
        Http.get(url).submit(callback);
    }

    public static void get(String url, ConsT<HttpResponse, Exception> callback, Cons<Throwable> error) {
        Http.get(url).error(error).submit(callback);
    }

    public static HttpRequest post(String url) {
        return Http.post(url, (String)null);
    }

    public static void post(String url, ConsT<HttpResponse, Exception> callback) {
        Http.post(url).submit(callback);
    }

    public static HttpRequest post(String url, String content) {
        if (url == null) {
            throw new NullPointerException("url cannot be null.");
        }
        return new HttpRequest(HttpMethod.POST).url(url).content(content);
    }

    public static class HttpRequest {
        public HttpMethod method = HttpMethod.GET;
        public String url;
        public ObjectMap<String, String> headers = new ObjectMap();
        public int timeout = 2000;
        public String content;
        public InputStream contentStream;
        public boolean followRedirects = true;
        public boolean includeCredentials = false;
        public Cons<Throwable> errorHandler = Log::err;

        protected HttpRequest() {
        }

        protected HttpRequest(HttpMethod method) {
            this.method = method;
        }

        public HttpRequest error(Cons<Throwable> failed) {
            this.errorHandler = failed;
            return this;
        }

        public HttpRequest method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public HttpRequest url(String url) {
            this.url = url;
            return this;
        }

        public HttpRequest timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public HttpRequest redirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public HttpRequest credentials(boolean includeCredentials) {
            this.includeCredentials = includeCredentials;
            return this;
        }

        public HttpRequest header(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public HttpRequest content(String content) {
            this.content = content;
            return this;
        }

        public HttpRequest content(InputStream contentStream) {
            this.contentStream = contentStream;
            return this;
        }

        public void submit(ConsT<HttpResponse, Exception> success) {
            exec.submit(() -> this.block(success));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void block(ConsT<HttpResponse, Exception> success) {
            if (this.url == null) {
                this.errorHandler.get(new ArcRuntimeException("can't process a HTTP request without URL set"));
                return;
            }
            try {
                URL url;
                if (this.method == HttpMethod.GET) {
                    String queryString = "";
                    String value = this.content;
                    if (value != null && !"".equals(value)) {
                        queryString = "?" + value;
                    }
                    url = new URL(this.url + queryString);
                } else {
                    url = new URL(this.url);
                }
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                boolean doingOutPut = this.method == HttpMethod.POST || this.method == HttpMethod.PUT;
                connection.setDoOutput(doingOutPut);
                connection.setDoInput(true);
                connection.setRequestMethod(this.method.toString());
                HttpURLConnection.setFollowRedirects(this.followRedirects);
                this.headers.each(connection::addRequestProperty);
                connection.setConnectTimeout(this.timeout);
                connection.setReadTimeout(this.timeout);
                try {
                    if (doingOutPut) {
                        if (this.content != null) {
                            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), Strings.utf8);){
                                writer.write(this.content);
                            }
                        }
                        if (this.contentStream != null) {
                            try (OutputStream os = connection.getOutputStream();){
                                Streams.copy(this.contentStream, os);
                            }
                        }
                    }
                    connection.connect();
                    try {
                        int code = connection.getResponseCode();
                        if (code >= 400) {
                            HttpStatus status = HttpStatus.byCode(code);
                            this.errorHandler.get(new HttpStatusException("HTTP request failed with error: " + code + " (" + (Object)((Object)status) + ", URL = " + url + ")", status, new HttpResponse(connection)));
                        } else {
                            success.get(new HttpResponse(connection));
                        }
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                catch (Throwable e) {
                    connection.disconnect();
                    this.errorHandler.get(e);
                }
            }
            catch (Throwable e) {
                this.errorHandler.get(e);
            }
        }
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        HEAD,
        CONNECT,
        OPTIONS,
        TRACE;

    }

    public static enum HttpStatus {
        UNKNOWN_STATUS(-1),
        CONTINUE(100),
        SWITCHING_PROTOCOLS(101),
        PROCESSING(102),
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NON_AUTHORITATIVE_INFORMATION(203),
        NO_CONTENT(204),
        RESET_CONTENT(205),
        PARTIAL_CONTENT(206),
        MULTI_STATUS(207),
        MULTIPLE_CHOICES(300),
        MOVED_PERMANENTLY(301),
        MOVED_TEMPORARILY(302),
        SEE_OTHER(303),
        NOT_MODIFIED(304),
        USE_PROXY(305),
        TEMPORARY_REDIRECT(307),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        NOT_ACCEPTABLE(406),
        PROXY_AUTHENTICATION_REQUIRED(407),
        REQUEST_TIMEOUT(408),
        CONFLICT(409),
        GONE(410),
        LENGTH_REQUIRED(411),
        PRECONDITION_FAILED(412),
        REQUEST_TOO_LONG(413),
        REQUEST_URI_TOO_LONG(414),
        UNSUPPORTED_MEDIA_TYPE(415),
        REQUESTED_RANGE_NOT_SATISFIABLE(416),
        EXPECTATION_FAILED(417),
        IM_A_TEAPOT(418),
        INSUFFICIENT_SPACE_ON_RESOURCE(419),
        METHOD_FAILURE(420),
        UNPROCESSABLE_ENTITY(422),
        LOCKED(423),
        FAILED_DEPENDENCY(424),
        INTERNAL_SERVER_ERROR(500),
        NOT_IMPLEMENTED(501),
        BAD_GATEWAY(502),
        SERVICE_UNAVAILABLE(503),
        GATEWAY_TIMEOUT(504),
        HTTP_VERSION_NOT_SUPPORTED(505),
        INSUFFICIENT_STORAGE(507);

        private static IntMap<HttpStatus> byCode;
        public final int code;

        private HttpStatus(int code) {
            this.code = code;
        }

        public static synchronized HttpStatus byCode(int code) {
            if (byCode == null) {
                byCode = new IntMap();
                for (HttpStatus status : HttpStatus.values()) {
                    byCode.put(status.code, status);
                }
            }
            return byCode.get(code, UNKNOWN_STATUS);
        }
    }

    public static class HttpStatusException
    extends RuntimeException {
        public HttpStatus status;
        public HttpResponse response;

        public HttpStatusException(String message, HttpStatus status, HttpResponse response) {
            super(message);
            this.status = status;
            this.response = response;
        }
    }

    public static class HttpResponse {
        private final HttpURLConnection connection;
        private HttpStatus status;

        protected HttpResponse(HttpURLConnection connection) throws IOException {
            this.connection = connection;
            this.status = HttpStatus.byCode(connection.getResponseCode());
        }

        public long getContentLength() {
            return this.connection.getContentLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getResult() {
            InputStream input = this.getResultAsStream();
            if (input == null) {
                return Streams.emptyBytes;
            }
            try {
                byte[] byArray = Streams.copyBytes(input, this.connection.getContentLength());
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = Streams.emptyBytes;
                return byArray;
            }
            finally {
                Streams.close(input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getResultAsString() {
            InputStream input = this.getResultAsStream();
            if (input == null) {
                return "";
            }
            try {
                String string = Streams.copyString(input, this.connection.getContentLength());
                return string;
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            finally {
                Streams.close(input);
            }
        }

        public InputStream getResultAsStream() {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException e) {
                return this.connection.getErrorStream();
            }
        }

        public HttpStatus getStatus() {
            return this.status;
        }

        public String getHeader(String name) {
            return this.connection.getHeaderField(name);
        }

        public ObjectMap<String, Seq<String>> getHeaders() {
            ObjectMap<String, Seq<String>> out = new ObjectMap<String, Seq<String>>();
            Map<String, List<String>> fields = this.connection.getHeaderFields();
            for (String key : fields.keySet()) {
                if (key == null) continue;
                out.put(key, Seq.with(fields.get(key).toArray(new String[0])));
            }
            return out;
        }
    }
}

