/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.fx.FxFilter;
import arc.graphics.Texture;
import arc.graphics.gl.FrameBuffer;

public final class CombineFilter
extends FxFilter {
    public float src1int = 1.0f;
    public float src1sat = 1.0f;
    public float src2int = 1.0f;
    public float src2sat = 1.0f;
    public Texture inputTexture2 = null;

    public CombineFilter() {
        super("screenspace", "combine");
        this.rebind();
    }

    public CombineFilter setInput(FrameBuffer buffer1, FrameBuffer buffer2) {
        this.inputTexture = (Texture)buffer1.getTexture();
        this.inputTexture2 = (Texture)buffer2.getTexture();
        return this;
    }

    public CombineFilter setInput(Texture texture1, Texture texture2) {
        this.inputTexture = texture1;
        this.inputTexture2 = texture2;
        return this;
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformi("u_texture1", 1);
        this.shader.setUniformf("u_src1Intensity", this.src1int);
        this.shader.setUniformf("u_src2Intensity", this.src2int);
        this.shader.setUniformf("u_src1Saturation", this.src1sat);
        this.shader.setUniformf("u_src2Saturation", this.src2sat);
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
        this.inputTexture2.bind(1);
    }
}

