/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.ai.BaseBuilderAI;
import mindustry.ai.RtsAI;
import mindustry.content.Fx;
import mindustry.core.GameState;
import mindustry.core.PerfCounter;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Rules;
import mindustry.game.SectorInfo;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.maps.MapPreviewLoader;
import mindustry.maps.SectorDamage;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Weather;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.storage.CoreBlock;

public class Logic
implements ApplicationListener {
    public Logic() {
        Events.on(EventType.BlockDestroyEvent.class, event -> {
            if (!Vars.state.rules.ghostBlocks) {
                return;
            }
            Tile tile = event.tile;
            if (tile.build == null || !tile.block().rebuildable) {
                return;
            }
            tile.build.addPlan(true);
        });
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking) {
                this.checkOverlappingPlans(event.team, event.tile);
                if (event.team == Vars.state.rules.defaultTeam) {
                    Vars.state.stats.placedBlockCount.increment(event.tile.block());
                }
            }
        });
        Events.on(EventType.PayloadDropEvent.class, e -> {
            if (e.build != null) {
                this.checkOverlappingPlans(e.build.team, e.build.tile);
            }
        });
        Events.on(EventType.SaveLoadEvent.class, e -> {
            if (Vars.state.isCampaign()) {
                Vars.state.rules.coreIncinerates = true;
                Vars.state.rules.canGameOver = true;
                Vars.state.rules.allowEditRules = false;
                if (!e.isMap) {
                    SectorInfo info = Vars.state.rules.sector.info;
                    info.write();
                    if (Vars.state.rules.sector.planet.allowWaveSimulation) {
                        int wavesPassed = info.wavesPassed;
                        if (wavesPassed > 0) {
                            Groups.unit.each(u -> {
                                if (u.team == Vars.state.rules.waveTeam) {
                                    u.remove();
                                }
                            });
                        }
                        if (wavesPassed > 0) {
                            Vars.state.wave += wavesPassed;
                            Vars.state.wavetime = Vars.state.rules.waveSpacing * Vars.state.getPlanet().campaignRules.difficulty.waveTimeMultiplier;
                            SectorDamage.applyCalculatedDamage();
                        }
                    }
                    Vars.state.getSector().planet.applyRules(Vars.state.rules);
                    info.damage = 0.0f;
                    info.wavesPassed = 0;
                    info.hasCore = true;
                    info.secondsPassed = 0.0f;
                    Vars.state.rules.sector.saveInfo();
                }
            }
        });
        Events.on(EventType.PlayEvent.class, e -> {
            Seq<Weather.WeatherEntry> randomWeather = Vars.state.rules.weather.copy().shuffle();
            float sum = 0.0f;
            for (Weather.WeatherEntry weather : randomWeather) {
                weather.cooldown = sum + Mathf.random(weather.maxFrequency);
                sum += weather.cooldown;
            }
            Vars.state.tick = 0.0;
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            Vars.state.rules.waveTeam.rules().infiniteAmmo = true;
            if (Vars.state.isCampaign()) {
                Vars.state.rules.coreIncinerates = true;
                Vars.state.rules.infiniteResources = false;
                Vars.state.rules.allowEditRules = false;
                Vars.state.rules.allowEditWorldProcessors = false;
                if (Vars.state.getPlanet().enemyInfiniteItems) {
                    Vars.state.rules.waveTeam.rules().infiniteResources = true;
                    Vars.state.rules.waveTeam.rules().fillItems = true;
                }
                Vars.state.rules.waveTeam.rules().buildSpeedMultiplier *= Vars.state.getPlanet().enemyBuildSpeedMultiplier;
            }
            Core.settings.manualSave();
        });
        Events.on(EventType.UnlockEvent.class, e -> {
            if (Vars.net.server()) {
                Call.researched(e.content);
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (!Vars.net.client() && e.sector == Vars.state.getSector() && e.sector.isBeingPlayed()) {
                Vars.state.rules.waveTeam.data().destroyToDerelict();
            }
            if (!Vars.net.client() && e.sector.planet.generator != null) {
                e.sector.planet.generator.onSectorCaptured(e.sector);
            }
        });
        Events.on(EventType.SectorLoseEvent.class, e -> {
            if (!Vars.net.client() && e.sector.planet.generator != null) {
                e.sector.planet.generator.onSectorLost(e.sector);
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            Building patt6130$temp = e.tile.build;
            if (patt6130$temp instanceof CoreBlock.CoreBuild) {
                CoreBlock.CoreBuild core = (CoreBlock.CoreBuild)patt6130$temp;
                if (core.team.isAI() && Vars.state.rules.coreDestroyClear) {
                    Core.app.post(() -> core.team.data().timeDestroy(core.x, core.y, Vars.state.rules.enemyCoreBuildRadius));
                }
            }
        });
        Events.on(EventType.CoreChangeEvent.class, e -> Core.app.post(() -> {
            if (Vars.state.rules.cleanupDeadTeams && Vars.state.rules.pvp && !e.core.isAdded() && e.core.team != Team.derelict && e.core.team.cores().isEmpty()) {
                e.core.team.data().destroyToDerelict();
            }
        }));
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            if (e.team == Vars.state.rules.defaultTeam) {
                if (e.breaking) {
                    ++Vars.state.stats.buildingsDeconstructed;
                } else {
                    ++Vars.state.stats.buildingsBuilt;
                }
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (e.tile.team() == Vars.state.rules.defaultTeam) {
                ++Vars.state.stats.buildingsDestroyed;
            }
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit.team() != Vars.state.rules.defaultTeam) {
                ++Vars.state.stats.enemyUnitsDestroyed;
            }
        });
        Events.on(EventType.UnitCreateEvent.class, e -> {
            if (e.unit.team == Vars.state.rules.defaultTeam) {
                ++Vars.state.stats.unitsCreated;
            }
        });
    }

    private void checkOverlappingPlans(Team team, Tile tile) {
        Teams.TeamData data = team.data();
        Iterator<Teams.BlockPlan> it = data.plans.iterator();
        Rect bounds = tile.block().bounds(tile.x, tile.y, Tmp.r1);
        while (it.hasNext()) {
            Teams.BlockPlan b = it.next();
            if (!bounds.overlaps(b.block.bounds(b.x, b.y, Tmp.r2))) continue;
            b.removed = true;
            it.remove();
        }
    }

    public void play() {
        Vars.state.set(GameState.State.playing);
        Vars.state.wavetime = (Vars.state.rules.initialWaveSpacing <= 0.0f ? Vars.state.rules.waveSpacing * 2.0f : Vars.state.rules.initialWaveSpacing) * (Vars.state.isCampaign() ? Vars.state.getPlanet().campaignRules.difficulty.waveTimeMultiplier : 1.0f);
        Events.fire(new EventType.PlayEvent());
        if (!Vars.state.isCampaign() || !Vars.state.rules.sector.planet.allowLaunchLoadout || Vars.state.rules.sector.preset != null && Vars.state.rules.sector.preset.addStartingItems) {
            for (Teams.TeamData team : Vars.state.teams.getActive()) {
                if (!team.hasCore()) continue;
                CoreBlock.CoreBuild entity = team.core();
                entity.items.clear();
                for (ItemStack stack : Vars.state.rules.loadout) {
                    entity.items.add(stack.item, Math.min(stack.amount, entity.storageCapacity - entity.items.get(stack.item)));
                }
            }
        }
        for (Teams.TeamData team : Vars.state.teams.getActive()) {
            for (CoreBlock.CoreBuild entity : team.cores) {
                entity.heal();
            }
        }
    }

    public void reset() {
        GameState.State prev = Vars.state.getState();
        Vars.state = new GameState();
        Events.fire(new EventType.StateChangeEvent(prev, GameState.State.menu));
        Groups.clear();
        Time.clear();
        Events.fire(new EventType.ResetEvent());
        Vars.world.tiles = new Tiles(0, 0);
        Core.settings.manualSave();
    }

    public void skipWave() {
        this.runWave();
    }

    public void runWave() {
        Vars.spawner.spawnEnemies();
        ++Vars.state.wave;
        Vars.state.wavetime = Vars.state.rules.waveSpacing * (Vars.state.isCampaign() ? Vars.state.getPlanet().campaignRules.difficulty.waveTimeMultiplier : 1.0f);
        Events.fire(new EventType.WaveEvent());
    }

    private void checkGameState() {
        if (Vars.state.isCampaign()) {
            if (Vars.state.teams.playerCores().size == 0 && !Vars.state.gameOver) {
                Vars.state.gameOver = true;
                Events.fire(new EventType.GameOverEvent(Vars.state.rules.waveTeam));
            }
            if (Vars.state.rules.waves && Vars.spawner.countSpawns() + Vars.state.teams.cores((Team)Vars.state.rules.waveTeam).size <= 0) {
                Vars.state.rules.waves = false;
            }
            if (Vars.state.rules.waves && Vars.state.enemies == 0 && Vars.state.rules.winWave > 0 && Vars.state.wave >= Vars.state.rules.winWave && !Vars.spawner.isSpawning() || Vars.state.rules.attackMode && !Vars.state.rules.waveTeam.isAlive()) {
                if (Vars.state.rules.sector.preset != null && Vars.state.rules.sector.preset.attackAfterWaves && !Vars.state.rules.attackMode) {
                    Vars.state.rules.attackMode = true;
                    Vars.state.rules.waves = false;
                    Call.setRules(Vars.state.rules);
                } else {
                    Call.sectorCapture();
                }
            }
        } else if (!Vars.state.rules.attackMode && Vars.state.teams.playerCores().size == 0 && !Vars.state.gameOver) {
            Vars.state.gameOver = true;
            Events.fire(new EventType.GameOverEvent(Vars.state.rules.waveTeam));
        } else if (Vars.state.rules.attackMode) {
            int countAlive = Vars.state.teams.getActive().count(t -> t.isAlive() && t.team != Team.derelict);
            if ((countAlive <= 1 || !Vars.state.rules.pvp && Vars.state.rules.defaultTeam.core() == null) && !Vars.state.gameOver) {
                Teams.TeamData left = Vars.state.teams.getActive().find(t -> t.isAlive() && t.team != Team.derelict);
                Events.fire(new EventType.GameOverEvent(left == null ? Team.derelict : left.team));
                Vars.state.gameOver = true;
            }
        } else if (!Vars.state.gameOver && Vars.state.rules.waves && Vars.state.enemies == 0 && Vars.state.rules.winWave > 0 && Vars.state.wave >= Vars.state.rules.winWave && !Vars.spawner.isSpawning()) {
            Vars.state.gameOver = true;
            Events.fire(new EventType.GameOverEvent(Vars.state.rules.defaultTeam));
        }
    }

    protected void updateWeather() {
        Vars.state.rules.weather.removeAll(w -> w.weather == null);
        for (Weather.WeatherEntry entry : Vars.state.rules.weather) {
            entry.cooldown -= Time.delta;
            if (!(entry.cooldown < 0.0f) && !entry.always || entry.weather.isActive()) continue;
            float duration = entry.always ? Float.POSITIVE_INFINITY : Mathf.random(entry.minDuration, entry.maxDuration);
            entry.cooldown = duration + Mathf.random(entry.minFrequency, entry.maxFrequency);
            Tmp.v1.setToRandomDirection();
            Call.createWeather(entry.weather, entry.intensity, duration, Tmp.v1.x, Tmp.v1.y);
        }
    }

    public static void sectorCapture() {
        Vars.state.rules.waves = false;
        if (Vars.state.rules.sector == null) {
            Vars.state.rules.attackMode = false;
            return;
        }
        boolean initial = !Vars.state.rules.sector.info.wasCaptured;
        Vars.state.rules.sector.info.wasCaptured = true;
        Events.fire(new EventType.SectorCaptureEvent(Vars.state.rules.sector, initial));
        Vars.state.rules.attackMode = false;
        Vars.state.rules.disableWorldProcessors = true;
        Call.clearObjectives();
        if (!Vars.headless && !Vars.net.client()) {
            Vars.control.saves.saveSector(Vars.state.rules.sector);
        }
    }

    public static void updateGameOver(Team winner) {
        Vars.state.gameOver = true;
        if (!Vars.headless) {
            Vars.state.won = Vars.player.team() == winner;
        }
    }

    public static void gameOver(Team winner) {
        Vars.state.stats.wavesLasted = Vars.state.wave;
        Vars.state.won = Vars.player.team() == winner;
        Time.run(180.0f, () -> Vars.ui.restart.show(winner));
        Vars.netClient.setQuiet();
    }

    public static void researched(Content content) {
        if (!(content instanceof UnlockableContent)) {
            return;
        }
        UnlockableContent u = (UnlockableContent)content;
        boolean was = u.unlockedNowHost();
        Vars.state.rules.researched.add(u);
        if (!was) {
            Events.fire(new EventType.UnlockEvent(u));
        }
    }

    @Override
    public void dispose() {
        if (Vars.netServer != null) {
            Vars.netServer.admins.forceSave();
        }
        Core.settings.manualSave();
    }

    @Override
    public void update() {
        boolean runStateCheck;
        PerfCounter.frame.end();
        PerfCounter.frame.begin();
        Events.fire(EventType.Trigger.update);
        Vars.universe.updateGlobal();
        if (Core.settings.modified() && !Vars.state.isPlaying()) {
            Vars.netServer.admins.forceSave();
            Core.settings.forceSave();
        }
        boolean bl = runStateCheck = !Vars.net.client() && !Vars.world.isInvalidMap() && !Vars.state.isEditor() && Vars.state.rules.canGameOver;
        if (Vars.state.isGame()) {
            if (!Vars.net.client()) {
                Vars.state.enemies = Groups.unit.count(u -> u.team() == Vars.state.rules.waveTeam && u.isEnemy());
            }
            if (!Vars.state.isPaused()) {
                Events.fire(EventType.Trigger.beforeGameUpdate);
                float delta = Core.graphics.getDeltaTime();
                Vars.state.tick = Vars.state.tick + (Float.isNaN(delta) || Float.isInfinite(delta) ? 0.0 : (double)(delta * 60.0f));
                ++Vars.state.updateId;
                Vars.state.teams.updateTeamStats();
                MapPreviewLoader.checkPreviews();
                if (Vars.state.rules.fog) {
                    Vars.fogControl.update();
                }
                if (Vars.state.isCampaign()) {
                    Vars.state.rules.sector.info.update();
                }
                if (Vars.state.isCampaign()) {
                    Vars.universe.update();
                }
                Time.update();
                Vars.logicVars.update();
                if (!Vars.net.client() && !Vars.state.isEditor()) {
                    this.updateWeather();
                    for (Teams.TeamData data : Vars.state.teams.getActive()) {
                        Rules.TeamRule rules = data.team.rules();
                        if (rules.fillItems && data.cores.size > 0) {
                            CoreBlock.CoreBuild core = data.cores.first();
                            Vars.content.items().each(i -> {
                                if (i.isOnPlanet(Vars.state.getPlanet()) && !i.isHidden()) {
                                    core.items.set((Item)i, core.getMaximumAccepted((Item)i));
                                }
                            });
                        }
                        if (rules.buildAi && !Vars.state.rules.pvp) {
                            if (data.buildAi == null) {
                                data.buildAi = new BaseBuilderAI(data);
                            }
                            data.buildAi.update();
                        }
                        if (rules.rtsAi) {
                            if (data.rtsAi == null) {
                                data.rtsAi = new RtsAI(data);
                            }
                            data.rtsAi.update();
                        }
                        if (!rules.prebuildAi || Vars.state.isEditor()) continue;
                        for (CoreBlock.CoreBuild core : data.cores) {
                            Seq<Unit> units = data.getUnits(((CoreBlock)core.block).unitType);
                            if (units != null && units.contains((Unit)((Object)((Boolf<Unit>)u -> u.flag == (double)core.pos())))) continue;
                            Unit unit = ((CoreBlock)core.block).unitType.spawn(core, data.team);
                            unit.flag = core.pos();
                            unit.add();
                            Units.notifyUnitSpawn(unit);
                            Fx.spawn.at(unit);
                        }
                    }
                }
                if (!Vars.state.isEditor()) {
                    Vars.state.rules.objectives.update();
                }
                if (Vars.state.rules.waves && Vars.state.rules.waveTimer && !Vars.state.gameOver && !this.isWaitingWave()) {
                    Vars.state.wavetime = Math.max(Vars.state.wavetime - Time.delta, 0.0f);
                }
                if (!Vars.net.client() && Vars.state.wavetime <= 0.0f && Vars.state.rules.waves) {
                    this.runWave();
                }
                Vars.state.envAttrs.clear();
                Vars.state.envAttrs.add(Vars.state.rules.attributes);
                Groups.weather.each(w -> Vars.state.envAttrs.add(w.weather.attrs, w.opacity));
                PerfCounter.entityUpdate.begin();
                Groups.update();
                PerfCounter.entityUpdate.end();
                Events.fire(EventType.Trigger.afterGameUpdate);
            }
            if (runStateCheck) {
                this.checkGameState();
            }
        } else if (Vars.netServer.isWaitingForPlayers() && runStateCheck) {
            this.checkGameState();
        }
    }

    public boolean isWaitingWave() {
        return (Vars.state.rules.waitEnemies || Vars.state.wave >= Vars.state.rules.winWave && Vars.state.rules.winWave > 0) && Vars.state.enemies > 0;
    }
}

