/*
 * Decompiled with CFR 0.152.
 */
package arc.util.noise;

import arc.util.noise.VectorTable;

public class Ridged {
    static final int X_NOISE_GEN = 1619;
    static final int Y_NOISE_GEN = 31337;
    static final int Z_NOISE_GEN = 6971;
    static final int SEED_NOISE_GEN = 1013;
    static final int SHIFT_NOISE_GEN = 8;
    static final int quality = 2;

    private Ridged() {
    }

    public static float noise2d(int seed, double x, double y, double frequency) {
        return Ridged.noise2d(seed, x, y, 1, frequency);
    }

    public static float noise2d(int seed, double x, double y, int octaves, double frequency) {
        return Ridged.noise2d(seed, x, y, octaves, 0.5, frequency);
    }

    public static float noise2d(int seed, double x, double y, int octaves, double persistence, double frequency) {
        double x1 = x * frequency;
        double y1 = y * frequency;
        double value = 0.0;
        double weight = 1.0;
        double offset = 1.0;
        double gain = 2.0;
        double sweight = 1.0;
        for (int curOctave = 0; curOctave < octaves; ++curOctave) {
            double iy0;
            double nx = Ridged.range(x1);
            double ny = Ridged.range(y1);
            int x0 = nx > 0.0 ? (int)nx : (int)nx - 1;
            int x11 = x0 + 1;
            int y0 = ny > 0.0 ? (int)ny : (int)ny - 1;
            int y11 = y0 + 1;
            double xs = 0.0;
            double ys = 0.0;
            switch (2) {
                case 0: {
                    xs = nx - (double)x0;
                    ys = ny - (double)y0;
                    break;
                }
                case 1: {
                    xs = Ridged.scurve3(nx - (double)x0);
                    ys = Ridged.scurve3(ny - (double)y0);
                    break;
                }
                case 2: {
                    xs = Ridged.scurve5(nx - (double)x0);
                    ys = Ridged.scurve5(ny - (double)y0);
                }
            }
            double n0 = Ridged.gradientNoise(nx, ny, x0, y0, seed + curOctave & Integer.MAX_VALUE);
            double n1 = Ridged.gradientNoise(nx, ny, x11, y0, seed + curOctave & Integer.MAX_VALUE);
            double ix0 = Ridged.lerp(n0, n1, xs);
            n0 = Ridged.gradientNoise(nx, ny, x0, y11, seed + curOctave & Integer.MAX_VALUE);
            n1 = Ridged.gradientNoise(nx, ny, x11, y11, seed + curOctave & Integer.MAX_VALUE);
            double ix1 = Ridged.lerp(n0, n1, xs);
            double signal = iy0 = Ridged.lerp(ix0, ix1, ys);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            weight = (signal *= weight) * gain;
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            value += signal * sweight;
            sweight *= persistence;
            x1 *= 2.0;
            y1 *= 2.0;
        }
        return (float)(value * 1.25 - 1.0);
    }

    public static float noise3d(int seed, double x, double y, double z, float frequency) {
        return Ridged.noise3d(seed, x, y, z, 1, frequency);
    }

    public static float noise3d(int seed, double x, double y, double z, int octaves, float frequency) {
        double x1 = x * (double)frequency;
        double y1 = y * (double)frequency;
        double z1 = z * (double)frequency;
        double value = 0.0;
        double weight = 1.0;
        double offset = 1.0;
        double gain = 2.0;
        double scaling = 0.5;
        double sweight = 1.0;
        for (int curOctave = 0; curOctave < octaves; ++curOctave) {
            double nx = Ridged.range(x1);
            double ny = Ridged.range(y1);
            double nz = Ridged.range(z1);
            int x0 = nx > 0.0 ? (int)nx : (int)nx - 1;
            int x11 = x0 + 1;
            int y0 = ny > 0.0 ? (int)ny : (int)ny - 1;
            int y11 = y0 + 1;
            int z0 = nz > 0.0 ? (int)nz : (int)nz - 1;
            int z11 = z0 + 1;
            double xs = 0.0;
            double ys = 0.0;
            double zs = 0.0;
            switch (2) {
                case 0: {
                    xs = nx - (double)x0;
                    ys = ny - (double)y0;
                    zs = nz - (double)z0;
                    break;
                }
                case 1: {
                    xs = Ridged.scurve3(nx - (double)x0);
                    ys = Ridged.scurve3(ny - (double)y0);
                    zs = Ridged.scurve3(nz - (double)z0);
                    break;
                }
                case 2: {
                    xs = Ridged.scurve5(nx - (double)x0);
                    ys = Ridged.scurve5(ny - (double)y0);
                    zs = Ridged.scurve5(nz - (double)z0);
                }
            }
            double n0 = Ridged.gradientNoise3D(nx, ny, nz, x0, y0, z0, seed + curOctave & Integer.MAX_VALUE);
            double n1 = Ridged.gradientNoise3D(nx, ny, nz, x11, y0, z0, seed + curOctave & Integer.MAX_VALUE);
            double ix0 = Ridged.lerp(n0, n1, xs);
            n0 = Ridged.gradientNoise3D(nx, ny, nz, x0, y11, z0, seed + curOctave & Integer.MAX_VALUE);
            n1 = Ridged.gradientNoise3D(nx, ny, nz, x11, y11, z0, seed + curOctave & Integer.MAX_VALUE);
            double ix1 = Ridged.lerp(n0, n1, xs);
            double iy0 = Ridged.lerp(ix0, ix1, ys);
            n0 = Ridged.gradientNoise3D(nx, ny, nz, x0, y0, z11, seed + curOctave & Integer.MAX_VALUE);
            n1 = Ridged.gradientNoise3D(nx, ny, nz, x11, y0, z11, seed + curOctave & Integer.MAX_VALUE);
            ix0 = Ridged.lerp(n0, n1, xs);
            n0 = Ridged.gradientNoise3D(nx, ny, nz, x0, y11, z11, seed + curOctave & Integer.MAX_VALUE);
            n1 = Ridged.gradientNoise3D(nx, ny, nz, x11, y11, z11, seed + curOctave & Integer.MAX_VALUE);
            ix1 = Ridged.lerp(n0, n1, xs);
            double iy1 = Ridged.lerp(ix0, ix1, ys);
            double signal = Ridged.lerp(iy0, iy1, zs);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            weight = (signal *= weight) * gain;
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            value += signal * sweight;
            sweight *= scaling;
            x1 *= 2.0;
            y1 *= 2.0;
            z1 *= 2.0;
        }
        return (float)(value * 1.25 - 1.0);
    }

    static double range(double n) {
        if (n >= 1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) - 1.073741824E9;
        }
        if (n <= -1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) + 1.073741824E9;
        }
        return n;
    }

    static double gradientNoise3D(double fx, double fy, double fz, int ix, int iy, int iz, int seed) {
        int vectorIndex = 1619 * ix + 31337 * iy + 6971 * iz + 1013 * seed;
        vectorIndex ^= vectorIndex >> 8;
        vectorIndex &= 0xFF;
        double xvGradient = VectorTable.randomVectors[vectorIndex *= 3];
        double yvGradient = VectorTable.randomVectors[vectorIndex + 1];
        double zvGradient = VectorTable.randomVectors[vectorIndex + 2];
        double xvPoint = fx - (double)ix;
        double yvPoint = fy - (double)iy;
        double zvPoint = fz - (double)iz;
        return (xvGradient * xvPoint + yvGradient * yvPoint + zvGradient * zvPoint) * 2.12;
    }

    static double gradientNoise(double fx, double fy, int ix, int iy, int seed) {
        int vectorIndex = 1619 * ix + 31337 * iy + 1013 * seed;
        vectorIndex ^= vectorIndex >> 8;
        vectorIndex &= 0xFF;
        double xvGradient = VectorTable.randomVectors[vectorIndex *= 3];
        double yvGradient = VectorTable.randomVectors[vectorIndex + 1];
        double xvPoint = fx - (double)ix;
        double yvPoint = fy - (double)iy;
        return (xvGradient * xvPoint + yvGradient * yvPoint) * 2.12;
    }

    static double lerp(double n0, double n1, double a) {
        return (1.0 - a) * n0 + a * n1;
    }

    static double scurve3(double a) {
        return a * a * (3.0 - 2.0 * a);
    }

    static double scurve5(double a) {
        double a3 = a * a * a;
        double a4 = a3 * a;
        double a5 = a4 * a;
        return 6.0 * a5 - 15.0 * a4 + 10.0 * a3;
    }
}

