/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.actions;

import arc.math.Mathf;
import arc.scene.actions.TemporalAction;

public class RotateToAction
extends TemporalAction {
    private float start;
    private float end;
    private boolean useShortestDirection = false;

    public RotateToAction() {
    }

    public RotateToAction(boolean useShortestDirection) {
        this.useShortestDirection = useShortestDirection;
    }

    @Override
    protected void begin() {
        this.start = this.target.getRotation();
    }

    @Override
    protected void update(float percent) {
        if (this.useShortestDirection) {
            this.target.setRotation(Mathf.slerp(this.start, this.end, percent));
        } else {
            this.target.setRotation(this.start + (this.end - this.start) * percent);
        }
    }

    public float getRotation() {
        return this.end;
    }

    public void setRotation(float rotation) {
        this.end = rotation;
    }

    public boolean isUseShortestDirection() {
        return this.useShortestDirection;
    }

    public void setUseShortestDirection(boolean useShortestDirection) {
        this.useShortestDirection = useShortestDirection;
    }
}

