/*
 * Decompiled with CFR 0.152.
 */
package mindustry.desktop.steam;

import arc.Events;
import arc.util.Log;
import arc.util.Timer;
import com.codedisaster.steamworks.SteamID;
import com.codedisaster.steamworks.SteamResult;
import com.codedisaster.steamworks.SteamUserStats;
import com.codedisaster.steamworks.SteamUserStatsCallback;
import mindustry.Vars;
import mindustry.game.EventType;

public class SStats
implements SteamUserStatsCallback {
    public final SteamUserStats stats = new SteamUserStats(this);
    private boolean updated = false;
    private int statSavePeriod = 4;

    public SStats() {
        this.stats.requestCurrentStats();
        Events.on(EventType.ClientLoadEvent.class, e -> Timer.schedule(() -> {
            if (this.updated) {
                this.stats.storeStats();
            }
        }, (float)(this.statSavePeriod * 60), (float)(this.statSavePeriod * 60)));
    }

    public void onUpdate() {
        this.updated = true;
    }

    @Override
    public void onUserStatsReceived(long gameID, SteamID steamID, SteamResult result) {
        Vars.service.init();
        if (result != SteamResult.OK) {
            Log.err("Failed to receive steam stats: @", new Object[]{result});
        } else {
            Log.info("Received steam stats.");
        }
    }

    @Override
    public void onUserStatsStored(long gameID, SteamResult result) {
        Log.info("Stored stats: @", new Object[]{result});
        if (result == SteamResult.OK) {
            this.updated = true;
        }
    }
}

