/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.IntQuadTree;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.ControlPathfinder;
import mindustry.ai.Pathfinder;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.gen.Unit;

public class UnitGroup {
    public Seq<Unit> units = new Seq();
    public int collisionLayer;
    public volatile float[] positions;
    public volatile float[] originalPositions;
    public volatile boolean valid;

    public void calculateFormation(Vec2 dest, int collisionLayer) {
        this.collisionLayer = collisionLayer;
        float cx = 0.0f;
        float cy = 0.0f;
        for (Unit unit : this.units) {
            cx += unit.x;
            cy += unit.y;
        }
        cx /= (float)this.units.size;
        cy /= (float)this.units.size;
        this.positions = new float[this.units.size * 2];
        int i = 0;
        while (i < this.units.size) {
            Unit unit;
            unit = this.units.get(i);
            this.positions[i * 2] = unit.x - cx;
            this.positions[i * 2 + 1] = unit.y - cy;
            unit.command().groupIndex = i++;
        }
        Vars.mainExecutor.submit(() -> {
            float maxSpaceUsage = 0.7f;
            boolean compress = true;
            int compressionIterations = 0;
            int physicsIterations = 0;
            int totalIterations = 0;
            int maxPhysicsIterations = Math.min(1 + (int)(Math.pow(this.units.size, 0.65) / 10.0), 6);
            IntQuadTree tree = new IntQuadTree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()), (index, hitbox) -> hitbox.setCentered(this.positions[index * 2], this.positions[index * 2 + 1], this.units.get((int)index).hitSize));
            IntSeq tmpseq = new IntSeq();
            Vec2 v1 = new Vec2();
            Vec2 v2 = new Vec2();
            while (totalIterations++ < 40 && physicsIterations < maxPhysicsIterations) {
                int a;
                float spaceUsed = 0.0f;
                if (compress) {
                    ++compressionIterations;
                    float maxDst = 1.0f;
                    float totalArea = 0.0f;
                    for (int a2 = 0; a2 < this.units.size; ++a2) {
                        v1.set(this.positions[a2 * 2], this.positions[a2 * 2 + 1]).lerp(v2.set(0.0f, 0.0f), 0.3f);
                        this.positions[a2 * 2] = v1.x;
                        this.positions[a2 * 2 + 1] = v1.y;
                        float rad = this.units.get((int)a2).hitSize * 0.6f;
                        maxDst = Math.max(maxDst, v1.dst(0.0f, 0.0f) + rad);
                        totalArea += (float)Math.PI * rad * rad;
                    }
                    float boundingArea = (float)Math.PI * maxDst * maxDst;
                    spaceUsed = totalArea / boundingArea;
                    boolean bl = compress = spaceUsed <= maxSpaceUsage && compressionIterations < 20;
                }
                if (compress && !(spaceUsed > 0.5f)) continue;
                ++physicsIterations;
                tree.clear();
                for (a = 0; a < this.units.size; ++a) {
                    tree.insert(a);
                }
                for (a = 0; a < this.units.size; ++a) {
                    Unit unit = this.units.get(a);
                    float x = this.positions[a * 2];
                    float y = this.positions[a * 2 + 1];
                    float radius = unit.hitSize / 2.0f;
                    tmpseq.clear();
                    tree.intersect(x - radius, y - radius, radius * 2.0f, radius * 2.0f, tmpseq);
                    for (int res = 0; res < tmpseq.size; ++res) {
                        int b = tmpseq.items[res];
                        if (a == b) continue;
                        float ox = this.positions[b * 2];
                        float oy = this.positions[b * 2 + 1];
                        Unit other = this.units.get(b);
                        float rs = (radius + other.hitSize / 2.0f) * 1.2f;
                        float dst = Mathf.dst(x, y, ox, oy);
                        if (!(dst < rs)) continue;
                        v2.set(x - ox, y - oy).setLength(rs - dst);
                        float mass1 = unit.hitSize;
                        float mass2 = other.hitSize;
                        float ms = mass1 + mass2;
                        float m1 = mass2 / ms;
                        float m2 = mass1 / ms;
                        float scl = 1.0f;
                        int n = a * 2;
                        this.positions[n] = this.positions[n] + v2.x * m1 * scl;
                        int n2 = a * 2 + 1;
                        this.positions[n2] = this.positions[n2] + v2.y * m1 * scl;
                        int n3 = b * 2;
                        this.positions[n3] = this.positions[n3] - v2.x * m2 * scl;
                        int n4 = b * 2 + 1;
                        this.positions[n4] = this.positions[n4] - v2.y * m2 * scl;
                    }
                }
            }
            this.originalPositions = (float[])this.positions.clone();
            for (int a = 0; a < this.units.size; ++a) {
                this.updateRaycast(a, dest, v1);
            }
            this.valid = true;
            if (ControlPathfinder.showDebug) {
                Core.app.post(() -> {
                    for (int i = 0; i < this.units.size; ++i) {
                        float x = this.positions[i * 2];
                        float y = this.positions[i * 2 + 1];
                        Fx.placeBlock.at(x + dest.x, y + dest.y, 1.0f, Color.green);
                    }
                });
            }
        });
    }

    public void updateRaycast(int index, Vec2 dest) {
        this.updateRaycast(index, dest, Tmp.v1);
    }

    private void updateRaycast(int index, Vec2 dest, Vec2 v1) {
        if (this.collisionLayer != 2 && this.originalPositions != null && this.positions != null) {
            float x = this.originalPositions[index * 2] + dest.x;
            float y = this.originalPositions[index * 2 + 1] + dest.y;
            Unit unit = this.units.get(index);
            Pathfinder.PathCost cost = unit.type.pathCost;
            int res = ControlPathfinder.raycastFastAvoid(unit.team.id, cost, World.toTile(dest.x), World.toTile(dest.y), World.toTile(x), World.toTile(y));
            if (res != 0) {
                v1.set((float)(Point2.x(res) * 8) - dest.x, (float)(Point2.y(res) * 8) - dest.y);
                v1.setLength(Math.max(v1.len() - 8.0f - 4.0f, 0.0f));
                this.positions[index * 2] = v1.x;
                this.positions[index * 2 + 1] = v1.y;
            }
            if (ControlPathfinder.showDebug) {
                Core.app.post(() -> Fx.debugLine.at(unit.x, unit.y, 0.0f, Color.green, new Vec2[]{new Vec2(dest.x, dest.y), new Vec2(x, y)}));
            }
        }
    }
}

