/*
 * Decompiled with CFR 0.152.
 */
package mindustry.async;

import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.util.Nullable;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.game.Teams;
import mindustry.gen.Unit;

public class AvoidanceProcess
implements AsyncProcess {
    static int wwidth;
    static int wheight;
    @Nullable
    int[] buffer1;
    @Nullable
    int[] buffer2;
    volatile boolean swap;
    IntSeq requests = new IntSeq();
    @Nullable
    int[] avoidance;
    boolean modified;
    boolean active;

    @Nullable
    public int[] getAvoidance() {
        if (!this.active) {
            this.buffer1 = new int[wwidth * wheight];
            this.buffer2 = new int[wwidth * wheight];
            this.active = true;
        }
        return this.avoidance;
    }

    @Override
    public void init() {
        wwidth = Vars.world.width();
        wheight = Vars.world.height();
    }

    @Override
    public void reset() {
        this.avoidance = null;
        this.buffer2 = null;
        this.buffer1 = null;
        this.swap = false;
        this.modified = false;
        this.active = false;
        this.requests.clear();
    }

    @Override
    public void begin() {
        if (!this.active) {
            return;
        }
        this.requests.clear();
        this.avoidance = !this.swap ? this.buffer1 : this.buffer2;
        for (Teams.TeamData team : Vars.state.teams.present) {
            if (!team.team.isAI() || team.team.rules().rtsAi) continue;
            for (Unit unit : team.units) {
                if (unit.collisionLayer() != 0) continue;
                float scaling = 2.0f;
                this.requests.add(Point2.pack(unit.tileX(), unit.tileY()), Float.floatToRawIntBits(unit.hitSize * 0.6f / 8.0f * scaling), unit.id);
            }
        }
    }

    @Override
    public void process() {
        int[] buffer = this.swap ? this.buffer1 : this.buffer2;
        boolean bl = this.swap = !this.swap;
        if (buffer == null) {
            return;
        }
        if (this.modified) {
            Arrays.fill(buffer, 0);
        }
        this.modified = this.requests.size > 0;
        int total = this.requests.size;
        int[] items = this.requests.items;
        for (int i = 0; i < total; i += 3) {
            int point = items[i];
            int id = items[i + 2];
            short rx = Point2.x(point);
            short ry = Point2.y(point);
            float rad = Float.intBitsToFloat(items[i + 1]);
            float rad2 = rad * rad;
            int r = Math.max(1, Mathf.ceil(rad));
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    int x = dx + rx;
                    int y = dy + ry;
                    if (x < 0 || y < 0 || x >= wwidth || y >= wheight || !((float)(dx * dx + dy * dy) <= rad2)) continue;
                    buffer[x + y * AvoidanceProcess.wwidth] = Math.max(buffer[x + y * wwidth], Integer.MAX_VALUE - id);
                }
            }
        }
    }

    @Override
    public boolean shouldProcess() {
        return this.active;
    }
}

