/*
 * Decompiled with CFR 0.152.
 */
package arc.net.dns;

import arc.Core;
import arc.math.Rand;
import arc.net.dns.JndiContextNameserverProvider;
import arc.net.dns.NameserverProvider;
import arc.net.dns.ResolvConfNameserverProvider;
import arc.net.dns.SRVRecord;
import arc.net.dns.WellKnownNameserverProvider;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class ArcDns {
    public static final int dnsResolverPort = 53;
    private static final Seq<InetSocketAddress> nameservers = new Seq(3);
    private static final Seq<NameserverProvider> nameserverProviders = Seq.with(new JndiContextNameserverProvider(), new ResolvConfNameserverProvider(), new WellKnownNameserverProvider());

    public static Seq<NameserverProvider> getNameserverProviders() {
        return nameserverProviders;
    }

    public static void setNameserverProviders(Seq<NameserverProvider> providers) {
        nameserverProviders.clear();
        nameserverProviders.addAll(providers);
        ArcDns.refreshNameservers();
    }

    public static Seq<InetSocketAddress> getNameservers() {
        return nameservers;
    }

    public static void refreshNameservers() {
        nameservers.clear();
        if (Core.app != null) {
            Core.app.getDnsServers(nameservers);
        }
        for (NameserverProvider provider : nameserverProviders) {
            if (!provider.isEnabled()) continue;
            try {
                nameservers.addAll(provider.getNameservers());
                if (nameservers.isEmpty()) continue;
                return;
            }
            catch (Exception e) {
                Log.warn("[DNS] Failed to initialize provider: @", e);
            }
        }
        for (InetSocketAddress server : nameservers) {
            Log.debug("[DNS] Added @ to nameservers", server);
        }
        nameservers.add(new InetSocketAddress(InetAddress.getLoopbackAddress(), 53));
    }

    public static Seq<SRVRecord> getSrvRecords(String domain) {
        for (InetSocketAddress nameserver : nameservers) {
            try {
                return ArcDns.getSrvRecords(domain, nameserver);
            }
            catch (IOException iOException) {
            }
        }
        return new Seq<SRVRecord>(1);
    }

    public static Seq<SRVRecord> getSrvRecords(String domain, InetSocketAddress nameserver) throws IOException {
        Seq<SRVRecord> records = new Seq<SRVRecord>();
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(2000);
            short id = (short)new Rand().nextInt(Short.MAX_VALUE);
            byte[] response = new byte[512];
            try (Streams.OptimizedByteArrayOutputStream stream = new Streams.OptimizedByteArrayOutputStream(128);
                 DataOutputStream out = new DataOutputStream(stream);){
                out.writeShort(id);
                out.writeShort(256);
                out.writeShort(1);
                out.writeShort(0);
                out.writeShort(0);
                out.writeShort(0);
                for (String part : domain.split("\\.")) {
                    out.writeByte(part.length());
                    out.write(part.getBytes(Strings.utf8));
                }
                out.writeByte(0);
                out.writeShort(33);
                out.writeShort(1);
                socket.send(new DatagramPacket(((ByteArrayOutputStream)stream).toByteArray(), stream.size(), nameserver));
            }
            DatagramPacket packet = new DatagramPacket(response, response.length);
            socket.receive(packet);
            try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(response));){
                int len;
                short responseId = in.readShort();
                if (responseId != id) {
                    throw new IOException("Invalid response from dns server " + nameserver);
                }
                in.readShort();
                in.readShort();
                int answers = in.readUnsignedShort();
                in.readShort();
                in.readShort();
                while ((len = in.readByte()) != 0) {
                    in.skipBytes(len);
                }
                in.readShort();
                in.readShort();
                for (int i = 0; i < answers; ++i) {
                    in.readShort();
                    in.readShort();
                    in.readShort();
                    long ttl = (long)in.readInt() & 0xFFFFFFFFL;
                    in.readShort();
                    int priority = in.readUnsignedShort();
                    int weight = in.readUnsignedShort();
                    int port = in.readUnsignedShort();
                    StringBuilder builder = new StringBuilder();
                    while ((len = in.readByte()) != 0) {
                        for (int j = 0; j < len; ++j) {
                            builder.append((char)in.readByte());
                        }
                        builder.append('.');
                    }
                    builder.delete(builder.length() - 1, builder.length());
                    records.add(new SRVRecord(ttl, priority, weight, port, builder.toString()));
                }
            }
        }
        return records.sort();
    }

    static {
        ArcDns.refreshNameservers();
    }
}

