/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel;

import arc.flabel.FEffect;
import arc.flabel.effects.BlinkEffect;
import arc.flabel.effects.EaseEffect;
import arc.flabel.effects.FadeEffect;
import arc.flabel.effects.GradientEffect;
import arc.flabel.effects.JumpEffect;
import arc.flabel.effects.RainbowEffect;
import arc.flabel.effects.ShakeEffect;
import arc.flabel.effects.SickEffect;
import arc.flabel.effects.WaveEffect;
import arc.flabel.effects.WindEffect;
import arc.func.Prov;
import arc.graphics.Color;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectMap;

public class FConfig {
    public static boolean forceColorMarkupByDefault = true;
    public static float defaultWaitValue = 0.25f;
    public static float defaultSpeedPerChar = 0.035f;
    public static int charLimitPerFrame = -1;
    public static Color defaultClearColor = new Color(Color.white);
    public static ObjectFloatMap<Character> intervalMultipliersByChar = new ObjectFloatMap();
    public static final ObjectMap<String, String> globalVars = new ObjectMap();
    static final ObjectMap<String, Prov<FEffect>> effects = new ObjectMap();
    static boolean dirtyEffectMaps = true;

    public static void registerEffect(String tokenName, Prov<FEffect> effect) {
        effects.put(tokenName, effect);
        dirtyEffectMaps = true;
    }

    public static void unregisterEffect(String tokenName) {
        effects.remove(tokenName);
    }

    static {
        intervalMultipliersByChar.put(Character.valueOf(' '), 0.0f);
        intervalMultipliersByChar.put(Character.valueOf(':'), 1.5f);
        intervalMultipliersByChar.put(Character.valueOf(','), 2.5f);
        intervalMultipliersByChar.put(Character.valueOf('.'), 2.5f);
        intervalMultipliersByChar.put(Character.valueOf('!'), 5.0f);
        intervalMultipliersByChar.put(Character.valueOf('?'), 5.0f);
        intervalMultipliersByChar.put(Character.valueOf('\n'), 20.0f);
        FConfig.registerEffect("ease", EaseEffect::new);
        FConfig.registerEffect("jump", JumpEffect::new);
        FConfig.registerEffect("shake", ShakeEffect::new);
        FConfig.registerEffect("sick", SickEffect::new);
        FConfig.registerEffect("wave", WaveEffect::new);
        FConfig.registerEffect("wind", WindEffect::new);
        FConfig.registerEffect("rainbow", RainbowEffect::new);
        FConfig.registerEffect("gradient", GradientEffect::new);
        FConfig.registerEffect("fade", FadeEffect::new);
        FConfig.registerEffect("blink", BlinkEffect::new);
    }
}

