import type NeuralNetwork from '../neural_network';
import type Tensor from '../tensor';
import type { TrainerAbstractOptions, TrainerResult } from '../types';
declare class Abstract {
    nn: NeuralNetwork;
    method: 'sgd' | 'adam' | 'adagrad' | 'adadelta' | 'nesterov';
    batchSize: number;
    learningRate: number;
    l1decay: number;
    l2decay: number;
    momentum: number;
    ro: number;
    eps: number;
    beta1: number;
    beta2: number;
    k: number;
    gsum: Float32Array[];
    xsum: Float32Array[];
    constructor(nn: NeuralNetwork, options?: TrainerAbstractOptions);
    train(input: Tensor, output: ArrayLike<number> | number): TrainerResult;
}
export default Abstract;
