var it = Object.defineProperty;
var r = (e, t) => it(e, "name", { value: t, configurable: !0 });

// src/measure/preview.ts
import { definePreview as St } from "storybook/preview-api";

// src/measure/constants.ts
var C = "storybook/measure-addon", Mt = `${C}/tool`, A = "measureEnabled", xt = {
  RESULT: `${C}/result`,
  REQUEST: `${C}/request`,
  CLEAR: `${C}/clear`
};

// src/measure/withMeasure.ts
import { useEffect as j } from "storybook/preview-api";

// src/measure/box-model/canvas.ts
import { global as R } from "@storybook/global";

// ../node_modules/tiny-invariant/dist/esm/tiny-invariant.js
var lt = !1, T = "Invariant failed";
function v(e, t) {
  if (!e) {
    if (lt)
      throw new Error(T);
    var o = typeof t == "function" ? t() : t, i = o ? "".concat(T, ": ").concat(o) : T;
    throw new Error(i);
  }
}
r(v, "invariant");

// src/measure/box-model/canvas.ts
function H() {
  let e = R.document.documentElement, t = Math.max(e.scrollHeight, e.offsetHeight);
  return { width: Math.max(e.scrollWidth, e.offsetWidth), height: t };
}
r(H, "getDocumentWidthAndHeight");
function rt() {
  let e = R.document.createElement("canvas");
  e.id = "storybook-addon-measure";
  let t = e.getContext("2d");
  v(t != null);
  let { width: o, height: i } = H();
  return D(e, t, { width: o, height: i }), e.style.position = "absolute", e.style.left = "0", e.style.top = "0", e.style.zIndex = "214748364\
7", e.style.pointerEvents = "none", R.document.body.appendChild(e), { canvas: e, context: t, width: o, height: i };
}
r(rt, "createCanvas");
function D(e, t, { width: o, height: i }) {
  e.style.width = `${o}px`, e.style.height = `${i}px`;
  let n = R.window.devicePixelRatio;
  e.width = Math.floor(o * n), e.height = Math.floor(i * n), t.scale(n, n);
}
r(D, "setCanvasWidthAndHeight");
var m = {};
function F() {
  m.canvas || (m = rt());
}
r(F, "init");
function W() {
  m.context && m.context.clearRect(0, 0, m.width ?? 0, m.height ?? 0);
}
r(W, "clear");
function Y(e) {
  W(), e(m.context);
}
r(Y, "draw");
function B() {
  v(m.canvas, "Canvas should exist in the state."), v(m.context, "Context should exist in the state."), D(m.canvas, m.context, { width: 0, height: 0 });
  let { width: e, height: t } = H();
  D(m.canvas, m.context, { width: e, height: t }), m.width = e, m.height = t;
}
r(B, "rescale");
function z() {
  m.canvas && (W(), m.canvas.parentNode?.removeChild(m.canvas), m = {});
}
r(z, "destroy");

// src/measure/box-model/visualizer.ts
import { global as b } from "@storybook/global";

// src/measure/box-model/labels.ts
var w = {
  margin: "#f6b26b",
  border: "#ffe599",
  padding: "#93c47d",
  content: "#6fa8dc",
  text: "#232020"
}, g = 6;
function X(e, { x: t, y: o, w: i, h: n, r: l }) {
  t = t - i / 2, o = o - n / 2, i < 2 * l && (l = i / 2), n < 2 * l && (l = n / 2), e.beginPath(), e.moveTo(t + l, o), e.arcTo(t + i, o, t +
  i, o + n, l), e.arcTo(t + i, o + n, t, o + n, l), e.arcTo(t, o + n, t, o, l), e.arcTo(t, o, t + i, o, l), e.closePath();
}
r(X, "roundedRect");
function at(e, { padding: t, border: o, width: i, height: n, top: l, left: a }) {
  let s = i - o.left - o.right - t.left - t.right, f = n - t.top - t.bottom - o.top - o.bottom, c = a + o.left + t.left, u = l + o.top + t.top;
  return e === "top" ? c += s / 2 : e === "right" ? (c += s, u += f / 2) : e === "bottom" ? (c += s / 2, u += f) : e === "left" ? u += f / 2 :
  e === "center" && (c += s / 2, u += f / 2), { x: c, y: u };
}
r(at, "positionCoordinate");
function st(e, t, { margin: o, border: i, padding: n }, l, a) {
  let s = /* @__PURE__ */ r((h) => 0, "shift"), f = 0, c = 0, u = a ? 1 : 0.5, d = a ? l * 2 : 0;
  return e === "padding" ? s = /* @__PURE__ */ r((h) => n[h] * u + d, "shift") : e === "border" ? s = /* @__PURE__ */ r((h) => n[h] + i[h] *
  u + d, "shift") : e === "margin" && (s = /* @__PURE__ */ r((h) => n[h] + i[h] + o[h] * u + d, "shift")), t === "top" ? c = -s("top") : t ===
  "right" ? f = s("right") : t === "bottom" ? c = s("bottom") : t === "left" && (f = -s("left")), { offsetX: f, offsetY: c };
}
r(st, "offset");
function ft(e, t) {
  return Math.abs(e.x - t.x) < Math.abs(e.w + t.w) / 2 && Math.abs(e.y - t.y) < Math.abs(e.h + t.h) / 2;
}
r(ft, "collide");
function ct(e, t, o) {
  return e === "top" ? t.y = o.y - o.h - g : e === "right" ? t.x = o.x + o.w / 2 + g + t.w / 2 : e === "bottom" ? t.y = o.y + o.h + g : e ===
  "left" && (t.x = o.x - o.w / 2 - g - t.w / 2), { x: t.x, y: t.y };
}
r(ct, "overlapAdjustment");
function $(e, t, { x: o, y: i, w: n, h: l }, a) {
  return X(e, { x: o, y: i, w: n, h: l, r: 3 }), e.fillStyle = `${w[t]}dd`, e.fill(), e.strokeStyle = w[t], e.stroke(), e.fillStyle = w.text,
  e.fillText(a, o, i), X(e, { x: o, y: i, w: n, h: l, r: 3 }), e.fillStyle = `${w[t]}dd`, e.fill(), e.strokeStyle = w[t], e.stroke(), e.fillStyle =
  w.text, e.fillText(a, o, i), { x: o, y: i, w: n, h: l };
}
r($, "textWithRect");
function N(e, t) {
  e.font = "600 12px monospace", e.textBaseline = "middle", e.textAlign = "center";
  let o = e.measureText(t), i = o.actualBoundingBoxAscent + o.actualBoundingBoxDescent, n = o.width + g * 2, l = i + g * 2;
  return { w: n, h: l };
}
r(N, "configureText");
function mt(e, t, { type: o, position: i = "center", text: n }, l, a = !1) {
  let { x: s, y: f } = at(i, t), { offsetX: c, offsetY: u } = st(o, i, t, g + 1, a);
  s += c, f += u;
  let { w: d, h } = N(e, n);
  if (l && ft({ x: s, y: f, w: d, h }, l)) {
    let S = ct(i, { x: s, y: f, w: d, h }, l);
    s = S.x, f = S.y;
  }
  return $(e, o, { x: s, y: f, w: d, h }, n);
}
r(mt, "drawLabel");
function ut(e, { w: t, h: o }) {
  let i = t * 0.5 + g, n = o * 0.5 + g;
  return {
    offsetX: (e.x === "left" ? -1 : 1) * i,
    offsetY: (e.y === "top" ? -1 : 1) * n
  };
}
r(ut, "floatingOffset");
function ht(e, t, { type: o, text: i }) {
  let { floatingAlignment: n, extremities: l } = t, a = l[n.x], s = l[n.y], { w: f, h: c } = N(e, i), { offsetX: u, offsetY: d } = ut(n, {
    w: f,
    h: c
  });
  return a += u, s += d, $(e, o, { x: a, y: s, w: f, h: c }, i);
}
r(ht, "drawFloatingLabel");
function y(e, t, o, i) {
  let n = [];
  o.forEach((l, a) => {
    let s = i && l.position === "center" ? ht(e, t, l) : mt(e, t, l, n[a - 1], i);
    n[a] = s;
  });
}
r(y, "drawStack");
function O(e, t, o, i) {
  let n = o.reduce((l, a) => (Object.prototype.hasOwnProperty.call(l, a.position) || (l[a.position] = []), l[a.position]?.push(a), l), {});
  n.top && y(e, t, n.top, i), n.right && y(e, t, n.right, i), n.bottom && y(e, t, n.bottom, i), n.left && y(e, t, n.left, i), n.center && y(
  e, t, n.center, i);
}
r(O, "labelStacks");

// src/measure/box-model/visualizer.ts
var M = {
  margin: "#f6b26ba8",
  border: "#ffe599a8",
  padding: "#93c47d8c",
  content: "#6fa8dca8"
}, I = 30;
function p(e) {
  return parseInt(e.replace("px", ""), 10);
}
r(p, "pxToNumber");
function L(e) {
  return Number.isInteger(e) ? e : e.toFixed(2);
}
r(L, "round");
function k(e) {
  return e.filter((t) => t.text !== 0 && t.text !== "0");
}
r(k, "filterZeroValues");
function dt(e) {
  let t = {
    top: b.window.scrollY,
    bottom: b.window.scrollY + b.window.innerHeight,
    left: b.window.scrollX,
    right: b.window.scrollX + b.window.innerWidth
  }, o = {
    top: Math.abs(t.top - e.top),
    bottom: Math.abs(t.bottom - e.bottom),
    left: Math.abs(t.left - e.left),
    right: Math.abs(t.right - e.right)
  };
  return {
    x: o.left > o.right ? "left" : "right",
    y: o.top > o.bottom ? "top" : "bottom"
  };
}
r(dt, "floatingAlignment");
function pt(e) {
  let t = b.getComputedStyle(e), { top: o, left: i, right: n, bottom: l, width: a, height: s } = e.getBoundingClientRect(), {
    marginTop: f,
    marginBottom: c,
    marginLeft: u,
    marginRight: d,
    paddingTop: h,
    paddingBottom: S,
    paddingLeft: K,
    paddingRight: Z,
    borderBottomWidth: Q,
    borderTopWidth: J,
    borderLeftWidth: tt,
    borderRightWidth: et
  } = t;
  o = o + b.window.scrollY, i = i + b.window.scrollX, l = l + b.window.scrollY, n = n + b.window.scrollX;
  let E = {
    top: p(f),
    bottom: p(c),
    left: p(u),
    right: p(d)
  }, ot = {
    top: p(h),
    bottom: p(S),
    left: p(K),
    right: p(Z)
  }, nt = {
    top: p(J),
    bottom: p(Q),
    left: p(tt),
    right: p(et)
  }, P = {
    top: o - E.top,
    bottom: l + E.bottom,
    left: i - E.left,
    right: n + E.right
  };
  return {
    margin: E,
    padding: ot,
    border: nt,
    top: o,
    left: i,
    bottom: l,
    right: n,
    width: a,
    height: s,
    extremities: P,
    floatingAlignment: dt(P)
  };
}
r(pt, "measureElement");
function bt(e, { margin: t, width: o, height: i, top: n, left: l, bottom: a, right: s }) {
  let f = i + t.bottom + t.top;
  e.fillStyle = M.margin, e.fillRect(l, n - t.top, o, t.top), e.fillRect(s, n - t.top, t.right, f), e.fillRect(l, a, o, t.bottom), e.fillRect(
  l - t.left, n - t.top, t.left, f);
  let c = [
    {
      type: "margin",
      text: L(t.top),
      position: "top"
    },
    {
      type: "margin",
      text: L(t.right),
      position: "right"
    },
    {
      type: "margin",
      text: L(t.bottom),
      position: "bottom"
    },
    {
      type: "margin",
      text: L(t.left),
      position: "left"
    }
  ];
  return k(c);
}
r(bt, "drawMargin");
function gt(e, { padding: t, border: o, width: i, height: n, top: l, left: a, bottom: s, right: f }) {
  let c = i - o.left - o.right, u = n - t.top - t.bottom - o.top - o.bottom;
  e.fillStyle = M.padding, e.fillRect(a + o.left, l + o.top, c, t.top), e.fillRect(
    f - t.right - o.right,
    l + t.top + o.top,
    t.right,
    u
  ), e.fillRect(
    a + o.left,
    s - t.bottom - o.bottom,
    c,
    t.bottom
  ), e.fillRect(a + o.left, l + t.top + o.top, t.left, u);
  let d = [
    {
      type: "padding",
      text: t.top,
      position: "top"
    },
    {
      type: "padding",
      text: t.right,
      position: "right"
    },
    {
      type: "padding",
      text: t.bottom,
      position: "bottom"
    },
    {
      type: "padding",
      text: t.left,
      position: "left"
    }
  ];
  return k(d);
}
r(gt, "drawPadding");
function wt(e, { border: t, width: o, height: i, top: n, left: l, bottom: a, right: s }) {
  let f = i - t.top - t.bottom;
  e.fillStyle = M.border, e.fillRect(l, n, o, t.top), e.fillRect(l, a - t.bottom, o, t.bottom), e.fillRect(l, n + t.top, t.left, f), e.fillRect(
  s - t.right, n + t.top, t.right, f);
  let c = [
    {
      type: "border",
      text: t.top,
      position: "top"
    },
    {
      type: "border",
      text: t.right,
      position: "right"
    },
    {
      type: "border",
      text: t.bottom,
      position: "bottom"
    },
    {
      type: "border",
      text: t.left,
      position: "left"
    }
  ];
  return k(c);
}
r(wt, "drawBorder");
function Lt(e, { padding: t, border: o, width: i, height: n, top: l, left: a }) {
  let s = i - o.left - o.right - t.left - t.right, f = n - t.top - t.bottom - o.top - o.bottom;
  return e.fillStyle = M.content, e.fillRect(
    a + o.left + t.left,
    l + o.top + t.top,
    s,
    f
  ), [
    {
      type: "content",
      position: "center",
      text: `${L(s)} x ${L(f)}`
    }
  ];
}
r(Lt, "drawContent");
function Et(e) {
  return (t) => {
    if (e && t) {
      let o = pt(e), i = bt(t, o), n = gt(t, o), l = wt(t, o), a = Lt(t, o), s = o.width <= I * 3 || o.height <= I;
      O(
        t,
        o,
        [...a, ...n, ...l, ...i],
        s
      );
    }
  };
}
r(Et, "drawBoxModel");
function _(e) {
  Y(Et(e));
}
r(_, "drawSelectedElement");

// src/measure/util.ts
import { global as yt } from "@storybook/global";
var q = /* @__PURE__ */ r((e, t) => {
  let o = yt.document.elementFromPoint(e, t), i = /* @__PURE__ */ r((l) => {
    if (l && l.shadowRoot) {
      let a = l.shadowRoot.elementFromPoint(e, t);
      return l.isEqualNode(a) ? l : a.shadowRoot ? i(a) : a;
    }
    return l;
  }, "crawlShadows");
  return i(o) || o;
}, "deepElementFromPoint");

// src/measure/withMeasure.ts
var G, x = { x: 0, y: 0 };
function U(e, t) {
  G = q(e, t), _(G);
}
r(U, "findAndDrawElement");
var V = /* @__PURE__ */ r((e, t) => {
  let { measureEnabled: o } = t.globals || {};
  return j(() => {
    if (typeof globalThis.document > "u")
      return;
    let i = /* @__PURE__ */ r((n) => {
      window.requestAnimationFrame(() => {
        n.stopPropagation(), x.x = n.clientX, x.y = n.clientY;
      });
    }, "onPointerMove");
    return globalThis.document.addEventListener("pointermove", i), () => {
      globalThis.document.removeEventListener("pointermove", i);
    };
  }, []), j(() => {
    let i = /* @__PURE__ */ r((l) => {
      window.requestAnimationFrame(() => {
        l.stopPropagation(), U(l.clientX, l.clientY);
      });
    }, "onPointerOver"), n = /* @__PURE__ */ r(() => {
      window.requestAnimationFrame(() => {
        B();
      });
    }, "onResize");
    return t.viewMode === "story" && o && (globalThis.document.addEventListener("pointerover", i), F(), globalThis.window.addEventListener("\
resize", n), U(x.x, x.y)), () => {
      globalThis.window.removeEventListener("resize", n), z();
    };
  }, [o, t.viewMode]), e();
}, "withMeasure");

// src/measure/preview.ts
var Ct = globalThis.FEATURES?.measure ? [V] : [], vt = {
  [A]: !1
}, te = /* @__PURE__ */ r(() => St({
  decorators: Ct,
  initialGlobals: vt
}), "default");
export {
  Ct as decorators,
  te as default,
  vt as initialGlobals
};
