import { Application, Definition } from '@hotwired/stimulus';

type ImportedModules = ReturnType<ImportMeta['glob']>;

declare const CONTROLLER_FILENAME_REGEX: RegExp;
declare function registerControllers(application: Application, controllerModules: ImportedModules): void;
declare function definitionsFromGlob(controllerModules: ImportedModules): Definition[];
declare function identifierForGlobKey(key: string): string | undefined;

export { CONTROLLER_FILENAME_REGEX, definitionsFromGlob, identifierForGlobKey, registerControllers };
