"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  CONTROLLER_FILENAME_REGEX: () => CONTROLLER_FILENAME_REGEX,
  definitionsFromGlob: () => definitionsFromGlob,
  identifierForGlobKey: () => identifierForGlobKey,
  registerControllers: () => registerControllers
});
module.exports = __toCommonJS(src_exports);
var CONTROLLER_FILENAME_REGEX = /^(?:.*?(?:controllers|components)\/|\.?\.\/)?(.+)(?:[/_-]controller\..+?)$/;
function registerControllers(application, controllerModules) {
  application.load(definitionsFromGlob(controllerModules));
}
function definitionsFromGlob(controllerModules) {
  return Object.entries(controllerModules).map(definitionFromEntry).filter((value) => value);
}
function definitionFromEntry([name, controllerModule]) {
  var _a;
  const identifier = identifierForGlobKey(name);
  const controllerConstructor = (_a = controllerModule.default) != null ? _a : controllerModule;
  if (identifier && typeof controllerConstructor === "function")
    return { identifier, controllerConstructor };
}
function identifierForGlobKey(key) {
  const logicalName = (key.match(CONTROLLER_FILENAME_REGEX) || [])[1];
  if (logicalName)
    return logicalName.replace(/_/g, "-").replace(/\//g, "--");
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CONTROLLER_FILENAME_REGEX,
  definitionsFromGlob,
  identifierForGlobKey,
  registerControllers
});
