// This file is auto-updated by ../bootstrap-tests.js

import React from 'react';
import { Sparklines, SparklinesBars, SparklinesLine, SparklinesCurve,  SparklinesNormalBand, SparklinesReferenceLine, SparklinesSpots } from '../src/Sparklines';
import { sampleData, sampleData100 } from './sampleData';

export default {
// AUTO-GENERATED PART STARTS HERE
	"Header": {jsx: (<Sparklines data={sampleData} height={50} margin={2} width={300}><SparklinesLine style={{fill: 'none', stroke: 'white'}} /><SparklinesReferenceLine style={{stroke: 'white', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="mean" /></Sparklines>), svg: "<svg width=\"300\" height=\"50\" viewbox=\"0 0 300 50\"><g><polyline points=\"2 26.066887020955583 12.206896551724139 45.54652927110727 22.413793103448278 33.90636931938852 32.62068965517241 29.177549752086648 42.827586206896555 29.70109352684341 53.0344827586207 18.925334070012052 63.24137931034483 29.183773465122954 73.44827586206897 28.764398923777502 83.65517241379311 40.544557819288656 93.86206896551725 46.193633191864905 104.0689655172414 21.703120571572512 114.27586206896552 40.61831611300432 124.48275862068967 13.98423022262012 134.6896551724138 48 144.89655172413794 32.86055861856278 155.1034482758621 30.010522516938543 165.31034482758622 24.96935553482233 175.51724137931035 2 185.7241379310345 30.93720854362344 195.93103448275863 19.786564180834066 206.1379310344828 10.399459049869085 216.34482758620692 18.567297273634907 226.55172413793105 36.15784561748332 236.7586206896552 16.643282623666856 246.96551724137933 14.17303219422537 257.1724137931035 26.858302516540814 267.3793103448276 15.483001054391034 277.58620689655174 38.10432333408586 287.7931034482759 35.43208580179642 298 31.607765704956066 298 48 2 48 2 26.066887020955583\" style=\"stroke:white;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 26.066887020955583 12.206896551724139 45.54652927110727 22.413793103448278 33.90636931938852 32.62068965517241 29.177549752086648 42.827586206896555 29.70109352684341 53.0344827586207 18.925334070012052 63.24137931034483 29.183773465122954 73.44827586206897 28.764398923777502 83.65517241379311 40.544557819288656 93.86206896551725 46.193633191864905 104.0689655172414 21.703120571572512 114.27586206896552 40.61831611300432 124.48275862068967 13.98423022262012 134.6896551724138 48 144.89655172413794 32.86055861856278 155.1034482758621 30.010522516938543 165.31034482758622 24.96935553482233 175.51724137931035 2 185.7241379310345 30.93720854362344 195.93103448275863 19.786564180834066 206.1379310344828 10.399459049869085 216.34482758620692 18.567297273634907 226.55172413793105 36.15784561748332 236.7586206896552 16.643282623666856 246.96551724137933 14.17303219422537 257.1724137931035 26.858302516540814 267.3793103448276 15.483001054391034 277.58620689655174 38.10432333408586 287.7931034482759 35.43208580179642 298 31.607765704956066\" style=\"stroke:white;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"25\" x2=\"298\" y2=\"25\" style=\"stroke:white;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"Simple": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"SimpleCurve": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesCurve style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><path d=\"M2 31.298818982032884 C 4.0344827586206895 31.298818982032884 8.103448275862068 55.01316606917407 10.137931034482758 55.01316606917407 C 12.172413793103448 55.01316606917407 16.241379310344826 40.842536562733855 18.275862068965516 40.842536562733855 C 20.310344827586206 40.842536562733855 24.379310344827584 35.085712741670704 26.413793103448274 35.085712741670704 C 28.448275862068964 35.085712741670704 32.51724137931034 35.72307038050503 34.55172413793103 35.72307038050503 C 36.58620689655172 35.72307038050503 40.6551724137931 22.604754520014673 42.689655172413794 22.604754520014673 C 44.724137931034484 22.604754520014673 48.79310344827586 35.09328943580186 50.82758620689655 35.09328943580186 C 52.86206896551724 35.09328943580186 56.93103448275861 34.582746515903054 58.9655172413793 34.582746515903054 C 60.99999999999999 34.582746515903054 65.06896551724137 48.92380951913402 67.10344827586206 48.92380951913402 C 69.13793103448276 48.92380951913402 73.20689655172413 55.80094475531381 75.24137931034483 55.80094475531381 C 77.27586206896552 55.80094475531381 81.34482758620689 25.98640765234915 83.37931034482759 25.98640765234915 C 85.41379310344827 25.98640765234915 89.48275862068965 49.013602224527006 91.51724137931033 49.013602224527006 C 93.55172413793102 49.013602224527006 97.62068965517241 16.58949766232015 99.6551724137931 16.58949766232015 C 101.68965517241378 16.58949766232015 105.75862068965517 58 107.79310344827586 58 C 109.82758620689654 58 113.89655172413792 39.56937570955469 115.9310344827586 39.56937570955469 C 117.9655172413793 39.56937570955469 122.03448275862067 36.09976654235997 124.06896551724137 36.09976654235997 C 126.10344827586206 36.09976654235997 130.17241379310343 29.96269369456632 132.20689655172413 29.96269369456632 C 134.24137931034483 29.96269369456632 138.3103448275862 2 140.3448275862069 2 C 142.3793103448276 2 146.44827586206895 37.2279060531068 148.48275862068965 37.2279060531068 C 150.51724137931035 37.2279060531068 154.58620689655172 23.65320856797191 156.6206896551724 23.65320856797191 C 158.6551724137931 23.65320856797191 162.72413793103448 12.225428408536278 164.75862068965517 12.225428408536278 C 166.79310344827587 12.225428408536278 170.8620689655172 22.168883637468582 172.8965517241379 22.168883637468582 C 174.9310344827586 22.168883637468582 178.99999999999997 43.5834642299797 181.03448275862067 43.5834642299797 C 183.06896551724137 43.5834642299797 187.13793103448273 19.82660493315965 189.17241379310343 19.82660493315965 C 191.20689655172413 19.82660493315965 195.2758620689655 16.819343540796105 197.3103448275862 16.819343540796105 C 199.3448275862069 16.819343540796105 203.41379310344826 32.262281324484476 205.44827586206895 32.262281324484476 C 207.48275862068965 32.262281324484476 211.55172413793102 18.414088240128216 213.58620689655172 18.414088240128216 C 215.6206896551724 18.414088240128216 219.68965517241378 45.95308927627845 221.72413793103448 45.95308927627845 C 223.75862068965517 45.95308927627845 227.8275862068965 42.699930541317386 229.8620689655172 42.699930541317386 C 231.8965517241379 42.699930541317386 235.96551724137927 38.0442365103813 237.99999999999997 38.0442365103813 L237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><path d=\"M2 31.298818982032884 C 4.0344827586206895 31.298818982032884 8.103448275862068 55.01316606917407 10.137931034482758 55.01316606917407 C 12.172413793103448 55.01316606917407 16.241379310344826 40.842536562733855 18.275862068965516 40.842536562733855 C 20.310344827586206 40.842536562733855 24.379310344827584 35.085712741670704 26.413793103448274 35.085712741670704 C 28.448275862068964 35.085712741670704 32.51724137931034 35.72307038050503 34.55172413793103 35.72307038050503 C 36.58620689655172 35.72307038050503 40.6551724137931 22.604754520014673 42.689655172413794 22.604754520014673 C 44.724137931034484 22.604754520014673 48.79310344827586 35.09328943580186 50.82758620689655 35.09328943580186 C 52.86206896551724 35.09328943580186 56.93103448275861 34.582746515903054 58.9655172413793 34.582746515903054 C 60.99999999999999 34.582746515903054 65.06896551724137 48.92380951913402 67.10344827586206 48.92380951913402 C 69.13793103448276 48.92380951913402 73.20689655172413 55.80094475531381 75.24137931034483 55.80094475531381 C 77.27586206896552 55.80094475531381 81.34482758620689 25.98640765234915 83.37931034482759 25.98640765234915 C 85.41379310344827 25.98640765234915 89.48275862068965 49.013602224527006 91.51724137931033 49.013602224527006 C 93.55172413793102 49.013602224527006 97.62068965517241 16.58949766232015 99.6551724137931 16.58949766232015 C 101.68965517241378 16.58949766232015 105.75862068965517 58 107.79310344827586 58 C 109.82758620689654 58 113.89655172413792 39.56937570955469 115.9310344827586 39.56937570955469 C 117.9655172413793 39.56937570955469 122.03448275862067 36.09976654235997 124.06896551724137 36.09976654235997 C 126.10344827586206 36.09976654235997 130.17241379310343 29.96269369456632 132.20689655172413 29.96269369456632 C 134.24137931034483 29.96269369456632 138.3103448275862 2 140.3448275862069 2 C 142.3793103448276 2 146.44827586206895 37.2279060531068 148.48275862068965 37.2279060531068 C 150.51724137931035 37.2279060531068 154.58620689655172 23.65320856797191 156.6206896551724 23.65320856797191 C 158.6551724137931 23.65320856797191 162.72413793103448 12.225428408536278 164.75862068965517 12.225428408536278 C 166.79310344827587 12.225428408536278 170.8620689655172 22.168883637468582 172.8965517241379 22.168883637468582 C 174.9310344827586 22.168883637468582 178.99999999999997 43.5834642299797 181.03448275862067 43.5834642299797 C 183.06896551724137 43.5834642299797 187.13793103448273 19.82660493315965 189.17241379310343 19.82660493315965 C 191.20689655172413 19.82660493315965 195.2758620689655 16.819343540796105 197.3103448275862 16.819343540796105 C 199.3448275862069 16.819343540796105 203.41379310344826 32.262281324484476 205.44827586206895 32.262281324484476 C 207.48275862068965 32.262281324484476 211.55172413793102 18.414088240128216 213.58620689655172 18.414088240128216 C 215.6206896551724 18.414088240128216 219.68965517241378 45.95308927627845 221.72413793103448 45.95308927627845 C 223.75862068965517 45.95308927627845 227.8275862068965 42.699930541317386 229.8620689655172 42.699930541317386 C 231.8965517241379 42.699930541317386 235.96551724137927 38.0442365103813 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#1c8cdc" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#1c8cdc;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#1c8cdc;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable2": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#fa7e17" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#fa7e17;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#fa7e17;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable3": {jsx: (<Sparklines data={sampleData} height={61} margin={2} width={240}><SparklinesLine color="#ea485c" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"61\" viewbox=\"0 0 240 61\"><g><polyline points=\"2 31.822012178140614 10.137931034482758 55.959829748980745 18.275862068965516 41.53615328706839 26.413793103448274 35.676529040629106 34.55172413793103 36.325268065871185 42.689655172413794 22.972696565014935 50.82758620689655 35.68424103286975 58.9655172413793 35.1645812751156 67.10344827586206 49.761734689118555 75.24137931034483 56.76167591165869 83.37931034482759 26.41473636042681 91.51724137931033 49.85313083567927 99.6551724137931 16.85002440629015 107.79310344827586 59 115.9310344827586 40.240257418653876 124.06896551724137 36.70869094490211 132.20689655172413 30.462027510540715 140.3448275862069 2 148.48275862068965 37.85697580405513 156.6206896551724 24.039873006685696 164.75862068965517 12.408025344402997 172.8965517241379 22.52904227385195 181.03448275862067 44.32602609122933 189.17241379310343 20.144937164108928 197.3103448275862 17.083974675453177 205.44827586206895 32.802679205278835 213.58620689655172 18.707196958701935 221.72413793103448 46.7379658704977 229.8620689655172 43.42671501526948 237.99999999999997 38.687883590923825 237.99999999999997 59 2 59 2 31.822012178140614\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#ea485c;\"/><polyline points=\"2 31.822012178140614 10.137931034482758 55.959829748980745 18.275862068965516 41.53615328706839 26.413793103448274 35.676529040629106 34.55172413793103 36.325268065871185 42.689655172413794 22.972696565014935 50.82758620689655 35.68424103286975 58.9655172413793 35.1645812751156 67.10344827586206 49.761734689118555 75.24137931034483 56.76167591165869 83.37931034482759 26.41473636042681 91.51724137931033 49.85313083567927 99.6551724137931 16.85002440629015 107.79310344827586 59 115.9310344827586 40.240257418653876 124.06896551724137 36.70869094490211 132.20689655172413 30.462027510540715 140.3448275862069 2 148.48275862068965 37.85697580405513 156.6206896551724 24.039873006685696 164.75862068965517 12.408025344402997 172.8965517241379 22.52904227385195 181.03448275862067 44.32602609122933 189.17241379310343 20.144937164108928 197.3103448275862 17.083974675453177 205.44827586206895 32.802679205278835 213.58620689655172 18.707196958701935 221.72413793103448 46.7379658704977 229.8620689655172 43.42671501526948 237.99999999999997 38.687883590923825\" style=\"stroke:#ea485c;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable4": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#56b45d" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#56b45d;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#56b45d;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable5": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#8e44af" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#8e44af;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#8e44af;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Customizable6": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#253e56" style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#253e56;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#253e56;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Bounds1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} max={0.5} width={240}><SparklinesLine style={{}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 7.670103552396827 10.137931034482758 52.37002272133571 18.275862068965516 25.659357182737544 26.413793103448274 14.808138782089328 34.55172413793103 16.009514254621237 42.689655172413794 -8.717612174024529 50.82758620689655 14.822420331312934 58.9655172413793 13.860081913649916 67.10344827586206 40.89200291427838 75.24137931034483 53.85493156002574 83.37931034482759 -2.343427756579426 91.51724137931033 41.06125601065409 99.6551724137931 -20.055959138894096 107.79310344827586 58 115.9310344827586 23.25953622131521 124.06896551724137 16.719560705585764 132.20689655172413 5.151598947152368 140.3448275862069 -47.55616244724296 148.48275862068965 18.846026374506227 156.6206896551724 -6.741348141798753 164.75862068965517 -28.281930622526744 172.8965517241379 -9.539198918382716 181.03448275862067 30.825818005950843 189.17241379310343 -13.954233764967562 197.3103448275862 -19.622715408782717 205.44827586206895 9.486164044032915 213.58620689655172 -16.616730934772352 221.72413793103448 35.29239883320382 229.8620689655172 29.160417549378508 237.99999999999997 20.38475334519728 237.99999999999997 58 2 58 2 7.670103552396827\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 7.670103552396827 10.137931034482758 52.37002272133571 18.275862068965516 25.659357182737544 26.413793103448274 14.808138782089328 34.55172413793103 16.009514254621237 42.689655172413794 -8.717612174024529 50.82758620689655 14.822420331312934 58.9655172413793 13.860081913649916 67.10344827586206 40.89200291427838 75.24137931034483 53.85493156002574 83.37931034482759 -2.343427756579426 91.51724137931033 41.06125601065409 99.6551724137931 -20.055959138894096 107.79310344827586 58 115.9310344827586 23.25953622131521 124.06896551724137 16.719560705585764 132.20689655172413 5.151598947152368 140.3448275862069 -47.55616244724296 148.48275862068965 18.846026374506227 156.6206896551724 -6.741348141798753 164.75862068965517 -28.281930622526744 172.8965517241379 -9.539198918382716 181.03448275862067 30.825818005950843 189.17241379310343 -13.954233764967562 197.3103448275862 -19.622715408782717 205.44827586206895 9.486164044032915 213.58620689655172 -16.616730934772352 221.72413793103448 35.29239883320382 229.8620689655172 29.160417549378508 237.99999999999997 20.38475334519728\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"Spots1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{fill: 'none'}} /><SparklinesSpots size={2} spotColors={{'0': 'black', '1': 'green', '-1': 'red'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><g><circle cx=\"237.99999999999997\" cy=\"38.0442365103813\" r=\"2\" style=\"fill:green;\"/></g></svg>"},
	"Spots2": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine color="#56b45d" style={{}} /><SparklinesSpots size={2} spotColors={{'0': 'black', '1': 'green', '-1': 'red'}} style={{fill: '#56b45d'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:#56b45d;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#56b45d;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><g><circle cx=\"2\" cy=\"31.298818982032884\" r=\"2\" style=\"fill:#56b45d;\"/><circle cx=\"237.99999999999997\" cy=\"38.0442365103813\" r=\"2\" style=\"fill:#56b45d;\"/></g></svg>"},
	"Spots3": {jsx: (<Sparklines data={sampleData} height={60} margin={6} width={240}><SparklinesLine style={{fill: 'none', stroke: '#336aff', strokeWidth: 3}} /><SparklinesSpots size={4} spotColors={{'0': 'black', '1': 'green', '-1': 'red'}} style={{fill: 'white', stroke: '#336aff', strokeWidth: 3}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"6 31.113273413171044 13.862068965517242 51.43985663072063 21.724137931034484 39.29360276805759 29.586206896551722 34.359182350003465 37.44827586206897 34.90548889757574 45.310344827586206 23.661218160012577 53.172413793103445 34.36567665925874 61.03448275862069 33.928068442202616 68.89655172413794 46.22040815925773 76.75862068965517 52.11509550455469 84.62068965517241 26.55977798772784 92.48275862068965 46.29737333530886 100.34482758620689 18.505283710560125 108.20689655172413 54 116.06896551724138 38.20232203676116 123.93103448275862 35.22837132202283 131.79310344827587 29.96802316677113 139.6551724137931 6 147.51724137931035 36.19534804552012 155.3793103448276 24.559893058261636 163.24137931034483 14.764652921602524 171.10344827586206 23.28761454640164 178.9655172413793 41.6429693399826 186.82758620689654 21.279947085565414 194.68965517241378 18.702294463539516 202.55172413793102 31.93909827812955 210.41379310344826 20.06921849153847 218.27586206896552 43.67407652252439 226.13793103448276 40.88565474970061 234 36.895059866041116 234 54 6 54 6 31.113273413171044\" style=\"stroke:#336aff;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"6 31.113273413171044 13.862068965517242 51.43985663072063 21.724137931034484 39.29360276805759 29.586206896551722 34.359182350003465 37.44827586206897 34.90548889757574 45.310344827586206 23.661218160012577 53.172413793103445 34.36567665925874 61.03448275862069 33.928068442202616 68.89655172413794 46.22040815925773 76.75862068965517 52.11509550455469 84.62068965517241 26.55977798772784 92.48275862068965 46.29737333530886 100.34482758620689 18.505283710560125 108.20689655172413 54 116.06896551724138 38.20232203676116 123.93103448275862 35.22837132202283 131.79310344827587 29.96802316677113 139.6551724137931 6 147.51724137931035 36.19534804552012 155.3793103448276 24.559893058261636 163.24137931034483 14.764652921602524 171.10344827586206 23.28761454640164 178.9655172413793 41.6429693399826 186.82758620689654 21.279947085565414 194.68965517241378 18.702294463539516 202.55172413793102 31.93909827812955 210.41379310344826 20.06921849153847 218.27586206896552 43.67407652252439 226.13793103448276 40.88565474970061 234 36.895059866041116\" style=\"stroke:#336aff;stroke-width:3;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><g><circle cx=\"6\" cy=\"31.113273413171044\" r=\"4\" style=\"fill:white;stroke:#336aff;stroke-width:3;\"/><circle cx=\"234\" cy=\"36.895059866041116\" r=\"4\" style=\"fill:white;stroke:#336aff;stroke-width:3;\"/></g></svg>"},
	"Bars1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesBars style={{fill: '#41c3f9'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><rect x=\"2\" y=\"32\" width=\"9\" height=\"29\" style=\"fill:#41c3f9;\"/><rect x=\"11\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:#41c3f9;\"/><rect x=\"19\" y=\"41\" width=\"9\" height=\"20\" style=\"fill:#41c3f9;\"/><rect x=\"27\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;\"/><rect x=\"35\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;\"/><rect x=\"43\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:#41c3f9;\"/><rect x=\"51\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;\"/><rect x=\"59\" y=\"35\" width=\"9\" height=\"26\" style=\"fill:#41c3f9;\"/><rect x=\"68\" y=\"49\" width=\"9\" height=\"12\" style=\"fill:#41c3f9;\"/><rect x=\"76\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:#41c3f9;\"/><rect x=\"84\" y=\"26\" width=\"9\" height=\"35\" style=\"fill:#41c3f9;\"/><rect x=\"92\" y=\"50\" width=\"9\" height=\"11\" style=\"fill:#41c3f9;\"/><rect x=\"100\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:#41c3f9;\"/><rect x=\"108\" y=\"58\" width=\"9\" height=\"2\" style=\"fill:#41c3f9;\"/><rect x=\"116\" y=\"40\" width=\"9\" height=\"21\" style=\"fill:#41c3f9;\"/><rect x=\"125\" y=\"37\" width=\"9\" height=\"24\" style=\"fill:#41c3f9;\"/><rect x=\"133\" y=\"30\" width=\"9\" height=\"31\" style=\"fill:#41c3f9;\"/><rect x=\"141\" y=\"2\" width=\"9\" height=\"58\" style=\"fill:#41c3f9;\"/><rect x=\"149\" y=\"38\" width=\"9\" height=\"23\" style=\"fill:#41c3f9;\"/><rect x=\"157\" y=\"24\" width=\"9\" height=\"37\" style=\"fill:#41c3f9;\"/><rect x=\"165\" y=\"13\" width=\"9\" height=\"48\" style=\"fill:#41c3f9;\"/><rect x=\"173\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:#41c3f9;\"/><rect x=\"182\" y=\"44\" width=\"9\" height=\"17\" style=\"fill:#41c3f9;\"/><rect x=\"190\" y=\"20\" width=\"9\" height=\"41\" style=\"fill:#41c3f9;\"/><rect x=\"198\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:#41c3f9;\"/><rect x=\"206\" y=\"33\" width=\"9\" height=\"28\" style=\"fill:#41c3f9;\"/><rect x=\"214\" y=\"19\" width=\"9\" height=\"42\" style=\"fill:#41c3f9;\"/><rect x=\"222\" y=\"46\" width=\"9\" height=\"15\" style=\"fill:#41c3f9;\"/><rect x=\"230\" y=\"43\" width=\"9\" height=\"18\" style=\"fill:#41c3f9;\"/><rect x=\"238\" y=\"39\" width=\"9\" height=\"22\" style=\"fill:#41c3f9;\"/></g></svg>"},
	"Bars2": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesBars style={{fill: '#41c3f9', fillOpacity: '.25', stroke: 'white'}} /><SparklinesLine style={{fill: 'none', stroke: '#41c3f9'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><rect x=\"2\" y=\"32\" width=\"9\" height=\"29\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"11\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"19\" y=\"41\" width=\"9\" height=\"20\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"27\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"35\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"43\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"51\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"59\" y=\"35\" width=\"9\" height=\"26\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"68\" y=\"49\" width=\"9\" height=\"12\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"76\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"84\" y=\"26\" width=\"9\" height=\"35\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"92\" y=\"50\" width=\"9\" height=\"11\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"100\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"108\" y=\"58\" width=\"9\" height=\"2\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"116\" y=\"40\" width=\"9\" height=\"21\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"125\" y=\"37\" width=\"9\" height=\"24\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"133\" y=\"30\" width=\"9\" height=\"31\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"141\" y=\"2\" width=\"9\" height=\"58\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"149\" y=\"38\" width=\"9\" height=\"23\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"157\" y=\"24\" width=\"9\" height=\"37\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"165\" y=\"13\" width=\"9\" height=\"48\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"173\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"182\" y=\"44\" width=\"9\" height=\"17\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"190\" y=\"20\" width=\"9\" height=\"41\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"198\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"206\" y=\"33\" width=\"9\" height=\"28\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"214\" y=\"19\" width=\"9\" height=\"42\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"222\" y=\"46\" width=\"9\" height=\"15\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"230\" y=\"43\" width=\"9\" height=\"18\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/><rect x=\"238\" y=\"39\" width=\"9\" height=\"22\" style=\"fill:#41c3f9;fill-opacity:.25;stroke:white;\"/></g><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:#41c3f9;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#41c3f9;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"ReferenceLine1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="max" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"60\" x2=\"237.99999999999997\" y2=\"60\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"ReferenceLine2": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="min" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"4\" x2=\"237.99999999999997\" y2=\"4\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"ReferenceLine3": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="mean" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"30\" x2=\"237.99999999999997\" y2=\"30\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"ReferenceLine4": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="avg" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"35.502288607718995\" x2=\"237.99999999999997\" y2=\"35.502288607718995\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"ReferenceLine5": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="median" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:slategray;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"2\" y1=\"37.09328943580186\" x2=\"237.99999999999997\" y2=\"37.09328943580186\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"ReferenceLine6": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesBars style={{fill: 'slategray', fillOpacity: '.5'}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="mean" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><rect x=\"2\" y=\"32\" width=\"9\" height=\"29\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"11\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"19\" y=\"41\" width=\"9\" height=\"20\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"27\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"35\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"43\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"51\" y=\"36\" width=\"9\" height=\"25\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"59\" y=\"35\" width=\"9\" height=\"26\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"68\" y=\"49\" width=\"9\" height=\"12\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"76\" y=\"56\" width=\"9\" height=\"5\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"84\" y=\"26\" width=\"9\" height=\"35\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"92\" y=\"50\" width=\"9\" height=\"11\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"100\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"108\" y=\"58\" width=\"9\" height=\"2\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"116\" y=\"40\" width=\"9\" height=\"21\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"125\" y=\"37\" width=\"9\" height=\"24\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"133\" y=\"30\" width=\"9\" height=\"31\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"141\" y=\"2\" width=\"9\" height=\"58\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"149\" y=\"38\" width=\"9\" height=\"23\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"157\" y=\"24\" width=\"9\" height=\"37\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"165\" y=\"13\" width=\"9\" height=\"48\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"173\" y=\"23\" width=\"9\" height=\"38\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"182\" y=\"44\" width=\"9\" height=\"17\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"190\" y=\"20\" width=\"9\" height=\"41\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"198\" y=\"17\" width=\"9\" height=\"44\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"206\" y=\"33\" width=\"9\" height=\"28\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"214\" y=\"19\" width=\"9\" height=\"42\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"222\" y=\"46\" width=\"9\" height=\"15\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"230\" y=\"43\" width=\"9\" height=\"18\" style=\"fill:slategray;fill-opacity:.5;\"/><rect x=\"238\" y=\"39\" width=\"9\" height=\"22\" style=\"fill:slategray;fill-opacity:.5;\"/></g><line x1=\"2\" y1=\"30\" x2=\"237.99999999999997\" y2=\"30\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"NormalBand1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{fill: 'none'}} /><SparklinesNormalBand style={{fill: 'red', fillOpacity: 0.1}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><rect x=\"2\" y=\"15.537572257915796\" width=\"235.99999999999997\" height=\"28.924855484168408\" style=\"fill:red;fill-opacity:0.1;\"/></svg>"},
	"NormalBand2": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{fill: 'none'}} /><SparklinesNormalBand style={{fill: 'red', fillOpacity: 0.1}} /><SparklinesReferenceLine style={{stroke: 'red', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="mean" /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:none;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:slategray;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><rect x=\"2\" y=\"15.537572257915796\" width=\"235.99999999999997\" height=\"28.924855484168408\" style=\"fill:red;fill-opacity:0.1;\"/><line x1=\"2\" y1=\"30\" x2=\"237.99999999999997\" y2=\"30\" style=\"stroke:red;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
	"RealWorld1": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesLine style={{fill: 'none', stroke: '#336aff', strokeWidth: 3}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813 237.99999999999997 58 2 58 2 31.298818982032884\" style=\"stroke:#336aff;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 31.298818982032884 10.137931034482758 55.01316606917407 18.275862068965516 40.842536562733855 26.413793103448274 35.085712741670704 34.55172413793103 35.72307038050503 42.689655172413794 22.604754520014673 50.82758620689655 35.09328943580186 58.9655172413793 34.582746515903054 67.10344827586206 48.92380951913402 75.24137931034483 55.80094475531381 83.37931034482759 25.98640765234915 91.51724137931033 49.013602224527006 99.6551724137931 16.58949766232015 107.79310344827586 58 115.9310344827586 39.56937570955469 124.06896551724137 36.09976654235997 132.20689655172413 29.96269369456632 140.3448275862069 2 148.48275862068965 37.2279060531068 156.6206896551724 23.65320856797191 164.75862068965517 12.225428408536278 172.8965517241379 22.168883637468582 181.03448275862067 43.5834642299797 189.17241379310343 19.82660493315965 197.3103448275862 16.819343540796105 205.44827586206895 32.262281324484476 213.58620689655172 18.414088240128216 221.72413793103448 45.95308927627845 229.8620689655172 42.699930541317386 237.99999999999997 38.0442365103813\" style=\"stroke:#336aff;stroke-width:3;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"RealWorld2": {jsx: (<Sparklines data={sampleData100} height={60} margin={2} width={200}><SparklinesLine style={{fill: 'none', stroke: '#2991c8'}} /><SparklinesSpots size={2} spotColors={{'0': 'black', '1': 'green', '-1': 'red'}} /><SparklinesNormalBand style={{fill: '#2991c8', fillOpacity: 0.1}} /></Sparklines>), svg: "<svg width=\"200\" height=\"60\" viewbox=\"0 0 200 60\"><g><polyline points=\"2 28.699169913196723 3.97979797979798 18.746892936298458 5.95959595959596 19.360363549601256 7.9393939393939394 30.942358615790692 9.91919191919192 27.591132781250213 11.8989898989899 21.88244635727191 13.878787878787879 2.2716470413641217 15.85858585858586 44.111635466963286 17.83838383838384 3.2392984148533266 19.81818181818182 21.312565202895534 21.7979797979798 30.062400796861898 23.77777777777778 13.537375547655664 25.757575757575758 49.24484231527506 27.737373737373737 22.48858782535742 29.71717171717172 28.800973561581834 31.6969696969697 32.692831983598424 33.67676767676768 26.76323370600337 35.65656565656566 21.04742626901525 37.63636363636364 8.908148712918885 39.61616161616162 39.42307267642152 41.5959595959596 14.153400514054887 43.57575757575758 14.144702285039587 45.55555555555556 41.45470153711412 47.535353535353536 23.533189884931215 49.515151515151516 27.715293492970268 51.494949494949495 41.70513637186207 53.474747474747474 29.411721832122044 55.45454545454546 17.62358784089425 57.43434343434344 32.48390724607359 59.41414141414142 13.531005353390151 61.3939393939394 10.218042392856221 63.37373737373738 36.28660959742038 65.35353535353536 37.844453271865795 67.33333333333334 36.51503609547178 69.31313131313132 22.937682542519745 71.2929292929293 22.567381607926563 73.27272727272728 22.71411320154566 75.25252525252526 2 77.23232323232324 20.487621577906445 79.21212121212122 7.986210626656898 81.1919191919192 43.061937149131296 83.17171717171718 33.999085136323544 85.15151515151516 20.969016617883042 87.13131313131314 29.929990618273386 89.11111111111111 39.278543592155756 91.0909090909091 23.38805292163325 93.07070707070707 42.80252242249484 95.05050505050505 15.585534273942795 97.03030303030303 39.599323143860154 99.01010101010101 33.691745712013685 100.98989898989899 26.331575733579037 102.96969696969697 3.0228512208252734 104.94949494949495 23.016391232788045 106.92929292929293 24.865822463434533 108.90909090909092 32.67248342992299 110.8888888888889 34.670391141823934 112.86868686868688 40.14362702027685 114.84848484848486 4.679008029655258 116.82828282828284 28.723458308473166 118.80808080808082 10.158595469341476 120.7878787878788 26.825606281831906 122.76767676767678 52.94019819187331 124.74747474747475 17.95226440373869 126.72727272727273 5.9547382471651655 128.70707070707073 36.825105794528945 130.6868686868687 26.665000451223552 132.66666666666669 21.952951545240513 134.64646464646466 29.471548928099068 136.62626262626264 20.251832625499166 138.60606060606062 15.580978413243034 140.5858585858586 2.1212161788152923 142.56565656565658 9.851473603001866 144.54545454545456 28.580661894354176 146.52525252525254 18.76085629542151 148.50505050505052 32.15998920013431 150.4848484848485 36.65153413647405 152.46464646464648 22.161706059025654 154.44444444444446 32.441178872961345 156.42424242424244 46.89206470261126 158.40404040404042 17.61289853610026 160.3838383838384 28.33563388469292 162.36363636363637 26.82937553981752 164.34343434343435 13.798612100526448 166.32323232323233 14.49965939137122 168.3030303030303 32.701361828132725 170.2828282828283 23.704916621261074 172.26262626262627 23.96314088374288 174.24242424242425 33.25406896916259 176.22222222222223 18.639075909683598 178.2020202020202 29.37596848130279 180.1818181818182 26.516267657250477 182.16161616161617 29.865091114827834 184.14141414141415 40.58037071398917 186.12121212121212 17.433733829691164 188.1010101010101 57.99999999999999 190.08080808080808 40.78634337580227 192.06060606060606 26.50123154323286 194.04040404040404 19.80587881060026 196.02020202020202 50.520499511476984 198 2.5117288917517246 198 58 2 58 2 28.699169913196723\" style=\"stroke:#2991c8;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 28.699169913196723 3.97979797979798 18.746892936298458 5.95959595959596 19.360363549601256 7.9393939393939394 30.942358615790692 9.91919191919192 27.591132781250213 11.8989898989899 21.88244635727191 13.878787878787879 2.2716470413641217 15.85858585858586 44.111635466963286 17.83838383838384 3.2392984148533266 19.81818181818182 21.312565202895534 21.7979797979798 30.062400796861898 23.77777777777778 13.537375547655664 25.757575757575758 49.24484231527506 27.737373737373737 22.48858782535742 29.71717171717172 28.800973561581834 31.6969696969697 32.692831983598424 33.67676767676768 26.76323370600337 35.65656565656566 21.04742626901525 37.63636363636364 8.908148712918885 39.61616161616162 39.42307267642152 41.5959595959596 14.153400514054887 43.57575757575758 14.144702285039587 45.55555555555556 41.45470153711412 47.535353535353536 23.533189884931215 49.515151515151516 27.715293492970268 51.494949494949495 41.70513637186207 53.474747474747474 29.411721832122044 55.45454545454546 17.62358784089425 57.43434343434344 32.48390724607359 59.41414141414142 13.531005353390151 61.3939393939394 10.218042392856221 63.37373737373738 36.28660959742038 65.35353535353536 37.844453271865795 67.33333333333334 36.51503609547178 69.31313131313132 22.937682542519745 71.2929292929293 22.567381607926563 73.27272727272728 22.71411320154566 75.25252525252526 2 77.23232323232324 20.487621577906445 79.21212121212122 7.986210626656898 81.1919191919192 43.061937149131296 83.17171717171718 33.999085136323544 85.15151515151516 20.969016617883042 87.13131313131314 29.929990618273386 89.11111111111111 39.278543592155756 91.0909090909091 23.38805292163325 93.07070707070707 42.80252242249484 95.05050505050505 15.585534273942795 97.03030303030303 39.599323143860154 99.01010101010101 33.691745712013685 100.98989898989899 26.331575733579037 102.96969696969697 3.0228512208252734 104.94949494949495 23.016391232788045 106.92929292929293 24.865822463434533 108.90909090909092 32.67248342992299 110.8888888888889 34.670391141823934 112.86868686868688 40.14362702027685 114.84848484848486 4.679008029655258 116.82828282828284 28.723458308473166 118.80808080808082 10.158595469341476 120.7878787878788 26.825606281831906 122.76767676767678 52.94019819187331 124.74747474747475 17.95226440373869 126.72727272727273 5.9547382471651655 128.70707070707073 36.825105794528945 130.6868686868687 26.665000451223552 132.66666666666669 21.952951545240513 134.64646464646466 29.471548928099068 136.62626262626264 20.251832625499166 138.60606060606062 15.580978413243034 140.5858585858586 2.1212161788152923 142.56565656565658 9.851473603001866 144.54545454545456 28.580661894354176 146.52525252525254 18.76085629542151 148.50505050505052 32.15998920013431 150.4848484848485 36.65153413647405 152.46464646464648 22.161706059025654 154.44444444444446 32.441178872961345 156.42424242424244 46.89206470261126 158.40404040404042 17.61289853610026 160.3838383838384 28.33563388469292 162.36363636363637 26.82937553981752 164.34343434343435 13.798612100526448 166.32323232323233 14.49965939137122 168.3030303030303 32.701361828132725 170.2828282828283 23.704916621261074 172.26262626262627 23.96314088374288 174.24242424242425 33.25406896916259 176.22222222222223 18.639075909683598 178.2020202020202 29.37596848130279 180.1818181818182 26.516267657250477 182.16161616161617 29.865091114827834 184.14141414141415 40.58037071398917 186.12121212121212 17.433733829691164 188.1010101010101 57.99999999999999 190.08080808080808 40.78634337580227 192.06060606060606 26.50123154323286 194.04040404040404 19.80587881060026 196.02020202020202 50.520499511476984 198 2.5117288917517246\" style=\"stroke:#2991c8;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><g><circle cx=\"198\" cy=\"2.5117288917517246\" r=\"2\" style=\"fill:green;\"/></g><rect x=\"2\" y=\"17.737546692035906\" width=\"196\" height=\"24.52490661592818\" style=\"fill:#2991c8;fill-opacity:0.1;\"/></svg>"},
	"RealWorld3": {jsx: (<Sparklines data={sampleData100} height={60} margin={2} width={240}><SparklinesLine style={{fill: 'none', stroke: 'black'}} /><SparklinesSpots size={2} spotColors={{'0': 'black', '1': 'green', '-1': 'red'}} style={{fill: 'orange'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><polyline points=\"2 28.699169913196723 4.383838383838384 18.746892936298458 6.767676767676767 19.360363549601256 9.15151515151515 30.942358615790692 11.535353535353535 27.591132781250213 13.919191919191919 21.88244635727191 16.3030303030303 2.2716470413641217 18.686868686868685 44.111635466963286 21.07070707070707 3.2392984148533266 23.454545454545453 21.312565202895534 25.838383838383837 30.062400796861898 28.22222222222222 13.537375547655664 30.606060606060602 49.24484231527506 32.98989898989899 22.48858782535742 35.37373737373737 28.800973561581834 37.75757575757576 32.692831983598424 40.14141414141414 26.76323370600337 42.52525252525252 21.04742626901525 44.90909090909091 8.908148712918885 47.29292929292929 39.42307267642152 49.676767676767675 14.153400514054887 52.060606060606055 14.144702285039587 54.44444444444444 41.45470153711412 56.82828282828282 23.533189884931215 59.212121212121204 27.715293492970268 61.59595959595959 41.70513637186207 63.97979797979797 29.411721832122044 66.36363636363636 17.62358784089425 68.74747474747474 32.48390724607359 71.13131313131312 13.531005353390151 73.51515151515152 10.218042392856221 75.8989898989899 36.28660959742038 78.28282828282828 37.844453271865795 80.66666666666666 36.51503609547178 83.05050505050504 22.937682542519745 85.43434343434343 22.567381607926563 87.81818181818181 22.71411320154566 90.2020202020202 2 92.58585858585857 20.487621577906445 94.96969696969697 7.986210626656898 97.35353535353535 43.061937149131296 99.73737373737373 33.999085136323544 102.12121212121211 20.969016617883042 104.50505050505049 29.929990618273386 106.88888888888889 39.278543592155756 109.27272727272727 23.38805292163325 111.65656565656565 42.80252242249484 114.04040404040403 15.585534273942795 116.42424242424241 39.599323143860154 118.8080808080808 33.691745712013685 121.19191919191918 26.331575733579037 123.57575757575756 3.0228512208252734 125.95959595959594 23.016391232788045 128.34343434343435 24.865822463434533 130.72727272727272 32.67248342992299 133.11111111111111 34.670391141823934 135.49494949494948 40.14362702027685 137.87878787878788 4.679008029655258 140.26262626262624 28.723458308473166 142.64646464646464 10.158595469341476 145.03030303030303 26.825606281831906 147.4141414141414 52.94019819187331 149.7979797979798 17.95226440373869 152.18181818181816 5.9547382471651655 154.56565656565655 36.825105794528945 156.94949494949495 26.665000451223552 159.33333333333331 21.952951545240513 161.7171717171717 29.471548928099068 164.10101010101008 20.251832625499166 166.48484848484847 15.580978413243034 168.86868686868686 2.1212161788152923 171.25252525252523 9.851473603001866 173.63636363636363 28.580661894354176 176.020202020202 18.76085629542151 178.4040404040404 32.15998920013431 180.78787878787878 36.65153413647405 183.17171717171715 22.161706059025654 185.55555555555554 32.441178872961345 187.93939393939394 46.89206470261126 190.3232323232323 17.61289853610026 192.7070707070707 28.33563388469292 195.09090909090907 26.82937553981752 197.47474747474746 13.798612100526448 199.85858585858585 14.49965939137122 202.24242424242422 32.701361828132725 204.62626262626262 23.704916621261074 207.01010101010098 23.96314088374288 209.39393939393938 33.25406896916259 211.77777777777777 18.639075909683598 214.16161616161614 29.37596848130279 216.54545454545453 26.516267657250477 218.9292929292929 29.865091114827834 221.3131313131313 40.58037071398917 223.6969696969697 17.433733829691164 226.08080808080805 57.99999999999999 228.46464646464645 40.78634337580227 230.84848484848482 26.50123154323286 233.2323232323232 19.80587881060026 235.6161616161616 50.520499511476984 237.99999999999997 2.5117288917517246 237.99999999999997 58 2 58 2 28.699169913196723\" style=\"stroke:black;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 28.699169913196723 4.383838383838384 18.746892936298458 6.767676767676767 19.360363549601256 9.15151515151515 30.942358615790692 11.535353535353535 27.591132781250213 13.919191919191919 21.88244635727191 16.3030303030303 2.2716470413641217 18.686868686868685 44.111635466963286 21.07070707070707 3.2392984148533266 23.454545454545453 21.312565202895534 25.838383838383837 30.062400796861898 28.22222222222222 13.537375547655664 30.606060606060602 49.24484231527506 32.98989898989899 22.48858782535742 35.37373737373737 28.800973561581834 37.75757575757576 32.692831983598424 40.14141414141414 26.76323370600337 42.52525252525252 21.04742626901525 44.90909090909091 8.908148712918885 47.29292929292929 39.42307267642152 49.676767676767675 14.153400514054887 52.060606060606055 14.144702285039587 54.44444444444444 41.45470153711412 56.82828282828282 23.533189884931215 59.212121212121204 27.715293492970268 61.59595959595959 41.70513637186207 63.97979797979797 29.411721832122044 66.36363636363636 17.62358784089425 68.74747474747474 32.48390724607359 71.13131313131312 13.531005353390151 73.51515151515152 10.218042392856221 75.8989898989899 36.28660959742038 78.28282828282828 37.844453271865795 80.66666666666666 36.51503609547178 83.05050505050504 22.937682542519745 85.43434343434343 22.567381607926563 87.81818181818181 22.71411320154566 90.2020202020202 2 92.58585858585857 20.487621577906445 94.96969696969697 7.986210626656898 97.35353535353535 43.061937149131296 99.73737373737373 33.999085136323544 102.12121212121211 20.969016617883042 104.50505050505049 29.929990618273386 106.88888888888889 39.278543592155756 109.27272727272727 23.38805292163325 111.65656565656565 42.80252242249484 114.04040404040403 15.585534273942795 116.42424242424241 39.599323143860154 118.8080808080808 33.691745712013685 121.19191919191918 26.331575733579037 123.57575757575756 3.0228512208252734 125.95959595959594 23.016391232788045 128.34343434343435 24.865822463434533 130.72727272727272 32.67248342992299 133.11111111111111 34.670391141823934 135.49494949494948 40.14362702027685 137.87878787878788 4.679008029655258 140.26262626262624 28.723458308473166 142.64646464646464 10.158595469341476 145.03030303030303 26.825606281831906 147.4141414141414 52.94019819187331 149.7979797979798 17.95226440373869 152.18181818181816 5.9547382471651655 154.56565656565655 36.825105794528945 156.94949494949495 26.665000451223552 159.33333333333331 21.952951545240513 161.7171717171717 29.471548928099068 164.10101010101008 20.251832625499166 166.48484848484847 15.580978413243034 168.86868686868686 2.1212161788152923 171.25252525252523 9.851473603001866 173.63636363636363 28.580661894354176 176.020202020202 18.76085629542151 178.4040404040404 32.15998920013431 180.78787878787878 36.65153413647405 183.17171717171715 22.161706059025654 185.55555555555554 32.441178872961345 187.93939393939394 46.89206470261126 190.3232323232323 17.61289853610026 192.7070707070707 28.33563388469292 195.09090909090907 26.82937553981752 197.47474747474746 13.798612100526448 199.85858585858585 14.49965939137122 202.24242424242422 32.701361828132725 204.62626262626262 23.704916621261074 207.01010101010098 23.96314088374288 209.39393939393938 33.25406896916259 211.77777777777777 18.639075909683598 214.16161616161614 29.37596848130279 216.54545454545453 26.516267657250477 218.9292929292929 29.865091114827834 221.3131313131313 40.58037071398917 223.6969696969697 17.433733829691164 226.08080808080805 57.99999999999999 228.46464646464645 40.78634337580227 230.84848484848482 26.50123154323286 233.2323232323232 19.80587881060026 235.6161616161616 50.520499511476984 237.99999999999997 2.5117288917517246\" style=\"stroke:black;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><g><circle cx=\"2\" cy=\"28.699169913196723\" r=\"2\" style=\"fill:orange;\"/><circle cx=\"237.99999999999997\" cy=\"2.5117288917517246\" r=\"2\" style=\"fill:orange;\"/></g></svg>"},
	"RealWorld4": {jsx: (<Sparklines data={sampleData} height={60} margin={2} width={240}><SparklinesBars style={{fill: '#40c0f5', stroke: 'white', strokeWidth: '1'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"60\" viewbox=\"0 0 240 60\"><g><rect x=\"2\" y=\"32\" width=\"8\" height=\"29\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"10\" y=\"56\" width=\"8\" height=\"5\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"17\" y=\"41\" width=\"8\" height=\"20\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"24\" y=\"36\" width=\"8\" height=\"25\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"31\" y=\"36\" width=\"8\" height=\"25\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"38\" y=\"23\" width=\"8\" height=\"38\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"45\" y=\"36\" width=\"8\" height=\"25\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"52\" y=\"35\" width=\"8\" height=\"26\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"60\" y=\"49\" width=\"8\" height=\"12\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"67\" y=\"56\" width=\"8\" height=\"5\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"74\" y=\"26\" width=\"8\" height=\"35\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"81\" y=\"50\" width=\"8\" height=\"11\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"88\" y=\"17\" width=\"8\" height=\"44\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"95\" y=\"58\" width=\"8\" height=\"2\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"102\" y=\"40\" width=\"8\" height=\"21\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"110\" y=\"37\" width=\"8\" height=\"24\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"117\" y=\"30\" width=\"8\" height=\"31\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"124\" y=\"2\" width=\"8\" height=\"58\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"131\" y=\"38\" width=\"8\" height=\"23\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"138\" y=\"24\" width=\"8\" height=\"37\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"145\" y=\"13\" width=\"8\" height=\"48\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"152\" y=\"23\" width=\"8\" height=\"38\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"160\" y=\"44\" width=\"8\" height=\"17\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"167\" y=\"20\" width=\"8\" height=\"41\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"174\" y=\"17\" width=\"8\" height=\"44\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"181\" y=\"33\" width=\"8\" height=\"28\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"188\" y=\"19\" width=\"8\" height=\"42\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"195\" y=\"46\" width=\"8\" height=\"15\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"202\" y=\"43\" width=\"8\" height=\"18\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/><rect x=\"209\" y=\"39\" width=\"8\" height=\"22\" style=\"fill:#40c0f5;stroke:white;stroke-width:1;\"/></g></svg>"},
	"RealWorld5": {jsx: (<Sparklines data={sampleData} height={80} margin={2} width={240}><SparklinesLine style={{fill: 'none', stroke: '#8ed53f', strokeWidth: '1'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"80\" viewbox=\"0 0 240 80\"><g><polyline points=\"2 41.762682904187486 10.137931034482758 73.94643966530765 18.275862068965516 54.71487104942451 26.413793103448274 46.90203872083881 34.55172413793103 47.76702408782825 42.689655172413794 29.96359542001991 50.82758620689655 46.912321377159664 58.9655172413793 46.219441700154135 67.10344827586206 65.68231291882473 75.24137931034483 75.01556788221158 83.37931034482759 34.55298181390241 91.51724137931033 65.80417444757236 99.6551724137931 21.800032541720196 107.79310344827586 78 115.9310344827586 52.9870098915385 124.06896551724137 48.27825459320281 132.20689655172413 39.94937001405429 140.3448275862069 2 148.48275862068965 49.80930107207351 156.6206896551724 31.38649734224759 164.75862068965517 15.877367125870661 172.8965517241379 29.372056365135933 181.03448275862067 58.43470145497244 189.17241379310343 26.193249552145236 197.3103448275862 22.111966233937565 205.44827586206895 43.07023894037178 213.58620689655172 24.27626261160258 221.72413793103448 61.650621160663604 229.8620689655172 57.2356200203593 237.99999999999997 50.91717812123176 237.99999999999997 78 2 78 2 41.762682904187486\" style=\"stroke:#8ed53f;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 41.762682904187486 10.137931034482758 73.94643966530765 18.275862068965516 54.71487104942451 26.413793103448274 46.90203872083881 34.55172413793103 47.76702408782825 42.689655172413794 29.96359542001991 50.82758620689655 46.912321377159664 58.9655172413793 46.219441700154135 67.10344827586206 65.68231291882473 75.24137931034483 75.01556788221158 83.37931034482759 34.55298181390241 91.51724137931033 65.80417444757236 99.6551724137931 21.800032541720196 107.79310344827586 78 115.9310344827586 52.9870098915385 124.06896551724137 48.27825459320281 132.20689655172413 39.94937001405429 140.3448275862069 2 148.48275862068965 49.80930107207351 156.6206896551724 31.38649734224759 164.75862068965517 15.877367125870661 172.8965517241379 29.372056365135933 181.03448275862067 58.43470145497244 189.17241379310343 26.193249552145236 197.3103448275862 22.111966233937565 205.44827586206895 43.07023894037178 213.58620689655172 24.27626261160258 221.72413793103448 61.650621160663604 229.8620689655172 57.2356200203593 237.99999999999997 50.91717812123176\" style=\"stroke:#8ed53f;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"RealWorld6": {jsx: (<Sparklines data={sampleData} height={80} margin={2} width={240}><SparklinesLine style={{fill: 'none', stroke: '#d1192e', strokeWidth: '1'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"80\" viewbox=\"0 0 240 80\"><g><polyline points=\"2 41.762682904187486 10.137931034482758 73.94643966530765 18.275862068965516 54.71487104942451 26.413793103448274 46.90203872083881 34.55172413793103 47.76702408782825 42.689655172413794 29.96359542001991 50.82758620689655 46.912321377159664 58.9655172413793 46.219441700154135 67.10344827586206 65.68231291882473 75.24137931034483 75.01556788221158 83.37931034482759 34.55298181390241 91.51724137931033 65.80417444757236 99.6551724137931 21.800032541720196 107.79310344827586 78 115.9310344827586 52.9870098915385 124.06896551724137 48.27825459320281 132.20689655172413 39.94937001405429 140.3448275862069 2 148.48275862068965 49.80930107207351 156.6206896551724 31.38649734224759 164.75862068965517 15.877367125870661 172.8965517241379 29.372056365135933 181.03448275862067 58.43470145497244 189.17241379310343 26.193249552145236 197.3103448275862 22.111966233937565 205.44827586206895 43.07023894037178 213.58620689655172 24.27626261160258 221.72413793103448 61.650621160663604 229.8620689655172 57.2356200203593 237.99999999999997 50.91717812123176 237.99999999999997 78 2 78 2 41.762682904187486\" style=\"stroke:#d1192e;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"2 41.762682904187486 10.137931034482758 73.94643966530765 18.275862068965516 54.71487104942451 26.413793103448274 46.90203872083881 34.55172413793103 47.76702408782825 42.689655172413794 29.96359542001991 50.82758620689655 46.912321377159664 58.9655172413793 46.219441700154135 67.10344827586206 65.68231291882473 75.24137931034483 75.01556788221158 83.37931034482759 34.55298181390241 91.51724137931033 65.80417444757236 99.6551724137931 21.800032541720196 107.79310344827586 78 115.9310344827586 52.9870098915385 124.06896551724137 48.27825459320281 132.20689655172413 39.94937001405429 140.3448275862069 2 148.48275862068965 49.80930107207351 156.6206896551724 31.38649734224759 164.75862068965517 15.877367125870661 172.8965517241379 29.372056365135933 181.03448275862067 58.43470145497244 189.17241379310343 26.193249552145236 197.3103448275862 22.111966233937565 205.44827586206895 43.07023894037178 213.58620689655172 24.27626261160258 221.72413793103448 61.650621160663604 229.8620689655172 57.2356200203593 237.99999999999997 50.91717812123176\" style=\"stroke:#d1192e;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"RealWorld7": {jsx: (<Sparklines data={sampleData} height={40} margin={2} width={240}><SparklinesLine style={{fill: '#8fc638', fillOpacity: '1', stroke: '#559500'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"40\" viewbox=\"0 0 240 40\"><g><polyline points=\"2 20.834955059878283 10.137931034482758 36.07989247304047 18.275862068965516 26.970202076043194 26.413793103448274 23.269386762502595 34.55172413793103 23.679116673181802 42.689655172413794 15.245913620009434 50.82758620689655 23.27425749444405 58.9655172413793 22.94605133165196 67.10344827586206 32.1653061194433 75.24137931034483 36.586321628416016 83.37931034482759 17.41983349079588 91.51724137931033 32.223030001481646 99.6551724137931 11.378962782920095 107.79310344827586 38 115.9310344827586 26.15174152757087 124.06896551724137 23.921278491517125 132.20689655172413 19.976017375078346 140.3448275862069 2 148.48275862068965 24.646511034140087 156.6206896551724 15.919919793696229 164.75862068965517 8.573489691201893 172.8965517241379 14.965710909801231 181.03448275862067 28.73222700498695 189.17241379310343 13.459960314174062 197.3103448275862 11.526720847654637 205.44827586206895 21.454323708597162 213.58620689655172 12.551913868653854 221.72413793103448 30.255557391893287 229.8620689655172 28.16424106227546 237.99999999999997 25.171294899530835 237.99999999999997 38 2 38 2 20.834955059878283\" style=\"stroke:#559500;stroke-width:0;fill-opacity:1;fill:#8fc638;\"/><polyline points=\"2 20.834955059878283 10.137931034482758 36.07989247304047 18.275862068965516 26.970202076043194 26.413793103448274 23.269386762502595 34.55172413793103 23.679116673181802 42.689655172413794 15.245913620009434 50.82758620689655 23.27425749444405 58.9655172413793 22.94605133165196 67.10344827586206 32.1653061194433 75.24137931034483 36.586321628416016 83.37931034482759 17.41983349079588 91.51724137931033 32.223030001481646 99.6551724137931 11.378962782920095 107.79310344827586 38 115.9310344827586 26.15174152757087 124.06896551724137 23.921278491517125 132.20689655172413 19.976017375078346 140.3448275862069 2 148.48275862068965 24.646511034140087 156.6206896551724 15.919919793696229 164.75862068965517 8.573489691201893 172.8965517241379 14.965710909801231 181.03448275862067 28.73222700498695 189.17241379310343 13.459960314174062 197.3103448275862 11.526720847654637 205.44827586206895 21.454323708597162 213.58620689655172 12.551913868653854 221.72413793103448 30.255557391893287 229.8620689655172 28.16424106227546 237.99999999999997 25.171294899530835\" style=\"stroke:#559500;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"RealWorld8": {jsx: (<Sparklines data={sampleData} height={40} margin={10} style={{background: '#272727'}} width={240}><SparklinesLine style={{fill: '#d2673a', fillOpacity: '.5', stroke: 'none'}} /></Sparklines>), svg: "<svg width=\"240\" height=\"40\" style=\"background:#272727;\" viewbox=\"0 0 240 40\"><g><polyline points=\"10 20.4638639221546 17.586206896551722 28.933273596133596 25.17241379310345 23.87233448669066 32.758620689655174 21.81632597916811 40.3448275862069 22.043953707323226 47.93103448275862 17.35884090000524 55.51724137931035 21.819031941357807 63.10344827586207 21.63669518425109 70.6896551724138 26.75850339969072 78.27586206896552 29.214623126897788 85.86206896551724 18.56657416155327 93.44827586206897 26.79057222304536 101.0344827586207 15.210534879400052 108.62068965517241 30 116.20689655172414 23.417634181983818 123.79310344827586 22.178488050842844 131.3793103448276 19.98667631948797 138.9655172413793 10 146.55172413793105 22.581395018966717 154.13793103448276 17.73328877427568 161.72413793103448 13.651938717334385 169.31034482758622 17.20317272766735 176.89655172413794 24.85123722499275 184.48275862068965 16.36664461898559 192.0689655172414 15.292622693141464 199.6551724137931 20.80795761588731 207.24137931034483 15.862174371474364 214.82758620689654 25.69753188438516 222.41379310344828 24.535689479041924 230 22.872941610850464 230 30 10 30 10 20.4638639221546\" style=\"stroke:none;stroke-width:0;fill-opacity:.5;fill:#d2673a;\"/><polyline points=\"10 20.4638639221546 17.586206896551722 28.933273596133596 25.17241379310345 23.87233448669066 32.758620689655174 21.81632597916811 40.3448275862069 22.043953707323226 47.93103448275862 17.35884090000524 55.51724137931035 21.819031941357807 63.10344827586207 21.63669518425109 70.6896551724138 26.75850339969072 78.27586206896552 29.214623126897788 85.86206896551724 18.56657416155327 93.44827586206897 26.79057222304536 101.0344827586207 15.210534879400052 108.62068965517241 30 116.20689655172414 23.417634181983818 123.79310344827586 22.178488050842844 131.3793103448276 19.98667631948797 138.9655172413793 10 146.55172413793105 22.581395018966717 154.13793103448276 17.73328877427568 161.72413793103448 13.651938717334385 169.31034482758622 17.20317272766735 176.89655172413794 24.85123722499275 184.48275862068965 16.36664461898559 192.0689655172414 15.292622693141464 199.6551724137931 20.80795761588731 207.24137931034483 15.862174371474364 214.82758620689654 25.69753188438516 222.41379310344828 24.535689479041924 230 22.872941610850464\" style=\"stroke:none;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g></svg>"},
	"RealWorld9": {jsx: (<Sparklines data={sampleData} height={40} margin={10} style={{background: '#00bdcc'}} width={240}><SparklinesLine style={{fill: 'none', stroke: 'white'}} /><SparklinesReferenceLine style={{stroke: 'white', strokeDasharray: '2, 2', strokeOpacity: 0.75}} type="mean" /></Sparklines>), svg: "<svg width=\"240\" height=\"40\" style=\"background:#00bdcc;\" viewbox=\"0 0 240 40\"><g><polyline points=\"10 20.4638639221546 17.586206896551722 28.933273596133596 25.17241379310345 23.87233448669066 32.758620689655174 21.81632597916811 40.3448275862069 22.043953707323226 47.93103448275862 17.35884090000524 55.51724137931035 21.819031941357807 63.10344827586207 21.63669518425109 70.6896551724138 26.75850339969072 78.27586206896552 29.214623126897788 85.86206896551724 18.56657416155327 93.44827586206897 26.79057222304536 101.0344827586207 15.210534879400052 108.62068965517241 30 116.20689655172414 23.417634181983818 123.79310344827586 22.178488050842844 131.3793103448276 19.98667631948797 138.9655172413793 10 146.55172413793105 22.581395018966717 154.13793103448276 17.73328877427568 161.72413793103448 13.651938717334385 169.31034482758622 17.20317272766735 176.89655172413794 24.85123722499275 184.48275862068965 16.36664461898559 192.0689655172414 15.292622693141464 199.6551724137931 20.80795761588731 207.24137931034483 15.862174371474364 214.82758620689654 25.69753188438516 222.41379310344828 24.535689479041924 230 22.872941610850464 230 30 10 30 10 20.4638639221546\" style=\"stroke:white;stroke-width:0;fill-opacity:.1;fill:none;\"/><polyline points=\"10 20.4638639221546 17.586206896551722 28.933273596133596 25.17241379310345 23.87233448669066 32.758620689655174 21.81632597916811 40.3448275862069 22.043953707323226 47.93103448275862 17.35884090000524 55.51724137931035 21.819031941357807 63.10344827586207 21.63669518425109 70.6896551724138 26.75850339969072 78.27586206896552 29.214623126897788 85.86206896551724 18.56657416155327 93.44827586206897 26.79057222304536 101.0344827586207 15.210534879400052 108.62068965517241 30 116.20689655172414 23.417634181983818 123.79310344827586 22.178488050842844 131.3793103448276 19.98667631948797 138.9655172413793 10 146.55172413793105 22.581395018966717 154.13793103448276 17.73328877427568 161.72413793103448 13.651938717334385 169.31034482758622 17.20317272766735 176.89655172413794 24.85123722499275 184.48275862068965 16.36664461898559 192.0689655172414 15.292622693141464 199.6551724137931 20.80795761588731 207.24137931034483 15.862174371474364 214.82758620689654 25.69753188438516 222.41379310344828 24.535689479041924 230 22.872941610850464\" style=\"stroke:white;stroke-width:1;stroke-linejoin:round;stroke-linecap:round;fill:none;\"/></g><line x1=\"10\" y1=\"20\" x2=\"230\" y2=\"20\" style=\"stroke:white;stroke-dasharray:2, 2;stroke-opacity:0.75;\"/></svg>"},
// AUTO-GENERATED PART ENDS HERE
};
