import { createFormattedComponent, createFormattedDateTimePartsComponent, } from './src/components/createFormattedComponent';
import { createIntl } from './src/components/createIntl';
import FormattedDateTimeRange from './src/components/dateTimeRange';
import injectIntl, { Context as IntlContext, Provider as RawIntlProvider, } from './src/components/injectIntl';
import FormattedMessage from './src/components/message';
import FormattedPlural from './src/components/plural';
import IntlProvider from './src/components/provider';
import FormattedRelativeTime from './src/components/relative';
import useIntl from './src/components/useIntl';
export { createIntlCache, InvalidConfigError, MessageFormatError, MissingDataError, MissingTranslationError, IntlError as ReactIntlError, IntlErrorCode as ReactIntlErrorCode, UnsupportedFormatterError, } from '@formatjs/intl';
export { createIntl, FormattedDateTimeRange, FormattedMessage, FormattedPlural, FormattedRelativeTime, injectIntl, IntlContext, IntlProvider, RawIntlProvider, useIntl, };
export function defineMessages(msgs) {
    return msgs;
}
export function defineMessage(msg) {
    return msg;
}
// IMPORTANT: Explicit here to prevent api-extractor from outputing `import('./src/types').CustomFormatConfig`
export var FormattedDate = createFormattedComponent('formatDate');
export var FormattedTime = createFormattedComponent('formatTime');
export var FormattedNumber = createFormattedComponent('formatNumber');
export var FormattedList = createFormattedComponent('formatList');
export var FormattedDisplayName = createFormattedComponent('formatDisplayName');
export var FormattedDateParts = createFormattedDateTimePartsComponent('formatDate');
export var FormattedTimeParts = createFormattedDateTimePartsComponent('formatTime');
export { FormattedListParts, FormattedNumberParts, } from './src/components/createFormattedComponent';
