import { RequestHandler } from 'msw';
import { setupServer } from 'msw/node';

type SetupServer = ReturnType<typeof setupServer>;
type InitializeOptions = Parameters<SetupServer['listen']>[0];
declare function initialize(options?: InitializeOptions, initialHandlers?: RequestHandler[]): SetupServer;
declare function getWorker(): SetupServer;

type MswParameters = {
    [key: string]: any;
    msw?: RequestHandler[] | {
        handlers: RequestHandler[] | Record<string, RequestHandler | RequestHandler[]>;
    };
};
type Context = {
    parameters: MswParameters;
};
declare const mswDecorator: <Story extends (...args: any[]) => any>(storyFn: Story, context: Context) => any;

declare const mswLoader: (context: Context) => Promise<{}>;

declare function applyRequestHandlers(handlersListOrObject: Context['parameters']['msw']): void;

export { type Context, type InitializeOptions, type MswParameters, applyRequestHandlers, getWorker, initialize, mswDecorator, mswLoader };
