"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  applyRequestHandlers: () => applyRequestHandlers,
  getWorker: () => getWorker,
  initialize: () => initialize,
  mswDecorator: () => mswDecorator,
  mswLoader: () => mswLoader
});
module.exports = __toCommonJS(src_exports);

// src/initialize.node.ts
var import_node = require("msw/node");

// src/augmentInitializeOptions.ts
var fileExtensionPattern = /\.(js|jsx|ts|tsx|mjs|woff|woff2|ttf|otf|eot)$/;
var filteredURLSubstrings = [
  "sb-common-assets",
  "node_modules",
  "node-modules",
  "hot-update.json",
  "__webpack_hmr",
  "iframe.html",
  "sb-vite",
  "@vite",
  "@react-refresh",
  "/virtual:",
  ".stories.",
  ".mdx"
];
var shouldFilterUrl = (url) => {
  if (fileExtensionPattern.test(url)) {
    return true;
  }
  const isStorybookRequest = filteredURLSubstrings.some(
    (substring) => url.includes(substring)
  );
  if (isStorybookRequest) {
    return true;
  }
  return false;
};
var augmentInitializeOptions = (options) => {
  if (typeof options?.onUnhandledRequest === "string") {
    return options;
  }
  return {
    ...options,
    // Filter requests that we know are not relevant to the user e.g. HMR, builder requests, statics assets, etc.
    onUnhandledRequest: (...args) => {
      const [{ url }, print] = args;
      if (shouldFilterUrl(url)) {
        return;
      }
      if (!options?.onUnhandledRequest) {
        print.warning();
        return;
      }
      if (typeof options?.onUnhandledRequest === "function") {
        options.onUnhandledRequest(...args);
      }
    }
  };
};

// src/initialize.node.ts
var api;
function initialize(options, initialHandlers = []) {
  const server = (0, import_node.setupServer)(...initialHandlers);
  server.listen(augmentInitializeOptions(options));
  api = server;
  return server;
}
async function waitForMswReady() {
  getWorker();
}
function getWorker() {
  if (api === void 0) {
    throw new Error(
      `[MSW] Failed to retrieve the worker: no active worker found. Did you forget to call "initialize"?`
    );
  }
  return api;
}

// ../../node_modules/ts-dedent/esm/index.js
function dedent(templ) {
  var values = [];
  for (var _i = 1; _i < arguments.length; _i++) {
    values[_i - 1] = arguments[_i];
  }
  var strings = Array.from(typeof templ === "string" ? [templ] : templ);
  strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
  var indentLengths = strings.reduce(function(arr, str) {
    var matches = str.match(/\n([\t ]+|(?!\s).)/g);
    if (matches) {
      return arr.concat(matches.map(function(match) {
        var _a, _b;
        return (_b = (_a = match.match(/[\t ]/g)) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0;
      }));
    }
    return arr;
  }, []);
  if (indentLengths.length) {
    var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
    strings = strings.map(function(str) {
      return str.replace(pattern_1, "\n");
    });
  }
  strings[0] = strings[0].replace(/^\r?\n/, "");
  var string = strings[0];
  values.forEach(function(value, i) {
    var endentations = string.match(/(?:^|\n)( *)$/);
    var endentation = endentations ? endentations[1] : "";
    var indentedValue = value;
    if (typeof value === "string" && value.includes("\n")) {
      indentedValue = String(value).split("\n").map(function(str, i2) {
        return i2 === 0 ? str : "" + endentation + str;
      }).join("\n");
    }
    string += indentedValue + strings[i + 1];
  });
  return string;
}

// src/util.ts
function once(fn) {
  let called = false;
  let value;
  const wrapper = (...args) => {
    if (!called) {
      called = true;
      value = fn(...args);
    }
    return value;
  };
  return wrapper;
}
function deprecate(message) {
  return once(() => {
    console.warn(dedent(message));
  });
}

// src/applyRequestHandlers.ts
var deprecateMessage = deprecate(`
[msw-storybook-addon] You are using parameters.msw as an Array instead of an Object with a property "handlers". This usage is deprecated and will be removed in the next release. Please use the Object syntax instead.

More info: https://github.com/mswjs/msw-storybook-addon/blob/main/MIGRATION.md#parametersmsw-array-notation-deprecated-in-favor-of-object-notation
`);
function applyRequestHandlers(handlersListOrObject) {
  api?.resetHandlers();
  if (handlersListOrObject == null) {
    return;
  }
  if (Array.isArray(handlersListOrObject) && handlersListOrObject.length > 0) {
    deprecateMessage();
    api.use(...handlersListOrObject);
    return;
  }
  if ("handlers" in handlersListOrObject && handlersListOrObject.handlers) {
    const handlers = Object.values(handlersListOrObject.handlers).filter(Boolean).reduce(
      (handlers2, handlersList) => handlers2.concat(handlersList),
      []
    );
    if (handlers.length > 0) {
      api.use(...handlers);
    }
    return;
  }
}

// src/decorator.ts
var deprecateMessage2 = deprecate(`
[msw-storybook-addon] The mswDecorator is deprecated and will be removed in the next release. Please use the mswLoader instead.

More info: https://github.com/mswjs/msw-storybook-addon/blob/main/MIGRATION.md#mswdecorator-is-deprecated-in-favor-of-mswloader
`);
var mswDecorator = (storyFn, context) => {
  deprecateMessage2();
  applyRequestHandlers(context.parameters.msw);
  return storyFn();
};

// src/loader.ts
var mswLoader = async (context) => {
  await waitForMswReady();
  applyRequestHandlers(context.parameters.msw);
  return {};
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  applyRequestHandlers,
  getWorker,
  initialize,
  mswDecorator,
  mswLoader
});
