import { RequestHandler } from 'msw';
import { setupWorker } from 'msw/browser';

type SetupWorker = ReturnType<typeof setupWorker>;
type InitializeOptions = Parameters<SetupWorker['start']>[0];
declare function initialize(options?: InitializeOptions, initialHandlers?: RequestHandler[]): SetupWorker;
declare function getWorker(): SetupWorker;

type MswParameters = {
    [key: string]: any;
    msw?: RequestHandler[] | {
        handlers: RequestHandler[] | Record<string, RequestHandler | RequestHandler[]>;
    };
};
type Context = {
    parameters: MswParameters;
};
declare const mswDecorator: <Story extends (...args: any[]) => any>(storyFn: Story, context: Context) => any;

declare const mswLoader: (context: Context) => Promise<{}>;

declare function applyRequestHandlers(handlersListOrObject: Context['parameters']['msw']): void;

export { type Context, type InitializeOptions, type MswParameters, applyRequestHandlers, getWorker, initialize, mswDecorator, mswLoader };
