"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = void 0;
const context_compat_1 = require("../context-compat");
const util_1 = require("../util");
function isComment(token) {
    return !!token && (token.type === 'Block' || token.type === 'Line');
}
exports.name = 'no-id';
function checkNode(context, node) {
    const msgs = (0, util_1.extractMessages)(node, (0, util_1.getSettings)(context));
    for (const [{ idPropNode }] of msgs) {
        if (idPropNode) {
            context.report({
                node: idPropNode,
                messageId: 'noId',
                fix(fixer) {
                    const src = context.getSourceCode();
                    const token = src.getTokenAfter(idPropNode);
                    const fixes = [fixer.remove(idPropNode)];
                    if (token && !isComment(token) && token?.value === ',') {
                        fixes.push(fixer.remove(token));
                    }
                    return fixes;
                },
            });
        }
    }
}
exports.rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Ban explicit ID from MessageDescriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#no-id',
        },
        fixable: 'code',
        schema: [],
        messages: {
            noId: 'Manual `id` are not allowed in message descriptor',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = (0, context_compat_1.getParserServices)(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
