"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rule = exports.name = exports.Option = void 0;
const context_compat_1 = require("../context-compat");
const util_1 = require("../util");
var Option;
(function (Option) {
    Option["literal"] = "literal";
    Option["anything"] = "anything";
})(Option || (exports.Option = Option = {}));
exports.name = 'enforce-default-message';
function checkNode(context, node) {
    const msgs = (0, util_1.extractMessages)(node, (0, util_1.getSettings)(context));
    const { options: [type], } = context;
    for (const [{ message: { defaultMessage }, messageNode, },] of msgs) {
        if (!defaultMessage) {
            if (type === 'literal' && messageNode) {
                context.report({
                    node: messageNode,
                    messageId: 'defaultMessageLiteral',
                });
            }
            else if (!messageNode) {
                context.report({
                    node: node,
                    messageId: 'defaultMessage',
                });
            }
        }
    }
}
exports.rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Enforce defaultMessage in message descriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#enforce-default-message',
        },
        fixable: 'code',
        schema: [
            {
                type: 'string',
                enum: Object.keys(Option),
            },
        ],
        messages: {
            defaultMessageLiteral: `"defaultMessage" must be:
- a string literal or
- template literal without variable`,
            defaultMessage: '`defaultMessage` has to be specified in message descriptor',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = (0, context_compat_1.getParserServices)(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
