/**
 * Algorithms for separable blend modes (i.e. where the same algorithms is applied to each color channel)
 * @see https://www.w3.org/TR/compositing-1/#blendingseparable
 */
/**
 * Blend two color channels with the "normal" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function normal(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "multiply" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function multiply(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "screen" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function screen(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "overlay" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function overlay(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "darken" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function darken(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "lighten" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function lighten(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "color dodge" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function colorDodge(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "color burn" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function colorBurn(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "hard light" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function hardLight(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "soft light" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function softLight(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "difference" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function difference(backdrop: number, source: number): number;
/**
 * Blend two color channels with the "exclusion" blend mode
 *
 * @param backdrop The background color channel as an integer from 0 to 255
 * @param source   The foreground color channel as an integer from 0 to 255
 * @return The blended channel value
 */
export declare function exclusion(backdrop: number, source: number): number;
//# sourceMappingURL=separable-modes.d.ts.map