import { ChannelBlender, NoAlphaBlender, RGB, RGBA } from './types';
/**
 * Converts a color from unit color channels [0..1] to 8-bit color channels [0..255]
 * @param color The { r,g,b,a } color to convert
 * @return The { r,g,b,a } with 8-bit color channels
 */
export declare function convertFromUnit(color: RGBA): RGBA;
export declare function convertFromUnit(color: RGB): RGB;
/**
 * Converts a color from 8-bit color channels [0..255] to unit color channels [0..1]
 * @param color The { r,g,b,a } color to convert
 * @return The { r,g,b,a } with unit color channels
 */
export declare function convertToUnit(color: RGBA): RGBA;
export declare function convertToUnit(color: RGB): RGB;
export interface BlendOptions {
    unitInput: boolean;
    unitOutput: boolean;
    roundOutput: boolean;
}
/**
 * Blend two colors
 * All RGBA objects are { r,g,b,a } with [0..255] for RGB and [0..1] for alpha
 * @param source               The { r,g,b,a } color to be put on top
 * @param backdrop             The { r,g,b,a } color to be put below the source
 * @param abstractModeCallback The abstract blend mode function (separable vs. non-separable)
 * @param concreteModeCallback The concrete blend mode function (normal, multiply, ...)
 * @param options              The options to apply
 * @return The { r,g,b,a } result object, channel values are not rounded
 */
export declare function performBlend(backdrop: RGBA, source: RGBA, abstractModeCallback: (backdrop: RGBA, source: RGBA, concreteModeCallback: ChannelBlender) => RGB, concreteModeCallback: ChannelBlender, options?: Partial<BlendOptions>): RGBA;
export declare function performBlend(backdrop: RGBA, source: RGBA, abstractModeCallback: (backdrop: RGBA, source: RGBA, concreteModeCallback: NoAlphaBlender) => RGB, concreteModeCallback: NoAlphaBlender, options?: Partial<BlendOptions>): RGBA;
//# sourceMappingURL=helpers.d.ts.map