import { LDMLPluralRule, PluralRulesInternal } from '@formatjs/ecma402-abstract';
import Decimal from 'decimal.js';
import { OperandsRecord } from './GetOperands';
/**
 * http://ecma-international.org/ecma-402/7.0/index.html#sec-resolveplural
 * @param pl
 * @param n
 * @param PluralRuleSelect Has to pass in bc it's implementation-specific
 */
export declare function ResolvePlural(pl: Intl.PluralRules, n: Decimal, { getInternalSlots, PluralRuleSelect, }: {
    getInternalSlots(pl: Intl.PluralRules): PluralRulesInternal;
    PluralRuleSelect: (locale: string, type: 'cardinal' | 'ordinal', n: Decimal, operands: OperandsRecord) => LDMLPluralRule;
}): LDMLPluralRule;
