var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  default: () => StimulusHMRPlugin
});
var import_stimulus_vite_helpers = require("stimulus-vite-helpers");
var import_debug = __toESM(require("debug"), 1);
var debug = (0, import_debug.default)("stimulus:hmr");
function StimulusHMRPlugin({ appGlobal = "$$StimulusApp$$" } = {}) {
  return {
    name: "stimulus:hmr",
    apply: "serve",
    transform(code, id, options) {
      if ((options == null ? void 0 : options.ssr) && !process.env.VITEST || id.includes("node_modules"))
        return;
      const appRegex = /\n[^\n]*?\s(\w+)(?:\s*=\s*Application\.start\(\))/;
      const appVariable = (code.match(appRegex) || [])[1];
      if (appVariable) {
        debug("application", { appVariable, id });
        const exportFooter = `export const $$StimulusApp$$ = window.$$StimulusApp$$ = ${appVariable};`;
        return `${code}
${exportFooter}`;
      }
      const controllerId = (0, import_stimulus_vite_helpers.identifierForGlobKey)(id);
      if (!controllerId)
        return;
      debug("controller", { name: controllerId, id });
      const metaHotFooter = `
        if (import.meta.hot) {
          import.meta.hot.accept(newModule => {
            if (!window.${appGlobal}) {
              console.warn('Stimulus app not available. Are you creating the app? Falling back to page refresh.');
              import.meta.hot.invalidate();
            } else {
              window.${appGlobal}.register('${controllerId}', newModule.default);
            }
          })
        }
      `.replace(/(\n|\s\s)+/gm, "");
      return `${code}
${metaHotFooter}`;
    }
  };
}
module.exports = __toCommonJS(src_exports);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
