var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import PropTypes from 'prop-types';
import isEqual from 'lodash.isequal';

export default function HotKeyMapMixin() {
  var hotKeyMap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};


  return {

    contextTypes: {
      hotKeyMap: PropTypes.object
    },

    childContextTypes: {
      hotKeyMap: PropTypes.object
    },

    getChildContext: function getChildContext() {
      return {
        hotKeyMap: this.__hotKeyMap__
      };
    },
    componentWillMount: function componentWillMount() {
      this.updateMap();
    },
    updateMap: function updateMap() {
      var newMap = this.buildMap();

      if (!isEqual(newMap, this.__hotKeyMap__)) {
        this.__hotKeyMap__ = newMap;
        return true;
      }

      return false;
    },
    buildMap: function buildMap() {
      var parentMap = this.context.hotKeyMap || {};
      var thisMap = this.props.keyMap || {};

      return _extends({}, parentMap, hotKeyMap, thisMap);
    },
    getMap: function getMap() {
      return this.__hotKeyMap__;
    }
  };
}