import { getParserServices } from '../context-compat';
import { extractMessages, getSettings } from '../util';
function isComment(token) {
    return !!token && (token.type === 'Block' || token.type === 'Line');
}
export const name = 'no-id';
function checkNode(context, node) {
    const msgs = extractMessages(node, getSettings(context));
    for (const [{ idPropNode }] of msgs) {
        if (idPropNode) {
            context.report({
                node: idPropNode,
                messageId: 'noId',
                fix(fixer) {
                    const src = context.getSourceCode();
                    const token = src.getTokenAfter(idPropNode);
                    const fixes = [fixer.remove(idPropNode)];
                    if (token && !isComment(token) && token?.value === ',') {
                        fixes.push(fixer.remove(token));
                    }
                    return fixes;
                },
            });
        }
    }
}
export const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Ban explicit ID from MessageDescriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#no-id',
        },
        fixable: 'code',
        schema: [],
        messages: {
            noId: 'Manual `id` are not allowed in message descriptor',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = getParserServices(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
