import { getParserServices } from '../context-compat';
import { extractMessages, getSettings } from '../util';
export var Option;
(function (Option) {
    Option["literal"] = "literal";
    Option["anything"] = "anything";
})(Option || (Option = {}));
export const name = 'enforce-default-message';
function checkNode(context, node) {
    const msgs = extractMessages(node, getSettings(context));
    const { options: [type], } = context;
    for (const [{ message: { defaultMessage }, messageNode, },] of msgs) {
        if (!defaultMessage) {
            if (type === 'literal' && messageNode) {
                context.report({
                    node: messageNode,
                    messageId: 'defaultMessageLiteral',
                });
            }
            else if (!messageNode) {
                context.report({
                    node: node,
                    messageId: 'defaultMessage',
                });
            }
        }
    }
}
export const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Enforce defaultMessage in message descriptor',
            url: 'https://formatjs.github.io/docs/tooling/linter#enforce-default-message',
        },
        fixable: 'code',
        schema: [
            {
                type: 'string',
                enum: Object.keys(Option),
            },
        ],
        messages: {
            defaultMessageLiteral: `"defaultMessage" must be:
- a string literal or
- template literal without variable`,
            defaultMessage: '`defaultMessage` has to be specified in message descriptor',
        },
    },
    defaultOptions: [],
    create(context) {
        const callExpressionVisitor = (node) => checkNode(context, node);
        const parserServices = getParserServices(context);
        //@ts-expect-error defineTemplateBodyVisitor exists in Vue parser
        if (parserServices?.defineTemplateBodyVisitor) {
            //@ts-expect-error
            return parserServices.defineTemplateBodyVisitor({
                CallExpression: callExpressionVisitor,
            }, {
                CallExpression: callExpressionVisitor,
            });
        }
        return {
            JSXOpeningElement: (node) => checkNode(context, node),
            CallExpression: callExpressionVisitor,
        };
    },
};
