"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const blocklist_elements_1 = require("./rules/blocklist-elements");
const enforce_default_message_1 = require("./rules/enforce-default-message");
const enforce_description_1 = require("./rules/enforce-description");
const enforce_id_1 = require("./rules/enforce-id");
const enforce_placeholders_1 = require("./rules/enforce-placeholders");
const enforce_plural_rules_1 = require("./rules/enforce-plural-rules");
const no_camel_case_1 = require("./rules/no-camel-case");
const no_complex_selectors_1 = require("./rules/no-complex-selectors");
const no_emoji_1 = require("./rules/no-emoji");
const no_id_1 = require("./rules/no-id");
const no_invalid_icu_1 = require("./rules/no-invalid-icu");
const no_literal_string_in_jsx_1 = require("./rules/no-literal-string-in-jsx");
const no_missing_icu_plural_one_placeholders_1 = require("./rules/no-missing-icu-plural-one-placeholders");
const no_multiple_plurals_1 = require("./rules/no-multiple-plurals");
const no_multiple_whitespaces_1 = require("./rules/no-multiple-whitespaces");
const no_offset_1 = require("./rules/no-offset");
const no_useless_message_1 = require("./rules/no-useless-message");
const prefer_formatted_message_1 = require("./rules/prefer-formatted-message");
const prefer_pound_in_plural_1 = require("./rules/prefer-pound-in-plural");
const no_literal_string_in_object_1 = require("./rules/no-literal-string-in-object");
const package_json_1 = require("./package.json");
// All rules
const rules = {
    // @ts-expect-error
    [blocklist_elements_1.name]: blocklist_elements_1.rule,
    // @ts-expect-error
    [enforce_default_message_1.name]: enforce_default_message_1.rule,
    // @ts-expect-error
    [enforce_description_1.name]: enforce_description_1.rule,
    // @ts-expect-error
    [enforce_id_1.name]: enforce_id_1.rule,
    // @ts-expect-error
    [enforce_placeholders_1.name]: enforce_placeholders_1.rule,
    // @ts-expect-error
    [enforce_plural_rules_1.name]: enforce_plural_rules_1.rule,
    // @ts-expect-error
    [no_camel_case_1.name]: no_camel_case_1.rule,
    // @ts-expect-error
    [no_complex_selectors_1.name]: no_complex_selectors_1.rule,
    // @ts-expect-error
    [no_emoji_1.name]: no_emoji_1.rule,
    // @ts-expect-error
    [no_id_1.name]: no_id_1.rule,
    // @ts-expect-error
    [no_invalid_icu_1.name]: no_invalid_icu_1.rule,
    // @ts-expect-error
    [no_literal_string_in_jsx_1.name]: no_literal_string_in_jsx_1.rule,
    // @ts-expect-error
    [no_multiple_plurals_1.name]: no_multiple_plurals_1.rule,
    // @ts-expect-error
    [no_multiple_whitespaces_1.name]: no_multiple_whitespaces_1.rule,
    // @ts-expect-error
    [no_offset_1.name]: no_offset_1.rule,
    // @ts-expect-error
    [no_useless_message_1.name]: no_useless_message_1.rule,
    // @ts-expect-error
    [prefer_formatted_message_1.name]: prefer_formatted_message_1.rule,
    // @ts-expect-error
    [prefer_pound_in_plural_1.name]: prefer_pound_in_plural_1.rule,
    // @ts-expect-error
    [no_missing_icu_plural_one_placeholders_1.name]: no_missing_icu_plural_one_placeholders_1.rule,
    // @ts-expect-error
    [no_literal_string_in_object_1.name]: no_literal_string_in_object_1.rule,
};
// Base plugin
const plugin = {
    meta: { name: package_json_1.name, version: package_json_1.version },
    rules,
};
// Configs
const configs = {
    strict: {
        name: 'formatjs/strict',
        plugins: { formatjs: plugin },
        rules: {
            'formatjs/no-offset': 'error',
            'formatjs/enforce-default-message': ['error', 'literal'],
            'formatjs/enforce-description': ['error', 'literal'],
            'formatjs/enforce-placeholders': 'error',
            'formatjs/no-emoji': 'error',
            'formatjs/no-multiple-whitespaces': 'error',
            'formatjs/no-multiple-plurals': 'error',
            'formatjs/no-complex-selectors': ['error', { limit: 20 }],
            'formatjs/no-useless-message': 'error',
            'formatjs/prefer-pound-in-plural': 'error',
            'formatjs/no-missing-icu-plural-one-placeholders': 'error',
            'formatjs/enforce-id': [
                'error',
                {
                    idInterpolationPattern: '[sha512:contenthash:base64:10]',
                },
            ],
            'formatjs/enforce-plural-rules': [
                'error',
                {
                    one: true,
                    other: true,
                },
            ],
            'formatjs/no-literal-string-in-jsx': [
                'error',
                {
                    props: {
                        include: [['*', '{label,placeholder,title}']],
                    },
                },
            ],
            'formatjs/blocklist-elements': ['error', ['selectordinal']],
        },
    },
    recommended: {
        name: 'formatjs/recommended',
        plugins: { formatjs: plugin },
        rules: {
            'formatjs/no-offset': 'error',
            'formatjs/enforce-default-message': ['error', 'literal'],
            'formatjs/enforce-description': ['error', 'literal'],
            'formatjs/enforce-placeholders': 'error',
            'formatjs/no-emoji': 'error',
            'formatjs/no-multiple-whitespaces': 'error',
            'formatjs/no-multiple-plurals': 'error',
            'formatjs/no-complex-selectors': ['error', { limit: 20 }],
            'formatjs/no-useless-message': 'error',
            'formatjs/prefer-pound-in-plural': 'error',
            'formatjs/no-missing-icu-plural-one-placeholders': 'error',
            'formatjs/enforce-plural-rules': [
                'error',
                {
                    one: true,
                    other: true,
                },
            ],
            'formatjs/no-literal-string-in-jsx': [
                'warn',
                {
                    props: {
                        include: [['*', '{label,placeholder,title}']],
                    },
                },
            ],
            'formatjs/blocklist-elements': ['error', ['selectordinal']],
        },
    },
};
plugin.configs = configs;
module.exports = plugin;
