# Installation
> `npm install --save @types/redux-immutable`

# Summary
This package contains type definitions for redux-immutable (https://github.com/gajus/redux-immutable).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/redux-immutable.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/redux-immutable/index.d.ts)
````ts
import { Collection, Record } from "immutable";
import { Action, Reducer, ReducersMapObject } from "redux";

export declare function combineReducers<S, A extends Action, T>(
    reducers: ReducersMapObject<S, A>,
    getDefaultState?: () => Collection.Keyed<T, S>,
): Reducer<S, A>;
export declare function combineReducers<S, A extends Action>(
    reducers: ReducersMapObject<S, A>,
    getDefaultState?: () => Collection.Indexed<S>,
): Reducer<S, A>;
export declare function combineReducers<S>(
    reducers: ReducersMapObject<S, any>,
    getDefaultState?: () => Collection.Indexed<S>,
): Reducer<S>;
export declare function combineReducers<S, T extends object>(
    reducers: ReducersMapObject<S, any>,
    getDefaultState?: Record.Factory<T>,
): Reducer<S>;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 20:08:00 GMT
 * Dependencies: [immutable](https://npmjs.com/package/immutable), [redux](https://npmjs.com/package/redux)

# Credits
These definitions were written by [Sebastian Sebald](https://github.com/sebald), [Gavin Gregory](https://github.com/gavingregory), and [Kanitkorn Sujautra](https://github.com/lukyth).
