'use strict';

var fs = require('fs');
var fs4 = require('fs/promises');
var babel = require('storybook/internal/babel');
var common = require('storybook/internal/common');
var csfTools = require('storybook/internal/csf-tools');
var nodeLogger = require('storybook/internal/node-logger');
var buffer = require('buffer');
var path = require('path');
var childProcess = require('child_process');
var process2 = require('process');
var url = require('url');
var os = require('os');
var promises = require('timers/promises');
var util = require('util');
var prompts = require('prompts');
var tsDedent = require('ts-dedent');
var tty = require('tty');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var fs4__namespace = /*#__PURE__*/_interopNamespace(fs4);
var path__default = /*#__PURE__*/_interopDefault(path);
var childProcess__default = /*#__PURE__*/_interopDefault(childProcess);
var process2__default = /*#__PURE__*/_interopDefault(process2);
var os__default = /*#__PURE__*/_interopDefault(os);
var prompts__default = /*#__PURE__*/_interopDefault(prompts);
var tty__default = /*#__PURE__*/_interopDefault(tty);

var __create=Object.create;var __defProp=Object.defineProperty;var __getOwnPropDesc=Object.getOwnPropertyDescriptor;var __getOwnPropNames=Object.getOwnPropertyNames;var __getProtoOf=Object.getPrototypeOf,__hasOwnProp=Object.prototype.hasOwnProperty;var __require=(x=>typeof require<"u"?require:typeof Proxy<"u"?new Proxy(x,{get:(a,b)=>(typeof require<"u"?require:a)[b]}):x)(function(x){if(typeof require<"u")return require.apply(this,arguments);throw Error('Dynamic require of "'+x+'" is not supported')});var __commonJS=(cb,mod)=>function(){return mod||(0, cb[__getOwnPropNames(cb)[0]])((mod={exports:{}}).exports,mod),mod.exports};var __copyProps=(to,from,except,desc)=>{if(from&&typeof from=="object"||typeof from=="function")for(let key of __getOwnPropNames(from))!__hasOwnProp.call(to,key)&&key!==except&&__defProp(to,key,{get:()=>from[key],enumerable:!(desc=__getOwnPropDesc(from,key))||desc.enumerable});return to};var __toESM=(mod,isNodeMode,target)=>(target=mod!=null?__create(__getProtoOf(mod)):{},__copyProps(isNodeMode||!mod||!mod.__esModule?__defProp(target,"default",{value:mod,enumerable:!0}):target,mod));var require_windows=__commonJS({"../../node_modules/isexe/windows.js"(exports,module){module.exports=isexe;isexe.sync=sync;var fs5=__require("fs");function checkPathExt(path6,options){var pathext=options.pathExt!==void 0?options.pathExt:process.env.PATHEXT;if(!pathext||(pathext=pathext.split(";"),pathext.indexOf("")!==-1))return !0;for(var i=0;i<pathext.length;i++){var p=pathext[i].toLowerCase();if(p&&path6.substr(-p.length).toLowerCase()===p)return !0}return !1}function checkStat(stat,path6,options){return !stat.isSymbolicLink()&&!stat.isFile()?!1:checkPathExt(path6,options)}function isexe(path6,options,cb){fs5.stat(path6,function(er,stat){cb(er,er?!1:checkStat(stat,path6,options));});}function sync(path6,options){return checkStat(fs5.statSync(path6),path6,options)}}});var require_mode=__commonJS({"../../node_modules/isexe/mode.js"(exports,module){module.exports=isexe;isexe.sync=sync;var fs5=__require("fs");function isexe(path6,options,cb){fs5.stat(path6,function(er,stat){cb(er,er?!1:checkStat(stat,options));});}function sync(path6,options){return checkStat(fs5.statSync(path6),options)}function checkStat(stat,options){return stat.isFile()&&checkMode(stat,options)}function checkMode(stat,options){var mod=stat.mode,uid=stat.uid,gid=stat.gid,myUid=options.uid!==void 0?options.uid:process.getuid&&process.getuid(),myGid=options.gid!==void 0?options.gid:process.getgid&&process.getgid(),u=parseInt("100",8),g=parseInt("010",8),o=parseInt("001",8),ug=u|g,ret=mod&o||mod&g&&gid===myGid||mod&u&&uid===myUid||mod&ug&&myUid===0;return ret}}});var require_isexe=__commonJS({"../../node_modules/isexe/index.js"(exports,module){__require("fs");var core;process.platform==="win32"||global.TESTING_WINDOWS?core=require_windows():core=require_mode();module.exports=isexe;isexe.sync=sync;function isexe(path6,options,cb){if(typeof options=="function"&&(cb=options,options={}),!cb){if(typeof Promise!="function")throw new TypeError("callback not provided");return new Promise(function(resolve2,reject){isexe(path6,options||{},function(er,is){er?reject(er):resolve2(is);});})}core(path6,options||{},function(er,is){er&&(er.code==="EACCES"||options&&options.ignoreErrors)&&(er=null,is=!1),cb(er,is);});}function sync(path6,options){try{return core.sync(path6,options||{})}catch(er){if(options&&options.ignoreErrors||er.code==="EACCES")return !1;throw er}}}});var require_which=__commonJS({"../../node_modules/which/which.js"(exports,module){var isWindows=process.platform==="win32"||process.env.OSTYPE==="cygwin"||process.env.OSTYPE==="msys",path6=__require("path"),COLON=isWindows?";":":",isexe=require_isexe(),getNotFoundError=cmd=>Object.assign(new Error(`not found: ${cmd}`),{code:"ENOENT"}),getPathInfo=(cmd,opt)=>{let colon=opt.colon||COLON,pathEnv=cmd.match(/\//)||isWindows&&cmd.match(/\\/)?[""]:[...isWindows?[process.cwd()]:[],...(opt.path||process.env.PATH||"").split(colon)],pathExtExe=isWindows?opt.pathExt||process.env.PATHEXT||".EXE;.CMD;.BAT;.COM":"",pathExt=isWindows?pathExtExe.split(colon):[""];return isWindows&&cmd.indexOf(".")!==-1&&pathExt[0]!==""&&pathExt.unshift(""),{pathEnv,pathExt,pathExtExe}},which=(cmd,opt,cb)=>{typeof opt=="function"&&(cb=opt,opt={}),opt||(opt={});let{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt),found=[],step2=i=>new Promise((resolve2,reject)=>{if(i===pathEnv.length)return opt.all&&found.length?resolve2(found):reject(getNotFoundError(cmd));let ppRaw=pathEnv[i],pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw,pCmd=path6.join(pathPart,cmd),p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;resolve2(subStep(p,i,0));}),subStep=(p,i,ii)=>new Promise((resolve2,reject)=>{if(ii===pathExt.length)return resolve2(step2(i+1));let ext=pathExt[ii];isexe(p+ext,{pathExt:pathExtExe},(er,is)=>{if(!er&&is)if(opt.all)found.push(p+ext);else return resolve2(p+ext);return resolve2(subStep(p,i,ii+1))});});return cb?step2(0).then(res=>cb(null,res),cb):step2(0)},whichSync=(cmd,opt)=>{opt=opt||{};let{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt),found=[];for(let i=0;i<pathEnv.length;i++){let ppRaw=pathEnv[i],pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw,pCmd=path6.join(pathPart,cmd),p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;for(let j=0;j<pathExt.length;j++){let cur=p+pathExt[j];try{if(isexe.sync(cur,{pathExt:pathExtExe}))if(opt.all)found.push(cur);else return cur}catch{}}}if(opt.all&&found.length)return found;if(opt.nothrow)return null;throw getNotFoundError(cmd)};module.exports=which;which.sync=whichSync;}});var require_path_key=__commonJS({"../../node_modules/path-key/index.js"(exports,module){var pathKey2=(options={})=>{let environment=options.env||process.env;return (options.platform||process.platform)!=="win32"?"PATH":Object.keys(environment).reverse().find(key=>key.toUpperCase()==="PATH")||"Path"};module.exports=pathKey2;module.exports.default=pathKey2;}});var require_resolveCommand=__commonJS({"../../node_modules/cross-spawn/lib/util/resolveCommand.js"(exports,module){var path6=__require("path"),which=require_which(),getPathKey=require_path_key();function resolveCommandAttempt(parsed,withoutPathExt){let env2=parsed.options.env||process.env,cwd2=process.cwd(),hasCustomCwd=parsed.options.cwd!=null,shouldSwitchCwd=hasCustomCwd&&process.chdir!==void 0&&!process.chdir.disabled;if(shouldSwitchCwd)try{process.chdir(parsed.options.cwd);}catch{}let resolved;try{resolved=which.sync(parsed.command,{path:env2[getPathKey({env:env2})],pathExt:withoutPathExt?path6.delimiter:void 0});}catch{}finally{shouldSwitchCwd&&process.chdir(cwd2);}return resolved&&(resolved=path6.resolve(hasCustomCwd?parsed.options.cwd:"",resolved)),resolved}function resolveCommand(parsed){return resolveCommandAttempt(parsed)||resolveCommandAttempt(parsed,!0)}module.exports=resolveCommand;}});var require_escape=__commonJS({"../../node_modules/cross-spawn/lib/util/escape.js"(exports,module){var metaCharsRegExp=/([()\][%!^"`<>&|;, *?])/g;function escapeCommand(arg){return arg=arg.replace(metaCharsRegExp,"^$1"),arg}function escapeArgument(arg,doubleEscapeMetaChars){return arg=`${arg}`,arg=arg.replace(/(?=(\\+?)?)\1"/g,'$1$1\\"'),arg=arg.replace(/(?=(\\+?)?)\1$/,"$1$1"),arg=`"${arg}"`,arg=arg.replace(metaCharsRegExp,"^$1"),doubleEscapeMetaChars&&(arg=arg.replace(metaCharsRegExp,"^$1")),arg}module.exports.command=escapeCommand;module.exports.argument=escapeArgument;}});var require_shebang_regex=__commonJS({"../../node_modules/shebang-regex/index.js"(exports,module){module.exports=/^#!(.*)/;}});var require_shebang_command=__commonJS({"../../node_modules/shebang-command/index.js"(exports,module){var shebangRegex=require_shebang_regex();module.exports=(string="")=>{let match=string.match(shebangRegex);if(!match)return null;let[path6,argument]=match[0].replace(/#! ?/,"").split(" "),binary=path6.split("/").pop();return binary==="env"?argument:argument?`${binary} ${argument}`:binary};}});var require_readShebang=__commonJS({"../../node_modules/cross-spawn/lib/util/readShebang.js"(exports,module){var fs5=__require("fs"),shebangCommand=require_shebang_command();function readShebang(command){let buffer=Buffer.alloc(150),fd;try{fd=fs5.openSync(command,"r"),fs5.readSync(fd,buffer,0,150,0),fs5.closeSync(fd);}catch{}return shebangCommand(buffer.toString())}module.exports=readShebang;}});var require_parse=__commonJS({"../../node_modules/cross-spawn/lib/parse.js"(exports,module){var path6=__require("path"),resolveCommand=require_resolveCommand(),escape=require_escape(),readShebang=require_readShebang(),isWin=process.platform==="win32",isExecutableRegExp=/\.(?:com|exe)$/i,isCmdShimRegExp=/node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;function detectShebang(parsed){parsed.file=resolveCommand(parsed);let shebang=parsed.file&&readShebang(parsed.file);return shebang?(parsed.args.unshift(parsed.file),parsed.command=shebang,resolveCommand(parsed)):parsed.file}function parseNonShell(parsed){if(!isWin)return parsed;let commandFile=detectShebang(parsed),needsShell=!isExecutableRegExp.test(commandFile);if(parsed.options.forceShell||needsShell){let needsDoubleEscapeMetaChars=isCmdShimRegExp.test(commandFile);parsed.command=path6.normalize(parsed.command),parsed.command=escape.command(parsed.command),parsed.args=parsed.args.map(arg=>escape.argument(arg,needsDoubleEscapeMetaChars));let shellCommand=[parsed.command].concat(parsed.args).join(" ");parsed.args=["/d","/s","/c",`"${shellCommand}"`],parsed.command=process.env.comspec||"cmd.exe",parsed.options.windowsVerbatimArguments=!0;}return parsed}function parse2(command,args,options){args&&!Array.isArray(args)&&(options=args,args=null),args=args?args.slice(0):[],options=Object.assign({},options);let parsed={command,args,options,file:void 0,original:{command,args}};return options.shell?parsed:parseNonShell(parsed)}module.exports=parse2;}});var require_enoent=__commonJS({"../../node_modules/cross-spawn/lib/enoent.js"(exports,module){var isWin=process.platform==="win32";function notFoundError(original,syscall){return Object.assign(new Error(`${syscall} ${original.command} ENOENT`),{code:"ENOENT",errno:"ENOENT",syscall:`${syscall} ${original.command}`,path:original.command,spawnargs:original.args})}function hookChildProcess(cp,parsed){if(!isWin)return;let originalEmit=cp.emit;cp.emit=function(name,arg1){if(name==="exit"){let err=verifyENOENT(arg1,parsed);if(err)return originalEmit.call(cp,"error",err)}return originalEmit.apply(cp,arguments)};}function verifyENOENT(status,parsed){return isWin&&status===1&&!parsed.file?notFoundError(parsed.original,"spawn"):null}function verifyENOENTSync(status,parsed){return isWin&&status===1&&!parsed.file?notFoundError(parsed.original,"spawnSync"):null}module.exports={hookChildProcess,verifyENOENT,verifyENOENTSync,notFoundError};}});var require_cross_spawn=__commonJS({"../../node_modules/cross-spawn/index.js"(exports,module){var cp=__require("child_process"),parse2=require_parse(),enoent=require_enoent();function spawn(command,args,options){let parsed=parse2(command,args,options),spawned=cp.spawn(parsed.command,parsed.args,parsed.options);return enoent.hookChildProcess(spawned,parsed),spawned}function spawnSync(command,args,options){let parsed=parse2(command,args,options),result=cp.spawnSync(parsed.command,parsed.args,parsed.options);return result.error=result.error||enoent.verifyENOENTSync(result.status,parsed),result}module.exports=spawn;module.exports.spawn=spawn;module.exports.sync=spawnSync;module.exports._parse=parse2;module.exports._enoent=enoent;}});var require_merge_stream=__commonJS({"../../node_modules/merge-stream/index.js"(exports,module){var{PassThrough}=__require("stream");module.exports=function(){var sources=[],output=new PassThrough({objectMode:!0});return output.setMaxListeners(0),output.add=add,output.isEmpty=isEmpty,output.on("unpipe",remove),Array.prototype.slice.call(arguments).forEach(add),output;function add(source){return Array.isArray(source)?(source.forEach(add),this):(sources.push(source),source.once("end",remove.bind(null,source)),source.once("error",output.emit.bind(output,"error")),source.pipe(output,{end:!1}),this)}function isEmpty(){return sources.length==0}function remove(source){sources=sources.filter(function(it){return it!==source}),!sources.length&&output.readable&&output.end();}};}});var require_picocolors=__commonJS({"../../node_modules/picocolors/picocolors.js"(exports,module){var p=process||{},argv=p.argv||[],env2=p.env||{},isColorSupported=!(env2.NO_COLOR||argv.includes("--no-color"))&&(!!env2.FORCE_COLOR||argv.includes("--color")||p.platform==="win32"||(p.stdout||{}).isTTY&&env2.TERM!=="dumb"||!!env2.CI),formatter=(open,close,replace=open)=>input=>{let string=""+input,index=string.indexOf(close,open.length);return ~index?open+replaceClose(string,close,replace,index)+close:open+string+close},replaceClose=(string,close,replace,index)=>{let result="",cursor=0;do result+=string.substring(cursor,index)+replace,cursor=index+close.length,index=string.indexOf(close,cursor);while(~index);return result+string.substring(cursor)},createColors=(enabled=isColorSupported)=>{let f=enabled?formatter:()=>String;return {isColorSupported:enabled,reset:f("\x1B[0m","\x1B[0m"),bold:f("\x1B[1m","\x1B[22m","\x1B[22m\x1B[1m"),dim:f("\x1B[2m","\x1B[22m","\x1B[22m\x1B[2m"),italic:f("\x1B[3m","\x1B[23m"),underline:f("\x1B[4m","\x1B[24m"),inverse:f("\x1B[7m","\x1B[27m"),hidden:f("\x1B[8m","\x1B[28m"),strikethrough:f("\x1B[9m","\x1B[29m"),black:f("\x1B[30m","\x1B[39m"),red:f("\x1B[31m","\x1B[39m"),green:f("\x1B[32m","\x1B[39m"),yellow:f("\x1B[33m","\x1B[39m"),blue:f("\x1B[34m","\x1B[39m"),magenta:f("\x1B[35m","\x1B[39m"),cyan:f("\x1B[36m","\x1B[39m"),white:f("\x1B[37m","\x1B[39m"),gray:f("\x1B[90m","\x1B[39m"),bgBlack:f("\x1B[40m","\x1B[49m"),bgRed:f("\x1B[41m","\x1B[49m"),bgGreen:f("\x1B[42m","\x1B[49m"),bgYellow:f("\x1B[43m","\x1B[49m"),bgBlue:f("\x1B[44m","\x1B[49m"),bgMagenta:f("\x1B[45m","\x1B[49m"),bgCyan:f("\x1B[46m","\x1B[49m"),bgWhite:f("\x1B[47m","\x1B[49m"),blackBright:f("\x1B[90m","\x1B[39m"),redBright:f("\x1B[91m","\x1B[39m"),greenBright:f("\x1B[92m","\x1B[39m"),yellowBright:f("\x1B[93m","\x1B[39m"),blueBright:f("\x1B[94m","\x1B[39m"),magentaBright:f("\x1B[95m","\x1B[39m"),cyanBright:f("\x1B[96m","\x1B[39m"),whiteBright:f("\x1B[97m","\x1B[39m"),bgBlackBright:f("\x1B[100m","\x1B[49m"),bgRedBright:f("\x1B[101m","\x1B[49m"),bgGreenBright:f("\x1B[102m","\x1B[49m"),bgYellowBright:f("\x1B[103m","\x1B[49m"),bgBlueBright:f("\x1B[104m","\x1B[49m"),bgMagentaBright:f("\x1B[105m","\x1B[49m"),bgCyanBright:f("\x1B[106m","\x1B[49m"),bgWhiteBright:f("\x1B[107m","\x1B[49m")}};module.exports=createColors();module.exports.createColors=createColors;}});var require_constants=__commonJS({"../../node_modules/semver/internal/constants.js"(exports,module){var SEMVER_SPEC_VERSION="2.0.0",MAX_SAFE_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991,MAX_SAFE_COMPONENT_LENGTH=16,MAX_SAFE_BUILD_LENGTH=250,RELEASE_TYPES=["major","premajor","minor","preminor","patch","prepatch","prerelease"];module.exports={MAX_LENGTH:256,MAX_SAFE_COMPONENT_LENGTH,MAX_SAFE_BUILD_LENGTH,MAX_SAFE_INTEGER,RELEASE_TYPES,SEMVER_SPEC_VERSION,FLAG_INCLUDE_PRERELEASE:1,FLAG_LOOSE:2};}});var require_debug=__commonJS({"../../node_modules/semver/internal/debug.js"(exports,module){var debug=typeof process=="object"&&process.env&&process.env.NODE_DEBUG&&/\bsemver\b/i.test(process.env.NODE_DEBUG)?(...args)=>console.error("SEMVER",...args):()=>{};module.exports=debug;}});var require_re=__commonJS({"../../node_modules/semver/internal/re.js"(exports,module){var{MAX_SAFE_COMPONENT_LENGTH,MAX_SAFE_BUILD_LENGTH,MAX_LENGTH}=require_constants(),debug=require_debug();exports=module.exports={};var re=exports.re=[],safeRe=exports.safeRe=[],src=exports.src=[],safeSrc=exports.safeSrc=[],t=exports.t={},R=0,LETTERDASHNUMBER="[a-zA-Z0-9-]",safeRegexReplacements=[["\\s",1],["\\d",MAX_LENGTH],[LETTERDASHNUMBER,MAX_SAFE_BUILD_LENGTH]],makeSafeRegex=value=>{for(let[token,max]of safeRegexReplacements)value=value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);return value},createToken=(name,value,isGlobal)=>{let safe=makeSafeRegex(value),index=R++;debug(name,index,value),t[name]=index,src[index]=value,safeSrc[index]=safe,re[index]=new RegExp(value,isGlobal?"g":void 0),safeRe[index]=new RegExp(safe,isGlobal?"g":void 0);};createToken("NUMERICIDENTIFIER","0|[1-9]\\d*");createToken("NUMERICIDENTIFIERLOOSE","\\d+");createToken("NONNUMERICIDENTIFIER",`\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);createToken("MAINVERSION",`(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);createToken("MAINVERSIONLOOSE",`(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);createToken("PRERELEASEIDENTIFIER",`(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASEIDENTIFIERLOOSE",`(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASE",`(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);createToken("PRERELEASELOOSE",`(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);createToken("BUILDIDENTIFIER",`${LETTERDASHNUMBER}+`);createToken("BUILD",`(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);createToken("FULLPLAIN",`v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);createToken("FULL",`^${src[t.FULLPLAIN]}$`);createToken("LOOSEPLAIN",`[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);createToken("LOOSE",`^${src[t.LOOSEPLAIN]}$`);createToken("GTLT","((?:<|>)?=?)");createToken("XRANGEIDENTIFIERLOOSE",`${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);createToken("XRANGEIDENTIFIER",`${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);createToken("XRANGEPLAIN",`[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);createToken("XRANGEPLAINLOOSE",`[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);createToken("XRANGE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);createToken("XRANGELOOSE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);createToken("COERCEPLAIN",`(^|[^\\d])(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);createToken("COERCE",`${src[t.COERCEPLAIN]}(?:$|[^\\d])`);createToken("COERCEFULL",src[t.COERCEPLAIN]+`(?:${src[t.PRERELEASE]})?(?:${src[t.BUILD]})?(?:$|[^\\d])`);createToken("COERCERTL",src[t.COERCE],!0);createToken("COERCERTLFULL",src[t.COERCEFULL],!0);createToken("LONETILDE","(?:~>?)");createToken("TILDETRIM",`(\\s*)${src[t.LONETILDE]}\\s+`,!0);exports.tildeTrimReplace="$1~";createToken("TILDE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);createToken("TILDELOOSE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("LONECARET","(?:\\^)");createToken("CARETTRIM",`(\\s*)${src[t.LONECARET]}\\s+`,!0);exports.caretTrimReplace="$1^";createToken("CARET",`^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);createToken("CARETLOOSE",`^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("COMPARATORLOOSE",`^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);createToken("COMPARATOR",`^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);createToken("COMPARATORTRIM",`(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`,!0);exports.comparatorTrimReplace="$1$2$3";createToken("HYPHENRANGE",`^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);createToken("HYPHENRANGELOOSE",`^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);createToken("STAR","(<|>)?=?\\s*\\*");createToken("GTE0","^\\s*>=\\s*0\\.0\\.0\\s*$");createToken("GTE0PRE","^\\s*>=\\s*0\\.0\\.0-0\\s*$");}});var require_parse_options=__commonJS({"../../node_modules/semver/internal/parse-options.js"(exports,module){var looseOption=Object.freeze({loose:!0}),emptyOpts=Object.freeze({}),parseOptions=options=>options?typeof options!="object"?looseOption:options:emptyOpts;module.exports=parseOptions;}});var require_identifiers=__commonJS({"../../node_modules/semver/internal/identifiers.js"(exports,module){var numeric=/^[0-9]+$/,compareIdentifiers=(a,b)=>{let anum=numeric.test(a),bnum=numeric.test(b);return anum&&bnum&&(a=+a,b=+b),a===b?0:anum&&!bnum?-1:bnum&&!anum?1:a<b?-1:1},rcompareIdentifiers=(a,b)=>compareIdentifiers(b,a);module.exports={compareIdentifiers,rcompareIdentifiers};}});var require_semver=__commonJS({"../../node_modules/semver/classes/semver.js"(exports,module){var debug=require_debug(),{MAX_LENGTH,MAX_SAFE_INTEGER}=require_constants(),{safeRe:re,safeSrc:src,t}=require_re(),parseOptions=require_parse_options(),{compareIdentifiers}=require_identifiers(),SemVer=class _SemVer{constructor(version,options){if(options=parseOptions(options),version instanceof _SemVer){if(version.loose===!!options.loose&&version.includePrerelease===!!options.includePrerelease)return version;version=version.version;}else if(typeof version!="string")throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);if(version.length>MAX_LENGTH)throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);debug("SemVer",version,options),this.options=options,this.loose=!!options.loose,this.includePrerelease=!!options.includePrerelease;let m=version.trim().match(options.loose?re[t.LOOSE]:re[t.FULL]);if(!m)throw new TypeError(`Invalid Version: ${version}`);if(this.raw=version,this.major=+m[1],this.minor=+m[2],this.patch=+m[3],this.major>MAX_SAFE_INTEGER||this.major<0)throw new TypeError("Invalid major version");if(this.minor>MAX_SAFE_INTEGER||this.minor<0)throw new TypeError("Invalid minor version");if(this.patch>MAX_SAFE_INTEGER||this.patch<0)throw new TypeError("Invalid patch version");m[4]?this.prerelease=m[4].split(".").map(id=>{if(/^[0-9]+$/.test(id)){let num=+id;if(num>=0&&num<MAX_SAFE_INTEGER)return num}return id}):this.prerelease=[],this.build=m[5]?m[5].split("."):[],this.format();}format(){return this.version=`${this.major}.${this.minor}.${this.patch}`,this.prerelease.length&&(this.version+=`-${this.prerelease.join(".")}`),this.version}toString(){return this.version}compare(other){if(debug("SemVer.compare",this.version,this.options,other),!(other instanceof _SemVer)){if(typeof other=="string"&&other===this.version)return 0;other=new _SemVer(other,this.options);}return other.version===this.version?0:this.compareMain(other)||this.comparePre(other)}compareMain(other){return other instanceof _SemVer||(other=new _SemVer(other,this.options)),compareIdentifiers(this.major,other.major)||compareIdentifiers(this.minor,other.minor)||compareIdentifiers(this.patch,other.patch)}comparePre(other){if(other instanceof _SemVer||(other=new _SemVer(other,this.options)),this.prerelease.length&&!other.prerelease.length)return -1;if(!this.prerelease.length&&other.prerelease.length)return 1;if(!this.prerelease.length&&!other.prerelease.length)return 0;let i=0;do{let a=this.prerelease[i],b=other.prerelease[i];if(debug("prerelease compare",i,a,b),a===void 0&&b===void 0)return 0;if(b===void 0)return 1;if(a===void 0)return -1;if(a===b)continue;return compareIdentifiers(a,b)}while(++i)}compareBuild(other){other instanceof _SemVer||(other=new _SemVer(other,this.options));let i=0;do{let a=this.build[i],b=other.build[i];if(debug("build compare",i,a,b),a===void 0&&b===void 0)return 0;if(b===void 0)return 1;if(a===void 0)return -1;if(a===b)continue;return compareIdentifiers(a,b)}while(++i)}inc(release,identifier,identifierBase){if(release.startsWith("pre")){if(!identifier&&identifierBase===!1)throw new Error("invalid increment argument: identifier is empty");if(identifier){let r=new RegExp(`^${this.options.loose?src[t.PRERELEASELOOSE]:src[t.PRERELEASE]}$`),match=`-${identifier}`.match(r);if(!match||match[1]!==identifier)throw new Error(`invalid identifier: ${identifier}`)}}switch(release){case"premajor":this.prerelease.length=0,this.patch=0,this.minor=0,this.major++,this.inc("pre",identifier,identifierBase);break;case"preminor":this.prerelease.length=0,this.patch=0,this.minor++,this.inc("pre",identifier,identifierBase);break;case"prepatch":this.prerelease.length=0,this.inc("patch",identifier,identifierBase),this.inc("pre",identifier,identifierBase);break;case"prerelease":this.prerelease.length===0&&this.inc("patch",identifier,identifierBase),this.inc("pre",identifier,identifierBase);break;case"release":if(this.prerelease.length===0)throw new Error(`version ${this.raw} is not a prerelease`);this.prerelease.length=0;break;case"major":(this.minor!==0||this.patch!==0||this.prerelease.length===0)&&this.major++,this.minor=0,this.patch=0,this.prerelease=[];break;case"minor":(this.patch!==0||this.prerelease.length===0)&&this.minor++,this.patch=0,this.prerelease=[];break;case"patch":this.prerelease.length===0&&this.patch++,this.prerelease=[];break;case"pre":{let base=Number(identifierBase)?1:0;if(this.prerelease.length===0)this.prerelease=[base];else {let i=this.prerelease.length;for(;--i>=0;)typeof this.prerelease[i]=="number"&&(this.prerelease[i]++,i=-2);if(i===-1){if(identifier===this.prerelease.join(".")&&identifierBase===!1)throw new Error("invalid increment argument: identifier already exists");this.prerelease.push(base);}}if(identifier){let prerelease=[identifier,base];identifierBase===!1&&(prerelease=[identifier]),compareIdentifiers(this.prerelease[0],identifier)===0?isNaN(this.prerelease[1])&&(this.prerelease=prerelease):this.prerelease=prerelease;}break}default:throw new Error(`invalid increment argument: ${release}`)}return this.raw=this.format(),this.build.length&&(this.raw+=`+${this.build.join(".")}`),this}};module.exports=SemVer;}});var require_parse2=__commonJS({"../../node_modules/semver/functions/parse.js"(exports,module){var SemVer=require_semver(),parse2=(version,options,throwErrors=!1)=>{if(version instanceof SemVer)return version;try{return new SemVer(version,options)}catch(er){if(!throwErrors)return null;throw er}};module.exports=parse2;}});var require_valid=__commonJS({"../../node_modules/semver/functions/valid.js"(exports,module){var parse2=require_parse2(),valid=(version,options)=>{let v=parse2(version,options);return v?v.version:null};module.exports=valid;}});var require_clean=__commonJS({"../../node_modules/semver/functions/clean.js"(exports,module){var parse2=require_parse2(),clean=(version,options)=>{let s=parse2(version.trim().replace(/^[=v]+/,""),options);return s?s.version:null};module.exports=clean;}});var require_inc=__commonJS({"../../node_modules/semver/functions/inc.js"(exports,module){var SemVer=require_semver(),inc=(version,release,options,identifier,identifierBase)=>{typeof options=="string"&&(identifierBase=identifier,identifier=options,options=void 0);try{return new SemVer(version instanceof SemVer?version.version:version,options).inc(release,identifier,identifierBase).version}catch{return null}};module.exports=inc;}});var require_diff=__commonJS({"../../node_modules/semver/functions/diff.js"(exports,module){var parse2=require_parse2(),diff=(version1,version2)=>{let v1=parse2(version1,null,!0),v2=parse2(version2,null,!0),comparison=v1.compare(v2);if(comparison===0)return null;let v1Higher=comparison>0,highVersion=v1Higher?v1:v2,lowVersion=v1Higher?v2:v1,highHasPre=!!highVersion.prerelease.length;if(!!lowVersion.prerelease.length&&!highHasPre){if(!lowVersion.patch&&!lowVersion.minor)return "major";if(lowVersion.compareMain(highVersion)===0)return lowVersion.minor&&!lowVersion.patch?"minor":"patch"}let prefix=highHasPre?"pre":"";return v1.major!==v2.major?prefix+"major":v1.minor!==v2.minor?prefix+"minor":v1.patch!==v2.patch?prefix+"patch":"prerelease"};module.exports=diff;}});var require_major=__commonJS({"../../node_modules/semver/functions/major.js"(exports,module){var SemVer=require_semver(),major=(a,loose)=>new SemVer(a,loose).major;module.exports=major;}});var require_minor=__commonJS({"../../node_modules/semver/functions/minor.js"(exports,module){var SemVer=require_semver(),minor=(a,loose)=>new SemVer(a,loose).minor;module.exports=minor;}});var require_patch=__commonJS({"../../node_modules/semver/functions/patch.js"(exports,module){var SemVer=require_semver(),patch=(a,loose)=>new SemVer(a,loose).patch;module.exports=patch;}});var require_prerelease=__commonJS({"../../node_modules/semver/functions/prerelease.js"(exports,module){var parse2=require_parse2(),prerelease=(version,options)=>{let parsed=parse2(version,options);return parsed&&parsed.prerelease.length?parsed.prerelease:null};module.exports=prerelease;}});var require_compare=__commonJS({"../../node_modules/semver/functions/compare.js"(exports,module){var SemVer=require_semver(),compare=(a,b,loose)=>new SemVer(a,loose).compare(new SemVer(b,loose));module.exports=compare;}});var require_rcompare=__commonJS({"../../node_modules/semver/functions/rcompare.js"(exports,module){var compare=require_compare(),rcompare=(a,b,loose)=>compare(b,a,loose);module.exports=rcompare;}});var require_compare_loose=__commonJS({"../../node_modules/semver/functions/compare-loose.js"(exports,module){var compare=require_compare(),compareLoose=(a,b)=>compare(a,b,!0);module.exports=compareLoose;}});var require_compare_build=__commonJS({"../../node_modules/semver/functions/compare-build.js"(exports,module){var SemVer=require_semver(),compareBuild=(a,b,loose)=>{let versionA=new SemVer(a,loose),versionB=new SemVer(b,loose);return versionA.compare(versionB)||versionA.compareBuild(versionB)};module.exports=compareBuild;}});var require_sort=__commonJS({"../../node_modules/semver/functions/sort.js"(exports,module){var compareBuild=require_compare_build(),sort=(list,loose)=>list.sort((a,b)=>compareBuild(a,b,loose));module.exports=sort;}});var require_rsort=__commonJS({"../../node_modules/semver/functions/rsort.js"(exports,module){var compareBuild=require_compare_build(),rsort=(list,loose)=>list.sort((a,b)=>compareBuild(b,a,loose));module.exports=rsort;}});var require_gt=__commonJS({"../../node_modules/semver/functions/gt.js"(exports,module){var compare=require_compare(),gt=(a,b,loose)=>compare(a,b,loose)>0;module.exports=gt;}});var require_lt=__commonJS({"../../node_modules/semver/functions/lt.js"(exports,module){var compare=require_compare(),lt=(a,b,loose)=>compare(a,b,loose)<0;module.exports=lt;}});var require_eq=__commonJS({"../../node_modules/semver/functions/eq.js"(exports,module){var compare=require_compare(),eq=(a,b,loose)=>compare(a,b,loose)===0;module.exports=eq;}});var require_neq=__commonJS({"../../node_modules/semver/functions/neq.js"(exports,module){var compare=require_compare(),neq=(a,b,loose)=>compare(a,b,loose)!==0;module.exports=neq;}});var require_gte=__commonJS({"../../node_modules/semver/functions/gte.js"(exports,module){var compare=require_compare(),gte=(a,b,loose)=>compare(a,b,loose)>=0;module.exports=gte;}});var require_lte=__commonJS({"../../node_modules/semver/functions/lte.js"(exports,module){var compare=require_compare(),lte=(a,b,loose)=>compare(a,b,loose)<=0;module.exports=lte;}});var require_cmp=__commonJS({"../../node_modules/semver/functions/cmp.js"(exports,module){var eq=require_eq(),neq=require_neq(),gt=require_gt(),gte=require_gte(),lt=require_lt(),lte=require_lte(),cmp=(a,op,b,loose)=>{switch(op){case"===":return typeof a=="object"&&(a=a.version),typeof b=="object"&&(b=b.version),a===b;case"!==":return typeof a=="object"&&(a=a.version),typeof b=="object"&&(b=b.version),a!==b;case"":case"=":case"==":return eq(a,b,loose);case"!=":return neq(a,b,loose);case">":return gt(a,b,loose);case">=":return gte(a,b,loose);case"<":return lt(a,b,loose);case"<=":return lte(a,b,loose);default:throw new TypeError(`Invalid operator: ${op}`)}};module.exports=cmp;}});var require_coerce=__commonJS({"../../node_modules/semver/functions/coerce.js"(exports,module){var SemVer=require_semver(),parse2=require_parse2(),{safeRe:re,t}=require_re(),coerce2=(version,options)=>{if(version instanceof SemVer)return version;if(typeof version=="number"&&(version=String(version)),typeof version!="string")return null;options=options||{};let match=null;if(!options.rtl)match=version.match(options.includePrerelease?re[t.COERCEFULL]:re[t.COERCE]);else {let coerceRtlRegex=options.includePrerelease?re[t.COERCERTLFULL]:re[t.COERCERTL],next;for(;(next=coerceRtlRegex.exec(version))&&(!match||match.index+match[0].length!==version.length);)(!match||next.index+next[0].length!==match.index+match[0].length)&&(match=next),coerceRtlRegex.lastIndex=next.index+next[1].length+next[2].length;coerceRtlRegex.lastIndex=-1;}if(match===null)return null;let major=match[2],minor=match[3]||"0",patch=match[4]||"0",prerelease=options.includePrerelease&&match[5]?`-${match[5]}`:"",build=options.includePrerelease&&match[6]?`+${match[6]}`:"";return parse2(`${major}.${minor}.${patch}${prerelease}${build}`,options)};module.exports=coerce2;}});var require_lrucache=__commonJS({"../../node_modules/semver/internal/lrucache.js"(exports,module){var LRUCache=class{constructor(){this.max=1e3,this.map=new Map;}get(key){let value=this.map.get(key);if(value!==void 0)return this.map.delete(key),this.map.set(key,value),value}delete(key){return this.map.delete(key)}set(key,value){if(!this.delete(key)&&value!==void 0){if(this.map.size>=this.max){let firstKey=this.map.keys().next().value;this.delete(firstKey);}this.map.set(key,value);}return this}};module.exports=LRUCache;}});var require_range=__commonJS({"../../node_modules/semver/classes/range.js"(exports,module){var SPACE_CHARACTERS=/\s+/g,Range=class _Range{constructor(range,options){if(options=parseOptions(options),range instanceof _Range)return range.loose===!!options.loose&&range.includePrerelease===!!options.includePrerelease?range:new _Range(range.raw,options);if(range instanceof Comparator)return this.raw=range.value,this.set=[[range]],this.formatted=void 0,this;if(this.options=options,this.loose=!!options.loose,this.includePrerelease=!!options.includePrerelease,this.raw=range.trim().replace(SPACE_CHARACTERS," "),this.set=this.raw.split("||").map(r=>this.parseRange(r.trim())).filter(c=>c.length),!this.set.length)throw new TypeError(`Invalid SemVer Range: ${this.raw}`);if(this.set.length>1){let first=this.set[0];if(this.set=this.set.filter(c=>!isNullSet(c[0])),this.set.length===0)this.set=[first];else if(this.set.length>1){for(let c of this.set)if(c.length===1&&isAny(c[0])){this.set=[c];break}}}this.formatted=void 0;}get range(){if(this.formatted===void 0){this.formatted="";for(let i=0;i<this.set.length;i++){i>0&&(this.formatted+="||");let comps=this.set[i];for(let k=0;k<comps.length;k++)k>0&&(this.formatted+=" "),this.formatted+=comps[k].toString().trim();}}return this.formatted}format(){return this.range}toString(){return this.range}parseRange(range){let memoKey=((this.options.includePrerelease&&FLAG_INCLUDE_PRERELEASE)|(this.options.loose&&FLAG_LOOSE))+":"+range,cached=cache.get(memoKey);if(cached)return cached;let loose=this.options.loose,hr=loose?re[t.HYPHENRANGELOOSE]:re[t.HYPHENRANGE];range=range.replace(hr,hyphenReplace(this.options.includePrerelease)),debug("hyphen replace",range),range=range.replace(re[t.COMPARATORTRIM],comparatorTrimReplace),debug("comparator trim",range),range=range.replace(re[t.TILDETRIM],tildeTrimReplace),debug("tilde trim",range),range=range.replace(re[t.CARETTRIM],caretTrimReplace),debug("caret trim",range);let rangeList=range.split(" ").map(comp=>parseComparator(comp,this.options)).join(" ").split(/\s+/).map(comp=>replaceGTE0(comp,this.options));loose&&(rangeList=rangeList.filter(comp=>(debug("loose invalid filter",comp,this.options),!!comp.match(re[t.COMPARATORLOOSE])))),debug("range list",rangeList);let rangeMap=new Map,comparators=rangeList.map(comp=>new Comparator(comp,this.options));for(let comp of comparators){if(isNullSet(comp))return [comp];rangeMap.set(comp.value,comp);}rangeMap.size>1&&rangeMap.has("")&&rangeMap.delete("");let result=[...rangeMap.values()];return cache.set(memoKey,result),result}intersects(range,options){if(!(range instanceof _Range))throw new TypeError("a Range is required");return this.set.some(thisComparators=>isSatisfiable(thisComparators,options)&&range.set.some(rangeComparators=>isSatisfiable(rangeComparators,options)&&thisComparators.every(thisComparator=>rangeComparators.every(rangeComparator=>thisComparator.intersects(rangeComparator,options)))))}test(version){if(!version)return !1;if(typeof version=="string")try{version=new SemVer(version,this.options);}catch{return !1}for(let i=0;i<this.set.length;i++)if(testSet(this.set[i],version,this.options))return !0;return !1}};module.exports=Range;var LRU=require_lrucache(),cache=new LRU,parseOptions=require_parse_options(),Comparator=require_comparator(),debug=require_debug(),SemVer=require_semver(),{safeRe:re,t,comparatorTrimReplace,tildeTrimReplace,caretTrimReplace}=require_re(),{FLAG_INCLUDE_PRERELEASE,FLAG_LOOSE}=require_constants(),isNullSet=c=>c.value==="<0.0.0-0",isAny=c=>c.value==="",isSatisfiable=(comparators,options)=>{let result=!0,remainingComparators=comparators.slice(),testComparator=remainingComparators.pop();for(;result&&remainingComparators.length;)result=remainingComparators.every(otherComparator=>testComparator.intersects(otherComparator,options)),testComparator=remainingComparators.pop();return result},parseComparator=(comp,options)=>(debug("comp",comp,options),comp=replaceCarets(comp,options),debug("caret",comp),comp=replaceTildes(comp,options),debug("tildes",comp),comp=replaceXRanges(comp,options),debug("xrange",comp),comp=replaceStars(comp,options),debug("stars",comp),comp),isX=id=>!id||id.toLowerCase()==="x"||id==="*",replaceTildes=(comp,options)=>comp.trim().split(/\s+/).map(c=>replaceTilde(c,options)).join(" "),replaceTilde=(comp,options)=>{let r=options.loose?re[t.TILDELOOSE]:re[t.TILDE];return comp.replace(r,(_,M,m,p,pr)=>{debug("tilde",comp,_,M,m,p,pr);let ret;return isX(M)?ret="":isX(m)?ret=`>=${M}.0.0 <${+M+1}.0.0-0`:isX(p)?ret=`>=${M}.${m}.0 <${M}.${+m+1}.0-0`:pr?(debug("replaceTilde pr",pr),ret=`>=${M}.${m}.${p}-${pr} <${M}.${+m+1}.0-0`):ret=`>=${M}.${m}.${p} <${M}.${+m+1}.0-0`,debug("tilde return",ret),ret})},replaceCarets=(comp,options)=>comp.trim().split(/\s+/).map(c=>replaceCaret(c,options)).join(" "),replaceCaret=(comp,options)=>{debug("caret",comp,options);let r=options.loose?re[t.CARETLOOSE]:re[t.CARET],z=options.includePrerelease?"-0":"";return comp.replace(r,(_,M,m,p,pr)=>{debug("caret",comp,_,M,m,p,pr);let ret;return isX(M)?ret="":isX(m)?ret=`>=${M}.0.0${z} <${+M+1}.0.0-0`:isX(p)?M==="0"?ret=`>=${M}.${m}.0${z} <${M}.${+m+1}.0-0`:ret=`>=${M}.${m}.0${z} <${+M+1}.0.0-0`:pr?(debug("replaceCaret pr",pr),M==="0"?m==="0"?ret=`>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p+1}-0`:ret=`>=${M}.${m}.${p}-${pr} <${M}.${+m+1}.0-0`:ret=`>=${M}.${m}.${p}-${pr} <${+M+1}.0.0-0`):(debug("no pr"),M==="0"?m==="0"?ret=`>=${M}.${m}.${p}${z} <${M}.${m}.${+p+1}-0`:ret=`>=${M}.${m}.${p}${z} <${M}.${+m+1}.0-0`:ret=`>=${M}.${m}.${p} <${+M+1}.0.0-0`),debug("caret return",ret),ret})},replaceXRanges=(comp,options)=>(debug("replaceXRanges",comp,options),comp.split(/\s+/).map(c=>replaceXRange(c,options)).join(" ")),replaceXRange=(comp,options)=>{comp=comp.trim();let r=options.loose?re[t.XRANGELOOSE]:re[t.XRANGE];return comp.replace(r,(ret,gtlt,M,m,p,pr)=>{debug("xRange",comp,ret,gtlt,M,m,p,pr);let xM=isX(M),xm=xM||isX(m),xp=xm||isX(p),anyX=xp;return gtlt==="="&&anyX&&(gtlt=""),pr=options.includePrerelease?"-0":"",xM?gtlt===">"||gtlt==="<"?ret="<0.0.0-0":ret="*":gtlt&&anyX?(xm&&(m=0),p=0,gtlt===">"?(gtlt=">=",xm?(M=+M+1,m=0,p=0):(m=+m+1,p=0)):gtlt==="<="&&(gtlt="<",xm?M=+M+1:m=+m+1),gtlt==="<"&&(pr="-0"),ret=`${gtlt+M}.${m}.${p}${pr}`):xm?ret=`>=${M}.0.0${pr} <${+M+1}.0.0-0`:xp&&(ret=`>=${M}.${m}.0${pr} <${M}.${+m+1}.0-0`),debug("xRange return",ret),ret})},replaceStars=(comp,options)=>(debug("replaceStars",comp,options),comp.trim().replace(re[t.STAR],"")),replaceGTE0=(comp,options)=>(debug("replaceGTE0",comp,options),comp.trim().replace(re[options.includePrerelease?t.GTE0PRE:t.GTE0],"")),hyphenReplace=incPr=>($0,from,fM,fm,fp,fpr,fb,to,tM,tm,tp,tpr)=>(isX(fM)?from="":isX(fm)?from=`>=${fM}.0.0${incPr?"-0":""}`:isX(fp)?from=`>=${fM}.${fm}.0${incPr?"-0":""}`:fpr?from=`>=${from}`:from=`>=${from}${incPr?"-0":""}`,isX(tM)?to="":isX(tm)?to=`<${+tM+1}.0.0-0`:isX(tp)?to=`<${tM}.${+tm+1}.0-0`:tpr?to=`<=${tM}.${tm}.${tp}-${tpr}`:incPr?to=`<${tM}.${tm}.${+tp+1}-0`:to=`<=${to}`,`${from} ${to}`.trim()),testSet=(set,version,options)=>{for(let i=0;i<set.length;i++)if(!set[i].test(version))return !1;if(version.prerelease.length&&!options.includePrerelease){for(let i=0;i<set.length;i++)if(debug(set[i].semver),set[i].semver!==Comparator.ANY&&set[i].semver.prerelease.length>0){let allowed=set[i].semver;if(allowed.major===version.major&&allowed.minor===version.minor&&allowed.patch===version.patch)return !0}return !1}return !0};}});var require_comparator=__commonJS({"../../node_modules/semver/classes/comparator.js"(exports,module){var ANY=Symbol("SemVer ANY"),Comparator=class _Comparator{static get ANY(){return ANY}constructor(comp,options){if(options=parseOptions(options),comp instanceof _Comparator){if(comp.loose===!!options.loose)return comp;comp=comp.value;}comp=comp.trim().split(/\s+/).join(" "),debug("comparator",comp,options),this.options=options,this.loose=!!options.loose,this.parse(comp),this.semver===ANY?this.value="":this.value=this.operator+this.semver.version,debug("comp",this);}parse(comp){let r=this.options.loose?re[t.COMPARATORLOOSE]:re[t.COMPARATOR],m=comp.match(r);if(!m)throw new TypeError(`Invalid comparator: ${comp}`);this.operator=m[1]!==void 0?m[1]:"",this.operator==="="&&(this.operator=""),m[2]?this.semver=new SemVer(m[2],this.options.loose):this.semver=ANY;}toString(){return this.value}test(version){if(debug("Comparator.test",version,this.options.loose),this.semver===ANY||version===ANY)return !0;if(typeof version=="string")try{version=new SemVer(version,this.options);}catch{return !1}return cmp(version,this.operator,this.semver,this.options)}intersects(comp,options){if(!(comp instanceof _Comparator))throw new TypeError("a Comparator is required");return this.operator===""?this.value===""?!0:new Range(comp.value,options).test(this.value):comp.operator===""?comp.value===""?!0:new Range(this.value,options).test(comp.semver):(options=parseOptions(options),options.includePrerelease&&(this.value==="<0.0.0-0"||comp.value==="<0.0.0-0")||!options.includePrerelease&&(this.value.startsWith("<0.0.0")||comp.value.startsWith("<0.0.0"))?!1:!!(this.operator.startsWith(">")&&comp.operator.startsWith(">")||this.operator.startsWith("<")&&comp.operator.startsWith("<")||this.semver.version===comp.semver.version&&this.operator.includes("=")&&comp.operator.includes("=")||cmp(this.semver,"<",comp.semver,options)&&this.operator.startsWith(">")&&comp.operator.startsWith("<")||cmp(this.semver,">",comp.semver,options)&&this.operator.startsWith("<")&&comp.operator.startsWith(">")))}};module.exports=Comparator;var parseOptions=require_parse_options(),{safeRe:re,t}=require_re(),cmp=require_cmp(),debug=require_debug(),SemVer=require_semver(),Range=require_range();}});var require_satisfies=__commonJS({"../../node_modules/semver/functions/satisfies.js"(exports,module){var Range=require_range(),satisfies2=(version,range,options)=>{try{range=new Range(range,options);}catch{return !1}return range.test(version)};module.exports=satisfies2;}});var require_to_comparators=__commonJS({"../../node_modules/semver/ranges/to-comparators.js"(exports,module){var Range=require_range(),toComparators=(range,options)=>new Range(range,options).set.map(comp=>comp.map(c=>c.value).join(" ").trim().split(" "));module.exports=toComparators;}});var require_max_satisfying=__commonJS({"../../node_modules/semver/ranges/max-satisfying.js"(exports,module){var SemVer=require_semver(),Range=require_range(),maxSatisfying=(versions2,range,options)=>{let max=null,maxSV=null,rangeObj=null;try{rangeObj=new Range(range,options);}catch{return null}return versions2.forEach(v=>{rangeObj.test(v)&&(!max||maxSV.compare(v)===-1)&&(max=v,maxSV=new SemVer(max,options));}),max};module.exports=maxSatisfying;}});var require_min_satisfying=__commonJS({"../../node_modules/semver/ranges/min-satisfying.js"(exports,module){var SemVer=require_semver(),Range=require_range(),minSatisfying=(versions2,range,options)=>{let min=null,minSV=null,rangeObj=null;try{rangeObj=new Range(range,options);}catch{return null}return versions2.forEach(v=>{rangeObj.test(v)&&(!min||minSV.compare(v)===1)&&(min=v,minSV=new SemVer(min,options));}),min};module.exports=minSatisfying;}});var require_min_version=__commonJS({"../../node_modules/semver/ranges/min-version.js"(exports,module){var SemVer=require_semver(),Range=require_range(),gt=require_gt(),minVersion=(range,loose)=>{range=new Range(range,loose);let minver=new SemVer("0.0.0");if(range.test(minver)||(minver=new SemVer("0.0.0-0"),range.test(minver)))return minver;minver=null;for(let i=0;i<range.set.length;++i){let comparators=range.set[i],setMin=null;comparators.forEach(comparator=>{let compver=new SemVer(comparator.semver.version);switch(comparator.operator){case">":compver.prerelease.length===0?compver.patch++:compver.prerelease.push(0),compver.raw=compver.format();case"":case">=":(!setMin||gt(compver,setMin))&&(setMin=compver);break;case"<":case"<=":break;default:throw new Error(`Unexpected operation: ${comparator.operator}`)}}),setMin&&(!minver||gt(minver,setMin))&&(minver=setMin);}return minver&&range.test(minver)?minver:null};module.exports=minVersion;}});var require_valid2=__commonJS({"../../node_modules/semver/ranges/valid.js"(exports,module){var Range=require_range(),validRange=(range,options)=>{try{return new Range(range,options).range||"*"}catch{return null}};module.exports=validRange;}});var require_outside=__commonJS({"../../node_modules/semver/ranges/outside.js"(exports,module){var SemVer=require_semver(),Comparator=require_comparator(),{ANY}=Comparator,Range=require_range(),satisfies2=require_satisfies(),gt=require_gt(),lt=require_lt(),lte=require_lte(),gte=require_gte(),outside=(version,range,hilo,options)=>{version=new SemVer(version,options),range=new Range(range,options);let gtfn,ltefn,ltfn,comp,ecomp;switch(hilo){case">":gtfn=gt,ltefn=lte,ltfn=lt,comp=">",ecomp=">=";break;case"<":gtfn=lt,ltefn=gte,ltfn=gt,comp="<",ecomp="<=";break;default:throw new TypeError('Must provide a hilo val of "<" or ">"')}if(satisfies2(version,range,options))return !1;for(let i=0;i<range.set.length;++i){let comparators=range.set[i],high=null,low=null;if(comparators.forEach(comparator=>{comparator.semver===ANY&&(comparator=new Comparator(">=0.0.0")),high=high||comparator,low=low||comparator,gtfn(comparator.semver,high.semver,options)?high=comparator:ltfn(comparator.semver,low.semver,options)&&(low=comparator);}),high.operator===comp||high.operator===ecomp||(!low.operator||low.operator===comp)&&ltefn(version,low.semver))return !1;if(low.operator===ecomp&&ltfn(version,low.semver))return !1}return !0};module.exports=outside;}});var require_gtr=__commonJS({"../../node_modules/semver/ranges/gtr.js"(exports,module){var outside=require_outside(),gtr=(version,range,options)=>outside(version,range,">",options);module.exports=gtr;}});var require_ltr=__commonJS({"../../node_modules/semver/ranges/ltr.js"(exports,module){var outside=require_outside(),ltr=(version,range,options)=>outside(version,range,"<",options);module.exports=ltr;}});var require_intersects=__commonJS({"../../node_modules/semver/ranges/intersects.js"(exports,module){var Range=require_range(),intersects=(r1,r2,options)=>(r1=new Range(r1,options),r2=new Range(r2,options),r1.intersects(r2,options));module.exports=intersects;}});var require_simplify=__commonJS({"../../node_modules/semver/ranges/simplify.js"(exports,module){var satisfies2=require_satisfies(),compare=require_compare();module.exports=(versions2,range,options)=>{let set=[],first=null,prev=null,v=versions2.sort((a,b)=>compare(a,b,options));for(let version of v)satisfies2(version,range,options)?(prev=version,first||(first=version)):(prev&&set.push([first,prev]),prev=null,first=null);first&&set.push([first,null]);let ranges=[];for(let[min,max]of set)min===max?ranges.push(min):!max&&min===v[0]?ranges.push("*"):max?min===v[0]?ranges.push(`<=${max}`):ranges.push(`${min} - ${max}`):ranges.push(`>=${min}`);let simplified=ranges.join(" || "),original=typeof range.raw=="string"?range.raw:String(range);return simplified.length<original.length?simplified:range};}});var require_subset=__commonJS({"../../node_modules/semver/ranges/subset.js"(exports,module){var Range=require_range(),Comparator=require_comparator(),{ANY}=Comparator,satisfies2=require_satisfies(),compare=require_compare(),subset=(sub,dom,options={})=>{if(sub===dom)return !0;sub=new Range(sub,options),dom=new Range(dom,options);let sawNonNull=!1;OUTER:for(let simpleSub of sub.set){for(let simpleDom of dom.set){let isSub=simpleSubset(simpleSub,simpleDom,options);if(sawNonNull=sawNonNull||isSub!==null,isSub)continue OUTER}if(sawNonNull)return !1}return !0},minimumVersionWithPreRelease=[new Comparator(">=0.0.0-0")],minimumVersion=[new Comparator(">=0.0.0")],simpleSubset=(sub,dom,options)=>{if(sub===dom)return !0;if(sub.length===1&&sub[0].semver===ANY){if(dom.length===1&&dom[0].semver===ANY)return !0;options.includePrerelease?sub=minimumVersionWithPreRelease:sub=minimumVersion;}if(dom.length===1&&dom[0].semver===ANY){if(options.includePrerelease)return !0;dom=minimumVersion;}let eqSet=new Set,gt,lt;for(let c of sub)c.operator===">"||c.operator===">="?gt=higherGT(gt,c,options):c.operator==="<"||c.operator==="<="?lt=lowerLT(lt,c,options):eqSet.add(c.semver);if(eqSet.size>1)return null;let gtltComp;if(gt&&lt){if(gtltComp=compare(gt.semver,lt.semver,options),gtltComp>0)return null;if(gtltComp===0&&(gt.operator!==">="||lt.operator!=="<="))return null}for(let eq of eqSet){if(gt&&!satisfies2(eq,String(gt),options)||lt&&!satisfies2(eq,String(lt),options))return null;for(let c of dom)if(!satisfies2(eq,String(c),options))return !1;return !0}let higher,lower,hasDomLT,hasDomGT,needDomLTPre=lt&&!options.includePrerelease&&lt.semver.prerelease.length?lt.semver:!1,needDomGTPre=gt&&!options.includePrerelease&&gt.semver.prerelease.length?gt.semver:!1;needDomLTPre&&needDomLTPre.prerelease.length===1&&lt.operator==="<"&&needDomLTPre.prerelease[0]===0&&(needDomLTPre=!1);for(let c of dom){if(hasDomGT=hasDomGT||c.operator===">"||c.operator===">=",hasDomLT=hasDomLT||c.operator==="<"||c.operator==="<=",gt){if(needDomGTPre&&c.semver.prerelease&&c.semver.prerelease.length&&c.semver.major===needDomGTPre.major&&c.semver.minor===needDomGTPre.minor&&c.semver.patch===needDomGTPre.patch&&(needDomGTPre=!1),c.operator===">"||c.operator===">="){if(higher=higherGT(gt,c,options),higher===c&&higher!==gt)return !1}else if(gt.operator===">="&&!satisfies2(gt.semver,String(c),options))return !1}if(lt){if(needDomLTPre&&c.semver.prerelease&&c.semver.prerelease.length&&c.semver.major===needDomLTPre.major&&c.semver.minor===needDomLTPre.minor&&c.semver.patch===needDomLTPre.patch&&(needDomLTPre=!1),c.operator==="<"||c.operator==="<="){if(lower=lowerLT(lt,c,options),lower===c&&lower!==lt)return !1}else if(lt.operator==="<="&&!satisfies2(lt.semver,String(c),options))return !1}if(!c.operator&&(lt||gt)&&gtltComp!==0)return !1}return !(gt&&hasDomLT&&!lt&&gtltComp!==0||lt&&hasDomGT&&!gt&&gtltComp!==0||needDomGTPre||needDomLTPre)},higherGT=(a,b,options)=>{if(!a)return b;let comp=compare(a.semver,b.semver,options);return comp>0?a:comp<0||b.operator===">"&&a.operator===">="?b:a},lowerLT=(a,b,options)=>{if(!a)return b;let comp=compare(a.semver,b.semver,options);return comp<0?a:comp>0||b.operator==="<"&&a.operator==="<="?b:a};module.exports=subset;}});var require_semver2=__commonJS({"../../node_modules/semver/index.js"(exports,module){var internalRe=require_re(),constants3=require_constants(),SemVer=require_semver(),identifiers=require_identifiers(),parse2=require_parse2(),valid=require_valid(),clean=require_clean(),inc=require_inc(),diff=require_diff(),major=require_major(),minor=require_minor(),patch=require_patch(),prerelease=require_prerelease(),compare=require_compare(),rcompare=require_rcompare(),compareLoose=require_compare_loose(),compareBuild=require_compare_build(),sort=require_sort(),rsort=require_rsort(),gt=require_gt(),lt=require_lt(),eq=require_eq(),neq=require_neq(),gte=require_gte(),lte=require_lte(),cmp=require_cmp(),coerce2=require_coerce(),Comparator=require_comparator(),Range=require_range(),satisfies2=require_satisfies(),toComparators=require_to_comparators(),maxSatisfying=require_max_satisfying(),minSatisfying=require_min_satisfying(),minVersion=require_min_version(),validRange=require_valid2(),outside=require_outside(),gtr=require_gtr(),ltr=require_ltr(),intersects=require_intersects(),simplifyRange=require_simplify(),subset=require_subset();module.exports={parse:parse2,valid,clean,inc,diff,major,minor,patch,prerelease,compare,rcompare,compareLoose,compareBuild,sort,rsort,gt,lt,eq,neq,gte,lte,cmp,coerce:coerce2,Comparator,Range,satisfies:satisfies2,toComparators,maxSatisfying,minSatisfying,minVersion,validRange,outside,gtr,ltr,intersects,simplifyRange,subset,SemVer,re:internalRe.re,src:internalRe.src,tokens:internalRe.t,SEMVER_SPEC_VERSION:constants3.SEMVER_SPEC_VERSION,RELEASE_TYPES:constants3.RELEASE_TYPES,compareIdentifiers:identifiers.compareIdentifiers,rcompareIdentifiers:identifiers.rcompareIdentifiers};}});var require_boxes=__commonJS({"../../node_modules/cli-boxes/boxes.json"(exports,module){module.exports={single:{topLeft:"\u250C",top:"\u2500",topRight:"\u2510",right:"\u2502",bottomRight:"\u2518",bottom:"\u2500",bottomLeft:"\u2514",left:"\u2502"},double:{topLeft:"\u2554",top:"\u2550",topRight:"\u2557",right:"\u2551",bottomRight:"\u255D",bottom:"\u2550",bottomLeft:"\u255A",left:"\u2551"},round:{topLeft:"\u256D",top:"\u2500",topRight:"\u256E",right:"\u2502",bottomRight:"\u256F",bottom:"\u2500",bottomLeft:"\u2570",left:"\u2502"},bold:{topLeft:"\u250F",top:"\u2501",topRight:"\u2513",right:"\u2503",bottomRight:"\u251B",bottom:"\u2501",bottomLeft:"\u2517",left:"\u2503"},singleDouble:{topLeft:"\u2553",top:"\u2500",topRight:"\u2556",right:"\u2551",bottomRight:"\u255C",bottom:"\u2500",bottomLeft:"\u2559",left:"\u2551"},doubleSingle:{topLeft:"\u2552",top:"\u2550",topRight:"\u2555",right:"\u2502",bottomRight:"\u255B",bottom:"\u2550",bottomLeft:"\u2558",left:"\u2502"},classic:{topLeft:"+",top:"-",topRight:"+",right:"|",bottomRight:"+",bottom:"-",bottomLeft:"+",left:"|"},arrow:{topLeft:"\u2198",top:"\u2193",topRight:"\u2199",right:"\u2190",bottomRight:"\u2196",bottom:"\u2191",bottomLeft:"\u2197",left:"\u2192"}};}});var require_cli_boxes=__commonJS({"../../node_modules/cli-boxes/index.js"(exports,module){var cliBoxes2=require_boxes();module.exports=cliBoxes2;module.exports.default=cliBoxes2;}});var require_ansi_regex=__commonJS({"../../node_modules/string-width/node_modules/ansi-regex/index.js"(exports,module){module.exports=({onlyFirst=!1}={})=>{let pattern=["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)","(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"].join("|");return new RegExp(pattern,onlyFirst?void 0:"g")};}});var require_strip_ansi=__commonJS({"../../node_modules/string-width/node_modules/strip-ansi/index.js"(exports,module){var ansiRegex2=require_ansi_regex();module.exports=string=>typeof string=="string"?string.replace(ansiRegex2(),""):string;}});var require_is_fullwidth_code_point=__commonJS({"../../node_modules/is-fullwidth-code-point/index.js"(exports,module){var isFullwidthCodePoint=codePoint=>Number.isNaN(codePoint)?!1:codePoint>=4352&&(codePoint<=4447||codePoint===9001||codePoint===9002||11904<=codePoint&&codePoint<=12871&&codePoint!==12351||12880<=codePoint&&codePoint<=19903||19968<=codePoint&&codePoint<=42182||43360<=codePoint&&codePoint<=43388||44032<=codePoint&&codePoint<=55203||63744<=codePoint&&codePoint<=64255||65040<=codePoint&&codePoint<=65049||65072<=codePoint&&codePoint<=65131||65281<=codePoint&&codePoint<=65376||65504<=codePoint&&codePoint<=65510||110592<=codePoint&&codePoint<=110593||127488<=codePoint&&codePoint<=127569||131072<=codePoint&&codePoint<=262141);module.exports=isFullwidthCodePoint;module.exports.default=isFullwidthCodePoint;}});var require_emoji_regex=__commonJS({"../../node_modules/string-width/node_modules/emoji-regex/index.js"(exports,module){module.exports=function(){return /\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F|\uD83D\uDC68(?:\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|[\u2695\u2696\u2708]\uFE0F|\uD83D[\uDC66\uDC67]|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708])\uFE0F|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C[\uDFFB-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)\uD83C\uDFFB|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB\uDFFC])|\uD83D\uDC69(?:\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB-\uDFFD])|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|(?:(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)\uFE0F|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\u200D[\u2640\u2642])|\uD83C\uDFF4\u200D\u2620)\uFE0F|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF4\uD83C\uDDF2|\uD83C\uDDF6\uD83C\uDDE6|[#\*0-9]\uFE0F\u20E3|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270A-\u270D]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC70\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDCAA\uDD74\uDD7A\uDD90\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD36\uDDB5\uDDB6\uDDBB\uDDD2-\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5\uDEEB\uDEEC\uDEF4-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g};}});var require_string_width=__commonJS({"../../node_modules/string-width/index.js"(exports,module){var stripAnsi2=require_strip_ansi(),isFullwidthCodePoint=require_is_fullwidth_code_point(),emojiRegex=require_emoji_regex(),stringWidth3=string=>{if(typeof string!="string"||string.length===0||(string=stripAnsi2(string),string.length===0))return 0;string=string.replace(emojiRegex(),"  ");let width=0;for(let i=0;i<string.length;i++){let code=string.codePointAt(i);code<=31||code>=127&&code<=159||code>=768&&code<=879||(code>65535&&i++,width+=isFullwidthCodePoint(code)?2:1);}return width};module.exports=stringWidth3;module.exports.default=stringWidth3;}});var require_ansi_align=__commonJS({"../../node_modules/ansi-align/index.js"(exports,module){var stringWidth3=require_string_width();function ansiAlign2(text,opts){if(!text)return text;opts=opts||{};let align=opts.align||"center";if(align==="left")return text;let split=opts.split||`
`,pad=opts.pad||" ",widthDiffFn=align!=="right"?halfDiff:fullDiff,returnString=!1;Array.isArray(text)||(returnString=!0,text=String(text).split(split));let width,maxWidth=0;return text=text.map(function(str){return str=String(str),width=stringWidth3(str),maxWidth=Math.max(width,maxWidth),{str,width}}).map(function(obj){return new Array(widthDiffFn(maxWidth,obj.width)+1).join(pad)+obj.str}),returnString?text.join(split):text}ansiAlign2.left=function(text){return ansiAlign2(text,{align:"left"})};ansiAlign2.center=function(text){return ansiAlign2(text,{align:"center"})};ansiAlign2.right=function(text){return ansiAlign2(text,{align:"right"})};module.exports=ansiAlign2;function halfDiff(maxWidth,curWidth){return Math.floor((maxWidth-curWidth)/2)}function fullDiff(maxWidth,curWidth){return maxWidth-curWidth}}});var import_cross_spawn=__toESM(require_cross_spawn(),1);function stripFinalNewline(input){let LF=typeof input=="string"?`
`:10,CR=typeof input=="string"?"\r":13;return input[input.length-1]===LF&&(input=input.slice(0,-1)),input[input.length-1]===CR&&(input=input.slice(0,-1)),input}function pathKey(options={}){let{env:env2=process.env,platform=process.platform}=options;return platform!=="win32"?"PATH":Object.keys(env2).reverse().find(key=>key.toUpperCase()==="PATH")||"Path"}var npmRunPath=({cwd:cwd2=process2__default.default.cwd(),path:pathOption=process2__default.default.env[pathKey()],preferLocal=!0,execPath=process2__default.default.execPath,addExecPath=!0}={})=>{let cwdString=cwd2 instanceof URL?url.fileURLToPath(cwd2):cwd2,cwdPath=path__default.default.resolve(cwdString),result=[];return preferLocal&&applyPreferLocal(result,cwdPath),addExecPath&&applyExecPath(result,execPath,cwdPath),[...result,pathOption].join(path__default.default.delimiter)},applyPreferLocal=(result,cwdPath)=>{let previous;for(;previous!==cwdPath;)result.push(path__default.default.join(cwdPath,"node_modules/.bin")),previous=cwdPath,cwdPath=path__default.default.resolve(cwdPath,"..");},applyExecPath=(result,execPath,cwdPath)=>{let execPathString=execPath instanceof URL?url.fileURLToPath(execPath):execPath;result.push(path__default.default.resolve(cwdPath,execPathString,".."));},npmRunPathEnv=({env:env2=process2__default.default.env,...options}={})=>{env2={...env2};let pathName=pathKey({env:env2});return options.path=env2[pathName],env2[pathName]=npmRunPath(options),env2};var copyProperty=(to,from,property,ignoreNonConfigurable)=>{if(property==="length"||property==="prototype"||property==="arguments"||property==="caller")return;let toDescriptor=Object.getOwnPropertyDescriptor(to,property),fromDescriptor=Object.getOwnPropertyDescriptor(from,property);!canCopyProperty(toDescriptor,fromDescriptor)&&ignoreNonConfigurable||Object.defineProperty(to,property,fromDescriptor);},canCopyProperty=function(toDescriptor,fromDescriptor){return toDescriptor===void 0||toDescriptor.configurable||toDescriptor.writable===fromDescriptor.writable&&toDescriptor.enumerable===fromDescriptor.enumerable&&toDescriptor.configurable===fromDescriptor.configurable&&(toDescriptor.writable||toDescriptor.value===fromDescriptor.value)},changePrototype=(to,from)=>{let fromPrototype=Object.getPrototypeOf(from);fromPrototype!==Object.getPrototypeOf(to)&&Object.setPrototypeOf(to,fromPrototype);},wrappedToString=(withName,fromBody)=>`/* Wrapped ${withName}*/
${fromBody}`,toStringDescriptor=Object.getOwnPropertyDescriptor(Function.prototype,"toString"),toStringName=Object.getOwnPropertyDescriptor(Function.prototype.toString,"name"),changeToString=(to,from,name)=>{let withName=name===""?"":`with ${name.trim()}() `,newToString=wrappedToString.bind(null,withName,from.toString());Object.defineProperty(newToString,"name",toStringName),Object.defineProperty(to,"toString",{...toStringDescriptor,value:newToString});};function mimicFunction(to,from,{ignoreNonConfigurable=!1}={}){let{name}=to;for(let property of Reflect.ownKeys(from))copyProperty(to,from,property,ignoreNonConfigurable);return changePrototype(to,from),changeToString(to,from,name),to}var calledFunctions=new WeakMap,onetime=(function_,options={})=>{if(typeof function_!="function")throw new TypeError("Expected a function");let returnValue,callCount=0,functionName=function_.displayName||function_.name||"<anonymous>",onetime2=function(...arguments_){if(calledFunctions.set(onetime2,++callCount),callCount===1)returnValue=function_.apply(this,arguments_),function_=null;else if(options.throw===!0)throw new Error(`Function \`${functionName}\` can only be called once`);return returnValue};return mimicFunction(onetime2,function_),calledFunctions.set(onetime2,callCount),onetime2};onetime.callCount=function_=>{if(!calledFunctions.has(function_))throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`);return calledFunctions.get(function_)};var onetime_default=onetime;var getRealtimeSignals=()=>{let length=SIGRTMAX-SIGRTMIN+1;return Array.from({length},getRealtimeSignal)},getRealtimeSignal=(value,index)=>({name:`SIGRT${index+1}`,number:SIGRTMIN+index,action:"terminate",description:"Application-specific signal (realtime)",standard:"posix"}),SIGRTMIN=34,SIGRTMAX=64;var SIGNALS=[{name:"SIGHUP",number:1,action:"terminate",description:"Terminal closed",standard:"posix"},{name:"SIGINT",number:2,action:"terminate",description:"User interruption with CTRL-C",standard:"ansi"},{name:"SIGQUIT",number:3,action:"core",description:"User interruption with CTRL-\\",standard:"posix"},{name:"SIGILL",number:4,action:"core",description:"Invalid machine instruction",standard:"ansi"},{name:"SIGTRAP",number:5,action:"core",description:"Debugger breakpoint",standard:"posix"},{name:"SIGABRT",number:6,action:"core",description:"Aborted",standard:"ansi"},{name:"SIGIOT",number:6,action:"core",description:"Aborted",standard:"bsd"},{name:"SIGBUS",number:7,action:"core",description:"Bus error due to misaligned, non-existing address or paging error",standard:"bsd"},{name:"SIGEMT",number:7,action:"terminate",description:"Command should be emulated but is not implemented",standard:"other"},{name:"SIGFPE",number:8,action:"core",description:"Floating point arithmetic error",standard:"ansi"},{name:"SIGKILL",number:9,action:"terminate",description:"Forced termination",standard:"posix",forced:!0},{name:"SIGUSR1",number:10,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGSEGV",number:11,action:"core",description:"Segmentation fault",standard:"ansi"},{name:"SIGUSR2",number:12,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGPIPE",number:13,action:"terminate",description:"Broken pipe or socket",standard:"posix"},{name:"SIGALRM",number:14,action:"terminate",description:"Timeout or timer",standard:"posix"},{name:"SIGTERM",number:15,action:"terminate",description:"Termination",standard:"ansi"},{name:"SIGSTKFLT",number:16,action:"terminate",description:"Stack is empty or overflowed",standard:"other"},{name:"SIGCHLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"posix"},{name:"SIGCLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"other"},{name:"SIGCONT",number:18,action:"unpause",description:"Unpaused",standard:"posix",forced:!0},{name:"SIGSTOP",number:19,action:"pause",description:"Paused",standard:"posix",forced:!0},{name:"SIGTSTP",number:20,action:"pause",description:'Paused using CTRL-Z or "suspend"',standard:"posix"},{name:"SIGTTIN",number:21,action:"pause",description:"Background process cannot read terminal input",standard:"posix"},{name:"SIGBREAK",number:21,action:"terminate",description:"User interruption with CTRL-BREAK",standard:"other"},{name:"SIGTTOU",number:22,action:"pause",description:"Background process cannot write to terminal output",standard:"posix"},{name:"SIGURG",number:23,action:"ignore",description:"Socket received out-of-band data",standard:"bsd"},{name:"SIGXCPU",number:24,action:"core",description:"Process timed out",standard:"bsd"},{name:"SIGXFSZ",number:25,action:"core",description:"File too big",standard:"bsd"},{name:"SIGVTALRM",number:26,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGPROF",number:27,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGWINCH",number:28,action:"ignore",description:"Terminal window size changed",standard:"bsd"},{name:"SIGIO",number:29,action:"terminate",description:"I/O is available",standard:"other"},{name:"SIGPOLL",number:29,action:"terminate",description:"Watched event",standard:"other"},{name:"SIGINFO",number:29,action:"ignore",description:"Request for process information",standard:"other"},{name:"SIGPWR",number:30,action:"terminate",description:"Device running out of power",standard:"systemv"},{name:"SIGSYS",number:31,action:"core",description:"Invalid system call",standard:"other"},{name:"SIGUNUSED",number:31,action:"terminate",description:"Invalid system call",standard:"other"}];var getSignals=()=>{let realtimeSignals=getRealtimeSignals();return [...SIGNALS,...realtimeSignals].map(normalizeSignal)},normalizeSignal=({name,number:defaultNumber,description,action,forced=!1,standard})=>{let{signals:{[name]:constantSignal}}=os.constants,supported=constantSignal!==void 0;return {name,number:supported?constantSignal:defaultNumber,description,supported,action,forced,standard}};var getSignalsByName=()=>{let signals2=getSignals();return Object.fromEntries(signals2.map(getSignalByName))},getSignalByName=({name,number,description,supported,action,forced,standard})=>[name,{name,number,description,supported,action,forced,standard}],signalsByName=getSignalsByName(),getSignalsByNumber=()=>{let signals2=getSignals(),length=65,signalsA=Array.from({length},(value,number)=>getSignalByNumber(number,signals2));return Object.assign({},...signalsA)},getSignalByNumber=(number,signals2)=>{let signal=findSignalByNumber(number,signals2);if(signal===void 0)return {};let{name,description,supported,action,forced,standard}=signal;return {[number]:{name,number,description,supported,action,forced,standard}}},findSignalByNumber=(number,signals2)=>{let signal=signals2.find(({name})=>os.constants.signals[name]===number);return signal!==void 0?signal:signals2.find(signalA=>signalA.number===number)};getSignalsByNumber();var getErrorPrefix=({timedOut,timeout,errorCode,signal,signalDescription,exitCode,isCanceled})=>timedOut?`timed out after ${timeout} milliseconds`:isCanceled?"was canceled":errorCode!==void 0?`failed with ${errorCode}`:signal!==void 0?`was killed with ${signal} (${signalDescription})`:exitCode!==void 0?`failed with exit code ${exitCode}`:"failed",makeError=({stdout,stderr,all,error:error2,signal,exitCode,command,escapedCommand,timedOut,isCanceled,killed,parsed:{options:{timeout,cwd:cwd2=process2__default.default.cwd()}}})=>{exitCode=exitCode===null?void 0:exitCode,signal=signal===null?void 0:signal;let signalDescription=signal===void 0?void 0:signalsByName[signal].description,errorCode=error2&&error2.code,execaMessage=`Command ${getErrorPrefix({timedOut,timeout,errorCode,signal,signalDescription,exitCode,isCanceled})}: ${command}`,isError=Object.prototype.toString.call(error2)==="[object Error]",shortMessage=isError?`${execaMessage}
${error2.message}`:execaMessage,message=[shortMessage,stderr,stdout].filter(Boolean).join(`
`);return isError?(error2.originalMessage=error2.message,error2.message=message):error2=new Error(message),error2.shortMessage=shortMessage,error2.command=command,error2.escapedCommand=escapedCommand,error2.exitCode=exitCode,error2.signal=signal,error2.signalDescription=signalDescription,error2.stdout=stdout,error2.stderr=stderr,error2.cwd=cwd2,all!==void 0&&(error2.all=all),"bufferedData"in error2&&delete error2.bufferedData,error2.failed=!0,error2.timedOut=!!timedOut,error2.isCanceled=isCanceled,error2.killed=killed&&!timedOut,error2};var aliases=["stdin","stdout","stderr"],hasAlias=options=>aliases.some(alias=>options[alias]!==void 0),normalizeStdio=options=>{if(!options)return;let{stdio}=options;if(stdio===void 0)return aliases.map(alias=>options[alias]);if(hasAlias(options))throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases.map(alias=>`\`${alias}\``).join(", ")}`);if(typeof stdio=="string")return stdio;if(!Array.isArray(stdio))throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``);let length=Math.max(stdio.length,aliases.length);return Array.from({length},(value,index)=>stdio[index])};var signals=[];signals.push("SIGHUP","SIGINT","SIGTERM");process.platform!=="win32"&&signals.push("SIGALRM","SIGABRT","SIGVTALRM","SIGXCPU","SIGXFSZ","SIGUSR2","SIGTRAP","SIGSYS","SIGQUIT","SIGIOT");process.platform==="linux"&&signals.push("SIGIO","SIGPOLL","SIGPWR","SIGSTKFLT");var processOk=process10=>!!process10&&typeof process10=="object"&&typeof process10.removeListener=="function"&&typeof process10.emit=="function"&&typeof process10.reallyExit=="function"&&typeof process10.listeners=="function"&&typeof process10.kill=="function"&&typeof process10.pid=="number"&&typeof process10.on=="function",kExitEmitter=Symbol.for("signal-exit emitter"),global2=globalThis,ObjectDefineProperty=Object.defineProperty.bind(Object),Emitter=class{emitted={afterExit:!1,exit:!1};listeners={afterExit:[],exit:[]};count=0;id=Math.random();constructor(){if(global2[kExitEmitter])return global2[kExitEmitter];ObjectDefineProperty(global2,kExitEmitter,{value:this,writable:!1,enumerable:!1,configurable:!1});}on(ev,fn){this.listeners[ev].push(fn);}removeListener(ev,fn){let list=this.listeners[ev],i=list.indexOf(fn);i!==-1&&(i===0&&list.length===1?list.length=0:list.splice(i,1));}emit(ev,code,signal){if(this.emitted[ev])return !1;this.emitted[ev]=!0;let ret=!1;for(let fn of this.listeners[ev])ret=fn(code,signal)===!0||ret;return ev==="exit"&&(ret=this.emit("afterExit",code,signal)||ret),ret}},SignalExitBase=class{},signalExitWrap=handler=>({onExit(cb,opts){return handler.onExit(cb,opts)},load(){return handler.load()},unload(){return handler.unload()}}),SignalExitFallback=class extends SignalExitBase{onExit(){return ()=>{}}load(){}unload(){}},SignalExit=class extends SignalExitBase{#hupSig=process4.platform==="win32"?"SIGINT":"SIGHUP";#emitter=new Emitter;#process;#originalProcessEmit;#originalProcessReallyExit;#sigListeners={};#loaded=!1;constructor(process10){super(),this.#process=process10,this.#sigListeners={};for(let sig of signals)this.#sigListeners[sig]=()=>{let listeners=this.#process.listeners(sig),{count}=this.#emitter,p=process10;if(typeof p.__signal_exit_emitter__=="object"&&typeof p.__signal_exit_emitter__.count=="number"&&(count+=p.__signal_exit_emitter__.count),listeners.length===count){this.unload();let ret=this.#emitter.emit("exit",null,sig),s=sig==="SIGHUP"?this.#hupSig:sig;ret||process10.kill(process10.pid,s);}};this.#originalProcessReallyExit=process10.reallyExit,this.#originalProcessEmit=process10.emit;}onExit(cb,opts){if(!processOk(this.#process))return ()=>{};this.#loaded===!1&&this.load();let ev=opts?.alwaysLast?"afterExit":"exit";return this.#emitter.on(ev,cb),()=>{this.#emitter.removeListener(ev,cb),this.#emitter.listeners.exit.length===0&&this.#emitter.listeners.afterExit.length===0&&this.unload();}}load(){if(!this.#loaded){this.#loaded=!0,this.#emitter.count+=1;for(let sig of signals)try{let fn=this.#sigListeners[sig];fn&&this.#process.on(sig,fn);}catch{}this.#process.emit=(ev,...a)=>this.#processEmit(ev,...a),this.#process.reallyExit=code=>this.#processReallyExit(code);}}unload(){this.#loaded&&(this.#loaded=!1,signals.forEach(sig=>{let listener=this.#sigListeners[sig];if(!listener)throw new Error("Listener not defined for signal: "+sig);try{this.#process.removeListener(sig,listener);}catch{}}),this.#process.emit=this.#originalProcessEmit,this.#process.reallyExit=this.#originalProcessReallyExit,this.#emitter.count-=1);}#processReallyExit(code){return processOk(this.#process)?(this.#process.exitCode=code||0,this.#emitter.emit("exit",this.#process.exitCode,null),this.#originalProcessReallyExit.call(this.#process,this.#process.exitCode)):0}#processEmit(ev,...args){let og=this.#originalProcessEmit;if(ev==="exit"&&processOk(this.#process)){typeof args[0]=="number"&&(this.#process.exitCode=args[0]);let ret=og.call(this.#process,ev,...args);return this.#emitter.emit("exit",this.#process.exitCode,null),ret}else return og.call(this.#process,ev,...args)}},process4=globalThis.process,{onExit,load,unload}=signalExitWrap(processOk(process4)?new SignalExit(process4):new SignalExitFallback);var DEFAULT_FORCE_KILL_TIMEOUT=1e3*5,spawnedKill=(kill,signal="SIGTERM",options={})=>{let killResult=kill(signal);return setKillTimeout(kill,signal,options,killResult),killResult},setKillTimeout=(kill,signal,options,killResult)=>{if(!shouldForceKill(signal,options,killResult))return;let timeout=getForceKillAfterTimeout(options),t=setTimeout(()=>{kill("SIGKILL");},timeout);t.unref&&t.unref();},shouldForceKill=(signal,{forceKillAfterTimeout},killResult)=>isSigterm(signal)&&forceKillAfterTimeout!==!1&&killResult,isSigterm=signal=>signal===os__default.default.constants.signals.SIGTERM||typeof signal=="string"&&signal.toUpperCase()==="SIGTERM",getForceKillAfterTimeout=({forceKillAfterTimeout=!0})=>{if(forceKillAfterTimeout===!0)return DEFAULT_FORCE_KILL_TIMEOUT;if(!Number.isFinite(forceKillAfterTimeout)||forceKillAfterTimeout<0)throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`);return forceKillAfterTimeout},spawnedCancel=(spawned,context)=>{spawned.kill()&&(context.isCanceled=!0);},timeoutKill=(spawned,signal,reject)=>{spawned.kill(signal),reject(Object.assign(new Error("Timed out"),{timedOut:!0,signal}));},setupTimeout=(spawned,{timeout,killSignal="SIGTERM"},spawnedPromise)=>{if(timeout===0||timeout===void 0)return spawnedPromise;let timeoutId,timeoutPromise=new Promise((resolve2,reject)=>{timeoutId=setTimeout(()=>{timeoutKill(spawned,killSignal,reject);},timeout);}),safeSpawnedPromise=spawnedPromise.finally(()=>{clearTimeout(timeoutId);});return Promise.race([timeoutPromise,safeSpawnedPromise])},validateTimeout=({timeout})=>{if(timeout!==void 0&&(!Number.isFinite(timeout)||timeout<0))throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`)},setExitHandler=async(spawned,{cleanup,detached},timedPromise)=>{if(!cleanup||detached)return timedPromise;let removeExitHandler=onExit(()=>{spawned.kill();});return timedPromise.finally(()=>{removeExitHandler();})};function isStream(stream){return stream!==null&&typeof stream=="object"&&typeof stream.pipe=="function"}function isWritableStream(stream){return isStream(stream)&&stream.writable!==!1&&typeof stream._write=="function"&&typeof stream._writableState=="object"}var isExecaChildProcess=target=>target instanceof childProcess.ChildProcess&&typeof target.then=="function",pipeToTarget=(spawned,streamName,target)=>{if(typeof target=="string")return spawned[streamName].pipe(fs.createWriteStream(target)),spawned;if(isWritableStream(target))return spawned[streamName].pipe(target),spawned;if(!isExecaChildProcess(target))throw new TypeError("The second argument must be a string, a stream or an Execa child process.");if(!isWritableStream(target.stdin))throw new TypeError("The target child process's stdin must be available.");return spawned[streamName].pipe(target.stdin),target},addPipeMethods=spawned=>{spawned.stdout!==null&&(spawned.pipeStdout=pipeToTarget.bind(void 0,spawned,"stdout")),spawned.stderr!==null&&(spawned.pipeStderr=pipeToTarget.bind(void 0,spawned,"stderr")),spawned.all!==void 0&&(spawned.pipeAll=pipeToTarget.bind(void 0,spawned,"all"));};var getStreamContents=async(stream,{init,convertChunk,getSize,truncateChunk,addChunk,getFinalChunk,finalize},{maxBuffer=Number.POSITIVE_INFINITY}={})=>{if(!isAsyncIterable(stream))throw new Error("The first argument must be a Readable, a ReadableStream, or an async iterable.");let state=init();state.length=0;try{for await(let chunk of stream){let chunkType=getChunkType(chunk),convertedChunk=convertChunk[chunkType](chunk,state);appendChunk({convertedChunk,state,getSize,truncateChunk,addChunk,maxBuffer});}return appendFinalChunk({state,convertChunk,getSize,truncateChunk,addChunk,getFinalChunk,maxBuffer}),finalize(state)}catch(error2){throw error2.bufferedData=finalize(state),error2}},appendFinalChunk=({state,getSize,truncateChunk,addChunk,getFinalChunk,maxBuffer})=>{let convertedChunk=getFinalChunk(state);convertedChunk!==void 0&&appendChunk({convertedChunk,state,getSize,truncateChunk,addChunk,maxBuffer});},appendChunk=({convertedChunk,state,getSize,truncateChunk,addChunk,maxBuffer})=>{let chunkSize=getSize(convertedChunk),newLength=state.length+chunkSize;if(newLength<=maxBuffer){addNewChunk(convertedChunk,state,addChunk,newLength);return}let truncatedChunk=truncateChunk(convertedChunk,maxBuffer-state.length);throw truncatedChunk!==void 0&&addNewChunk(truncatedChunk,state,addChunk,maxBuffer),new MaxBufferError},addNewChunk=(convertedChunk,state,addChunk,newLength)=>{state.contents=addChunk(convertedChunk,state,newLength),state.length=newLength;},isAsyncIterable=stream=>typeof stream=="object"&&stream!==null&&typeof stream[Symbol.asyncIterator]=="function",getChunkType=chunk=>{let typeOfChunk=typeof chunk;if(typeOfChunk==="string")return "string";if(typeOfChunk!=="object"||chunk===null)return "others";if(globalThis.Buffer?.isBuffer(chunk))return "buffer";let prototypeName=objectToString.call(chunk);return prototypeName==="[object ArrayBuffer]"?"arrayBuffer":prototypeName==="[object DataView]"?"dataView":Number.isInteger(chunk.byteLength)&&Number.isInteger(chunk.byteOffset)&&objectToString.call(chunk.buffer)==="[object ArrayBuffer]"?"typedArray":"others"},{toString:objectToString}=Object.prototype,MaxBufferError=class extends Error{name="MaxBufferError";constructor(){super("maxBuffer exceeded");}};var identity=value=>value,noop=()=>{},getContentsProp=({contents})=>contents,throwObjectStream=chunk=>{throw new Error(`Streams in object mode are not supported: ${String(chunk)}`)},getLengthProp=convertedChunk=>convertedChunk.length;async function getStreamAsArrayBuffer(stream,options){return getStreamContents(stream,arrayBufferMethods,options)}var initArrayBuffer=()=>({contents:new ArrayBuffer(0)}),useTextEncoder=chunk=>textEncoder.encode(chunk),textEncoder=new TextEncoder,useUint8Array=chunk=>new Uint8Array(chunk),useUint8ArrayWithOffset=chunk=>new Uint8Array(chunk.buffer,chunk.byteOffset,chunk.byteLength),truncateArrayBufferChunk=(convertedChunk,chunkSize)=>convertedChunk.slice(0,chunkSize),addArrayBufferChunk=(convertedChunk,{contents,length:previousLength},length)=>{let newContents=hasArrayBufferResize()?resizeArrayBuffer(contents,length):resizeArrayBufferSlow(contents,length);return new Uint8Array(newContents).set(convertedChunk,previousLength),newContents},resizeArrayBufferSlow=(contents,length)=>{if(length<=contents.byteLength)return contents;let arrayBuffer=new ArrayBuffer(getNewContentsLength(length));return new Uint8Array(arrayBuffer).set(new Uint8Array(contents),0),arrayBuffer},resizeArrayBuffer=(contents,length)=>{if(length<=contents.maxByteLength)return contents.resize(length),contents;let arrayBuffer=new ArrayBuffer(length,{maxByteLength:getNewContentsLength(length)});return new Uint8Array(arrayBuffer).set(new Uint8Array(contents),0),arrayBuffer},getNewContentsLength=length=>SCALE_FACTOR**Math.ceil(Math.log(length)/Math.log(SCALE_FACTOR)),SCALE_FACTOR=2,finalizeArrayBuffer=({contents,length})=>hasArrayBufferResize()?contents:contents.slice(0,length),hasArrayBufferResize=()=>"resize"in ArrayBuffer.prototype,arrayBufferMethods={init:initArrayBuffer,convertChunk:{string:useTextEncoder,buffer:useUint8Array,arrayBuffer:useUint8Array,dataView:useUint8ArrayWithOffset,typedArray:useUint8ArrayWithOffset,others:throwObjectStream},getSize:getLengthProp,truncateChunk:truncateArrayBufferChunk,addChunk:addArrayBufferChunk,getFinalChunk:noop,finalize:finalizeArrayBuffer};async function getStreamAsBuffer(stream,options){if(!("Buffer"in globalThis))throw new Error("getStreamAsBuffer() is only supported in Node.js");try{return arrayBufferToNodeBuffer(await getStreamAsArrayBuffer(stream,options))}catch(error2){throw error2.bufferedData!==void 0&&(error2.bufferedData=arrayBufferToNodeBuffer(error2.bufferedData)),error2}}var arrayBufferToNodeBuffer=arrayBuffer=>globalThis.Buffer.from(arrayBuffer);async function getStreamAsString(stream,options){return getStreamContents(stream,stringMethods,options)}var initString=()=>({contents:"",textDecoder:new TextDecoder}),useTextDecoder=(chunk,{textDecoder})=>textDecoder.decode(chunk,{stream:!0}),addStringChunk=(convertedChunk,{contents})=>contents+convertedChunk,truncateStringChunk=(convertedChunk,chunkSize)=>convertedChunk.slice(0,chunkSize),getFinalStringChunk=({textDecoder})=>{let finalChunk=textDecoder.decode();return finalChunk===""?void 0:finalChunk},stringMethods={init:initString,convertChunk:{string:identity,buffer:useTextDecoder,arrayBuffer:useTextDecoder,dataView:useTextDecoder,typedArray:useTextDecoder,others:throwObjectStream},getSize:getLengthProp,truncateChunk:truncateStringChunk,addChunk:addStringChunk,getFinalChunk:getFinalStringChunk,finalize:getContentsProp};var import_merge_stream=__toESM(require_merge_stream(),1),validateInputOptions=input=>{if(input!==void 0)throw new TypeError("The `input` and `inputFile` options cannot be both set.")},getInput=({input,inputFile})=>typeof inputFile!="string"?input:(validateInputOptions(input),fs.createReadStream(inputFile)),handleInput=(spawned,options)=>{let input=getInput(options);input!==void 0&&(isStream(input)?input.pipe(spawned.stdin):spawned.stdin.end(input));},makeAllStream=(spawned,{all})=>{if(!all||!spawned.stdout&&!spawned.stderr)return;let mixed=(0, import_merge_stream.default)();return spawned.stdout&&mixed.add(spawned.stdout),spawned.stderr&&mixed.add(spawned.stderr),mixed},getBufferedData=async(stream,streamPromise)=>{if(!(!stream||streamPromise===void 0)){await promises.setTimeout(0),stream.destroy();try{return await streamPromise}catch(error2){return error2.bufferedData}}},getStreamPromise=(stream,{encoding,buffer,maxBuffer})=>{if(!(!stream||!buffer))return encoding==="utf8"||encoding==="utf-8"?getStreamAsString(stream,{maxBuffer}):encoding===null||encoding==="buffer"?getStreamAsBuffer(stream,{maxBuffer}):applyEncoding(stream,maxBuffer,encoding)},applyEncoding=async(stream,maxBuffer,encoding)=>(await getStreamAsBuffer(stream,{maxBuffer})).toString(encoding),getSpawnedResult=async({stdout,stderr,all},{encoding,buffer,maxBuffer},processDone)=>{let stdoutPromise=getStreamPromise(stdout,{encoding,buffer,maxBuffer}),stderrPromise=getStreamPromise(stderr,{encoding,buffer,maxBuffer}),allPromise=getStreamPromise(all,{encoding,buffer,maxBuffer:maxBuffer*2});try{return await Promise.all([processDone,stdoutPromise,stderrPromise,allPromise])}catch(error2){return Promise.all([{error:error2,signal:error2.signal,timedOut:error2.timedOut},getBufferedData(stdout,stdoutPromise),getBufferedData(stderr,stderrPromise),getBufferedData(all,allPromise)])}};var nativePromisePrototype=(async()=>{})().constructor.prototype,descriptors=["then","catch","finally"].map(property=>[property,Reflect.getOwnPropertyDescriptor(nativePromisePrototype,property)]),mergePromise=(spawned,promise)=>{for(let[property,descriptor]of descriptors){let value=typeof promise=="function"?(...args)=>Reflect.apply(descriptor.value,promise(),args):descriptor.value.bind(promise);Reflect.defineProperty(spawned,property,{...descriptor,value});}},getSpawnedPromise=spawned=>new Promise((resolve2,reject)=>{spawned.on("exit",(exitCode,signal)=>{resolve2({exitCode,signal});}),spawned.on("error",error2=>{reject(error2);}),spawned.stdin&&spawned.stdin.on("error",error2=>{reject(error2);});});var normalizeArgs=(file,args=[])=>Array.isArray(args)?[file,...args]:[file],NO_ESCAPE_REGEXP=/^[\w.-]+$/,escapeArg=arg=>typeof arg!="string"||NO_ESCAPE_REGEXP.test(arg)?arg:`"${arg.replaceAll('"','\\"')}"`,joinCommand=(file,args)=>normalizeArgs(file,args).join(" "),getEscapedCommand=(file,args)=>normalizeArgs(file,args).map(arg=>escapeArg(arg)).join(" ");var verboseDefault=util.debuglog("execa").enabled,padField=(field,padding)=>String(field).padStart(padding,"0"),getTimestamp=()=>{let date=new Date;return `${padField(date.getHours(),2)}:${padField(date.getMinutes(),2)}:${padField(date.getSeconds(),2)}.${padField(date.getMilliseconds(),3)}`},logCommand=(escapedCommand,{verbose})=>{verbose&&process2__default.default.stderr.write(`[${getTimestamp()}] ${escapedCommand}
`);};var DEFAULT_MAX_BUFFER=1e3*1e3*100,getEnv=({env:envOption,extendEnv,preferLocal,localDir,execPath})=>{let env2=extendEnv?{...process2__default.default.env,...envOption}:envOption;return preferLocal?npmRunPathEnv({env:env2,cwd:localDir,execPath}):env2},handleArguments=(file,args,options={})=>{let parsed=import_cross_spawn.default._parse(file,args,options);return file=parsed.command,args=parsed.args,options=parsed.options,options={maxBuffer:DEFAULT_MAX_BUFFER,buffer:!0,stripFinalNewline:!0,extendEnv:!0,preferLocal:!1,localDir:options.cwd||process2__default.default.cwd(),execPath:process2__default.default.execPath,encoding:"utf8",reject:!0,cleanup:!0,all:!1,windowsHide:!0,verbose:verboseDefault,...options},options.env=getEnv(options),options.stdio=normalizeStdio(options),process2__default.default.platform==="win32"&&path__default.default.basename(file,".exe")==="cmd"&&args.unshift("/q"),{file,args,options,parsed}},handleOutput=(options,value,error2)=>typeof value!="string"&&!buffer.Buffer.isBuffer(value)?error2===void 0?void 0:"":options.stripFinalNewline?stripFinalNewline(value):value;function execa(file,args,options){let parsed=handleArguments(file,args,options),command=joinCommand(file,args),escapedCommand=getEscapedCommand(file,args);logCommand(escapedCommand,parsed.options),validateTimeout(parsed.options);let spawned;try{spawned=childProcess__default.default.spawn(parsed.file,parsed.args,parsed.options);}catch(error2){let dummySpawned=new childProcess__default.default.ChildProcess,errorPromise=Promise.reject(makeError({error:error2,stdout:"",stderr:"",all:"",command,escapedCommand,parsed,timedOut:!1,isCanceled:!1,killed:!1}));return mergePromise(dummySpawned,errorPromise),dummySpawned}let spawnedPromise=getSpawnedPromise(spawned),timedPromise=setupTimeout(spawned,parsed.options,spawnedPromise),processDone=setExitHandler(spawned,parsed.options,timedPromise),context={isCanceled:!1};spawned.kill=spawnedKill.bind(null,spawned.kill.bind(spawned)),spawned.cancel=spawnedCancel.bind(null,spawned,context);let handlePromiseOnce=onetime_default(async()=>{let[{error:error2,exitCode,signal,timedOut},stdoutResult,stderrResult,allResult]=await getSpawnedResult(spawned,parsed.options,processDone),stdout=handleOutput(parsed.options,stdoutResult),stderr=handleOutput(parsed.options,stderrResult),all=handleOutput(parsed.options,allResult);if(error2||exitCode!==0||signal!==null){let returnedError=makeError({error:error2,exitCode,signal,stdout,stderr,all,command,escapedCommand,parsed,timedOut,isCanceled:(parsed.options.signal?parsed.options.signal.aborted:!1),killed:spawned.killed});if(!parsed.options.reject)return returnedError;throw returnedError}return {command,escapedCommand,exitCode:0,stdout,stderr,all,failed:!1,timedOut:!1,isCanceled:!1,killed:!1}});return handleInput(spawned,parsed.options),spawned.all=makeAllStream(spawned,parsed.options),addPipeMethods(spawned),mergePromise(spawned,handlePromiseOnce),spawned}var Node=class{value;next;constructor(value){this.value=value;}},Queue=class{#head;#tail;#size;constructor(){this.clear();}enqueue(value){let node=new Node(value);this.#head?(this.#tail.next=node,this.#tail=node):(this.#head=node,this.#tail=node),this.#size++;}dequeue(){let current=this.#head;if(current)return this.#head=this.#head.next,this.#size--,current.value}peek(){if(this.#head)return this.#head.value}clear(){this.#head=void 0,this.#tail=void 0,this.#size=0;}get size(){return this.#size}*[Symbol.iterator](){let current=this.#head;for(;current;)yield current.value,current=current.next;}*drain(){for(;this.#head;)yield this.dequeue();}};function pLimit(concurrency){if(!((Number.isInteger(concurrency)||concurrency===Number.POSITIVE_INFINITY)&&concurrency>0))throw new TypeError("Expected `concurrency` to be a number from 1 and up");let queue=new Queue,activeCount=0,next=()=>{activeCount--,queue.size>0&&queue.dequeue()();},run=async(fn,resolve2,args)=>{activeCount++;let result=(async()=>fn(...args))();resolve2(result);try{await result;}catch{}next();},enqueue=(fn,resolve2,args)=>{queue.enqueue(run.bind(void 0,fn,resolve2,args)),(async()=>(await Promise.resolve(),activeCount<concurrency&&queue.size>0&&queue.dequeue()()))();},generator=(fn,...args)=>new Promise(resolve2=>{enqueue(fn,resolve2,args);});return Object.defineProperties(generator,{activeCount:{get:()=>activeCount},pendingCount:{get:()=>queue.size},clearQueue:{value:()=>{queue.clear();}}}),generator}var EndError=class extends Error{constructor(value){super(),this.value=value;}},testElement=async(element,tester)=>tester(await element),finder=async element=>{let values=await Promise.all(element);if(values[1]===!0)throw new EndError(values[0]);return !1};async function pLocate(iterable,tester,{concurrency=Number.POSITIVE_INFINITY,preserveOrder=!0}={}){let limit=pLimit(concurrency),items=[...iterable].map(element=>[element,limit(testElement,element,tester)]),checkLimit=pLimit(preserveOrder?1:Number.POSITIVE_INFINITY);try{await Promise.all(items.map(element=>checkLimit(finder,element)));}catch(error2){if(error2 instanceof EndError)return error2.value;throw error2}}var typeMappings={directory:"isDirectory",file:"isFile"};function checkType(type){if(!Object.hasOwnProperty.call(typeMappings,type))throw new Error(`Invalid type specified: ${type}`)}var matchType=(type,stat)=>stat[typeMappings[type]](),toPath=urlOrPath=>urlOrPath instanceof URL?url.fileURLToPath(urlOrPath):urlOrPath;async function locatePath(paths,{cwd:cwd2=process2__default.default.cwd(),type="file",allowSymlinks=!0,concurrency,preserveOrder}={}){checkType(type),cwd2=toPath(cwd2);let statFunction=allowSymlinks?fs.promises.stat:fs.promises.lstat;return pLocate(paths,async path_=>{try{let stat=await statFunction(path__default.default.resolve(cwd2,path_));return matchType(type,stat)}catch{return !1}},{concurrency,preserveOrder})}function toPath2(urlOrPath){return urlOrPath instanceof URL?url.fileURLToPath(urlOrPath):urlOrPath}var findUpStop=Symbol("findUpStop");async function findUpMultiple(name,options={}){let directory=path__default.default.resolve(toPath2(options.cwd)??""),{root}=path__default.default.parse(directory),stopAt=path__default.default.resolve(directory,toPath2(options.stopAt??root)),limit=options.limit??Number.POSITIVE_INFINITY,paths=[name].flat(),runMatcher=async locateOptions=>{if(typeof name!="function")return locatePath(paths,locateOptions);let foundPath=await name(locateOptions.cwd);return typeof foundPath=="string"?locatePath([foundPath],locateOptions):foundPath},matches=[];for(;;){let foundPath=await runMatcher({...options,cwd:directory});if(foundPath===findUpStop||(foundPath&&matches.push(path__default.default.resolve(directory,foundPath)),directory===stopAt||matches.length>=limit))break;directory=path__default.default.dirname(directory);}return matches}async function findUp(name,options={}){return (await findUpMultiple(name,{...options,limit:1}))[0]}var _DRIVE_LETTER_START_RE=/^[A-Za-z]:\//;function normalizeWindowsPath(input=""){return input&&input.replace(/\\/g,"/").replace(_DRIVE_LETTER_START_RE,r=>r.toUpperCase())}var _UNC_REGEX=/^[/\\]{2}/,_IS_ABSOLUTE_RE=/^[/\\](?![/\\])|^[/\\]{2}(?!\.)|^[A-Za-z]:[/\\]/,_DRIVE_LETTER_RE=/^[A-Za-z]:$/,_ROOT_FOLDER_RE=/^\/([A-Za-z]:)?$/;var normalize=function(path6){if(path6.length===0)return ".";path6=normalizeWindowsPath(path6);let isUNCPath=path6.match(_UNC_REGEX),isPathAbsolute=isAbsolute(path6),trailingSeparator=path6[path6.length-1]==="/";return path6=normalizeString(path6,!isPathAbsolute),path6.length===0?isPathAbsolute?"/":trailingSeparator?"./":".":(trailingSeparator&&(path6+="/"),_DRIVE_LETTER_RE.test(path6)&&(path6+="/"),isUNCPath?isPathAbsolute?`//${path6}`:`//./${path6}`:isPathAbsolute&&!isAbsolute(path6)?`/${path6}`:path6)},join=function(...arguments_){if(arguments_.length===0)return ".";let joined;for(let argument of arguments_)argument&&argument.length>0&&(joined===void 0?joined=argument:joined+=`/${argument}`);return joined===void 0?".":normalize(joined.replace(/\/\/+/g,"/"))};function cwd(){return typeof process<"u"&&typeof process.cwd=="function"?process.cwd().replace(/\\/g,"/"):"/"}var resolve=function(...arguments_){arguments_=arguments_.map(argument=>normalizeWindowsPath(argument));let resolvedPath="",resolvedAbsolute=!1;for(let index=arguments_.length-1;index>=-1&&!resolvedAbsolute;index--){let path6=index>=0?arguments_[index]:cwd();!path6||path6.length===0||(resolvedPath=`${path6}/${resolvedPath}`,resolvedAbsolute=isAbsolute(path6));}return resolvedPath=normalizeString(resolvedPath,!resolvedAbsolute),resolvedAbsolute&&!isAbsolute(resolvedPath)?`/${resolvedPath}`:resolvedPath.length>0?resolvedPath:"."};function normalizeString(path6,allowAboveRoot){let res="",lastSegmentLength=0,lastSlash=-1,dots=0,char=null;for(let index=0;index<=path6.length;++index){if(index<path6.length)char=path6[index];else {if(char==="/")break;char="/";}if(char==="/"){if(!(lastSlash===index-1||dots===1))if(dots===2){if(res.length<2||lastSegmentLength!==2||res[res.length-1]!=="."||res[res.length-2]!=="."){if(res.length>2){let lastSlashIndex=res.lastIndexOf("/");lastSlashIndex===-1?(res="",lastSegmentLength=0):(res=res.slice(0,lastSlashIndex),lastSegmentLength=res.length-1-res.lastIndexOf("/")),lastSlash=index,dots=0;continue}else if(res.length>0){res="",lastSegmentLength=0,lastSlash=index,dots=0;continue}}allowAboveRoot&&(res+=res.length>0?"/..":"..",lastSegmentLength=2);}else res.length>0?res+=`/${path6.slice(lastSlash+1,index)}`:res=path6.slice(lastSlash+1,index),lastSegmentLength=index-lastSlash-1;lastSlash=index,dots=0;}else char==="."&&dots!==-1?++dots:dots=-1;}return res}var isAbsolute=function(p){return _IS_ABSOLUTE_RE.test(p)};var _EXTNAME_RE=/.(\.[^./]+)$/,extname=function(p){let match=_EXTNAME_RE.exec(normalizeWindowsPath(p));return match&&match[1]||""},relative=function(from,to){let _from=resolve(from).replace(_ROOT_FOLDER_RE,"$1").split("/"),_to=resolve(to).replace(_ROOT_FOLDER_RE,"$1").split("/");if(_to[0][1]===":"&&_from[0][1]===":"&&_from[0]!==_to[0])return _to.join("/");let _fromCopy=[..._from];for(let segment of _fromCopy){if(_to[0]!==segment)break;_from.shift(),_to.shift();}return [..._from.map(()=>".."),..._to].join("/")},dirname=function(p){let segments=normalizeWindowsPath(p).replace(/\/$/,"").split("/").slice(0,-1);return segments.length===1&&_DRIVE_LETTER_RE.test(segments[0])&&(segments[0]+="/"),segments.join("/")||(isAbsolute(p)?"/":".")};var import_picocolors=__toESM(require_picocolors()),import_semver=__toESM(require_semver2());var DOCUMENTATION_LINK2="writing-tests/integrations/vitest-addon";var SUPPORTED_FRAMEWORKS=["@storybook/nextjs","@storybook/nextjs-vite","@storybook/react-vite","@storybook/svelte-vite","@storybook/vue3-vite","@storybook/html-vite","@storybook/web-components-vite","@storybook/sveltekit","@storybook/react-native-web-vite"];function ansiRegex({onlyFirst=!1}={}){let pattern=["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?(?:\\u0007|\\u001B\\u005C|\\u009C))","(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-nq-uy=><~]))"].join("|");return new RegExp(pattern,onlyFirst?void 0:"g")}var regex=ansiRegex();function stripAnsi(string){if(typeof string!="string")throw new TypeError(`Expected a \`string\`, got \`${typeof string}\``);return string.replace(regex,"")}function isAmbiguous(x){return x===161||x===164||x===167||x===168||x===170||x===173||x===174||x>=176&&x<=180||x>=182&&x<=186||x>=188&&x<=191||x===198||x===208||x===215||x===216||x>=222&&x<=225||x===230||x>=232&&x<=234||x===236||x===237||x===240||x===242||x===243||x>=247&&x<=250||x===252||x===254||x===257||x===273||x===275||x===283||x===294||x===295||x===299||x>=305&&x<=307||x===312||x>=319&&x<=322||x===324||x>=328&&x<=331||x===333||x===338||x===339||x===358||x===359||x===363||x===462||x===464||x===466||x===468||x===470||x===472||x===474||x===476||x===593||x===609||x===708||x===711||x>=713&&x<=715||x===717||x===720||x>=728&&x<=731||x===733||x===735||x>=768&&x<=879||x>=913&&x<=929||x>=931&&x<=937||x>=945&&x<=961||x>=963&&x<=969||x===1025||x>=1040&&x<=1103||x===1105||x===8208||x>=8211&&x<=8214||x===8216||x===8217||x===8220||x===8221||x>=8224&&x<=8226||x>=8228&&x<=8231||x===8240||x===8242||x===8243||x===8245||x===8251||x===8254||x===8308||x===8319||x>=8321&&x<=8324||x===8364||x===8451||x===8453||x===8457||x===8467||x===8470||x===8481||x===8482||x===8486||x===8491||x===8531||x===8532||x>=8539&&x<=8542||x>=8544&&x<=8555||x>=8560&&x<=8569||x===8585||x>=8592&&x<=8601||x===8632||x===8633||x===8658||x===8660||x===8679||x===8704||x===8706||x===8707||x===8711||x===8712||x===8715||x===8719||x===8721||x===8725||x===8730||x>=8733&&x<=8736||x===8739||x===8741||x>=8743&&x<=8748||x===8750||x>=8756&&x<=8759||x===8764||x===8765||x===8776||x===8780||x===8786||x===8800||x===8801||x>=8804&&x<=8807||x===8810||x===8811||x===8814||x===8815||x===8834||x===8835||x===8838||x===8839||x===8853||x===8857||x===8869||x===8895||x===8978||x>=9312&&x<=9449||x>=9451&&x<=9547||x>=9552&&x<=9587||x>=9600&&x<=9615||x>=9618&&x<=9621||x===9632||x===9633||x>=9635&&x<=9641||x===9650||x===9651||x===9654||x===9655||x===9660||x===9661||x===9664||x===9665||x>=9670&&x<=9672||x===9675||x>=9678&&x<=9681||x>=9698&&x<=9701||x===9711||x===9733||x===9734||x===9737||x===9742||x===9743||x===9756||x===9758||x===9792||x===9794||x===9824||x===9825||x>=9827&&x<=9829||x>=9831&&x<=9834||x===9836||x===9837||x===9839||x===9886||x===9887||x===9919||x>=9926&&x<=9933||x>=9935&&x<=9939||x>=9941&&x<=9953||x===9955||x===9960||x===9961||x>=9963&&x<=9969||x===9972||x>=9974&&x<=9977||x===9979||x===9980||x===9982||x===9983||x===10045||x>=10102&&x<=10111||x>=11094&&x<=11097||x>=12872&&x<=12879||x>=57344&&x<=63743||x>=65024&&x<=65039||x===65533||x>=127232&&x<=127242||x>=127248&&x<=127277||x>=127280&&x<=127337||x>=127344&&x<=127373||x===127375||x===127376||x>=127387&&x<=127404||x>=917760&&x<=917999||x>=983040&&x<=1048573||x>=1048576&&x<=1114109}function isFullWidth(x){return x===12288||x>=65281&&x<=65376||x>=65504&&x<=65510}function isWide(x){return x>=4352&&x<=4447||x===8986||x===8987||x===9001||x===9002||x>=9193&&x<=9196||x===9200||x===9203||x===9725||x===9726||x===9748||x===9749||x>=9776&&x<=9783||x>=9800&&x<=9811||x===9855||x>=9866&&x<=9871||x===9875||x===9889||x===9898||x===9899||x===9917||x===9918||x===9924||x===9925||x===9934||x===9940||x===9962||x===9970||x===9971||x===9973||x===9978||x===9981||x===9989||x===9994||x===9995||x===10024||x===10060||x===10062||x>=10067&&x<=10069||x===10071||x>=10133&&x<=10135||x===10160||x===10175||x===11035||x===11036||x===11088||x===11093||x>=11904&&x<=11929||x>=11931&&x<=12019||x>=12032&&x<=12245||x>=12272&&x<=12287||x>=12289&&x<=12350||x>=12353&&x<=12438||x>=12441&&x<=12543||x>=12549&&x<=12591||x>=12593&&x<=12686||x>=12688&&x<=12773||x>=12783&&x<=12830||x>=12832&&x<=12871||x>=12880&&x<=42124||x>=42128&&x<=42182||x>=43360&&x<=43388||x>=44032&&x<=55203||x>=63744&&x<=64255||x>=65040&&x<=65049||x>=65072&&x<=65106||x>=65108&&x<=65126||x>=65128&&x<=65131||x>=94176&&x<=94180||x===94192||x===94193||x>=94208&&x<=100343||x>=100352&&x<=101589||x>=101631&&x<=101640||x>=110576&&x<=110579||x>=110581&&x<=110587||x===110589||x===110590||x>=110592&&x<=110882||x===110898||x>=110928&&x<=110930||x===110933||x>=110948&&x<=110951||x>=110960&&x<=111355||x>=119552&&x<=119638||x>=119648&&x<=119670||x===126980||x===127183||x===127374||x>=127377&&x<=127386||x>=127488&&x<=127490||x>=127504&&x<=127547||x>=127552&&x<=127560||x===127568||x===127569||x>=127584&&x<=127589||x>=127744&&x<=127776||x>=127789&&x<=127797||x>=127799&&x<=127868||x>=127870&&x<=127891||x>=127904&&x<=127946||x>=127951&&x<=127955||x>=127968&&x<=127984||x===127988||x>=127992&&x<=128062||x===128064||x>=128066&&x<=128252||x>=128255&&x<=128317||x>=128331&&x<=128334||x>=128336&&x<=128359||x===128378||x===128405||x===128406||x===128420||x>=128507&&x<=128591||x>=128640&&x<=128709||x===128716||x>=128720&&x<=128722||x>=128725&&x<=128727||x>=128732&&x<=128735||x===128747||x===128748||x>=128756&&x<=128764||x>=128992&&x<=129003||x===129008||x>=129292&&x<=129338||x>=129340&&x<=129349||x>=129351&&x<=129535||x>=129648&&x<=129660||x>=129664&&x<=129673||x>=129679&&x<=129734||x>=129742&&x<=129756||x>=129759&&x<=129769||x>=129776&&x<=129784||x>=131072&&x<=196605||x>=196608&&x<=262141}function validate(codePoint){if(!Number.isSafeInteger(codePoint))throw new TypeError(`Expected a code point, got \`${typeof codePoint}\`.`)}function eastAsianWidth(codePoint,{ambiguousAsWide=!1}={}){return validate(codePoint),isFullWidth(codePoint)||isWide(codePoint)||ambiguousAsWide&&isAmbiguous(codePoint)?2:1}var emoji_regex_default=()=>/[#*0-9]\uFE0F?\u20E3|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26AA\u26B0\u26B1\u26BD\u26BE\u26C4\u26C8\u26CF\u26D1\u26E9\u26F0-\u26F5\u26F7\u26F8\u26FA\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B55\u3030\u303D\u3297\u3299]\uFE0F?|[\u261D\u270C\u270D](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?|[\u270A\u270B](?:\uD83C[\uDFFB-\uDFFF])?|[\u23E9-\u23EC\u23F0\u23F3\u25FD\u2693\u26A1\u26AB\u26C5\u26CE\u26D4\u26EA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2795-\u2797\u27B0\u27BF\u2B50]|\u26D3\uFE0F?(?:\u200D\uD83D\uDCA5)?|\u26F9(?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|\u2764\uFE0F?(?:\u200D(?:\uD83D\uDD25|\uD83E\uDE79))?|\uD83C(?:[\uDC04\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]\uFE0F?|[\uDF85\uDFC2\uDFC7](?:\uD83C[\uDFFB-\uDFFF])?|[\uDFC4\uDFCA](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDFCB\uDFCC](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF43\uDF45-\uDF4A\uDF4C-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uDDE6\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF]|\uDDE7\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF]|\uDDE8\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF7\uDDFA-\uDDFF]|\uDDE9\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF]|\uDDEA\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA]|\uDDEB\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7]|\uDDEC\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE]|\uDDED\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA]|\uDDEE\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9]|\uDDEF\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5]|\uDDF0\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF]|\uDDF1\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE]|\uDDF2\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF]|\uDDF3\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF]|\uDDF4\uD83C\uDDF2|\uDDF5\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE]|\uDDF6\uD83C\uDDE6|\uDDF7\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC]|\uDDF8\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF]|\uDDF9\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF]|\uDDFA\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF]|\uDDFB\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA]|\uDDFC\uD83C[\uDDEB\uDDF8]|\uDDFD\uD83C\uDDF0|\uDDFE\uD83C[\uDDEA\uDDF9]|\uDDFF\uD83C[\uDDE6\uDDF2\uDDFC]|\uDF44(?:\u200D\uD83D\uDFEB)?|\uDF4B(?:\u200D\uD83D\uDFE9)?|\uDFC3(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDFF3\uFE0F?(?:\u200D(?:\u26A7\uFE0F?|\uD83C\uDF08))?|\uDFF4(?:\u200D\u2620\uFE0F?|\uDB40\uDC67\uDB40\uDC62\uDB40(?:\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDC73\uDB40\uDC63\uDB40\uDC74|\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F)?)|\uD83D(?:[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3]\uFE0F?|[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC](?:\uD83C[\uDFFB-\uDFFF])?|[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4\uDEB5](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD74\uDD90](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?|[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC25\uDC27-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE41\uDE43\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEDC-\uDEDF\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB\uDFF0]|\uDC08(?:\u200D\u2B1B)?|\uDC15(?:\u200D\uD83E\uDDBA)?|\uDC26(?:\u200D(?:\u2B1B|\uD83D\uDD25))?|\uDC3B(?:\u200D\u2744\uFE0F?)?|\uDC41\uFE0F?(?:\u200D\uD83D\uDDE8\uFE0F?)?|\uDC68(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDC68\uDC69]\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFE])))?))?|\uDC69(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?[\uDC68\uDC69]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?|\uDC69\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?))|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFE])))?))?|\uDC6F(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDD75(?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDE2E(?:\u200D\uD83D\uDCA8)?|\uDE35(?:\u200D\uD83D\uDCAB)?|\uDE36(?:\u200D\uD83C\uDF2B\uFE0F?)?|\uDE42(?:\u200D[\u2194\u2195]\uFE0F?)?|\uDEB6(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?)|\uD83E(?:[\uDD0C\uDD0F\uDD18-\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5\uDEC3-\uDEC5\uDEF0\uDEF2-\uDEF8](?:\uD83C[\uDFFB-\uDFFF])?|[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD\uDDCF\uDDD4\uDDD6-\uDDDD](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDDDE\uDDDF](?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD0D\uDD0E\uDD10-\uDD17\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCC\uDDD0\uDDE0-\uDDFF\uDE70-\uDE7C\uDE80-\uDE89\uDE8F-\uDEC2\uDEC6\uDECE-\uDEDC\uDEDF-\uDEE9]|\uDD3C(?:\u200D[\u2640\u2642]\uFE0F?|\uD83C[\uDFFB-\uDFFF])?|\uDDCE(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDDD1(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1|\uDDD1\u200D\uD83E\uDDD2(?:\u200D\uD83E\uDDD2)?|\uDDD2(?:\u200D\uD83E\uDDD2)?))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFC-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFD-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFD\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFE]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?))?|\uDEF1(?:\uD83C(?:\uDFFB(?:\u200D\uD83E\uDEF2\uD83C[\uDFFC-\uDFFF])?|\uDFFC(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFD-\uDFFF])?|\uDFFD(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])?|\uDFFE(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFD\uDFFF])?|\uDFFF(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFE])?))?)/g;var segmenter=new Intl.Segmenter,defaultIgnorableCodePointRegex=new RegExp("^\\p{Default_Ignorable_Code_Point}$","u");function stringWidth(string,options={}){if(typeof string!="string"||string.length===0)return 0;let{ambiguousIsNarrow=!0,countAnsiEscapeCodes=!1}=options;if(countAnsiEscapeCodes||(string=stripAnsi(string)),string.length===0)return 0;let width=0,eastAsianWidthOptions={ambiguousAsWide:!ambiguousIsNarrow};for(let{segment:character}of segmenter.segment(string)){let codePoint=character.codePointAt(0);if(!(codePoint<=31||codePoint>=127&&codePoint<=159)&&!(codePoint>=8203&&codePoint<=8207||codePoint===65279)&&!(codePoint>=768&&codePoint<=879||codePoint>=6832&&codePoint<=6911||codePoint>=7616&&codePoint<=7679||codePoint>=8400&&codePoint<=8447||codePoint>=65056&&codePoint<=65071)&&!(codePoint>=55296&&codePoint<=57343)&&!(codePoint>=65024&&codePoint<=65039)&&!defaultIgnorableCodePointRegex.test(character)){if(emoji_regex_default().test(character)){width+=2;continue}width+=eastAsianWidth(codePoint,eastAsianWidthOptions);}}return width}var wrapAnsi16=(offset=0)=>code=>`\x1B[${code+offset}m`,wrapAnsi256=(offset=0)=>code=>`\x1B[${38+offset};5;${code}m`,wrapAnsi16m=(offset=0)=>(red,green,blue)=>`\x1B[${38+offset};2;${red};${green};${blue}m`,styles={modifier:{reset:[0,0],bold:[1,22],dim:[2,22],italic:[3,23],underline:[4,24],overline:[53,55],inverse:[7,27],hidden:[8,28],strikethrough:[9,29]},color:{black:[30,39],red:[31,39],green:[32,39],yellow:[33,39],blue:[34,39],magenta:[35,39],cyan:[36,39],white:[37,39],blackBright:[90,39],gray:[90,39],grey:[90,39],redBright:[91,39],greenBright:[92,39],yellowBright:[93,39],blueBright:[94,39],magentaBright:[95,39],cyanBright:[96,39],whiteBright:[97,39]},bgColor:{bgBlack:[40,49],bgRed:[41,49],bgGreen:[42,49],bgYellow:[43,49],bgBlue:[44,49],bgMagenta:[45,49],bgCyan:[46,49],bgWhite:[47,49],bgBlackBright:[100,49],bgGray:[100,49],bgGrey:[100,49],bgRedBright:[101,49],bgGreenBright:[102,49],bgYellowBright:[103,49],bgBlueBright:[104,49],bgMagentaBright:[105,49],bgCyanBright:[106,49],bgWhiteBright:[107,49]}};Object.keys(styles.modifier);var foregroundColorNames=Object.keys(styles.color),backgroundColorNames=Object.keys(styles.bgColor);[...foregroundColorNames,...backgroundColorNames];function assembleStyles(){let codes=new Map;for(let[groupName,group]of Object.entries(styles)){for(let[styleName,style]of Object.entries(group))styles[styleName]={open:`\x1B[${style[0]}m`,close:`\x1B[${style[1]}m`},group[styleName]=styles[styleName],codes.set(style[0],style[1]);Object.defineProperty(styles,groupName,{value:group,enumerable:!1});}return Object.defineProperty(styles,"codes",{value:codes,enumerable:!1}),styles.color.close="\x1B[39m",styles.bgColor.close="\x1B[49m",styles.color.ansi=wrapAnsi16(),styles.color.ansi256=wrapAnsi256(),styles.color.ansi16m=wrapAnsi16m(),styles.bgColor.ansi=wrapAnsi16(10),styles.bgColor.ansi256=wrapAnsi256(10),styles.bgColor.ansi16m=wrapAnsi16m(10),Object.defineProperties(styles,{rgbToAnsi256:{value(red,green,blue){return red===green&&green===blue?red<8?16:red>248?231:Math.round((red-8)/247*24)+232:16+36*Math.round(red/255*5)+6*Math.round(green/255*5)+Math.round(blue/255*5)},enumerable:!1},hexToRgb:{value(hex){let matches=/[a-f\d]{6}|[a-f\d]{3}/i.exec(hex.toString(16));if(!matches)return [0,0,0];let[colorString]=matches;colorString.length===3&&(colorString=[...colorString].map(character=>character+character).join(""));let integer=Number.parseInt(colorString,16);return [integer>>16&255,integer>>8&255,integer&255]},enumerable:!1},hexToAnsi256:{value:hex=>styles.rgbToAnsi256(...styles.hexToRgb(hex)),enumerable:!1},ansi256ToAnsi:{value(code){if(code<8)return 30+code;if(code<16)return 90+(code-8);let red,green,blue;if(code>=232)red=((code-232)*10+8)/255,green=red,blue=red;else {code-=16;let remainder=code%36;red=Math.floor(code/36)/5,green=Math.floor(remainder/6)/5,blue=remainder%6/5;}let value=Math.max(red,green,blue)*2;if(value===0)return 30;let result=30+(Math.round(blue)<<2|Math.round(green)<<1|Math.round(red));return value===2&&(result+=60),result},enumerable:!1},rgbToAnsi:{value:(red,green,blue)=>styles.ansi256ToAnsi(styles.rgbToAnsi256(red,green,blue)),enumerable:!1},hexToAnsi:{value:hex=>styles.ansi256ToAnsi(styles.hexToAnsi256(hex)),enumerable:!1}}),styles}var ansiStyles=assembleStyles(),ansi_styles_default=ansiStyles;function hasFlag(flag,argv=globalThis.Deno?globalThis.Deno.args:process2__default.default.argv){let prefix=flag.startsWith("-")?"":flag.length===1?"-":"--",position=argv.indexOf(prefix+flag),terminatorPosition=argv.indexOf("--");return position!==-1&&(terminatorPosition===-1||position<terminatorPosition)}var{env}=process2__default.default,flagForceColor;hasFlag("no-color")||hasFlag("no-colors")||hasFlag("color=false")||hasFlag("color=never")?flagForceColor=0:(hasFlag("color")||hasFlag("colors")||hasFlag("color=true")||hasFlag("color=always"))&&(flagForceColor=1);function envForceColor(){if("FORCE_COLOR"in env)return env.FORCE_COLOR==="true"?1:env.FORCE_COLOR==="false"?0:env.FORCE_COLOR.length===0?1:Math.min(Number.parseInt(env.FORCE_COLOR,10),3)}function translateLevel(level){return level===0?!1:{level,hasBasic:!0,has256:level>=2,has16m:level>=3}}function _supportsColor(haveStream,{streamIsTTY,sniffFlags=!0}={}){let noFlagForceColor=envForceColor();noFlagForceColor!==void 0&&(flagForceColor=noFlagForceColor);let forceColor=sniffFlags?flagForceColor:noFlagForceColor;if(forceColor===0)return 0;if(sniffFlags){if(hasFlag("color=16m")||hasFlag("color=full")||hasFlag("color=truecolor"))return 3;if(hasFlag("color=256"))return 2}if("TF_BUILD"in env&&"AGENT_NAME"in env)return 1;if(haveStream&&!streamIsTTY&&forceColor===void 0)return 0;let min=forceColor||0;if(env.TERM==="dumb")return min;if(process2__default.default.platform==="win32"){let osRelease=os__default.default.release().split(".");return Number(osRelease[0])>=10&&Number(osRelease[2])>=10586?Number(osRelease[2])>=14931?3:2:1}if("CI"in env)return ["GITHUB_ACTIONS","GITEA_ACTIONS","CIRCLECI"].some(key=>key in env)?3:["TRAVIS","APPVEYOR","GITLAB_CI","BUILDKITE","DRONE"].some(sign=>sign in env)||env.CI_NAME==="codeship"?1:min;if("TEAMCITY_VERSION"in env)return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION)?1:0;if(env.COLORTERM==="truecolor"||env.TERM==="xterm-kitty")return 3;if("TERM_PROGRAM"in env){let version=Number.parseInt((env.TERM_PROGRAM_VERSION||"").split(".")[0],10);switch(env.TERM_PROGRAM){case"iTerm.app":return version>=3?3:2;case"Apple_Terminal":return 2}}return /-256(color)?$/i.test(env.TERM)?2:/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)||"COLORTERM"in env?1:min}function createSupportsColor(stream,options={}){let level=_supportsColor(stream,{streamIsTTY:stream&&stream.isTTY,...options});return translateLevel(level)}var supportsColor={stdout:createSupportsColor({isTTY:tty__default.default.isatty(1)}),stderr:createSupportsColor({isTTY:tty__default.default.isatty(2)})},supports_color_default=supportsColor;function stringReplaceAll(string,substring,replacer){let index=string.indexOf(substring);if(index===-1)return string;let substringLength=substring.length,endIndex=0,returnValue="";do returnValue+=string.slice(endIndex,index)+substring+replacer,endIndex=index+substringLength,index=string.indexOf(substring,endIndex);while(index!==-1);return returnValue+=string.slice(endIndex),returnValue}function stringEncaseCRLFWithFirstIndex(string,prefix,postfix,index){let endIndex=0,returnValue="";do{let gotCR=string[index-1]==="\r";returnValue+=string.slice(endIndex,gotCR?index-1:index)+prefix+(gotCR?`\r
`:`
`)+postfix,endIndex=index+1,index=string.indexOf(`
`,endIndex);}while(index!==-1);return returnValue+=string.slice(endIndex),returnValue}var{stdout:stdoutColor,stderr:stderrColor}=supports_color_default,GENERATOR=Symbol("GENERATOR"),STYLER=Symbol("STYLER"),IS_EMPTY=Symbol("IS_EMPTY"),levelMapping=["ansi","ansi","ansi256","ansi16m"],styles2=Object.create(null),applyOptions=(object,options={})=>{if(options.level&&!(Number.isInteger(options.level)&&options.level>=0&&options.level<=3))throw new Error("The `level` option should be an integer from 0 to 3");let colorLevel=stdoutColor?stdoutColor.level:0;object.level=options.level===void 0?colorLevel:options.level;};var chalkFactory=options=>{let chalk2=(...strings)=>strings.join(" ");return applyOptions(chalk2,options),Object.setPrototypeOf(chalk2,createChalk.prototype),chalk2};function createChalk(options){return chalkFactory(options)}Object.setPrototypeOf(createChalk.prototype,Function.prototype);for(let[styleName,style]of Object.entries(ansi_styles_default))styles2[styleName]={get(){let builder=createBuilder(this,createStyler(style.open,style.close,this[STYLER]),this[IS_EMPTY]);return Object.defineProperty(this,styleName,{value:builder}),builder}};styles2.visible={get(){let builder=createBuilder(this,this[STYLER],!0);return Object.defineProperty(this,"visible",{value:builder}),builder}};var getModelAnsi=(model,level,type,...arguments_)=>model==="rgb"?level==="ansi16m"?ansi_styles_default[type].ansi16m(...arguments_):level==="ansi256"?ansi_styles_default[type].ansi256(ansi_styles_default.rgbToAnsi256(...arguments_)):ansi_styles_default[type].ansi(ansi_styles_default.rgbToAnsi(...arguments_)):model==="hex"?getModelAnsi("rgb",level,type,...ansi_styles_default.hexToRgb(...arguments_)):ansi_styles_default[type][model](...arguments_),usedModels=["rgb","hex","ansi256"];for(let model of usedModels){styles2[model]={get(){let{level}=this;return function(...arguments_){let styler=createStyler(getModelAnsi(model,levelMapping[level],"color",...arguments_),ansi_styles_default.color.close,this[STYLER]);return createBuilder(this,styler,this[IS_EMPTY])}}};let bgModel="bg"+model[0].toUpperCase()+model.slice(1);styles2[bgModel]={get(){let{level}=this;return function(...arguments_){let styler=createStyler(getModelAnsi(model,levelMapping[level],"bgColor",...arguments_),ansi_styles_default.bgColor.close,this[STYLER]);return createBuilder(this,styler,this[IS_EMPTY])}}};}var proto=Object.defineProperties(()=>{},{...styles2,level:{enumerable:!0,get(){return this[GENERATOR].level},set(level){this[GENERATOR].level=level;}}}),createStyler=(open,close,parent)=>{let openAll,closeAll;return parent===void 0?(openAll=open,closeAll=close):(openAll=parent.openAll+open,closeAll=close+parent.closeAll),{open,close,openAll,closeAll,parent}},createBuilder=(self,_styler,_isEmpty)=>{let builder=(...arguments_)=>applyStyle(builder,arguments_.length===1?""+arguments_[0]:arguments_.join(" "));return Object.setPrototypeOf(builder,proto),builder[GENERATOR]=self,builder[STYLER]=_styler,builder[IS_EMPTY]=_isEmpty,builder},applyStyle=(self,string)=>{if(self.level<=0||!string)return self[IS_EMPTY]?"":string;let styler=self[STYLER];if(styler===void 0)return string;let{openAll,closeAll}=styler;if(string.includes("\x1B"))for(;styler!==void 0;)string=stringReplaceAll(string,styler.close,styler.open),styler=styler.parent;let lfIndex=string.indexOf(`
`);return lfIndex!==-1&&(string=stringEncaseCRLFWithFirstIndex(string,closeAll,openAll,lfIndex)),openAll+string+closeAll};Object.defineProperties(createChalk.prototype,styles2);var chalk=createChalk();createChalk({level:stderrColor?stderrColor.level:0});var source_default=chalk;var emoji_regex_default2=()=>/[#*0-9]\uFE0F?\u20E3|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26AA\u26B0\u26B1\u26BD\u26BE\u26C4\u26C8\u26CF\u26D1\u26E9\u26F0-\u26F5\u26F7\u26F8\u26FA\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2757\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B55\u3030\u303D\u3297\u3299]\uFE0F?|[\u261D\u270C\u270D](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?|[\u270A\u270B](?:\uD83C[\uDFFB-\uDFFF])?|[\u23E9-\u23EC\u23F0\u23F3\u25FD\u2693\u26A1\u26AB\u26C5\u26CE\u26D4\u26EA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2795-\u2797\u27B0\u27BF\u2B50]|\u26D3\uFE0F?(?:\u200D\uD83D\uDCA5)?|\u26F9(?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|\u2764\uFE0F?(?:\u200D(?:\uD83D\uDD25|\uD83E\uDE79))?|\uD83C(?:[\uDC04\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]\uFE0F?|[\uDF85\uDFC2\uDFC7](?:\uD83C[\uDFFB-\uDFFF])?|[\uDFC4\uDFCA](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDFCB\uDFCC](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF43\uDF45-\uDF4A\uDF4C-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uDDE6\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF]|\uDDE7\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF]|\uDDE8\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF7\uDDFA-\uDDFF]|\uDDE9\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF]|\uDDEA\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA]|\uDDEB\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7]|\uDDEC\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE]|\uDDED\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA]|\uDDEE\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9]|\uDDEF\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5]|\uDDF0\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF]|\uDDF1\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE]|\uDDF2\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF]|\uDDF3\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF]|\uDDF4\uD83C\uDDF2|\uDDF5\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE]|\uDDF6\uD83C\uDDE6|\uDDF7\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC]|\uDDF8\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF]|\uDDF9\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF]|\uDDFA\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF]|\uDDFB\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA]|\uDDFC\uD83C[\uDDEB\uDDF8]|\uDDFD\uD83C\uDDF0|\uDDFE\uD83C[\uDDEA\uDDF9]|\uDDFF\uD83C[\uDDE6\uDDF2\uDDFC]|\uDF44(?:\u200D\uD83D\uDFEB)?|\uDF4B(?:\u200D\uD83D\uDFE9)?|\uDFC3(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDFF3\uFE0F?(?:\u200D(?:\u26A7\uFE0F?|\uD83C\uDF08))?|\uDFF4(?:\u200D\u2620\uFE0F?|\uDB40\uDC67\uDB40\uDC62\uDB40(?:\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDC73\uDB40\uDC63\uDB40\uDC74|\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F)?)|\uD83D(?:[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3]\uFE0F?|[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC](?:\uD83C[\uDFFB-\uDFFF])?|[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4\uDEB5](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD74\uDD90](?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?|[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC25\uDC27-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE41\uDE43\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEDC-\uDEDF\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB\uDFF0]|\uDC08(?:\u200D\u2B1B)?|\uDC15(?:\u200D\uD83E\uDDBA)?|\uDC26(?:\u200D(?:\u2B1B|\uD83D\uDD25))?|\uDC3B(?:\u200D\u2744\uFE0F?)?|\uDC41\uFE0F?(?:\u200D\uD83D\uDDE8\uFE0F?)?|\uDC68(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDC68\uDC69]\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?)|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?\uDC68\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D\uDC68\uD83C[\uDFFB-\uDFFE])))?))?|\uDC69(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:\uDC8B\u200D\uD83D)?[\uDC68\uDC69]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D(?:[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?|\uDC69\u200D\uD83D(?:\uDC66(?:\u200D\uD83D\uDC66)?|\uDC67(?:\u200D\uD83D[\uDC66\uDC67])?))|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFC-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFD-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFD\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D\uD83D(?:[\uDC68\uDC69]|\uDC8B\u200D\uD83D[\uDC68\uDC69])\uD83C[\uDFFB-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83D[\uDC68\uDC69]\uD83C[\uDFFB-\uDFFE])))?))?|\uDC6F(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDD75(?:\uD83C[\uDFFB-\uDFFF]|\uFE0F)?(?:\u200D[\u2640\u2642]\uFE0F?)?|\uDE2E(?:\u200D\uD83D\uDCA8)?|\uDE35(?:\u200D\uD83D\uDCAB)?|\uDE36(?:\u200D\uD83C\uDF2B\uFE0F?)?|\uDE42(?:\u200D[\u2194\u2195]\uFE0F?)?|\uDEB6(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?)|\uD83E(?:[\uDD0C\uDD0F\uDD18-\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5\uDEC3-\uDEC5\uDEF0\uDEF2-\uDEF8](?:\uD83C[\uDFFB-\uDFFF])?|[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD\uDDCF\uDDD4\uDDD6-\uDDDD](?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDDDE\uDDDF](?:\u200D[\u2640\u2642]\uFE0F?)?|[\uDD0D\uDD0E\uDD10-\uDD17\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCC\uDDD0\uDDE0-\uDDFF\uDE70-\uDE7C\uDE80-\uDE89\uDE8F-\uDEC2\uDEC6\uDECE-\uDEDC\uDEDF-\uDEE9]|\uDD3C(?:\u200D[\u2640\u2642]\uFE0F?|\uD83C[\uDFFB-\uDFFF])?|\uDDCE(?:\uD83C[\uDFFB-\uDFFF])?(?:\u200D(?:[\u2640\u2642]\uFE0F?(?:\u200D\u27A1\uFE0F?)?|\u27A1\uFE0F?))?|\uDDD1(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1|\uDDD1\u200D\uD83E\uDDD2(?:\u200D\uD83E\uDDD2)?|\uDDD2(?:\u200D\uD83E\uDDD2)?))|\uD83C(?:\uDFFB(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFC-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFC(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFD-\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFD(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFE(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFD\uDFFF]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?|\uDFFF(?:\u200D(?:[\u2695\u2696\u2708]\uFE0F?|\u2764\uFE0F?\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1\uD83C[\uDFFB-\uDFFE]|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E(?:[\uDDAF\uDDBC\uDDBD](?:\u200D\u27A1\uFE0F?)?|[\uDDB0-\uDDB3]|\uDD1D\u200D\uD83E\uDDD1\uD83C[\uDFFB-\uDFFF])))?))?|\uDEF1(?:\uD83C(?:\uDFFB(?:\u200D\uD83E\uDEF2\uD83C[\uDFFC-\uDFFF])?|\uDFFC(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFD-\uDFFF])?|\uDFFD(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])?|\uDFFE(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFD\uDFFF])?|\uDFFF(?:\u200D\uD83E\uDEF2\uD83C[\uDFFB-\uDFFE])?))?)/g;var segmenter2=new Intl.Segmenter,defaultIgnorableCodePointRegex2=new RegExp("^\\p{Default_Ignorable_Code_Point}$","u");function stringWidth2(string,options={}){if(typeof string!="string"||string.length===0)return 0;let{ambiguousIsNarrow=!0,countAnsiEscapeCodes=!1}=options;if(countAnsiEscapeCodes||(string=stripAnsi(string)),string.length===0)return 0;let width=0,eastAsianWidthOptions={ambiguousAsWide:!ambiguousIsNarrow};for(let{segment:character}of segmenter2.segment(string)){let codePoint=character.codePointAt(0);if(!(codePoint<=31||codePoint>=127&&codePoint<=159)&&!(codePoint>=8203&&codePoint<=8207||codePoint===65279)&&!(codePoint>=768&&codePoint<=879||codePoint>=6832&&codePoint<=6911||codePoint>=7616&&codePoint<=7679||codePoint>=8400&&codePoint<=8447||codePoint>=65056&&codePoint<=65071)&&!(codePoint>=55296&&codePoint<=57343)&&!(codePoint>=65024&&codePoint<=65039)&&!defaultIgnorableCodePointRegex2.test(character)){if(emoji_regex_default2().test(character)){width+=2;continue}width+=eastAsianWidth(codePoint,eastAsianWidthOptions);}}return width}function widestLine(string){let lineWidth=0;for(let line of string.split(`
`))lineWidth=Math.max(lineWidth,stringWidth2(line));return lineWidth}var import_cli_boxes=__toESM(require_cli_boxes(),1);var UPPERCASE=/[\p{Lu}]/u,LOWERCASE=/[\p{Ll}]/u,LEADING_CAPITAL=/^[\p{Lu}](?![\p{Lu}])/gu,IDENTIFIER=/([\p{Alpha}\p{N}_]|$)/u,SEPARATORS=/[_.\- ]+/,LEADING_SEPARATORS=new RegExp("^"+SEPARATORS.source),SEPARATORS_AND_IDENTIFIER=new RegExp(SEPARATORS.source+IDENTIFIER.source,"gu"),NUMBERS_AND_IDENTIFIER=new RegExp("\\d+"+IDENTIFIER.source,"gu"),preserveCamelCase=(string,toLowerCase,toUpperCase,preserveConsecutiveUppercase2)=>{let isLastCharLower=!1,isLastCharUpper=!1,isLastLastCharUpper=!1,isLastLastCharPreserved=!1;for(let index=0;index<string.length;index++){let character=string[index];isLastLastCharPreserved=index>2?string[index-3]==="-":!0,isLastCharLower&&UPPERCASE.test(character)?(string=string.slice(0,index)+"-"+string.slice(index),isLastCharLower=!1,isLastLastCharUpper=isLastCharUpper,isLastCharUpper=!0,index++):isLastCharUpper&&isLastLastCharUpper&&LOWERCASE.test(character)&&(!isLastLastCharPreserved||preserveConsecutiveUppercase2)?(string=string.slice(0,index-1)+"-"+string.slice(index-1),isLastLastCharUpper=isLastCharUpper,isLastCharUpper=!1,isLastCharLower=!0):(isLastCharLower=toLowerCase(character)===character&&toUpperCase(character)!==character,isLastLastCharUpper=isLastCharUpper,isLastCharUpper=toUpperCase(character)===character&&toLowerCase(character)!==character);}return string},preserveConsecutiveUppercase=(input,toLowerCase)=>(LEADING_CAPITAL.lastIndex=0,input.replaceAll(LEADING_CAPITAL,match=>toLowerCase(match))),postProcess=(input,toUpperCase)=>(SEPARATORS_AND_IDENTIFIER.lastIndex=0,NUMBERS_AND_IDENTIFIER.lastIndex=0,input.replaceAll(NUMBERS_AND_IDENTIFIER,(match,pattern,offset)=>["_","-"].includes(input.charAt(offset+match.length))?match:toUpperCase(match)).replaceAll(SEPARATORS_AND_IDENTIFIER,(_,identifier)=>toUpperCase(identifier)));function camelCase(input,options){if(!(typeof input=="string"||Array.isArray(input)))throw new TypeError("Expected the input to be `string | string[]`");if(options={pascalCase:!1,preserveConsecutiveUppercase:!1,...options},Array.isArray(input)?input=input.map(x=>x.trim()).filter(x=>x.length).join("-"):input=input.trim(),input.length===0)return "";let toLowerCase=options.locale===!1?string=>string.toLowerCase():string=>string.toLocaleLowerCase(options.locale),toUpperCase=options.locale===!1?string=>string.toUpperCase():string=>string.toLocaleUpperCase(options.locale);return input.length===1?SEPARATORS.test(input)?"":options.pascalCase?toUpperCase(input):toLowerCase(input):(input!==toLowerCase(input)&&(input=preserveCamelCase(input,toLowerCase,toUpperCase,options.preserveConsecutiveUppercase)),input=input.replace(LEADING_SEPARATORS,""),input=options.preserveConsecutiveUppercase?preserveConsecutiveUppercase(input,toLowerCase):toLowerCase(input),options.pascalCase&&(input=toUpperCase(input.charAt(0))+input.slice(1)),postProcess(input,toUpperCase))}var import_ansi_align=__toESM(require_ansi_align(),1);var wrapAnsi162=(offset=0)=>code=>`\x1B[${code+offset}m`,wrapAnsi2562=(offset=0)=>code=>`\x1B[${38+offset};5;${code}m`,wrapAnsi16m2=(offset=0)=>(red,green,blue)=>`\x1B[${38+offset};2;${red};${green};${blue}m`,styles3={modifier:{reset:[0,0],bold:[1,22],dim:[2,22],italic:[3,23],underline:[4,24],overline:[53,55],inverse:[7,27],hidden:[8,28],strikethrough:[9,29]},color:{black:[30,39],red:[31,39],green:[32,39],yellow:[33,39],blue:[34,39],magenta:[35,39],cyan:[36,39],white:[37,39],blackBright:[90,39],gray:[90,39],grey:[90,39],redBright:[91,39],greenBright:[92,39],yellowBright:[93,39],blueBright:[94,39],magentaBright:[95,39],cyanBright:[96,39],whiteBright:[97,39]},bgColor:{bgBlack:[40,49],bgRed:[41,49],bgGreen:[42,49],bgYellow:[43,49],bgBlue:[44,49],bgMagenta:[45,49],bgCyan:[46,49],bgWhite:[47,49],bgBlackBright:[100,49],bgGray:[100,49],bgGrey:[100,49],bgRedBright:[101,49],bgGreenBright:[102,49],bgYellowBright:[103,49],bgBlueBright:[104,49],bgMagentaBright:[105,49],bgCyanBright:[106,49],bgWhiteBright:[107,49]}};Object.keys(styles3.modifier);var foregroundColorNames2=Object.keys(styles3.color),backgroundColorNames2=Object.keys(styles3.bgColor);[...foregroundColorNames2,...backgroundColorNames2];function assembleStyles2(){let codes=new Map;for(let[groupName,group]of Object.entries(styles3)){for(let[styleName,style]of Object.entries(group))styles3[styleName]={open:`\x1B[${style[0]}m`,close:`\x1B[${style[1]}m`},group[styleName]=styles3[styleName],codes.set(style[0],style[1]);Object.defineProperty(styles3,groupName,{value:group,enumerable:!1});}return Object.defineProperty(styles3,"codes",{value:codes,enumerable:!1}),styles3.color.close="\x1B[39m",styles3.bgColor.close="\x1B[49m",styles3.color.ansi=wrapAnsi162(),styles3.color.ansi256=wrapAnsi2562(),styles3.color.ansi16m=wrapAnsi16m2(),styles3.bgColor.ansi=wrapAnsi162(10),styles3.bgColor.ansi256=wrapAnsi2562(10),styles3.bgColor.ansi16m=wrapAnsi16m2(10),Object.defineProperties(styles3,{rgbToAnsi256:{value:(red,green,blue)=>red===green&&green===blue?red<8?16:red>248?231:Math.round((red-8)/247*24)+232:16+36*Math.round(red/255*5)+6*Math.round(green/255*5)+Math.round(blue/255*5),enumerable:!1},hexToRgb:{value:hex=>{let matches=/[a-f\d]{6}|[a-f\d]{3}/i.exec(hex.toString(16));if(!matches)return [0,0,0];let[colorString]=matches;colorString.length===3&&(colorString=[...colorString].map(character=>character+character).join(""));let integer=Number.parseInt(colorString,16);return [integer>>16&255,integer>>8&255,integer&255]},enumerable:!1},hexToAnsi256:{value:hex=>styles3.rgbToAnsi256(...styles3.hexToRgb(hex)),enumerable:!1},ansi256ToAnsi:{value:code=>{if(code<8)return 30+code;if(code<16)return 90+(code-8);let red,green,blue;if(code>=232)red=((code-232)*10+8)/255,green=red,blue=red;else {code-=16;let remainder=code%36;red=Math.floor(code/36)/5,green=Math.floor(remainder/6)/5,blue=remainder%6/5;}let value=Math.max(red,green,blue)*2;if(value===0)return 30;let result=30+(Math.round(blue)<<2|Math.round(green)<<1|Math.round(red));return value===2&&(result+=60),result},enumerable:!1},rgbToAnsi:{value:(red,green,blue)=>styles3.ansi256ToAnsi(styles3.rgbToAnsi256(red,green,blue)),enumerable:!1},hexToAnsi:{value:hex=>styles3.ansi256ToAnsi(styles3.hexToAnsi256(hex)),enumerable:!1}}),styles3}var ansiStyles2=assembleStyles2(),ansi_styles_default2=ansiStyles2;var ESCAPES=new Set(["\x1B","\x9B"]),END_CODE=39,ANSI_ESCAPE_BELL="\x07",ANSI_CSI="[",ANSI_OSC="]",ANSI_SGR_TERMINATOR="m",ANSI_ESCAPE_LINK=`${ANSI_OSC}8;;`,wrapAnsiCode=code=>`${ESCAPES.values().next().value}${ANSI_CSI}${code}${ANSI_SGR_TERMINATOR}`,wrapAnsiHyperlink=url=>`${ESCAPES.values().next().value}${ANSI_ESCAPE_LINK}${url}${ANSI_ESCAPE_BELL}`,wordLengths=string=>string.split(" ").map(character=>stringWidth(character)),wrapWord=(rows,word,columns)=>{let characters=[...word],isInsideEscape=!1,isInsideLinkEscape=!1,visible=stringWidth(stripAnsi(rows.at(-1)));for(let[index,character]of characters.entries()){let characterLength=stringWidth(character);if(visible+characterLength<=columns?rows[rows.length-1]+=character:(rows.push(character),visible=0),ESCAPES.has(character)&&(isInsideEscape=!0,isInsideLinkEscape=characters.slice(index+1,index+1+ANSI_ESCAPE_LINK.length).join("")===ANSI_ESCAPE_LINK),isInsideEscape){isInsideLinkEscape?character===ANSI_ESCAPE_BELL&&(isInsideEscape=!1,isInsideLinkEscape=!1):character===ANSI_SGR_TERMINATOR&&(isInsideEscape=!1);continue}visible+=characterLength,visible===columns&&index<characters.length-1&&(rows.push(""),visible=0);}!visible&&rows.at(-1).length>0&&rows.length>1&&(rows[rows.length-2]+=rows.pop());},stringVisibleTrimSpacesRight=string=>{let words=string.split(" "),last=words.length;for(;last>0&&!(stringWidth(words[last-1])>0);)last--;return last===words.length?string:words.slice(0,last).join(" ")+words.slice(last).join("")},exec=(string,columns,options={})=>{if(options.trim!==!1&&string.trim()==="")return "";let returnValue="",escapeCode,escapeUrl,lengths=wordLengths(string),rows=[""];for(let[index,word]of string.split(" ").entries()){options.trim!==!1&&(rows[rows.length-1]=rows.at(-1).trimStart());let rowLength=stringWidth(rows.at(-1));if(index!==0&&(rowLength>=columns&&(options.wordWrap===!1||options.trim===!1)&&(rows.push(""),rowLength=0),(rowLength>0||options.trim===!1)&&(rows[rows.length-1]+=" ",rowLength++)),options.hard&&lengths[index]>columns){let remainingColumns=columns-rowLength,breaksStartingThisLine=1+Math.floor((lengths[index]-remainingColumns-1)/columns);Math.floor((lengths[index]-1)/columns)<breaksStartingThisLine&&rows.push(""),wrapWord(rows,word,columns);continue}if(rowLength+lengths[index]>columns&&rowLength>0&&lengths[index]>0){if(options.wordWrap===!1&&rowLength<columns){wrapWord(rows,word,columns);continue}rows.push("");}if(rowLength+lengths[index]>columns&&options.wordWrap===!1){wrapWord(rows,word,columns);continue}rows[rows.length-1]+=word;}options.trim!==!1&&(rows=rows.map(row=>stringVisibleTrimSpacesRight(row)));let preString=rows.join(`
`),pre=[...preString],preStringIndex=0;for(let[index,character]of pre.entries()){if(returnValue+=character,ESCAPES.has(character)){let{groups}=new RegExp(`(?:\\${ANSI_CSI}(?<code>\\d+)m|\\${ANSI_ESCAPE_LINK}(?<uri>.*)${ANSI_ESCAPE_BELL})`).exec(preString.slice(preStringIndex))||{groups:{}};if(groups.code!==void 0){let code2=Number.parseFloat(groups.code);escapeCode=code2===END_CODE?void 0:code2;}else groups.uri!==void 0&&(escapeUrl=groups.uri.length===0?void 0:groups.uri);}let code=ansi_styles_default2.codes.get(Number(escapeCode));pre[index+1]===`
`?(escapeUrl&&(returnValue+=wrapAnsiHyperlink("")),escapeCode&&code&&(returnValue+=wrapAnsiCode(code))):character===`
`&&(escapeCode&&code&&(returnValue+=wrapAnsiCode(escapeCode)),escapeUrl&&(returnValue+=wrapAnsiHyperlink(escapeUrl))),preStringIndex+=character.length;}return returnValue};function wrapAnsi(string,columns,options){return String(string).normalize().replaceAll(`\r
`,`
`).split(`
`).map(line=>exec(line,columns,options)).join(`
`)}__toESM(require_cli_boxes(),1);var NEWLINE=`
`,PAD=" ",NONE="none",terminalColumns=()=>{let{env:env2,stdout,stderr}=process2__default.default;return stdout?.columns?stdout.columns:stderr?.columns?stderr.columns:env2.COLUMNS?Number.parseInt(env2.COLUMNS,10):80},getObject=detail=>typeof detail=="number"?{top:detail,right:detail*3,bottom:detail,left:detail*3}:{top:0,right:0,bottom:0,left:0,...detail},getBorderWidth=borderStyle=>borderStyle===NONE?0:2,getBorderChars=borderStyle=>{let sides=["topLeft","topRight","bottomRight","bottomLeft","left","right","top","bottom"],characters;if(borderStyle===NONE){borderStyle={};for(let side of sides)borderStyle[side]="";}if(typeof borderStyle=="string"){if(characters=import_cli_boxes.default[borderStyle],!characters)throw new TypeError(`Invalid border style: ${borderStyle}`)}else {typeof borderStyle?.vertical=="string"&&(borderStyle.left=borderStyle.vertical,borderStyle.right=borderStyle.vertical),typeof borderStyle?.horizontal=="string"&&(borderStyle.top=borderStyle.horizontal,borderStyle.bottom=borderStyle.horizontal);for(let side of sides)if(borderStyle[side]===null||typeof borderStyle[side]!="string")throw new TypeError(`Invalid border style: ${side}`);characters=borderStyle;}return characters},makeTitle=(text,horizontal,alignment)=>{let title="",textWidth=stringWidth(text);switch(alignment){case"left":{title=text+horizontal.slice(textWidth);break}case"right":{title=horizontal.slice(textWidth)+text;break}default:{horizontal=horizontal.slice(textWidth),horizontal.length%2===1?(horizontal=horizontal.slice(Math.floor(horizontal.length/2)),title=horizontal.slice(1)+text+horizontal):(horizontal=horizontal.slice(horizontal.length/2),title=horizontal+text+horizontal);break}}return title},makeContentText=(text,{padding,width,textAlignment,height})=>{text=(0, import_ansi_align.default)(text,{align:textAlignment});let lines=text.split(NEWLINE),textWidth=widestLine(text),max=width-padding.left-padding.right;if(textWidth>max){let newLines=[];for(let line of lines){let createdLines=wrapAnsi(line,max,{hard:!0}),alignedLinesArray=(0, import_ansi_align.default)(createdLines,{align:textAlignment}).split(`
`),longestLength=Math.max(...alignedLinesArray.map(s=>stringWidth(s)));for(let alignedLine of alignedLinesArray){let paddedLine;switch(textAlignment){case"center":{paddedLine=PAD.repeat((max-longestLength)/2)+alignedLine;break}case"right":{paddedLine=PAD.repeat(max-longestLength)+alignedLine;break}default:{paddedLine=alignedLine;break}}newLines.push(paddedLine);}}lines=newLines;}textAlignment==="center"&&textWidth<max?lines=lines.map(line=>PAD.repeat((max-textWidth)/2)+line):textAlignment==="right"&&textWidth<max&&(lines=lines.map(line=>PAD.repeat(max-textWidth)+line));let paddingLeft=PAD.repeat(padding.left),paddingRight=PAD.repeat(padding.right);return lines=lines.map(line=>{let newLine=paddingLeft+line+paddingRight;return newLine+PAD.repeat(width-stringWidth(newLine))}),padding.top>0&&(lines=[...Array.from({length:padding.top}).fill(PAD.repeat(width)),...lines]),padding.bottom>0&&(lines=[...lines,...Array.from({length:padding.bottom}).fill(PAD.repeat(width))]),height&&lines.length>height?lines=lines.slice(0,height):height&&lines.length<height&&(lines=[...lines,...Array.from({length:height-lines.length}).fill(PAD.repeat(width))]),lines.join(NEWLINE)},boxContent=(content,contentWidth,options)=>{let colorizeBorder=border=>{let newBorder=options.borderColor?getColorFunction(options.borderColor)(border):border;return options.dimBorder?source_default.dim(newBorder):newBorder},colorizeContent=content2=>options.backgroundColor?getBGColorFunction(options.backgroundColor)(content2):content2,chars=getBorderChars(options.borderStyle),columns=terminalColumns(),marginLeft=PAD.repeat(options.margin.left);if(options.float==="center"){let marginWidth=Math.max((columns-contentWidth-getBorderWidth(options.borderStyle))/2,0);marginLeft=PAD.repeat(marginWidth);}else if(options.float==="right"){let marginWidth=Math.max(columns-contentWidth-options.margin.right-getBorderWidth(options.borderStyle),0);marginLeft=PAD.repeat(marginWidth);}let result="";options.margin.top&&(result+=NEWLINE.repeat(options.margin.top)),(options.borderStyle!==NONE||options.title)&&(result+=colorizeBorder(marginLeft+chars.topLeft+(options.title?makeTitle(options.title,chars.top.repeat(contentWidth),options.titleAlignment):chars.top.repeat(contentWidth))+chars.topRight)+NEWLINE);let lines=content.split(NEWLINE);return result+=lines.map(line=>marginLeft+colorizeBorder(chars.left)+colorizeContent(line)+colorizeBorder(chars.right)).join(NEWLINE),options.borderStyle!==NONE&&(result+=NEWLINE+colorizeBorder(marginLeft+chars.bottomLeft+chars.bottom.repeat(contentWidth)+chars.bottomRight)),options.margin.bottom&&(result+=NEWLINE.repeat(options.margin.bottom)),result},sanitizeOptions=options=>{if(options.fullscreen&&process2__default.default?.stdout){let newDimensions=[process2__default.default.stdout.columns,process2__default.default.stdout.rows];typeof options.fullscreen=="function"&&(newDimensions=options.fullscreen(...newDimensions)),options.width||=newDimensions[0],options.height||=newDimensions[1];}return options.width&&=Math.max(1,options.width-getBorderWidth(options.borderStyle)),options.height&&=Math.max(1,options.height-getBorderWidth(options.borderStyle)),options},formatTitle=(title,borderStyle)=>borderStyle===NONE?title:` ${title} `,determineDimensions=(text,options)=>{options=sanitizeOptions(options);let widthOverride=options.width!==void 0,columns=terminalColumns(),borderWidth=getBorderWidth(options.borderStyle),maxWidth=columns-options.margin.left-options.margin.right-borderWidth,widest=widestLine(wrapAnsi(text,columns-borderWidth,{hard:!0,trim:!1}))+options.padding.left+options.padding.right;if(options.title&&widthOverride?(options.title=options.title.slice(0,Math.max(0,options.width-2)),options.title&&=formatTitle(options.title,options.borderStyle)):options.title&&(options.title=options.title.slice(0,Math.max(0,maxWidth-2)),options.title&&(options.title=formatTitle(options.title,options.borderStyle),stringWidth(options.title)>widest&&(options.width=stringWidth(options.title)))),options.width||=widest,!widthOverride){if(options.margin.left&&options.margin.right&&options.width>maxWidth){let multiplier=(columns-options.width-borderWidth)/(options.margin.left+options.margin.right);options.margin.left=Math.max(0,Math.floor(options.margin.left*multiplier)),options.margin.right=Math.max(0,Math.floor(options.margin.right*multiplier));}options.width=Math.min(options.width,columns-borderWidth-options.margin.left-options.margin.right);}return options.width-(options.padding.left+options.padding.right)<=0&&(options.padding.left=0,options.padding.right=0),options.height&&options.height-(options.padding.top+options.padding.bottom)<=0&&(options.padding.top=0,options.padding.bottom=0),options},isHex=color=>color.match(/^#(?:[0-f]{3}){1,2}$/i),isColorValid=color=>typeof color=="string"&&(source_default[color]??isHex(color)),getColorFunction=color=>isHex(color)?source_default.hex(color):source_default[color],getBGColorFunction=color=>isHex(color)?source_default.bgHex(color):source_default[camelCase(["bg",color])];function boxen(text,options){if(options={padding:0,borderStyle:"single",dimBorder:!1,textAlignment:"left",float:"left",titleAlignment:"left",...options},options.align&&(options.textAlignment=options.align),options.borderColor&&!isColorValid(options.borderColor))throw new Error(`${options.borderColor} is not a valid borderColor`);if(options.backgroundColor&&!isColorValid(options.backgroundColor))throw new Error(`${options.backgroundColor} is not a valid backgroundColor`);return options.padding=getObject(options.padding),options.margin=getObject(options.margin),options=determineDimensions(text,options),text=makeContentText(text,options),boxContent(text,options.width,options)}var fancy=process.platform!=="win32"||process.env.CI||process.env.TERM==="xterm-256color",step=nodeLogger.colors.gray("\u203A");nodeLogger.colors.blue(fancy?"\u2139":"i");nodeLogger.colors.green(fancy?"\u2714":"\u221A");nodeLogger.colors.orange(fancy?"\u26A0":"\u203C");nodeLogger.colors.red(fancy?"\u2716":"\xD7");var baseOptions={borderStyle:"round",padding:1},print=(message,options)=>{nodeLogger.logger.line(1),nodeLogger.logger.plain(boxen(message,{...baseOptions,...options}));},printInfo=(title,message,options)=>print(message,{borderColor:"blue",title,...options}),printWarning=(title,message,options)=>print(message,{borderColor:"yellow",title,...options}),printError=(title,message,options)=>print(message,{borderColor:"red",title,...options}),printSuccess=(title,message,options)=>print(message,{borderColor:"green",title,...options});var loadTemplate=async(name,replacements)=>{let template=await fs4__namespace.readFile(join(dirname(__require.resolve("@storybook/addon-vitest/package.json")),"templates",name),"utf8");return Object.entries(replacements).forEach(([key,value])=>template=template.replace(key,value)),template},mergeProperties=(source,target)=>{for(let sourceProp of source)if(sourceProp.type==="ObjectProperty"){let targetProp=target.find(p=>sourceProp.key.type==="Identifier"&&p.type==="ObjectProperty"&&p.key.type==="Identifier"&&p.key.name===sourceProp.key.name);targetProp&&targetProp.type==="ObjectProperty"?sourceProp.value.type==="ObjectExpression"&&targetProp.value.type==="ObjectExpression"?mergeProperties(sourceProp.value.properties,targetProp.value.properties):sourceProp.value.type==="ArrayExpression"&&targetProp.value.type==="ArrayExpression"?targetProp.value.elements.push(...sourceProp.value.elements):targetProp.value=sourceProp.value:target.push(sourceProp);}},updateConfigFile=(source,target)=>{let updated=!1;for(let sourceNode of source.program.body)if(sourceNode.type==="ImportDeclaration"){if(!target.program.body.some(targetNode=>targetNode.type===sourceNode.type&&targetNode.specifiers.some(s=>s.local.name===sourceNode.specifiers[0].local.name))){let lastImport=target.program.body.findLastIndex(n=>n.type==="ImportDeclaration");target.program.body.splice(lastImport+1,0,sourceNode);}}else if(sourceNode.type==="VariableDeclaration"){if(!target.program.body.some(targetNode=>targetNode.type===sourceNode.type&&targetNode.declarations.some(d=>"name"in d.id&&"name"in sourceNode.declarations[0].id&&d.id.name===sourceNode.declarations[0].id.name))){let lastImport=target.program.body.findLastIndex(n=>n.type==="ImportDeclaration");target.program.body.splice(lastImport+1,0,sourceNode);}}else if(sourceNode.type==="ExportDefaultDeclaration"){let exportDefault=target.program.body.find(n=>n.type==="ExportDefaultDeclaration");if(exportDefault&&sourceNode.declaration.type==="CallExpression"&&sourceNode.declaration.arguments.length>0&&sourceNode.declaration.arguments[0].type==="ObjectExpression"){let{properties}=sourceNode.declaration.arguments[0];exportDefault.declaration.type==="ObjectExpression"?(mergeProperties(properties,exportDefault.declaration.properties),updated=!0):exportDefault.declaration.type==="CallExpression"&&exportDefault.declaration.callee.type==="Identifier"&&exportDefault.declaration.callee.name==="defineConfig"&&exportDefault.declaration.arguments[0]?.type==="ObjectExpression"&&(mergeProperties(properties,exportDefault.declaration.arguments[0].properties),updated=!0);}}return updated},updateWorkspaceFile=(source,target)=>{let updated=!1;for(let sourceNode of source.program.body)if(sourceNode.type==="ImportDeclaration"){if(!target.program.body.some(targetNode=>targetNode.type===sourceNode.type&&targetNode.source.value===sourceNode.source.value&&targetNode.specifiers.some(s=>s.local.name===sourceNode.specifiers[0].local.name))){let lastImport=target.program.body.findLastIndex(n=>n.type==="ImportDeclaration");target.program.body.splice(lastImport+1,0,sourceNode);}}else if(sourceNode.type==="VariableDeclaration"){if(!target.program.body.some(targetNode=>targetNode.type===sourceNode.type&&targetNode.declarations.some(d=>"name"in d.id&&"name"in sourceNode.declarations[0].id&&d.id.name===sourceNode.declarations[0].id.name))){let lastImport=target.program.body.findLastIndex(n=>n.type==="ImportDeclaration");target.program.body.splice(lastImport+1,0,sourceNode);}}else if(sourceNode.type==="ExportDefaultDeclaration"){let exportDefault=target.program.body.find(n=>n.type==="ExportDefaultDeclaration");if(exportDefault&&sourceNode.declaration.type==="CallExpression"&&sourceNode.declaration.arguments.length>0&&sourceNode.declaration.arguments[0].type==="ArrayExpression"&&sourceNode.declaration.arguments[0].elements.length>0){let{elements}=sourceNode.declaration.arguments[0];exportDefault.declaration.type==="ArrayExpression"?(exportDefault.declaration.elements.push(...elements),updated=!0):exportDefault.declaration.type==="CallExpression"&&exportDefault.declaration.callee.type==="Identifier"&&exportDefault.declaration.callee.name==="defineWorkspace"&&exportDefault.declaration.arguments[0]?.type==="ArrayExpression"&&(exportDefault.declaration.arguments[0].elements.push(...elements),updated=!0);}}return updated};function getAddonNames(mainConfig){return (mainConfig.addons||[]).map(addon=>{let name="";return typeof addon=="string"?name=addon:typeof addon=="object"&&(name=addon.name),name}).filter(item=>item!=null)}var ADDON_NAME="@storybook/addon-vitest",EXTENSIONS=[".ts",".tsx",".js",".jsx",".cts",".mts",".cjs",".mjs"],addonA11yName="@storybook/addon-a11y",findFile=async(basename2,extensions=EXTENSIONS)=>findUp(extensions.map(ext=>basename2+ext));async function postInstall(options){printSuccess("\u{1F44B} Howdy!",tsDedent.dedent`
      I'm the installation helper for ${nodeLogger.colors.pink(ADDON_NAME)}

      Hold on for a moment while I look at your project and get it set up...
    `);let packageManager=common.JsPackageManagerFactory.getPackageManager({force:options.packageManager}),info2=await getStorybookInfo(options),allDeps=await packageManager.getAllDependencies(),dependencies=["vitest","@vitest/browser","playwright"].filter(p=>!allDeps[p]),vitestVersionSpecifier=await packageManager.getInstalledVersion("vitest"),coercedVitestVersion=vitestVersionSpecifier?(0, import_semver.coerce)(vitestVersionSpecifier):null,vitestVersionToInstall=vitestVersionSpecifier??"latest",mainJsPath=common.serverResolve(resolve(options.configDir,"main")),config=await csfTools.readConfig(mainJsPath),hasCustomWebpackConfig=!!config.getFieldNode(["webpackFinal"]),isInteractive=process.stdout.isTTY&&!process.env.CI;info2.frameworkPackageName==="@storybook/nextjs"&&!hasCustomWebpackConfig&&(options.yes||!isInteractive?{migrateToNextjsVite:!!options.yes}:await prompts__default.default({type:"confirm",name:"migrateToNextjsVite",message:tsDedent.dedent`
            The addon requires the use of @storybook/nextjs-vite to work with Next.js.
            https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}#install-and-set-up

            Do you want to migrate?
          `,initial:!0})).migrateToNextjsVite&&(await packageManager.addDependencies({installAsDevDependencies:!0,skipInstall:options.skipInstall},[`@storybook/nextjs-vite@${common.versions["@storybook/nextjs-vite"]}`]),await packageManager.removeDependencies({},["@storybook/nextjs"]),babel.traverse(config._ast,{StringLiteral(path6){path6.node.value==="@storybook/nextjs"&&(path6.node.value="@storybook/nextjs-vite");}}),await csfTools.writeConfig(config,mainJsPath),info2.frameworkPackageName="@storybook/nextjs-vite",info2.builderPackageName="@storybook/builder-vite",await common.scanAndTransformFiles({promptMessage:"Enter a glob to scan for all @storybook/nextjs imports to substitute with @storybook/nextjs-vite:",force:options.yes,dryRun:!1,transformFn:(files,options2,dryRun)=>common.transformImportFiles(files,options2,dryRun),transformOptions:{"@storybook/nextjs":"@storybook/nextjs-vite"}}));let annotationsImport=SUPPORTED_FRAMEWORKS.includes(info2.frameworkPackageName)?info2.frameworkPackageName==="@storybook/nextjs"?"@storybook/nextjs-vite":info2.frameworkPackageName:null,isRendererSupported=!!annotationsImport,result=await(async()=>{let reasons=[];hasCustomWebpackConfig&&reasons.push("\u2022 The addon can not be used with a custom Webpack configuration."),info2.frameworkPackageName!=="@storybook/nextjs"&&info2.builderPackageName!=="@storybook/builder-vite"&&reasons.push("\u2022 The addon can only be used with a Vite-based Storybook framework or Next.js."),isRendererSupported||reasons.push(tsDedent.dedent`
        • The addon cannot yet be used with ${import_picocolors.default.bold(nodeLogger.colors.pink(info2.frameworkPackageName))}
      `),coercedVitestVersion&&!(0, import_semver.satisfies)(coercedVitestVersion,">=3.0.0")&&reasons.push(tsDedent.dedent`
        • The addon requires Vitest 3.0.0 or higher. You are currently using ${import_picocolors.default.bold(vitestVersionSpecifier)}.
          Please update all of your Vitest dependencies and try again.
      `);let mswVersionSpecifier=await packageManager.getInstalledVersion("msw"),coercedMswVersion=mswVersionSpecifier?(0, import_semver.coerce)(mswVersionSpecifier):null;return coercedMswVersion&&!(0, import_semver.satisfies)(coercedMswVersion,">=2.0.0")&&reasons.push(tsDedent.dedent`
        • The addon uses Vitest behind the scenes, which supports only version 2 and above of MSW. However, we have detected version ${import_picocolors.default.bold(coercedMswVersion.version)} in this project.
        Please update the 'msw' package and try again.
      `),info2.frameworkPackageName==="@storybook/nextjs"&&(await packageManager.getInstalledVersion("next")||reasons.push(tsDedent.dedent`
          • You are using ${import_picocolors.default.bold(nodeLogger.colors.pink("@storybook/nextjs"))} without having ${import_picocolors.default.bold(nodeLogger.colors.pink("next"))} installed.
            Please install "next" or use a different Storybook framework integration and try again.
        `)),reasons.length>0?(reasons.unshift("@storybook/addon-vitest's automated setup failed due to the following package incompatibilities:"),reasons.push("--------------------------------"),reasons.push(tsDedent.dedent`
          You can fix these issues and rerun the command to reinstall. If you wish to roll back the installation, remove ${import_picocolors.default.bold(nodeLogger.colors.pink(ADDON_NAME))} from the "addons" array
          in your main Storybook config file and remove the dependency from your package.json file.
        `),isRendererSupported?reasons.push(tsDedent.dedent`
            Fear not, however, you can follow the manual installation process instead at:
            ${import_picocolors.default.cyan(`https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}#manual-setup`)}
          `):reasons.push(tsDedent.dedent`
            Please check the documentation for more information about its requirements and installation:
            ${import_picocolors.default.cyan(`https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}`)}
          `),reasons.map(r=>r.trim()).join(`

`)):null})();if(result){printError("\u26D4\uFE0F Sorry!",result),nodeLogger.logger.line(1);return}if(info2.frameworkPackageName==="@storybook/nextjs"){printInfo("\u{1F37F} Just so you know...",tsDedent.dedent`
        It looks like you're using Next.js.

        Adding ${import_picocolors.default.bold(nodeLogger.colors.pink("@storybook/nextjs-vite/vite-plugin"))} so you can use it with Vitest.

        More info about the plugin at ${import_picocolors.default.cyan("https://github.com/storybookjs/vite-plugin-storybook-nextjs")}
      `);try{let storybookVersion=await packageManager.getInstalledVersion("storybook");dependencies.push(`@storybook/nextjs-vite@^${storybookVersion}`);}catch{console.error("Failed to install @storybook/nextjs-vite. Please install it manually");}}let v8Version=await packageManager.getInstalledVersion("@vitest/coverage-v8"),istanbulVersion=await packageManager.getInstalledVersion("@vitest/coverage-istanbul");!v8Version&&!istanbulVersion&&(printInfo("\u{1F648} Let me cover this for you",tsDedent.dedent`
        You don't seem to have a coverage reporter installed. Vitest needs either V8 or Istanbul to generate coverage reports.

        Adding ${import_picocolors.default.bold(nodeLogger.colors.pink("@vitest/coverage-v8"))} to enable coverage reporting.
        Read more about Vitest coverage providers at ${import_picocolors.default.cyan("https://vitest.dev/guide/coverage.html#coverage-providers")}
      `),dependencies.push("@vitest/coverage-v8"));let versionedDependencies=dependencies.map(p=>p.includes("vitest")?`${p}@${vitestVersionToInstall??"latest"}`:p);versionedDependencies.length>0&&(nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Installing dependencies:`),nodeLogger.logger.plain(nodeLogger.colors.gray("  "+versionedDependencies.join(", "))),await packageManager.addDependencies({installAsDevDependencies:!0,skipInstall:options.skipInstall},versionedDependencies)),nodeLogger.logger.line(1),options.skipInstall?(nodeLogger.logger.plain("Skipping Playwright installation, please run this command manually:"),nodeLogger.logger.plain(nodeLogger.colors.gray("  npx playwright install chromium --with-deps"))):(nodeLogger.logger.plain(`${step} Configuring Playwright with Chromium (this might take some time):`),nodeLogger.logger.plain(nodeLogger.colors.gray("  npx playwright install chromium --with-deps")),await packageManager.executeCommand({command:"npx",args:["playwright","install","chromium","--with-deps"]}));let fileExtension=allDeps.typescript||await findFile("tsconfig",[...EXTENSIONS,".json"])?"ts":"js",vitestSetupFile=resolve(options.configDir,`vitest.setup.${fileExtension}`);if(fs.existsSync(vitestSetupFile)){printError("\u{1F6A8} Oh no!",tsDedent.dedent`
        Found an existing Vitest setup file:
        ${nodeLogger.colors.gray(vitestSetupFile)}

        Please refer to the documentation to complete the setup manually:
        ${import_picocolors.default.cyan(`https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}#manual-setup`)}
      `),nodeLogger.logger.line(1);return}nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Creating a Vitest setup file for Storybook:`),nodeLogger.logger.plain(nodeLogger.colors.gray(`  ${vitestSetupFile}`));let previewExists=EXTENSIONS.map(ext=>resolve(options.configDir,`preview${ext}`)).some(fs.existsSync),imports=[`import { setProjectAnnotations } from '${annotationsImport}';`],projectAnnotations=[];previewExists&&(imports.push("import * as projectAnnotations from './preview';"),projectAnnotations.push("projectAnnotations")),await fs4.writeFile(vitestSetupFile,tsDedent.dedent`
      ${imports.join(`
`)}

      // This is an important step to apply the right configuration when testing your stories.
      // More info at: https://storybook.js.org/docs/api/portable-stories/portable-stories-vitest#setprojectannotations
      setProjectAnnotations([${projectAnnotations.join(", ")}]);
    `);let vitestWorkspaceFile=await findFile("vitest.workspace",[".ts",".js",".json"])||await findFile("vitest.projects",[".ts",".js",".json"]),viteConfigFile=await findFile("vite.config"),vitestConfigFile=await findFile("vitest.config"),vitestShimFile=await findFile("vitest.shims.d"),rootConfig=vitestConfigFile||viteConfigFile,browserConfig=`{
        enabled: true,
        headless: true,
        provider: 'playwright',
        instances: [{ browser: 'chromium' }]
      }`;if(fileExtension==="ts"&&!vitestShimFile&&await fs4.writeFile("vitest.shims.d.ts",'/// <reference types="@vitest/browser/providers/playwright" />'),vitestWorkspaceFile){let workspaceTemplate=await loadTemplate("vitest.workspace.template.ts",{EXTENDS_WORKSPACE:viteConfigFile?relative(dirname(vitestWorkspaceFile),viteConfigFile):"",CONFIG_DIR:options.configDir,BROWSER_CONFIG:browserConfig,SETUP_FILE:relative(dirname(vitestWorkspaceFile),vitestSetupFile)}).then(t=>t.replace(`
  'ROOT_CONFIG',`,"").replace(/\s+extends: '',/,"")),workspaceFile=await fs4__namespace.readFile(vitestWorkspaceFile,"utf8"),source=babel.babelParse(workspaceTemplate),target=babel.babelParse(workspaceFile);if(updateWorkspaceFile(source,target)){nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Updating your Vitest workspace file:`),nodeLogger.logger.plain(nodeLogger.colors.gray(`  ${vitestWorkspaceFile}`));let formattedContent=await common.formatFileContent(vitestWorkspaceFile,babel.generate(target).code);await fs4.writeFile(vitestWorkspaceFile,formattedContent);}else {printError("\u{1F6A8} Oh no!",tsDedent.dedent`
          Could not update existing Vitest workspace file:
          ${nodeLogger.colors.gray(vitestWorkspaceFile)}

          I was able to configure most of the addon but could not safely extend
          your existing workspace file automatically, you must do it yourself.

          Please refer to the documentation to complete the setup manually:
          ${import_picocolors.default.cyan(`https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}#manual-setup`)}
        `),nodeLogger.logger.line(1);return}}else if(rootConfig){let target,updated,configFile=await fs4__namespace.readFile(rootConfig,"utf8");if(configFile.includes("workspace:")){let configTemplate=await loadTemplate("vitest.config.template.ts",{CONFIG_DIR:options.configDir,BROWSER_CONFIG:browserConfig,SETUP_FILE:relative(dirname(rootConfig),vitestSetupFile)}),source=babel.babelParse(configTemplate);target=babel.babelParse(configFile),updated=updateConfigFile(source,target);}if(target&&updated){nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Updating your ${vitestConfigFile?"Vitest":"Vite"} config file:`),nodeLogger.logger.plain(nodeLogger.colors.gray(`  ${rootConfig}`));let formattedContent=await common.formatFileContent(rootConfig,babel.generate(target).code);await fs4.writeFile(rootConfig,formattedContent);}else {printWarning("\u26A0\uFE0F Cannot update config file",tsDedent.dedent`
          Could not update your existing ${vitestConfigFile?"Vitest":"Vite"} config file:
          ${nodeLogger.colors.gray(rootConfig)}

          Your existing config file cannot be safely updated, so instead a new Vitest
          workspace file will be created, extending from your config file.

          Please refer to the Vitest documentation to learn about the workspace file:
          ${import_picocolors.default.cyan("https://vitest.dev/guide/workspace.html")}
        `);let extension=extname(rootConfig).includes("ts")?".ts":".js",newWorkspaceFile=resolve(dirname(rootConfig),`vitest.workspace${extension}`),workspaceTemplate=await loadTemplate("vitest.workspace.template.ts",{ROOT_CONFIG:relative(dirname(newWorkspaceFile),rootConfig),EXTENDS_WORKSPACE:viteConfigFile?relative(dirname(newWorkspaceFile),viteConfigFile):"",CONFIG_DIR:options.configDir,BROWSER_CONFIG:browserConfig,SETUP_FILE:relative(dirname(newWorkspaceFile),vitestSetupFile)}).then(t=>t.replace(/\s+extends: '',/,""));nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Creating a Vitest workspace file:`),nodeLogger.logger.plain(nodeLogger.colors.gray(`  ${newWorkspaceFile}`));let formattedContent=await common.formatFileContent(newWorkspaceFile,workspaceTemplate);await fs4.writeFile(newWorkspaceFile,formattedContent);}}else {let newConfigFile=resolve(`vitest.config.${fileExtension}`),configTemplate=await loadTemplate("vitest.config.template.ts",{CONFIG_DIR:options.configDir,BROWSER_CONFIG:browserConfig,SETUP_FILE:relative(dirname(newConfigFile),vitestSetupFile)});nodeLogger.logger.line(1),nodeLogger.logger.plain(`${step} Creating a Vitest config file:`),nodeLogger.logger.plain(nodeLogger.colors.gray(`  ${newConfigFile}`));let formattedContent=await common.formatFileContent(newConfigFile,configTemplate);await fs4.writeFile(newConfigFile,formattedContent);}if(info2.addons.find(addon=>addon.includes(addonA11yName)))try{nodeLogger.logger.plain(`${step} Setting up ${addonA11yName} for @storybook/addon-vitest:`);let command=["automigrate","addonA11yAddonTest"];options.yes&&command.push("--yes"),options.packageManager&&command.push("--package-manager",options.packageManager),options.skipInstall&&command.push("--skip-install"),options.configDir!==".storybook"&&command.push("--config-dir",options.configDir),await execa("storybook",command,{stdio:"inherit"});}catch(e){printError("\u{1F6A8} Oh no!",tsDedent.dedent`
        We have detected that you have ${addonA11yName} installed but could not automatically set it up for @storybook/addon-vitest:

        ${e instanceof Error?e.message:String(e)}

        Please refer to the documentation to complete the setup manually:
        ${import_picocolors.default.cyan("https://storybook.js.org/docs/writing-tests/accessibility-testing#test-addon-integration")}
      `);}let runCommand=rootConfig?"npx vitest --project=storybook":"npx vitest";printSuccess("\u{1F389} All done!",tsDedent.dedent`
      @storybook/addon-vitest is now configured and you're ready to run your tests!

      Here are a couple of tips to get you started:
      • You can run tests with ${nodeLogger.colors.gray(runCommand)}
      • When using the Vitest extension in your editor, all of your stories will be shown as tests!

      Check the documentation for more information about its features and options at:
      ${import_picocolors.default.cyan(`https://storybook.js.org/docs/next/${DOCUMENTATION_LINK2}`)}
    `),nodeLogger.logger.line(1);}async function getStorybookInfo({configDir,packageManager:pkgMgr}){let packageJson=await common.JsPackageManagerFactory.getPackageManager({force:pkgMgr}).retrievePackageJson(),config=await common.loadMainConfig({configDir,noCache:!0}),{framework}=config,frameworkName=typeof framework=="string"?framework:framework?.name;common.validateFrameworkName(frameworkName);let frameworkPackageName=common.extractProperFrameworkName(frameworkName),core=await(await common.loadAllPresets({corePresets:[join(frameworkName,"preset")],overridePresets:[__require.resolve("storybook/internal/core-server/presets/common-override-preset")],configDir,packageJson,isCritical:!0})).apply("core",{}),{builder,renderer}=core;if(!builder)throw new Error("Could not detect your Storybook builder.");let builderPackageJson=await fs4__namespace.readFile(__require.resolve(join(typeof builder=="string"?builder:builder.name,"package.json")),"utf8"),builderPackageName=JSON.parse(builderPackageJson).name,rendererPackageName;if(renderer){let rendererPackageJson=await fs4__namespace.readFile(__require.resolve(join(renderer,"package.json")),"utf8");rendererPackageName=JSON.parse(rendererPackageJson).name;}return {frameworkPackageName,builderPackageName,rendererPackageName,addons:getAddonNames(config)}}

module.exports = postInstall;
