/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.limine.snapper.formats.json1.SnapperEntry;
import org.limine.snapper.formats.snapper.SnapperProperty;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.Output;
import org.limine.snapper.processes.Utility;

public class SnapperReader {
    private final HashMap<String, SnapperEntry> snapperEntries = new HashMap();
    private String lastTimeID = null;

    public SnapperReader() {
        this.process();
    }

    private void process() {
        this.readList();
        if (this.snapperEntries.isEmpty()) {
            if (Utility.isDirectoryPresent("/.snapshots")) {
                if (Utility.runCommand("btrfs subvolume show /.snapshots", false, false)) {
                    if (this.countNumericFoldersWithSnapshot() > 0) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.readList();
                        if (this.snapperEntries.isEmpty() && this.countNumericFoldersWithSnapshot() > 0) {
                            String errMessage = "Snapper list is empty, but \"/.snapshots\" is not empty. Snapper is too slow or has a bug.";
                            Utility.exitWithError(errMessage);
                            return;
                        }
                    }
                    Utility.warnMessage("You do not have a snapshot.");
                } else {
                    String errMessage = "\"/.snapshots\" is not Btrfs subvolume.";
                    Utility.exitWithError(errMessage);
                }
            } else {
                String errMessage = "\"/.snapshots\" is either not a directory or is missing.";
                Utility.exitWithError(errMessage);
            }
        }
    }

    private void readList() {
        this.snapperEntries.clear();
        this.lastTimeID = null;
        Output output = Utility.getTextFromCommand(Config.SNAPPER_LIST_CMDLINE, true, null);
        if (output.isSuccess()) {
            for (String line : output.text()) {
                SnapperEntry entry;
                if (line.isEmpty() || !Character.isDigit(line.charAt(0)) || (entry = this.createSnapperEntry(line)) == null) continue;
                this.snapperEntries.put(entry.timeId(), entry);
                this.lastTimeID = entry.timeId();
            }
        }
    }

    private SnapperEntry createSnapperEntry(String line) {
        String[] columns = line.split(",");
        if (columns.length >= 2) {
            int snapshotID = Integer.parseInt(columns[0].trim());
            String utcTime = columns[1].trim();
            if (snapshotID == 0) {
                return null;
            }
            if (Utility.isTimeFormatNotValid(utcTime)) {
                String errMessage = "Stop the tool due to a mismatch in the Snapper time format: " + utcTime;
                Utility.exitWithError(errMessage);
                return null;
            }
            String description = "";
            if (columns.length == 3) {
                description = columns[2];
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(SnapperProperty.DESCRIPTION.replace, description);
            String localTime = Utility.convertUTCtoLocal(utcTime);
            return new SnapperEntry(snapshotID, utcTime, localTime, properties);
        }
        String errMessage = "Mismatch Snapper format output!";
        Utility.exitWithError(errMessage);
        return null;
    }

    private int countNumericFoldersWithSnapshot() {
        Path path = Paths.get("/.snapshots", new String[0]);
        int count = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path entry : stream) {
                boolean numeric;
                String name = entry.getFileName().toString();
                if (name.isEmpty() || !(numeric = name.chars().allMatch(Character::isDigit)) || !Files.isDirectory(entry.resolve("snapshot"), new LinkOption[0])) continue;
                ++count;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return count;
    }

    public HashMap<String, SnapperEntry> getSnapperEntries() {
        return this.snapperEntries;
    }

    public SnapperEntry getLastSnapperEntry() {
        if (this.snapperEntries.isEmpty()) {
            return null;
        }
        return this.snapperEntries.get(this.lastTimeID);
    }
}

