/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.objects.Config;
import org.limine.snapper.processes.Utility;

public class HistoryWriter {
    public static void save(Manifest manifest, String filePath) throws IOException {
        HistoryWriter.updateDetail(manifest);
        Utility.ensurePathExists(filePath);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(filePath), (Object)manifest);
        Utility.infoMessage("Saved:", filePath);
    }

    public static void backup(String manifestPath) {
        if (Utility.isFilePresent(manifestPath)) {
            String backupPath = manifestPath + ".old";
            boolean isBackupNeeded = true;
            if (Utility.isFilePresent(backupPath)) {
                isBackupNeeded = Utility.isFileOlderThan(backupPath, Config.CONFIG_BACKUP_THRESHOLD);
            }
            if (isBackupNeeded) {
                Utility.copyFile(manifestPath, backupPath, true, false, false);
            }
        }
    }

    private static void updateDetail(Manifest manifest) {
        if (!"1.3.0".equals(manifest.getVersion())) {
            manifest.setVersion("1.3.0");
        }
        if (Config.UUID != null && !Config.UUID.equals(manifest.getUuid())) {
            manifest.setUuid(Config.UUID);
            return;
        }
        if (Config.IS_TIME_FOR_RESTORE) {
            return;
        }
        if (manifest.getUuid() == null || manifest.getUuid().isEmpty()) {
            manifest.setUuid(Utility.getUuid());
        }
    }
}

