/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.formats.json1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.processes.Utility;

public class Manifest {
    @JsonProperty(value="snapshotEntries")
    private final List<SnapshotEntry> snapshotEntries;
    @JsonProperty(value="properties")
    private final HashMap<String, String> properties = new HashMap();
    @JsonProperty(value="jsonFormatVersion")
    private String version;
    @JsonProperty(value="lastUTCTime")
    private String lastUTCTime;
    @JsonProperty(value="lastTimestamp")
    private String lastLocalTime;
    @JsonProperty(value="lastSnapshotID")
    private int lastSnapshotID;
    @JsonProperty(value="uuid")
    private String uuid;

    public Manifest() {
        this.snapshotEntries = new ArrayList<SnapshotEntry>();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getLastUTCTime() {
        if ((this.lastUTCTime == null || this.lastUTCTime.isEmpty()) && this.lastLocalTime != null) {
            this.lastUTCTime = Utility.convertLocalToUTC(this.lastLocalTime);
        }
        return this.lastUTCTime;
    }

    public void setLastUTCTime(String lastUTCTime) {
        this.lastUTCTime = lastUTCTime;
    }

    public String getLastLocalTime() {
        return this.lastLocalTime;
    }

    public void setLastLocalTime(String lastLocalTime) {
        this.lastLocalTime = lastLocalTime;
    }

    public int getLastSnapshotID() {
        return this.lastSnapshotID;
    }

    public void setLastSnapshotID(int lastSnapshotID) {
        this.lastSnapshotID = lastSnapshotID;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public List<SnapshotEntry> getSnapshotEntries() {
        return this.snapshotEntries;
    }
}

