/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper;

import java.io.IOException;
import java.util.Arrays;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.objects.Config;
import org.limine.snapper.processes.ConfigReader;
import org.limine.snapper.processes.FormatConverter;
import org.limine.snapper.processes.HistoryReader;
import org.limine.snapper.processes.HistoryWriter;
import org.limine.snapper.processes.LimineReader;
import org.limine.snapper.processes.LimineWriter;
import org.limine.snapper.processes.SnapperReader;
import org.limine.snapper.processes.SnapshotManager;
import org.limine.snapper.processes.Utility;

public class Main {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            Utility.warnMessage("No option provided.");
            return;
        }
        String option = args[0];
        boolean hasNoForceSave = Arrays.asList(args).contains("--no-force-save");
        switch (option) {
            case "--update": {
                if (hasNoForceSave) {
                    Config.IS_SAVE_FORCED = false;
                }
                Main.update();
                break;
            }
            case "--restore": {
                Main.restore();
                break;
            }
            case "--info": {
                Main.info();
                break;
            }
            case "--list": {
                Main.list();
                break;
            }
            default: {
                Utility.warnMessage("The option " + option + " is unknown.");
            }
        }
    }

    private static void info() {
        Config config = new ConfigReader().readConfig();
        String manifestPath = Utility.buildPath(config.espPath(), config.machineID(), "limine_history", "snapshots.json");
        Manifest manifest = HistoryReader.load(manifestPath);
        HistoryReader.displayInfo(manifest, config);
    }

    private static void list() {
        Config config = new ConfigReader().readConfig();
        String manifestPath = Utility.buildPath(config.espPath(), config.machineID(), "limine_history", "snapshots.json");
        Manifest manifest = HistoryReader.load(manifestPath);
        HistoryReader.displaySnapshotList(manifest);
    }

    private static void update() throws IOException {
        if (Utility.areYouInSnapshot()) {
            String errMessage = "You are in the snapshot, the tool does not update anything!";
            Utility.errorMessage(errMessage);
            return;
        }
        if (!Utility.areYouInBtrfs()) {
            String errMessage = "You are not in Btrfs, the tool does not update anything!";
            Utility.errorMessage(errMessage);
            return;
        }
        ConfigReader configReader = new ConfigReader();
        configReader.loadQuietMode();
        Config config = configReader.readConfig();
        configReader.checkMountPaths(config);
        configReader.readSnapperConfig();
        SnapperReader snapper = new SnapperReader();
        LimineReader limine = new LimineReader(config);
        String manifestPath = Utility.buildPath(config.espPath(), config.machineID(), "limine_history", "snapshots.json");
        Manifest manifest = HistoryReader.load(manifestPath);
        boolean isManifestChanged = FormatConverter.upgradeManifest(manifest);
        SnapshotManager manager = new SnapshotManager(config);
        manager.sync(manifest, snapper);
        boolean needToUpdateLimineConfig = manager.checkUpdate();
        if (needToUpdateLimineConfig) {
            if (limine.isTargetOsNotFound()) {
                Object errMessage = "No target OS name in the config /etc/default/limine";
                if (Config.TARGET_OS_NAME != null) {
                    errMessage = "OS name: '" + Config.TARGET_OS_NAME + " is not found or is wrong in " + Utility.buildPath(config.espPath(), "limine.conf");
                }
                Utility.errorMessage((String)errMessage);
                return;
            }
            if (limine.getTargetOsNode().nodes.isEmpty() || limine.getTargetOsNode().nodes.size() < 2 && limine.isSnapshotsNodeInsideOS()) {
                String errMessage = "Your OS entry has no kernel in " + Utility.buildPath(config.espPath(), "limine.conf") + ". Please add at least a kernel name '//<kernel name>' and its boot config!";
                Utility.errorMessage(errMessage);
                return;
            }
            if (manager.isAllowedToAddSnapshot()) {
                SnapshotEntry newSnapshotEntry = limine.createCurrentLimineEntry(snapper.getLastSnapperEntry());
                if (manager.predictSpaceUsage(newSnapshotEntry)) {
                    if (Config.SNAPSHOT_WRITABLE) {
                        String makeSnapshotWritable = "btrfs property set '/.snapshots/" + newSnapshotEntry.snapperEntry().snapshotID() + "/snapshot' ro false";
                        Utility.runCommand(makeSnapshotWritable, false, false);
                    }
                    manager.historyAddSnapshot(manifest, newSnapshotEntry);
                } else {
                    String errMessage = "Stop creating a snapshot entry because the ESP usage limit " + Config.LIMIT_USAGE_PERCENT + "% is exceeded.";
                    Utility.errorMessage(errMessage);
                }
            }
            HistoryWriter.backup(manifestPath);
            HistoryWriter.save(manifest, manifestPath);
        } else if (isManifestChanged || Config.UUID != null && !Config.UUID.equals(manifest.getUuid())) {
            manifest.setUuid(Config.UUID);
            HistoryWriter.save(manifest, manifestPath);
        }
        if (Config.IS_SAVE_FORCED || needToUpdateLimineConfig) {
            LimineWriter writer = new LimineWriter(config, limine);
            writer.backup();
            writer.setSnapshots(manifest);
            writer.save();
        }
    }

    private static void restore() throws IOException {
        Config.ENABLE_TMP_CONFIG = Utility.areYouInBtrfs() && Utility.areYouInSnapshot();
        Config config = new ConfigReader().readConfig();
        String manifestPath = Utility.buildPath(config.espPath(), config.machineID(), "limine_history", "snapshots.json");
        Manifest manifest = HistoryReader.load(manifestPath);
        LimineReader limine = new LimineReader(config, true);
        if (limine.isTargetOsNotFound()) {
            Object errMessage = "No target OS name in the config /etc/default/limine";
            if (Config.TARGET_OS_NAME != null) {
                errMessage = "OS name: '" + Config.TARGET_OS_NAME + " is not found or is wrong in " + Utility.buildPath(config.espPath(), "limine.conf");
            }
            Utility.errorMessage((String)errMessage);
            return;
        }
        Config.IS_TIME_FOR_RESTORE = true;
        SnapshotManager manager = new SnapshotManager(config);
        SnapshotEntry restoredEntry = manager.restore(manifest, limine);
        if (restoredEntry == null) {
            Utility.exitWithError("The restore failed.", true);
        }
        if (manager.isBackupNeeded()) {
            HistoryWriter.backup(manifestPath);
            HistoryWriter.save(manifest, manifestPath);
        }
        LimineWriter writer = new LimineWriter(config, limine);
        writer.backup();
        writer.setTargetEntry(restoredEntry);
        writer.setSnapshots(manifest);
        writer.save();
        if (Utility.isCommandPresent("reboot")) {
            boolean needRestart = Utility.askUser(" \n The restore is complete. Please reboot now:\n Type \"[y]es\" to reboot, \"[n]o\" or \"[c]ancel\" to abort rebooting.\n ");
            if (needRestart) {
                Utility.runCommand("reboot", true, false);
            }
        } else {
            Utility.askUser(" \n The restore is complete. Please reboot now.\n Type \"[y]es\" to close.\n ");
        }
    }
}

