/* astal-power-profiles-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalPowerProfiles", gir_version = "0.1")]
namespace AstalPowerProfiles {
	/**
	 * Client for  [[https://freedesktop-team.pages.debian.net/power-profiles-daemon/gdbus-org.freedesktop.UPower.PowerProfiles.html|PowerProfiles]].
	 */
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public class PowerProfiles : GLib.Object {
		public PowerProfiles ();
		/** Gets the default singleton PowerProfiles instance. */
		public static AstalPowerProfiles.PowerProfiles get_default ();
		/**
		 * This forces the passed profile (either 'power-saver' or 'performance')
		 * to be activated until either the caller quits,
		 * [method@AstalPowerProfiles.PowerProfiles.release_profile] is called,
		 * or the [property@AstalPowerProfiles.PowerProfiles:active_profile] is changed by the user.
		 * When conflicting profiles are requested to be held,
		 * the 'power-saver' profile will be activated in preference to the 'performance' profile.
		 * Those holds will be automatically cancelled if the user manually switches to another profile,
		 * and the [signal@AstalPowerProfiles.PowerProfiles::profile_released] signal will be emitted.
		 */
		public int hold_profile (string profile, string reason, string application_id);
		/**
		 * This removes the hold that was set on a profile.
		 */
		public void release_profile (uint cookie);
		/**
		 * List of the "actions" implemented in the running daemon.
		 * This can used to figure out whether particular functionality is available in the daemon.
		 */
		public string[] actions { owned get; }
		/**
		 * The type of the currently active profile.
		 * It might change automatically if a profile is held,
		 * using the [method@AstalPowerProfiles.PowerProfiles.hold_profile] method.
		 */
		public string active_profile { owned get; set; }
		/**
		 * List of dictionaries representing the current profile holds.
		 */
		public AstalPowerProfiles.Hold[] active_profile_holds { owned get; }
		/**
		 * Return a named icon based [property@AstalPowerProfiles.PowerProfiles:active_profile].
		 */
		public string icon_name { owned get; }
		/**
		 * This will be set if the performance power profile is running in degraded mode,
		 * with the value being used to identify the reason for that degradation.
		 * Possible values are:
		 * - "lap-detected" (the computer is sitting on the user's lap)
		 * - "high-operating-temperature" (the computer is close to overheating)
		 * - "" (the empty string, if not performance is not degraded)
		 */
		public string performance_degraded { owned get; }
		/**
		 * List of each profile.
		 */
		public AstalPowerProfiles.Profile[] profiles { owned get; }
		/**
		 * The version of the power-profiles-daemon software.
		 */
		public string version { owned get; }
		/**
		 * Emitted when the profile is released because
		 * [property@AstalPowerProfiles.PowerProfiles:active_profile] was manually changed.
		 * This will only be emitted to the process that originally called
		 * [method@AstalPowerProfiles.PowerProfiles.hold_profile].
		 */
		public signal void profile_released (uint cookie);
	}
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public struct Hold {
		public string application_id;
		public string profile;
		public string reason;
	}
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public struct Profile {
		/**
		 * Will be one of:
		 * - "power-saver" (battery saving profile)
		 * - "balanced" (the default profile)
		 * - "performance" (a profile that does not care about noise or battery consumption)
		 */
		public string profile;
		public string cpu_driver;
		public string platform_driver;
		/**
		 * Identifies the power-profiles-daemon backend code used to implement the profile.
		 */
		public string driver;
	}
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public const string VERSION;
	[CCode (cheader_filename = "astal-power-profiles.h")]
	public static AstalPowerProfiles.PowerProfiles get_default ();
}
