/* astal-bluetooth-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalBluetooth", gir_version = "0.1")]
namespace AstalBluetooth {
	/**
	 * Object representing an [[https://github.com/RadiusNetworks/bluez/blob/master/doc/adapter-api.txt|adapter]].
	 */
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public class Adapter : GLib.Object {
		/**
		 * This removes the remote device and the pairing information.
		 *
		 * Possible errors: `InvalidArguments`, `Failed`.
		 */
		public void remove_device (AstalBluetooth.Device device) throws GLib.Error;
		/**
		 * This method starts the device discovery procedure.
		 *
		 * Possible errors: `NotReady`, `Failed`.
		 */
		public void start_discovery () throws GLib.Error;
		/**
		 * This method will cancel any previous [method@AstalBluetooth.Adapter.start_discovery] procedure.
		 *
		 * Possible errors: `NotReady`, `Failed`, `NotAuthorized`.
		 */
		public void stop_discovery () throws GLib.Error;
		/**
		 * The Bluetooth device address.
		 */
		public string address { owned get; }
		/**
		 * The Bluetooth friendly name.
		 *
		 * In case no alias is set, it will return [property@AstalBluetooth.Adapter:name].
		 */
		public string alias { owned get; set; }
		/**
		 * The Bluetooth class of device.
		 */
		public uint @class { get; }
		/**
		 * Switch an adapter to discoverable or non-discoverable
		 * to either make it visible or hide it.
		 */
		public bool discoverable { get; set; }
		/**
		 * The discoverable timeout in seconds.
		 * A value of zero means that the timeout is disabled
		 * and it will stay in discoverable/limited mode forever
		 * until [method@AstalBluetooth.Adapter.stop_discovery] is invoked.
		 * The default value for the discoverable timeout should be `180`.
		 */
		public uint discoverable_timeout { get; set; }
		/**
		 * Indicates that a device discovery procedure is active.
		 */
		public bool discovering { get; }
		/**
		 * Local Device ID information in modalias format used by the kernel and udev.
		 */
		public string modalias { owned get; }
		/**
		 * The Bluetooth system name (pretty hostname).
		 */
		public string name { owned get; }
		/**
		 * Switch an adapter to pairable or non-pairable.
		 */
		public bool pairable { get; set; }
		/**
		 * The pairable timeout in seconds.
		 *
		 * A value of zero means that the timeout is disabled and it will stay in pairable mode forever.
		 * The default value for pairable timeout should be disabled `0`.
		 */
		public uint pairable_timeout { get; set; }
		/**
		 * Switch an adapter on or off.
		 */
		public bool powered { get; set; }
		/**
		 * List of 128-bit UUIDs that represents the available local services.
		 */
		public string[] uuids { owned get; }
	}
	/**
	 * Manager object for `org.bluez`.
	 */
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public class Bluetooth : GLib.Object {
		public Bluetooth ();
		/**
		 * Gets the default singleton Bluetooth object.
		 */
		public static AstalBluetooth.Bluetooth get_default ();
		/**
		 * Toggle the [property@AstalBluetooth.Adapter:powered]
		 * property of the [property@AstalBluetooth.Bluetooth:adapter].
		 */
		public void toggle ();
		/**
		 * The first registered adapter which is usually the only adapter.
		 */
		public AstalBluetooth.Adapter? adapter { get; }
		/**
		 * List of adapters available on the host device.
		 */
		public GLib.List<weak AstalBluetooth.Adapter> adapters { owned get; }
		/**
		 * List of registered devices on the `org.bluez` bus.
		 */
		public GLib.List<weak AstalBluetooth.Device> devices { owned get; }
		/**
		 * `true` if any of the [property@AstalBluetooth.Bluetooth:devices] is connected.
		 */
		public bool is_connected { get; private set; }
		/**
		 * `true` if any of the [property@AstalBluetooth.Bluetooth:adapters] are powered.
		 */
		public bool is_powered { get; private set; }
		/**
		 * Emitted when an adapter is registered on the `org.bluez` bus.
		 */
		public signal void adapter_added (AstalBluetooth.Adapter adapter);
		/**
		 * Emitted when an adapter is unregistered on the `org.bluez` bus.
		 */
		public signal void adapter_removed (AstalBluetooth.Adapter adapter);
		/**
		 * Emitted when a new device is registered on the `org.bluez` bus.
		 */
		public signal void device_added (AstalBluetooth.Device device);
		/**
		 * Emitted when a device is unregistered on the `org.bluez` bus.
		 */
		public signal void device_removed (AstalBluetooth.Device device);
	}
	/**
	 * Object representing a [[https://github.com/luetzel/bluez/blob/master/doc/device-api.txt|device]].
	 */
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public class Device : GLib.Object {
		/**
		 * This method can be used to cancel a pairing operation
		 * initiated by [method@AstalBluetooth.Device.pair].
		 *
		 * Possible errors: `DoesNotExist`, `Failed`.
		 */
		public void cancel_pairing () throws GLib.Error;
		/**
		 * This is a generic method to connect any profiles
		 * the remote device supports that can be connected to.
		 *
		 * Possible errors: `NotReady`, `Failed`, `InProgress`, `AlreadyConnected`.
		 */
		public async void connect_device () throws GLib.Error;
		/**
		 * This method connects a specific profile of this device.
		 * The UUID provided is the remote service UUID for the profile.
		 *
		 * Possible errors: `Failed`, `InProgress`, `InvalidArguments`, `NotAvailable`, `NotReady`.
		 *
		 * @param uuid the remote service UUID.
		 */
		public void connect_profile (string uuid) throws GLib.Error;
		/**
		 * This method gracefully disconnects all connected profiles.
		 *
		 * Possible errors: `NotConnected`.
		 */
		public async void disconnect_device () throws GLib.Error;
		/**
		 * This method disconnects a specific profile of this device.
		 *
		 * Possible errors: `Failed`, `InProgress`, `InvalidArguments`, `NotSupported`.
		 *
		 * @param uuid the remote service UUID.
		 */
		public void disconnect_profile (string uuid) throws GLib.Error;
		/**
		 * This method will connect to the remote device and initiate pairing.
		 *
		 * Possible errors: `InvalidArguments`, `Failed`, `AlreadyExists`,
		 * `AuthenticationCanceled`, `AuthenticationFailed`, `AuthenticationRejected`,
		 * `AuthenticationTimeout`, `ConnectionAttemptFailed`.
		 */
		public void pair () throws GLib.Error;
		/**
		 * The object path of the adapter the device belongs to.
		 */
		public GLib.ObjectPath adapter { owned get; }
		/**
		 * The Bluetooth device address of the remote device.
		 */
		public string address { owned get; }
		/**
		 * The name alias for the remote device.
		 *
		 * In case no alias is set, it will return the remote device [property@AstalBluetooth.Device:name].
		 */
		public string alias { owned get; set; }
		/**
		 * External appearance of device, as found on GAP service.
		 */
		public uint16 appearance { get; }
		/**
		 * The percentage of battery left on the device if it has one, else -1.
		 */
		public double battery_percentage { get; }
		/**
		 * If set to `true` any incoming connections from the device will be immediately rejected.
		 */
		public bool blocked { get; set; }
		/**
		 * The Bluetooth class of device of the remote device.
		 */
		public uint32 @class { get; }
		/**
		 * Indicates if the remote device is currently connected.
		 */
		public bool connected { get; }
		/**
		 * Indicates if this device is currently trying to be connected.
		 */
		public bool connecting { get; private set; }
		/**
		 * Proposed icon name.
		 */
		public string icon { owned get; }
		/**
		 * `true` if the device only supports the pre-2.1 pairing mechanism.
		 */
		public bool legacy_pairing { get; }
		/**
		 * Remote Device ID information in modalias format used by the kernel and udev.
		 */
		public string modalias { owned get; }
		/**
		 * The Bluetooth remote name.
		 *
		 * It is always better to use [property@AstalBluetooth.Device:alias].
		 */
		public string name { owned get; }
		/**
		 * Indicates if the remote device is paired.
		 */
		public bool paired { get; }
		/**
		 * Received Signal Strength Indicator of the remote device (inquiry or advertising).
		 */
		public int16 rssi { get; }
		/**
		 * Indicates if the remote is seen as trusted.
		 */
		public bool trusted { get; set; }
		/**
		 * List of 128-bit UUIDs that represents the available remote services.
		 */
		public string[] uuids { owned get; }
	}
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public const string VERSION;
	/**
	 * Gets the default singleton Bluetooth object.
	 */
	[CCode (cheader_filename = "astal-bluetooth.h")]
	public static AstalBluetooth.Bluetooth get_default ();
}
