/* astal-apps-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalApps", gir_version = "0.1")]
namespace AstalApps {
	/**
	 * Object representing an applications .desktop file.
	 */
	[CCode (cheader_filename = "astal-apps.h")]
	public class Application : GLib.Object {
		/**
		 * Calculate a score using exact string algorithm.
		 */
		public AstalApps.Score exact_match (string term);
		/**
		 * Calculate a score for an application using fuzzy matching algorithm.
		 */
		public AstalApps.Score fuzzy_match (string term);
		/**
		 * Get a value from the .desktop file by its key.
		 */
		public string get_key (string key);
		/**
		 * Launches this application.
		 * The launched application inherits the environment of the launching process
		 */
		public bool launch ();
		/**
		 * The underlying DesktopAppInfo.
		 */
		public GLib.DesktopAppInfo app { get; set construct; }
		/**
		 * `Categories` field from the desktop file.
		 */
		public string[] categories { owned get; }
		/**
		 * Description of this Application.
		 */
		public string description { get; }
		/**
		 * Name of the .desktop of this Application.
		 */
		public string entry { get; }
		/**
		 * `Exec` field from the desktop file.
		 * Note that if you want to launch this Application you should use the [method@AstalApps.Application.launch] method.
		 */
		public string executable { owned get; }
		/**
		 * The number of times [method@AstalApps.Application.launch] was called on this Application.
		 */
		public int frequency { get; set; }
		/**
		 * `Icon` field from the desktop file.
		 * This is usually a named icon or a path to a file.
		 */
		public string icon_name { owned get; }
		/**
		 * `Keywords` field from the desktop file.
		 */
		public string[] keywords { owned get; }
		/**
		 * The name of this Application.
		 */
		public string name { get; }
		/**
		 * `StartupWMClass` field from the desktop file.
		 * This represents the `WM_CLASS` property of the main window of the application.
		 */
		public string wm_class { get; }
	}
	/**
	 * This object can be used to query applications.
	 * Multipliers can be set to customize [struct@AstalApps.Score] results
	 * from queries which then are summed and sorted accordingly.
	 */
	[CCode (cheader_filename = "astal-apps.h")]
	public class Apps : GLib.Object {
		public Apps ();
		/**
		 * Query the `list` of applications with a simple string matching algorithm.
		 */
		public GLib.List<weak AstalApps.Application> exact_query (string? search = "");
		/**
		 * Calculate a score for an application using exact string algorithm.
		 * Taking this Apps' include settings into consideration .
		 */
		public double exact_score (string search, AstalApps.Application a);
		/**
		 * Query the `list` of applications with a fuzzy matching algorithm.
		 */
		public GLib.List<weak AstalApps.Application> fuzzy_query (string? search = "");
		/**
		 * Calculate a score for an application using fuzzy matching algorithm.
		 * Taking this Apps' include settings into consideration .
		 */
		public double fuzzy_score (string search, AstalApps.Application a);
		/**
		 * Reload the `list` of Applications.
		 */
		public void reload ();
		/**
		 * Extra multiplier to apply when matching the categories of an application.
		 * Defaults to `0`
		 */
		public double categories_multiplier { get; set; }
		/**
		 * Extra multiplier to apply when matching the description of an application.
		 * Defaults to `0`
		 */
		public double description_multiplier { get; set; }
		/**
		 * Extra multiplier to apply when matching the entry of an application.
		 * Defaults to `0`
		 */
		public double entry_multiplier { get; set; }
		/**
		 * Extra multiplier to apply when matching the executable of an application.
		 * Defaults to `0.5`
		 */
		public double executable_multiplier { get; set; }
		/**
		 * Extra multiplier to apply when matching the keywords of an application.
		 * Defaults to `0.5`
		 */
		public double keywords_multiplier { get; set; }
		/**
		 * Full list of available applications.
		 */
		public GLib.List<weak AstalApps.Application> list { owned get; }
		/**
		 * The minimum score the application has to meet in order to be included in queries.
		 */
		public double min_score { get; set; }
		/**
		 * Extra multiplier to apply when matching the `name` of an application.
		 * Defaults to `2`
		 */
		public double name_multiplier { get; set; }
		/**
		 * Indicates wether hidden applications should included in queries.
		 */
		public bool show_hidden { get; set; }
	}
	[CCode (cheader_filename = "astal-apps.h")]
	public struct Score {
		public int name;
		public int entry;
		public int executable;
		public int description;
		public int keywords;
		public int categories;
	}
	[CCode (cheader_filename = "astal-apps.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-apps.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-apps.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-apps.h")]
	public const string VERSION;
}
