/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.scene.text.TabAdvancePolicy;
import com.sun.javafx.text.FixedTabAdvancePolicy;
import java.util.Arrays;
import javafx.collections.ObservableList;
import javafx.scene.text.TabStop;
import javafx.scene.text.TabStopPolicy;
import javafx.scene.text.TextFlow;

public class DefaultTabAdvancePolicy
implements TabAdvancePolicy {
    private final TextFlow flow;
    private final float[] stops;
    private final float interval;

    private DefaultTabAdvancePolicy(TextFlow textFlow, float[] fArray, float f) {
        this.flow = textFlow;
        this.stops = fArray;
        this.interval = f;
    }

    public static DefaultTabAdvancePolicy of(TextFlow textFlow, TabStopPolicy tabStopPolicy) {
        ObservableList<TabStop> observableList = tabStopPolicy.tabStops();
        float[] fArray = new float[observableList.size()];
        for (int i = 0; i < fArray.length; ++i) {
            TabStop tabStop = (TabStop)observableList.get(i);
            fArray[i] = (float)tabStop.getPosition();
        }
        Arrays.sort(fArray);
        float f = (float)tabStopPolicy.getDefaultInterval();
        return new DefaultTabAdvancePolicy(textFlow, fArray, f);
    }

    @Override
    public float nextTabStop(float f, float f2) {
        for (int i = 0; i < this.stops.length; ++i) {
            double d = this.stops[i] + f;
            if (!((double)f2 < d)) continue;
            return (float)d;
        }
        if (this.interval <= 0.0f) {
            return -1.0f;
        }
        return FixedTabAdvancePolicy.nextPosition(f2 - f, this.interval) + f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("DefaultTabAdvancePolicy{");
        stringBuilder.append(", stops=[");
        for (int i = 0; i < this.stops.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.stops[i]);
        }
        stringBuilder.append("], interval=").append(this.interval);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

