/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.skin;

import com.sun.jfx.incubator.scene.control.input.InputMapHelper;
import com.sun.jfx.incubator.scene.control.input.SkinInputMap;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaBehavior;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaHelper;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaSkinHelper;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.ListenerHelper;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.DataFormat;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Font;
import jfx.incubator.scene.control.input.InputMap;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.SelectionSegment;
import jfx.incubator.scene.control.richtext.StyleHandlerRegistry;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;
import jfx.incubator.scene.control.richtext.skin.CellContext;

public class RichTextAreaSkin
extends SkinBase<RichTextArea> {
    private final ListenerHelper listenerHelper;
    private final RichTextAreaBehavior behavior;
    private final VFlow vflow;
    private final ScrollBar vscroll;
    private final ScrollBar hscroll;
    private final EventHandler<InputMethodEvent> inputMethodTextChangedHandler = this::handleInputMethodEvent;
    private InputMethodRequests inputMethodRequests;
    private Ime ime;

    public RichTextAreaSkin(RichTextArea richTextArea) {
        super((Control)richTextArea);
        this.listenerHelper = new ListenerHelper();
        this.vscroll = this.createVScrollBar();
        this.vscroll.setOrientation(Orientation.VERTICAL);
        this.vscroll.addEventFilter(ScrollEvent.ANY, scrollEvent -> scrollEvent.consume());
        this.hscroll = this.createHScrollBar();
        this.hscroll.setOrientation(Orientation.HORIZONTAL);
        this.hscroll.addEventFilter(ScrollEvent.ANY, scrollEvent -> scrollEvent.consume());
        this.vflow = new VFlow(this, this.vscroll, this.hscroll);
        this.getChildren().add((Object)this.vflow);
        this.behavior = new RichTextAreaBehavior(richTextArea);
        this.listenerHelper.addChangeListener(this.vflow::handleSelectionChange, new ObservableValue[]{richTextArea.selectionProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::updateRateRestartBlink, true, new ObservableValue[]{richTextArea.caretBlinkPeriodProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::updateCaretAndSelection, new ObservableValue[]{richTextArea.highlightCurrentParagraphProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleContentPadding, true, new ObservableValue[]{richTextArea.contentPaddingProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleDecoratorChange, new ObservableValue[]{richTextArea.leftDecoratorProperty(), richTextArea.rightDecoratorProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleUseContentHeight, true, new ObservableValue[]{richTextArea.useContentHeightProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleUseContentWidth, true, new ObservableValue[]{richTextArea.useContentWidthProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleVerticalScroll, new ObservableValue[]{this.vscroll.valueProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleHorizontalScroll, new ObservableValue[]{this.hscroll.valueProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleWrapText, new ObservableValue[]{richTextArea.wrapTextProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleModelChange, new ObservableValue[]{richTextArea.modelProperty()});
        this.listenerHelper.addChangeListener(richTextArea.modelProperty(), true, this::handleModelChange);
    }

    public void install() {
        final RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
        InputMapHelper.setSkinInputMap((InputMap)richTextArea.getInputMap(), (SkinInputMap)this.behavior.getSkinInputMap());
        if (richTextArea.getOnInputMethodTextChanged() == null) {
            richTextArea.setOnInputMethodTextChanged(this.inputMethodTextChangedHandler);
        }
        if (richTextArea.getInputMethodRequests() == null) {
            this.inputMethodRequests = new InputMethodRequests(){
                final /* synthetic */ RichTextAreaSkin this$0;
                {
                    this.this$0 = richTextAreaSkin;
                }

                public Point2D getTextLocation(int n) {
                    SelectionSegment selectionSegment = richTextArea.getSelection();
                    if (selectionSegment != null) {
                        TextPos textPos = selectionSegment.getMin();
                        textPos = RichUtils.advancePosition(textPos, n);
                        return this.this$0.vflow.getImeLocationOnScreen(textPos);
                    }
                    return new Point2D(0.0, 0.0);
                }

                public String getSelectedText() {
                    SelectionSegment selectionSegment = richTextArea.getSelection();
                    if (selectionSegment != null && !selectionSegment.isCollapsed()) {
                        int n = 4096;
                        StringBuilder stringBuilder = new StringBuilder(n);
                        RichTextAreaHelper.getText(richTextArea, selectionSegment.getMin(), selectionSegment.getMax(), stringBuilder, n);
                        return stringBuilder.toString();
                    }
                    return "";
                }

                public int getLocationOffset(int n, int n2) {
                    TextPos textPos = this.this$0.vflow.getTextPosLocal(n, n2);
                    return textPos.offset() - this.this$0.ime.start.offset();
                }

                public void cancelLatestCommittedText() {
                }
            };
            richTextArea.setInputMethodRequests(this.inputMethodRequests);
        }
    }

    public void dispose() {
        RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
        if (richTextArea != null) {
            if (richTextArea.getInputMethodRequests() == this.inputMethodRequests) {
                richTextArea.setInputMethodRequests(null);
            }
            if (richTextArea.getOnInputMethodTextChanged() == this.inputMethodTextChangedHandler) {
                richTextArea.setOnInputMethodTextChanged(null);
            }
            this.listenerHelper.disconnect();
            this.vflow.dispose();
            this.getChildren().remove((Object)this.vflow);
            super.dispose();
        }
    }

    private void handleInputMethodEvent(InputMethodEvent inputMethodEvent) {
        RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
        if (RichUtils.canEdit(richTextArea) && !richTextArea.isDisabled()) {
            SelectionSegment selectionSegment = richTextArea.getSelection();
            if (selectionSegment == null) {
                return;
            }
            TextPos textPos = selectionSegment.getMax();
            if (this.ime != null) {
                if (this.ime.shapes != null) {
                    this.vflow.removeImHighlight(this.ime.shapes);
                    this.ime.shapes = null;
                }
                textPos = RichUtils.advancePosition(this.ime.start, this.ime.length);
            } else {
                this.ime = new Ime();
                this.ime.start = selectionSegment.getMin();
            }
            String string = RichUtils.getImeText(inputMethodEvent);
            this.ime.length = string.length();
            richTextArea.replaceText(this.ime.start, textPos, string, false);
            TextPos textPos2 = this.ime.start;
            if (inputMethodEvent.getComposed().size() > 0) {
                this.ime.shapes = new ArrayList<Shape>();
                TextPos textPos3 = this.ime.start;
                for (InputMethodTextRun inputMethodTextRun : inputMethodEvent.getComposed()) {
                    textPos2 = RichUtils.advancePosition(textPos3, inputMethodTextRun.getText().length());
                    this.appendImeShapes(this.ime.shapes, inputMethodTextRun.getHighlight(), textPos3, textPos2);
                    textPos3 = textPos2;
                }
                this.vflow.addImeHighlights(this.ime.shapes, this.ime.start);
            } else {
                this.ime.shapes = null;
                textPos2 = RichUtils.advancePosition(this.ime.start, string.length());
            }
            richTextArea.select(textPos2);
            if (inputMethodEvent.getCommitted().length() > 0 || this.ime.length == 0) {
                if (this.ime.shapes != null) {
                    this.vflow.removeImHighlight(this.ime.shapes);
                }
                this.ime = null;
            }
            inputMethodEvent.consume();
        }
    }

    private void appendImeShapes(List<Shape> list, InputMethodHighlight inputMethodHighlight, TextPos textPos, TextPos textPos2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        List<PathElement> list2 = this.vflow.getUnderlineShape(textPos, textPos2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            LineTo lineTo;
            MoveTo moveTo;
            PathElement pathElement = list2.get(i);
            if (pathElement instanceof MoveTo) {
                moveTo = (MoveTo)pathElement;
                d = d2 = moveTo.getX();
                d3 = d4 = moveTo.getY();
            } else if (pathElement instanceof LineTo) {
                lineTo = (LineTo)pathElement;
                d = d < lineTo.getX() ? d : lineTo.getX();
                d2 = d2 > lineTo.getX() ? d2 : lineTo.getX();
                d3 = d3 < lineTo.getY() ? d3 : lineTo.getY();
                d4 = d4 > lineTo.getY() ? d4 : lineTo.getY();
            } else if (pathElement instanceof HLineTo) {
                HLineTo hLineTo = (HLineTo)pathElement;
                d = d < hLineTo.getX() ? d : hLineTo.getX();
                d2 = d2 > hLineTo.getX() ? d2 : hLineTo.getX();
            } else if (pathElement instanceof VLineTo) {
                VLineTo vLineTo = (VLineTo)pathElement;
                d3 = d3 < vLineTo.getY() ? d3 : vLineTo.getY();
                double d5 = d4 = d4 > vLineTo.getY() ? d4 : vLineTo.getY();
            }
            if (!(pathElement instanceof ClosePath) && i != n - 1 && (i >= n - 1 || !(list2.get(i + 1) instanceof MoveTo))) continue;
            moveTo = null;
            switch (inputMethodHighlight) {
                case SELECTED_RAW: {
                    moveTo = new Path(this.vflow.getRangeShape(textPos, textPos2));
                    moveTo.setFill((Paint)this.imeSelectColor());
                    moveTo.setOpacity(0.3);
                    break;
                }
                case UNSELECTED_RAW: {
                    moveTo = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                    moveTo.setStroke((Paint)this.imeColor());
                    moveTo.setStrokeWidth(d4 - d3);
                    lineTo = moveTo.getStrokeDashArray();
                    lineTo.add((Object)2.0);
                    lineTo.add((Object)2.0);
                    break;
                }
                case SELECTED_CONVERTED: {
                    moveTo = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                    moveTo.setStroke((Paint)this.imeColor());
                    moveTo.setStrokeWidth((d4 - d3) * 3.0);
                    break;
                }
                case UNSELECTED_CONVERTED: {
                    moveTo = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                    moveTo.setStroke((Paint)this.imeColor());
                    moveTo.setStrokeWidth(d4 - d3);
                }
            }
            if (moveTo == null) continue;
            moveTo.setManaged(false);
            list.add((Shape)moveTo);
        }
    }

    private Color imeColor() {
        return RichUtils.isDarkScheme((Node)this.getSkinnable()) ? Color.WHITE : Color.BLACK;
    }

    private Color imeSelectColor() {
        return Color.BLUE;
    }

    private void handleModelChange(Object object, StyledTextModel styledTextModel, StyledTextModel styledTextModel2) {
        if (styledTextModel != null) {
            styledTextModel.removeListener(this.vflow);
        }
        if (styledTextModel2 != null) {
            styledTextModel2.addListener(this.vflow);
        }
    }

    protected ScrollBar createVScrollBar() {
        return new ScrollBar();
    }

    protected ScrollBar createHScrollBar() {
        return new ScrollBar();
    }

    private VFlow getVFlow() {
        return this.vflow;
    }

    public StyleResolver getStyleResolver() {
        return this.vflow;
    }

    public void copyText(DataFormat dataFormat) {
        this.behavior.copyWithFormat(dataFormat);
    }

    public void pasteText(DataFormat dataFormat) {
        this.behavior.pasteWithFormat(dataFormat);
    }

    public void applyStyles(CellContext cellContext, StyleAttributeMap styleAttributeMap, boolean bl) {
        if (styleAttributeMap != null) {
            RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
            StyleHandlerRegistry styleHandlerRegistry = richTextArea.getStyleHandlerRegistry();
            for (StyleAttribute<?> styleAttribute : styleAttributeMap.getAttributes()) {
                Object obj = styleAttributeMap.get(styleAttribute);
                if (obj == null) continue;
                styleHandlerRegistry.process(richTextArea, bl, cellContext, styleAttribute, obj);
            }
        }
    }

    public void refreshLayout() {
        this.vflow.invalidateLayout();
        ((RichTextArea)this.getSkinnable()).requestLayout();
    }

    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        if (((RichTextArea)this.getSkinnable()).isUseContentHeight()) {
            return super.computePrefHeight(d, d2, d3, d4, d5);
        }
        return 176.0;
    }

    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        if (((RichTextArea)this.getSkinnable()).isUseContentWidth()) {
            return super.computePrefWidth(d, d2, d3, d4, d5);
        }
        return 480.0;
    }

    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return 10.0;
    }

    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return 10.0;
    }

    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SHOW_TEXT_RANGE: {
                Integer n = (Integer)objectArray[0];
                Integer n2 = (Integer)objectArray[1];
                if (n == null || n2 == null) break;
                break;
            }
            default: {
                super.executeAccessibleAction(accessibleAction, objectArray);
            }
        }
    }

    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case BOUNDS_FOR_RANGE: {
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null) {
                    int n = (Integer)objectArray[0];
                    int n2 = (Integer)objectArray[1];
                    PathElement[] pathElementArray = this.getVFlow().getRangeShape(textPos.index(), n, n2 + 1);
                    return RichUtils.pathToBoundsArray((Node)this.getVFlow(), pathElementArray);
                }
                return null;
            }
            case FONT: {
                Double d;
                String string;
                StyleAttributeMap styleAttributeMap = ((RichTextArea)this.getSkinnable()).getActiveStyleAttributeMap();
                if (styleAttributeMap != null && (string = styleAttributeMap.getFontFamily()) != null && (d = styleAttributeMap.getFontSize()) != null) {
                    return Font.font((String)string, (double)d);
                }
                return null;
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.hscroll;
            }
            case LINE_FOR_OFFSET: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineForOffset(n);
                }
                return null;
            }
            case LINE_START: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineStart(n);
                }
                return null;
            }
            case LINE_END: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineEnd(n);
                }
                return null;
            }
            case OFFSET_AT_POINT: {
                Point2D point2D = (Point2D)objectArray[0];
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getTextPosition(point2D.getX(), point2D.getY());
                return textPos == null ? null : Integer.valueOf(textPos.charIndex());
            }
            case VERTICAL_SCROLLBAR: {
                return this.vscroll;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static {
        RichTextAreaSkinHelper.setAccessor(new RichTextAreaSkinHelper.Accessor(){

            @Override
            public VFlow getVFlow(Skin<?> skin) {
                if (skin instanceof RichTextAreaSkin) {
                    RichTextAreaSkin richTextAreaSkin = (RichTextAreaSkin)skin;
                    return richTextAreaSkin.getVFlow();
                }
                return null;
            }

            @Override
            public ListenerHelper getListenerHelper(Skin<?> skin) {
                return ((RichTextAreaSkin)skin).listenerHelper;
            }
        });
    }

    private static class Ime {
        public TextPos start;
        public int length;
        public List<Shape> shapes;

        private Ime() {
        }
    }
}

