set -l commands "+list-fonts +list-keybinds +list-themes +list-colors +list-actions +ssh-cache +edit-config +show-config +validate-config +show-face +crash-report +boo +new-window"
complete -c ghostty -f
complete -c ghostty -s e -l help -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l version -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-family -r -f  -a "(ghostty +list-fonts | grep '^[A-Z]')" -d "The font families to use."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-family-bold -r -f  -a "(ghostty +list-fonts | grep '^[A-Z]')"
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-family-italic -r -f  -a "(ghostty +list-fonts | grep '^[A-Z]')"
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-family-bold-italic -r -f  -a "(ghostty +list-fonts | grep '^[A-Z]')"
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-style -r -f -d "The named font style to use for each of the requested terminal font styles."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-style-bold -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-style-italic -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-style-bold-italic -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-synthetic-style -r -f -a "bold no-bold italic no-italic bold-italic no-bold-italic" -d "Control whether Ghostty should synthesize a style if the requested style is not available in the specified font-family."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-feature -r -f -d "Apply a font feature."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-size -r -f -d "Font size in points."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-variation -r -f -d "A repeatable configuration to set one or more font variations values for a variable font."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-variation-bold -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-variation-italic -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-variation-bold-italic -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-codepoint-map -r -f -d "Force one or a range of Unicode codepoints to map to a specific named font."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-codepoint-map -r -f -d "Map specific Unicode codepoints to replacement values when copying text to clipboard."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-thicken  -f -d "Draw fonts with a thicker stroke, if supported."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-thicken-strength -r -f -d "Strength of thickening when `font-thicken` is enabled."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l font-shaping-break -r -f -a "cursor no-cursor" -d "Locations to break font shaping into multiple runs."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l alpha-blending -r -f -a "native linear linear-corrected" -d "What color space to use when performing alpha blending."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-cell-width -r -f -d "All of the configurations behavior adjust various metrics determined by the font."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-cell-height -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-font-baseline -r -f -d "Distance in pixels or percentage adjustment from the bottom of the cell to the text baseline."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-underline-position -r -f -d "Distance in pixels or percentage adjustment from the top of the cell to the top of the underline."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-underline-thickness -r -f -d "Thickness in pixels of the underline."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-strikethrough-position -r -f -d "Distance in pixels or percentage adjustment from the top of the cell to the top of the strikethrough."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-strikethrough-thickness -r -f -d "Thickness in pixels or percentage adjustment of the strikethrough."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-overline-position -r -f -d "Distance in pixels or percentage adjustment from the top of the cell to the top of the overline."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-overline-thickness -r -f -d "Thickness in pixels or percentage adjustment of the overline."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-cursor-thickness -r -f -d "Thickness in pixels or percentage adjustment of the bar cursor and outlined rect cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-cursor-height -r -f -d "Height in pixels or percentage adjustment of the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-box-thickness -r -f -d "Thickness in pixels or percentage adjustment of box drawing characters."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l adjust-icon-height -r -f -d "Height in pixels or percentage adjustment of maximum height for nerd font icons."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l grapheme-width-method -r -f -a "legacy unicode" -d "The method to use for calculating the cell width of a grapheme cluster."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l freetype-load-flags -r -f -a "hinting no-hinting force-autohint no-force-autohint monochrome no-monochrome autohint no-autohint light no-light" -d "FreeType load flags to enable."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l theme -r -f -a "(ghostty +list-themes | sed -E 's/^(.*) \(.*\$/\1/')" -d "A theme to use."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background -r -f -d "Background color for the window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l foreground -r -f -d "Foreground color for the window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-image -r -f -d "Background image for the terminal."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-image-opacity -r -f -d "Background image opacity."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-image-position -r -f -a "top-left top-center top-right center-left center-center center-right bottom-left bottom-center bottom-right center" -d "Background image position."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-image-fit -r -f -a "contain cover stretch none" -d "Background image fit."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-image-repeat  -f -d "Whether to repeat the background image or not."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l selection-foreground -r -f -d "The foreground and background color for selection."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l selection-background -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l selection-clear-on-typing  -f -d "Whether to clear selected text when typing."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l selection-clear-on-copy  -f -d "Whether to clear selected text after copying."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l minimum-contrast -r -f -d "The minimum contrast ratio between the foreground and background colors."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l palette -r -f -d "Color palette for the 256 color form that many terminal applications use."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-color -r -f -d "The color of the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-opacity -r -f -d "The opacity level (opposite of transparency) of the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-style -r -f -a "bar block underline block_hollow" -d "The style of the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-style-blink -r -f -d "Sets the default blinking state of the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-text -r -f -d "The color of the text under the cursor."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l cursor-click-to-move  -f -d "Enables the ability to move the cursor at prompts by using `alt+click` on Linux and `option+click` on macOS."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l mouse-hide-while-typing  -f -d "Hide the mouse immediately when typing."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l scroll-to-bottom -r -f -a "keystroke no-keystroke output no-output" -d "When to scroll the surface to the bottom."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l mouse-shift-capture -r -f -a "false true always never" -d "Determines whether running programs can detect the shift key pressed with a mouse click."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l mouse-reporting  -f -d "Enable or disable mouse reporting."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l mouse-scroll-multiplier -r -f -d "Multiplier for scrolling distance with the mouse wheel."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-opacity -r -f -d "The opacity level (opposite of transparency) of the background."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-opacity-cells  -f -d "Applies background opacity to cells with an explicit background color set."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l background-blur -r -f -d "Whether to blur the background when `background-opacity` is less than 1."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l unfocused-split-opacity -r -f -d "The opacity level (opposite of transparency) of an unfocused split."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l unfocused-split-fill -r -f -d "The color to dim the unfocused split."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l split-divider-color -r -f -d "The color of the split divider."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l search-foreground -r -f -d "The foreground and background color for search matches."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l search-background -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l search-selected-foreground -r -f -d "The foreground and background color for the currently selected search match."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l search-selected-background -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l command -r -f -d "The command to run, usually a shell."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l initial-command -r -f -d "This is the same as \"command\", but only applies to the first terminal surface created when Ghostty starts."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l notify-on-command-finish -r -f -a "never unfocused always" -d "Controls when command finished notifications are sent."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l notify-on-command-finish-action -r -f -a "bell no-bell notify no-notify" -d "If command finished notifications are enabled, this controls how the user is notified."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l notify-on-command-finish-after -r -f -d "If command finished notifications are enabled, this controls how long a command must have been running before a notification will be sent."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l env -r -f -d "Extra environment variables to pass to commands launched in a terminal surface."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l input -r -f -d "Data to send as input to the command on startup."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l wait-after-command  -f -d "If true, keep the terminal open after the command exits."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l abnormal-command-exit-runtime -r -f -d "The number of milliseconds of runtime below which we consider a process exit to be abnormal."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l scrollback-limit -r -f -d "The size of the scrollback buffer in bytes."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l scrollbar -r -f -a "system never" -d "Control when the scrollbar is shown to scroll the scrollback buffer."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l link -r -f -d "Match a regular expression against the terminal text and associate clicking it with an action."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l link-url  -f -d "Enable URL matching."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l link-previews -r -f -a "false true osc8" -d "Show link previews for a matched URL."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l maximize  -f -d "Whether to start the window in a maximized state."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l fullscreen  -f -d "Start new windows in fullscreen."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l title -r -f -d "The title Ghostty will use for the window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l class -r -f -d "The setting that will change the application class value."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l x11-instance-name -r -f -d "This controls the instance name field of the `WM_CLASS` X11 property when running under X11."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l working-directory -r -f -k -a "(__fish_complete_directories)" -d "The directory to change to after starting the command."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l keybind -r -f -d "Key bindings."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-padding-x -r -f -d "Horizontal window padding."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-padding-y -r -f -d "Vertical window padding."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-padding-balance  -f -d "The viewport dimensions are usually not perfectly divisible by the cell size."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-padding-color -r -f -a "background extend extend-always" -d "The color of the padding area of the window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-vsync  -f -d "Synchronize rendering with the screen refresh rate."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-inherit-working-directory  -f -d "If true, new windows and tabs will inherit the working directory of the previously focused window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-inherit-font-size  -f -d "If true, new windows and tabs will inherit the font size of the previously focused window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-decoration -r -f -a "auto client server none" -d "Configure a preference for window decorations."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-title-font-family -r -f -d "The font that will be used for the application's window and tab titles."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-subtitle -r -f -a "false working-directory" -d "The text that will be displayed in the subtitle of the window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-theme -r -f -a "auto system light dark ghostty" -d "The theme to use for the windows."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-colorspace -r -f -a "srgb display-p3" -d "The color space to use when interpreting terminal colors."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-height -r -f -d "The initial window size."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-width -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-position-x -r -f -d "The starting window position."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-position-y -r -f
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-save-state -r -f -a "default never always" -d "Whether to enable saving and restoring window state."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-step-resize  -f -d "Resize the window in discrete increments of the focused surface's cell size."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-new-tab-position -r -f -a "current end" -d "The position where new tabs are created."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-show-tab-bar -r -f -a "always auto never" -d "Whether to show the tab bar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-titlebar-background -r -f -d "Background color for the window titlebar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l window-titlebar-foreground -r -f -d "Foreground color for the window titlebar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l resize-overlay -r -f -a "always never after-first" -d "This controls when resize overlays are shown."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l resize-overlay-position -r -f -a "center top-left top-center top-right bottom-left bottom-center bottom-right" -d "If resize overlays are enabled, this controls the position of the overlay."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l resize-overlay-duration -r -f -d "If resize overlays are enabled, this controls how long the overlay is visible on the screen before it is hidden."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l focus-follows-mouse  -f -d "If true, when there are multiple split panes, the mouse selects the pane that is focused."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-read -r -f -a "allow deny ask" -d "Whether to allow programs running in the terminal to read/write to the system clipboard (OSC 52, for googling)."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-write -r -f -a "allow deny ask"
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-trim-trailing-spaces  -f -d "Trims trailing whitespace on data that is copied to the clipboard."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-paste-protection  -f -d "Require confirmation before pasting text that appears unsafe."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l clipboard-paste-bracketed-safe  -f -d "If true, bracketed pastes will be considered safe."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l title-report  -f -d "Enables or disabled title reporting (CSI 21 t)."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l image-storage-limit -r -f -d "The total amount of bytes that can be used for image data (e.g."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l copy-on-select -r -f -a "false true clipboard" -d "Whether to automatically copy selected text to the clipboard."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l right-click-action -r -f -a "ignore paste copy copy-or-paste context-menu" -d "The action to take when the user right-clicks on the terminal surface."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l click-repeat-interval -r -f -d "The time in milliseconds between clicks to consider a click a repeat (double, triple, etc.) or an entirely new single click."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l config-file -r -F -d "Additional configuration files to read."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l config-default-files  -f -d "When this is true, the default configuration file paths will be loaded."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l confirm-close-surface -r -f -a "false true always" -d "Confirms that a surface should be closed before closing it."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quit-after-last-window-closed  -f -d "Whether or not to quit after the last surface is closed."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quit-after-last-window-closed-delay -r -f -d "Controls how long Ghostty will stay running after the last open surface has been closed."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l initial-window  -f -d "This controls whether an initial window is created when Ghostty is run."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l undo-timeout -r -f -d "The duration that undo operations remain available."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-position -r -f -a "top bottom left right center" -d "The position of the \"quick\" terminal window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-size -r -f -d "The size of the quick terminal."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-quick-terminal-layer -r -f -a "overlay top bottom background" -d "The layer of the quick terminal window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-quick-terminal-namespace -r -f -d "The namespace for the quick terminal window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-screen -r -f -a "main mouse macos-menu-bar" -d "The screen where the quick terminal should show up."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-animation-duration -r -f -d "Duration (in seconds) of the quick terminal enter and exit animation."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-autohide  -f -d "Automatically hide the quick terminal when focus shifts to another window."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-space-behavior -r -f -a "remain move" -d "This configuration option determines the behavior of the quick terminal when switching between macOS spaces."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l quick-terminal-keyboard-interactivity -r -f -a "none on-demand exclusive" -d "Determines under which circumstances that the quick terminal should receive keyboard input."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l shell-integration -r -f -a "none detect bash elvish fish zsh" -d "Whether to enable shell integration auto-injection or not."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l shell-integration-features -r -f -a "cursor no-cursor sudo no-sudo title no-title ssh-env no-ssh-env ssh-terminfo no-ssh-terminfo path no-path" -d "Shell integration features to enable."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l command-palette-entry -r -f -d "Custom entries into the command palette."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l osc-color-report-format -r -f -a "none 8-bit 16-bit" -d "Sets the reporting format for OSC sequences that request color information."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l vt-kam-allowed  -f -d "If true, allows the \"KAM\" mode (ANSI mode 2) to be used within the terminal."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l custom-shader -r -F -d "Custom shaders to run after the default shaders."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l custom-shader-animation -r -f -a "false true always" -d "If `true` (default), the focused terminal surface will run an animation loop when custom shaders are used."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l bell-features -r -f -a "system no-system audio no-audio attention no-attention title no-title border no-border" -d "Bell features to enable if bell support is available in your runtime."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l bell-audio-path -r -f -d "If `audio` is an enabled bell feature, this is a path to an audio file."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l bell-audio-volume -r -f -d "If `audio` is an enabled bell feature, this is the volume to play the audio file at (relative to the system volume)."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l app-notifications -r -f -a "clipboard-copy no-clipboard-copy config-reload no-config-reload" -d "Control the in-app notifications that Ghostty shows."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-non-native-fullscreen -r -f -a "false true visible-menu padded-notch" -d "If anything other than false, fullscreen mode on macOS will not use the native fullscreen, but make the window fullscreen without animations and using a new space."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-window-buttons -r -f -a "visible hidden" -d "Whether the window buttons in the macOS titlebar are visible."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-titlebar-style -r -f -a "native transparent tabs hidden" -d "The style of the macOS titlebar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-titlebar-proxy-icon -r -f -a "visible hidden" -d "Whether the proxy icon in the macOS titlebar is visible."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-dock-drop-behavior -r -f -a "new-tab window" -d "Controls the windowing behavior when dropping a file or folder onto the Ghostty icon in the macOS dock."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-option-as-alt -r -f -d "macOS doesn't have a distinct \"alt\" key and instead has the \"option\" key which behaves slightly differently."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-window-shadow  -f -d "Whether to enable the macOS window shadow."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-hidden -r -f -a "never always" -d "If true, the macOS icon in the dock and app switcher will be hidden."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-auto-secure-input  -f -d "If true, Ghostty on macOS will automatically enable the \"Secure Input\" feature when it detects that a password prompt is being displayed."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-secure-input-indication  -f -d "If true, Ghostty will show a graphical indication when secure input is enabled."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-icon -r -f -a "official blueprint chalkboard microchip glass holographic paper retro xray custom custom-style" -d "Customize the macOS app icon."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-custom-icon -r -f -d "The absolute path to the custom icon file."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-icon-frame -r -f -a "aluminum beige plastic chrome" -d "The material to use for the frame of the macOS app icon."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-icon-ghost-color -r -f -d "The color of the ghost in the macOS app icon."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-icon-screen-color -r -f -d "The color of the screen in the macOS app icon."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l macos-shortcuts -r -f -a "allow deny ask" -d "Whether macOS Shortcuts are allowed to control Ghostty."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l linux-cgroup -r -f -a "never always single-instance" -d "Put every surface (tab, split, window) into a dedicated Linux cgroup."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l linux-cgroup-memory-limit -r -f -d "Memory limit for any individual terminal process (tab, split, window, etc.) in bytes."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l linux-cgroup-processes-limit -r -f -d "Number of processes limit for any individual terminal process (tab, split, window, etc.)."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l linux-cgroup-hard-fail  -f -d "If this is false, then any cgroup initialization (for linux-cgroup) will be allowed to fail and the failure is ignored."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-opengl-debug  -f -d "Enable or disable GTK's OpenGL debugging logs."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-single-instance -r -f -a "false true detect" -d "If `true`, the Ghostty GTK application will run in single-instance mode: each new `ghostty` process launched will result in a new window if there is already a running process."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-titlebar  -f -d "When enabled, the full GTK titlebar is displayed instead of your window manager's simple titlebar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-tabs-location -r -f -a "top bottom" -d "Determines the side of the screen that the GTK tab bar will stick to."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-titlebar-hide-when-maximized  -f -d "If this is `true`, the titlebar will be hidden when the window is maximized, and shown when the titlebar is unmaximized."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-toolbar-style -r -f -a "flat raised raised-border" -d "Determines the appearance of the top and bottom bars tab bar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-titlebar-style -r -f -a "native tabs" -d "The style of the GTK titlbar."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-wide-tabs  -f -d "If `true` (default), then the Ghostty GTK tabs will be \"wide.\" Wide tabs are the new typical Gnome style where tabs fill their available space."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l gtk-custom-css -r -F -d "Custom CSS files to be loaded."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l desktop-notifications  -f -d "If `true` (default), applications running in the terminal can show desktop notifications using certain escape sequences such as OSC 9 or OSC 777."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l bold-color -r -f -d "Modifies the color used for bold text in the terminal."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l faint-opacity -r -f -d "The opacity level (opposite of transparency) of the faint text."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l term -r -f -d "This will be used to set the `TERM` environment variable."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l enquiry-response -r -f -d "String to send when we receive `ENQ` (`0x05`) from the command that we are running."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l async-backend -r -f -a "auto epoll io_uring" -d "Configures the low-level API to use for async IO, eventing, etc."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l auto-update -r -f -d "Control the auto-update functionality of Ghostty."
complete -c ghostty -n "not __fish_seen_subcommand_from $commands" -l auto-update-channel -r -f -d "The release channel to use for auto-updates."
complete -c ghostty -n "string match -q -- '+*' (commandline -pt)" -f -a "+list-fonts +list-keybinds +list-themes +list-colors +list-actions +ssh-cache +edit-config +show-config +validate-config +show-face +crash-report +boo +new-window"
complete -c ghostty -n "__fish_seen_subcommand_from +list-fonts" -l family -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-fonts" -l style -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-fonts" -l bold -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-fonts" -l italic -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-keybinds" -l default -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-keybinds" -l docs -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-keybinds" -l plain -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-themes" -l path -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-themes" -l plain -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-themes" -l color -r -f -a "all dark light"
complete -c ghostty -n "__fish_seen_subcommand_from +list-colors" -l plain -f
complete -c ghostty -n "__fish_seen_subcommand_from +list-actions" -l docs -f
complete -c ghostty -n "__fish_seen_subcommand_from +ssh-cache" -l clear -f
complete -c ghostty -n "__fish_seen_subcommand_from +ssh-cache" -l add -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +ssh-cache" -l remove -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +ssh-cache" -l host -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +ssh-cache" -l expire-days -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +show-config" -l default -f
complete -c ghostty -n "__fish_seen_subcommand_from +show-config" -l changes-only -f
complete -c ghostty -n "__fish_seen_subcommand_from +show-config" -l docs -f
complete -c ghostty -n "__fish_seen_subcommand_from +validate-config" -l config-file -r -F
complete -c ghostty -n "__fish_seen_subcommand_from +show-face" -l cp -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +show-face" -l string -r -f
complete -c ghostty -n "__fish_seen_subcommand_from +show-face" -l style -r -f -a "regular bold italic bold_italic"
complete -c ghostty -n "__fish_seen_subcommand_from +show-face" -l presentation -r -f -a "text emoji"
complete -c ghostty -n "__fish_seen_subcommand_from +new-window" -l class -r -f
