const core = require('@sentry/core');
const utils = require('@sentry/utils');
const ipc = require('../ipc.js');

const INTEGRATION_NAME = 'ScopeToMain';
/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup() {
            const scope = core.getCurrentScope();
            if (scope) {
                const ipc$1 = ipc.getIPC();
                scope.addScopeListener((updatedScope) => {
                    ipc$1.sendScope(JSON.stringify(utils.normalize(updatedScope.getScopeData(), 20, 2000)));
                    scope.clearBreadcrumbs();
                    scope.clearAttachments();
                });
            }
        },
    };
});
/**
 * Passes scope changes to the main process.
 *
 * @deprecated Use `scopeToMainIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const ScopeToMain = core.convertIntegrationFnToClass(INTEGRATION_NAME, scopeToMainIntegration);

exports.ScopeToMain = ScopeToMain;
exports.scopeToMainIntegration = scopeToMainIntegration;
//# sourceMappingURL=scope-to-main.js.map
