const core = require('@sentry/core');
const metrics = require('../metrics.js');

const INTEGRATION_NAME = 'MetricsAggregator';
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 */
const metricsAggregatorIntegration = () => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup(client) {
            client.metricsAggregator = new metrics.ElectronRendererMetricsAggregator();
        },
    };
};
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 *
 * @deprecated Use `metricsAggregatorIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const MetricsAggregator = core.convertIntegrationFnToClass(INTEGRATION_NAME, metricsAggregatorIntegration);

exports.MetricsAggregator = MetricsAggregator;
exports.metricsAggregatorIntegration = metricsAggregatorIntegration;
//# sourceMappingURL=metrics-aggregator.js.map
