const node = require('@sentry/node');
const index$1 = require('./integrations/index.js');
const core = require('@sentry/core');
const electronBreadcrumbs = require('./integrations/electron-breadcrumbs.js');
const onuncaughtexception = require('./integrations/onuncaughtexception.js');
const mainContext = require('./integrations/main-context.js');
const index = require('./integrations/sentry-minidump/index.js');
const electronMinidump = require('./integrations/electron-minidump.js');
const preloadInjection = require('./integrations/preload-injection.js');
const mainProcessSession = require('./integrations/main-process-session.js');
const browserWindowSession = require('./integrations/browser-window-session.js');
const additionalContext = require('./integrations/additional-context.js');
const netBreadcrumbs = require('./integrations/net-breadcrumbs.js');
const childProcess = require('./integrations/child-process.js');
const screenshots = require('./integrations/screenshots.js');
const rendererProfiling = require('./integrations/renderer-profiling.js');
const anr = require('./integrations/anr.js');
const electronNet = require('./transports/electron-net.js');
const electronOfflineNet = require('./transports/electron-offline-net.js');
const sdk = require('./sdk.js');
const anr$1 = require('./anr.js');
const process = require('../common/process.js');
const mode = require('../common/mode.js');

process.ensureProcess('main');
/**
 * @deprecated All integrations are now exported from the root of the package.
 */
const Integrations = Object.assign(Object.assign({}, node.Integrations), index$1);

exports.NodeClient = node.NodeClient;
exports.close = node.close;
exports.flush = node.flush;
exports.lastEventId = node.lastEventId;
exports.Hub = core.Hub;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.functionToStringIntegration = core.functionToStringIntegration;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.getIsolationScope = core.getIsolationScope;
exports.inboundFiltersIntegration = core.inboundFiltersIntegration;
exports.linkedErrorsIntegration = core.linkedErrorsIntegration;
exports.makeMain = core.makeMain;
exports.metrics = core.metrics;
exports.parameterize = core.parameterize;
exports.requestDataIntegration = core.requestDataIntegration;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.electronBreadcrumbsIntegration = electronBreadcrumbs.electronBreadcrumbsIntegration;
exports.onUncaughtExceptionIntegration = onuncaughtexception.onUncaughtExceptionIntegration;
exports.mainContextIntegration = mainContext.mainContextIntegration;
exports.sentryMinidumpIntegration = index.sentryMinidumpIntegration;
exports.electronMinidumpIntegration = electronMinidump.electronMinidumpIntegration;
exports.preloadInjectionIntegration = preloadInjection.preloadInjectionIntegration;
exports.mainProcessSessionIntegration = mainProcessSession.mainProcessSessionIntegration;
exports.browserWindowSessionIntegration = browserWindowSession.browserWindowSessionIntegration;
exports.additionalContextIntegration = additionalContext.additionalContextIntegration;
exports.electronNetIntegration = netBreadcrumbs.electronNetIntegration;
exports.childProcessIntegration = childProcess.childProcessIntegration;
exports.screenshotsIntegration = screenshots.screenshotsIntegration;
exports.rendererProfileFromIpc = rendererProfiling.rendererProfileFromIpc;
exports.anrIntegration = anr.anrIntegration;
exports.makeElectronTransport = electronNet.makeElectronTransport;
exports.makeElectronOfflineTransport = electronOfflineNet.makeElectronOfflineTransport;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.init = sdk.init;
exports.enableMainProcessAnrDetection = anr$1.enableMainProcessAnrDetection;
Object.defineProperty(exports, 'IPCMode', {
	enumerable: true,
	get: () => mode.IPCMode
});
exports.Integrations = Integrations;
//# sourceMappingURL=index.js.map
