import { getIPC } from './ipc.js';

/**
 * Sends metrics to the Electron main process where they can be aggregated in a single process
 */
class ElectronRendererMetricsAggregator {
    constructor() {
        this._ipc = getIPC();
    }
    /** @inheritdoc */
    add(metricType, name, value, unit, tags, timestamp) {
        this._ipc.sendAddMetric({ metricType, name, value, unit, tags, timestamp });
    }
    /** @inheritdoc */
    flush() {
        // do nothing
    }
    /** @inheritdoc */
    close() {
        // do nothing
    }
    /** @inheritdoc */
    toString() {
        return '';
    }
}

export { ElectronRendererMetricsAggregator };
//# sourceMappingURL=metrics.js.map
