import { convertIntegrationFnToClass } from '@sentry/core';
import { ElectronRendererMetricsAggregator } from '../metrics.js';

const INTEGRATION_NAME = 'MetricsAggregator';
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 */
const metricsAggregatorIntegration = () => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup(client) {
            client.metricsAggregator = new ElectronRendererMetricsAggregator();
        },
    };
};
/**
 * Enables Sentry metrics monitoring.
 *
 * @experimental This API is experimental and might having breaking changes in the future.
 *
 * @deprecated Use `metricsAggregatorIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const MetricsAggregator = convertIntegrationFnToClass(INTEGRATION_NAME, metricsAggregatorIntegration);

export { MetricsAggregator, metricsAggregatorIntegration };
//# sourceMappingURL=metrics-aggregator.js.map
