import { __awaiter } from 'tslib';
import { defineIntegration, convertIntegrationFnToClass } from '@sentry/core';
import { app } from 'electron';
import { getEventDefaults } from '../context.js';
import { normalizeEvent } from '../../common/normalize.js';
import { mergeEvents } from '../../common/merge.js';

const INTEGRATION_NAME = 'MainContext';
/** Adds Electron context to events and normalises paths. */
const mainContextIntegration = defineIntegration(() => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        processEvent(event, _, client) {
            return __awaiter(this, void 0, void 0, function* () {
                const clientOptions = client.getOptions();
                const normalized = normalizeEvent(event, app.getAppPath());
                const defaults = yield getEventDefaults(clientOptions.release, clientOptions.environment);
                return mergeEvents(defaults, normalized);
            });
        },
    };
});
/**
 * Adds Electron context to events and normalises paths.
 *
 * @deprecated Use `mainContextIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const MainContext = convertIntegrationFnToClass(INTEGRATION_NAME, mainContextIntegration);

export { MainContext, mainContextIntegration };
//# sourceMappingURL=main-context.js.map
